.im man.im
.NM findp find patterns in text
.SY findp pattern [input-file ...]
.FU
.ital findp
reads its input a line at a time and writes to its output those
lines that match the specified text pattern.
A text pattern is a concatenation of the following elements:
.nf
.in 0
.br
       c       literal character c
       ?       any character except newline
       %       beginning of line
       $       end of line (null string before newline)
       [...]   character class (any one of these characters)
       [^...]  negated character class (all but these characters)
       *       closure (zero or more occurrences of previous pattern)
       \@c      escaped character (e.g., \@%, \@[, \@*)
.br
.fi
.in 4
Special meaning of characters in a text pattern is lost when escaped, inside
[...]
(except
\@]),
or for:
.br
.in 0
.nf
       %       not at beginning
       $       not at end
       *       at beginning
.br
.in 4
.fi
A character class consists of zero or more of the following elements,
surrounded by
[
and
] :
.br
.in 0
.nf
       c       literal character c, including [
       c1-c2   range of characters (digits, lower or upper case letters)
       ^       negated character class if at beginning
       \@c      escaped character (e.g., \@^ \@- \@\@ \@])
.br
.in 4
.fi
Special meaning of characters in a character class is lost when escaped
or for:
.br
.in 0
.nf
       ^       not at beginning
       -       at beginning or end
.br
.in 4
.fi
An escape sequence consists of the character
\@
followed by a single character:
.br
.in 0
.nf
       \@n      newline
       \@t      tab
       \@c      c (including \@\@)
.in 4
.fi
.EG
To print lines ending in a Pascal keyword or identifier:
.Q1
findp [a-zA-Z][a-zA-Z0-9]*$
.Q2
