/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*              Routines for updating the screen within BinkleyTerm         */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern BUFFER Sbuf;
extern CELLP Scrnbuf;

char *pop_malloc (unsigned);
void pop_free (char *);

BINK_SAVEP sb_save (int top, int left, int height, int width)
{
   BINK_SAVEP new;
   CELLP c;
   int i, j;

   new = calloc (1, sizeof (BINK_SAVE));
   c = new->save_cells = (CELLP) pop_malloc (sizeof(CELL) * height * width);
   new->region = sb_new (top, left, height, width);
   new->save_row = top;
   new->save_col = left;
   new->save_ht  = height;
   new->save_wid = width;

   j = top * SB_COLS + left;
   for (i = 0; i < height; i++)
      {
#ifndef MILQ
      (void) memcpy (&c[i * width], &Scrnbuf[j], width * sizeof (CELL));
#endif
      j += SB_COLS;
      }

   return (new);
}

void sb_restore (BINK_SAVEP save )
{
   int i, j, r;

#ifndef MILQ
   j = save->save_row * SB_COLS + save->save_col;
   for (r = save->save_row, i = 0; i < save->save_ht; r++, i++)
      {
#ifndef MILQ
      (void) memcpy (&Scrnbuf[j], &(save->save_cells[i * save->save_wid]), save->save_wid * sizeof (CELL));
#endif
      j += SB_COLS;
      if (save->save_col < Sbuf.lcol[r])
         Sbuf.lcol[r] = save->save_col;
      if (save->save_col + save->save_wid > Sbuf.rcol[r])
         Sbuf.rcol[r] = save->save_col + save->save_wid;
      }

   Sbuf.flags |= SB_DELTA;
#endif

   pop_free ( (char *)(save->save_cells));
   free (save->region);
   free (save);
}

char *pop_malloc (unsigned int s)
{
  char *p;

  p = (char *) popbuf;
  popbuf += s;
  return (p);
}

void pop_free (char *s)
{
  popbuf = (byte *) s;
}
