/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                 Box Drawing subroutines for BinkleyTerm                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern BUFFER Sbuf;
extern CELLP Scrnbuf;

unsigned char sb_ra (REGIONP win, int r, int c)
{
   return ((unsigned char) (Scrnbuf + (win->r0 + r) * SB_COLS + win->c0 + c)->b.attr);
}

unsigned char sb_rc (REGIONP win, int r, int c)
{
   return ((unsigned char) (Scrnbuf + (win->r0 + r) * SB_COLS + win->c0 + c)->b.ch);
}

unsigned int sb_rca (REGIONP win, int r, int c)
{
   return ((unsigned int) (Scrnbuf + (win->r0 + r) * SB_COLS + win->c0 + c)->cap);
}

int sb_input_chars (REGIONP win, int row, int col, char *str, int len)
{
   int i;
   int j;

   sb_move (win, row, col);
   for (i = 0; i < len; i++)
      (void) sb_putc (win, '_');
   sb_move (win, row, col);

   i = 0;
   while (i < len)
      {
      sb_show ();
      while (!KEYPRESS ())
         time_release ();
      j = FOSSIL_CHAR ();
      if ((j & 0xff) != 0)
         {
         j &= 0xff;
         j = toupper (j);
         if (isprint (j))
            {
            (void) sb_putc (win, j & 0xff);
            *str = (char) (j & 0xff);
            ++str;
            ++i;
            ++col;
            continue;
            }
         }

      switch (j)
         {
         case ESC:
            return (1);

         case BS:
         case LFAR:
            if (i > 0)
               {
               --col;
               sb_move (win, row, col);
               (void) sb_putc (win, '_');
               sb_move (win, row, col);
               --str;
               --i;
               }
            break;

         case CR:
         case LV:
            *str = '\0';
            for (j = i; j < len; j++)
               (void) sb_putc (win, ' ');

            if (i)
               return (0);
            else
               return (1);
         }
      }

   *str = '\0';
   sb_show ();
   return (0);
}


