/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*             Screen Buffer Definitions used in BinkleyTerm                */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/


#define SB_OK  0
#define SB_ERR (-1)

#define SB_MODE_ANSI 1
#define SB_MODE_AVATAR 2
#define SB_MODE_SIMPLE 0

/* screen buffer constants */
extern unsigned int SB_ROWS;
extern unsigned int SB_COLS;

#define SB_SIZ  SB_ROWS * SB_COLS

typedef struct {
  unsigned int          Attr;          /* Note, this is NOT the same as a */
                                       /* Windows attr word               */
  int                   Bgd;
  unsigned char         Buf[81];
  int                   CtrlSeqIntro;
  int                   Esc;
  int                   Fgd;
  int                   NewLineKludge;
  int                   Mode;          /* Simple, ANSI, or Avatar */
  unsigned int          SaveCol;
  unsigned int          SaveRow;
  int                   Scroll;
  int                   State;         /* Maybe run it like an FSM */
  } _ANSIStuff, *_ANSIStuffP;


/* screen character/attribute buffer element definition */
typedef struct
{
   unsigned char ch;                             /* character */
   unsigned char attr;                           /* attribute */
} BYTEBUF, *BYTEBUFP;

typedef union
{
   BYTEBUF b;
   unsigned int cap;                             /* character/attribute pair */
} CELL, *CELLP;

/* screen buffer control structure */
typedef struct
{
   /* current position */
   int row, col;

   /* pointer to screen buffer array */
   CELLP bp;

   /* changed region per screen buffer row */
   int *lcol;                                    /* left end of changed
                                                  * region */
   int *rcol;                                    /* right end of changed
                                                  * region */

   /* buffer status */
   unsigned int flags;
} BUFFER, *BUFFERP;

/* buffer flags values */
#define SB_DELTA  0x01
#define SB_RAW    0x02
#define SB_DIRECT 0x04
#define SB_SCROLL 0x08
#define SB_SYNC   0x10

#ifdef MILQ

#define MILQ_WIN_CLOSED 0x0001
#define MILQ_WIN_FOCUS  0x0002

typedef struct {
  RECT                  OrgRect;
  int                   OrgZ;          /* We are not currently saving the */
                                       /* Z ordering.  We want to.        */
  int                   Flags;         /* Does the window have the focus? */
                                       /* Is the window even open?        */
  } _MilqSave;

#endif

/* coordinates of a window (rectangular region) on the screen buffer */

/* At one point, we tried substituting REGION with HWND.  There were some
 * inherent problems with this, most notably, that a window doesn't have
 * a current cursor position concept.
 *
 * We probably can and should create a special window class that would
 * deal with this, but not today...
 */

typedef struct
{
   /* current position */
   int row, col;

   /* window boundaries */
   int r0, c0;                                   /* upper left corner */
   int r1, c1;                                   /* lower right corner */

   /* scrolling region boundaries */
   int sr0, sc0;                                 /* upper left corner */
   int sr1, sc1;                                 /* lower right corner */

   /* window buffer flags */
   unsigned int wflags;

   _ANSIStuff           ANSI;

#ifdef MILQ
   HWND                 hWnd;
   _MilqSave            MilqSave;
#endif

} REGION, *REGIONP;

/* coordinates of a window (rectangular region) on the screen buffer */
typedef struct {
   /* top left corner */
   short save_row, save_col;

   /* height and width */
   short save_ht, save_wid;

   /* Window to use */
   REGIONP region;

   /* Saved cells from the window */
   CELLP save_cells;

} BINK_SAVE, *BINK_SAVEP;

#define HIST_BBS_ROW  1
#define HIST_MAIL_ROW 1
#define HIST_ATT_ROW  2
#define HIST_CONN_ROW 3
#define HIST_FILE_ROW 4
#define HIST_LAST_ROW 5
#define HIST_COL      13
#define HIST_COL2     8

#define SET_EVNT_ROW  2
#define SET_PORT_ROW  3
#define SET_TIME_ROW  1
#define SET_DATE_ROW  4
#define SET_STAT_ROW  4
#define SET_TASK_ROW  5

#define SET_COL       10
#define SET_TIME_COL  2

