/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                This module was written by Vince Perriello                */
/*                   OS/2 code contributed by Bill Andrus                   */
/*                                                                          */
/*             DOS and OS/2 kernel routines used by BinkleyTerm             */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"


#ifndef OS_2 /* Here's the DOS stuff */

void dostime (int *hour, int *min, int *sec, int *hdths)
{
   union REGS r;

   r.h.ah = 0x2c;

   (void) intdos (&r, &r);

   *hour  = r.h.ch;
   *min   = r.h.cl;
   *sec   = r.h.dh;
   *hdths = r.h.dl;
}

void dos_break_off (void)
{
   union REGS r;

   r.x.ax = 0x3301;
   r.h.dl = 0x00;

   (void) intdos (&r, &r);
}


void mtask_find ()
{
   char *p, *q;

   for (;;)
      {
      if (have_ml)
         {
         if ((have_ml = ml_active ()) != 0)
            {
            p = "MultiLink";
            mtask_idle = ml_pause;
            break;
            }
         }

      if (have_tv)
         {
         if ((have_tv = tv_get_version ()) != 0)
            {
            p = "T-View";
            mtask_idle = tv_pause;
            break;
            }
         }

      if ((have_dv = dv_get_version ()) != 0)
         {
         p = "DESQview";
         mtask_idle = dv_pause;
         break;
         }

      if ((have_mos = mos_active ()) != 0)
         {
       p = "PC-MOS";
         mtask_idle = mos_pause;
         break;
         }

      if ((have_ddos = ddos_active ()) != 0)
         {
         p = "DoubleDOS";
         mtask_idle = ddos_pause;
         break;
         }

      if ((have_windows = windows_active ()) != 0)
         {
         p = "MSWindows";
         if (winslice)
            mtask_idle = windows_pause;
         else
            mtask_idle = msdos_pause;
         break;
         }
  /* else */
         {
         p = "None";
         mtask_idle = msdos_pause;
         break;
         }
    }

   if ((q = calloc (1, 1 + strlen (p))) == NULL)
      exit (254);

   (void) strcpy (mtask_name = q, p);
}

void set_prior (int pclass)
{
    happy_compiler = pclass;  /* This makes compilers happy! */
    return;
}

#else /* in other words, here's the OS/2 stuff */
#ifdef Snoop
#include "snserver.h"
HSNOOP hsnoop=(HSNOOP)NULL;
#endif

void dostime(int *hour, int *min, int *sec, int *hdths)
{
    DATETIME dt;

    DosGetDateTime(&dt);
    *hour      = dt.hours;                        /* current hour */
    *min       = dt.minutes;                      /* current minute */
    *sec       = dt.seconds;                      /* current second */
    *hdths     = dt.hundredths;                   /* current hundredths of a second */
}

void dos_break_off (void)
{
 /*
  * The problem which dos_break_off was trying to address
  * was a funny with computers like the Sanyo and the DEC
  * Rainbow, where ^C checking in DOS would screw up the
  * FOSSIL's ability to get keystrokes. So while we could
  * emulate the functionality of the DOS side, there is no
  * need to do so. So we won't.
  */
}

void _cdecl os2_pause ()
{
   DosSleep (1L);
}

void mtask_find ()
{
   char *p, *q;

   if (_osmode == DOS_MODE)
       p = "None";
   else
       p = "OS/2";
   mtask_idle = os2_pause;

   if ((q = calloc (1, 1 + strlen (p))) == NULL)
      exit (254);

   (void) strcpy (mtask_name = q, p);
}

void WRITE_ANSI (char c)
{
   static char s[] = {'\0', '\0'};

   *s = c;

   (void) VioWrtTTY (s, 1, (HVIO) 0L);
}

void set_prior (int pclass)
{
  char *s;
  static USHORT regular = 0;
  static USHORT janus = 0;
  static USHORT modem = 0;
  USHORT priority;

  switch (pclass)
    {
    case 2:
      if (regular)
         priority = regular;
      else
         {
         s = getenv("REGULARPRIORITY");
         if (s)
          priority = regular = atoi(s);
         else
          priority = regular = 2;
         }
       break;

    case 3:
      if (janus)
         priority = janus;
      else
         {
         s = getenv("JANUSPRIORITY");
         if (s)
          priority = janus = atoi(s);
         else
          priority = janus = 3;
         }
       break;

    case 4:
      if (modem)
         priority = modem;
      else
         {
         s = getenv("MODEMPRIORITY");
         if (s)
          priority = modem = atoi(s);
         else
          priority = modem = 4;
         }
      break;

    default:
      priority = 2;
      break;
    }

   (void) DosSetPrty ((USHORT) 1, priority, (SHORT) 31, (USHORT) 0);
}

#ifdef Snoop
#pragma check_stack(off)
static int far pascal _loadds mesgfunc(int error, char far *mesg)
{
  if(!error)
    status_line(":%Fs", mesg);
  else
    status_line("!SYS%04u : %Fs", error, mesg);
  return(0);
}
#pragma check_stack()

void snoop_open(char *callpipename)
{
   static char *pipe = NULL;
   if(pipe != NULL)
      free(pipe);
/* if((*callpipename != '\0') && (callpipename != NULL) && (hsnoop == (HSNOOP)NULL)) */
      pipe = strdup(callpipename);
   SnoopOpen(pipe, &hsnoop, xfer_id, (PFNSN)mesgfunc);
}

void snoop_close(void)
{
  if(hsnoop != (HSNOOP)NULL)
     SnoopClose(hsnoop);
  hsnoop = (HSNOOP)NULL;
}
#endif /* Snoop */
#endif /* OS_2 */

#ifdef NEED_CPUTS
int _cdecl cputs (const char *str)
{
    printf ("%s", str);
    return 0;
}
#endif

#ifdef NEED_PUTCH
int _cdecl putch (int ch)
{
    return putchar (ch);
}
#endif

#ifdef NEED_CPRINTF
int _cdecl cprintf (const char *format, ...)
{
    va_list arg_ptr;

    va_start (arg_ptr, format);
    return vprintf (format, arg_ptr);
}
#endif



