/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*            This header file was written by Peter Fitzsimmons             */
/*             OS/2 Communications definitions for BinkleyTerm              */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define TRUE 1
#define FALSE 0

typedef unsigned char bool;
/*
typedef unsigned char byte;
typedef unsigned short word;
*/
extern void com_putc( unsigned char c );
extern unsigned com_putc_now( unsigned char c );
extern void com_write(char *buf, unsigned int bytes, int carcheck);
extern void com_wait(void);
extern int  com_getchar(void);
extern int  com_peek(void);
extern int  com_char_avail(void);
extern bool com_out_empty(void);
extern bool com_out_full(void);
extern bool com_online(void);
extern void com_clear_out(void);
extern void com_clear_in(void);
extern void com_XON_enable(void);
extern void com_XON_disable(void);
extern long com_cur_baud(void );
extern  int com_init(int port, char far *pipe);
extern  int com_fini(void);
extern  int com_set_baud(unsigned rate,char parity,int databits,int stopbits);
extern  void com_DTR_on(void );
extern  void com_DTR_off(void );
extern  void com_break(int on);

extern  void MDM_ENABLE(unsigned rate);
extern  void MDM_DISABLE(void );
extern  void BUFFER_BYTE(unsigned char ch);
extern  void UNBUFFER_BYTES(void );
static  void zap_zbuf(void );
extern unsigned Cominit(int port, int failsafe);
extern int get_key(void);

/* translate binkley fossil stuff to my async package */
#define CARRIER            (com_online())
#define MODEM_STATUS       (com_online())
#define CHAR_AVAIL()       com_char_avail()
#define OUT_EMPTY()        com_out_empty()
/* #define OUT_FULL()          (!com_out_empty()) */
#define OUT_FULL()         (com_out_full())
#define LOWER_DTR()        com_DTR_off()
#define RAISE_DTR()        com_DTR_on()
#define CLEAR_OUTBOUND()   com_clear_out()
#define CLEAR_INBOUND()    com_clear_in()
#define KEYPRESS()         kbhit()
#define READKB()           get_key()
#define FOSSIL_CHAR()      get_key()
#define XON_ENABLE()       com_XON_enable()
#define IN_XON_ENABLE()    com_XON_enable()
#define XON_DISABLE()      com_XON_disable()
#define _BRK_DISABLE()
#define FOSSIL_WATCHDOG(x)
#define SENDBYTE(c)        com_putc(c)
#define MODEM_IN()         com_getchar()
/* #define WRITE_ANSI(c)      putchar(c) */
#define PEEKBYTE()         com_peek()
#define do_break(on)       com_break(on)
#define SENDCHARS(buf, size, carcheck) com_write(buf, size, carcheck)
#define Com_Tx_NW(c)        com_putc_now(c)

#define real_flush(fh)     DosBufReset(fh)

/* some usefull bits */
#define RLSD  0x80       /* (MSR) Received line signal detect,
                  * sometimes called Carrier Detect */
#define THRE 0x20        /* (LSR) Transmitter holding register empty
                  * (ready for another byte) */
#define DR   0x1         /* (LSR) Data ready indicator */
#define OE   0x2         /* (LSR) Overrun error! We are not reading the
                  * bytes fast enuf */

extern unsigned short hfComHandle;
extern unsigned long WriteSem;


#if defined(OS2_INCLUDED) && !defined(BSEDEV_INCLUDED) && !defined(ASYNC_SETBAUDRATE)

/* OS/2 Category 1 DosDevIoctl() calls */
#define SERIAL          1       /* category: serial device control */
#define ASYNC_SETBAUDRATE    0x0041  /* Sets baud rate                                 */
#define ASYNC_SETLINECTRL    0x0042  /* Sets line characteristics for serial device    */
#define ASYNC_TRANSMITIMM    0x0044  /* Transmits byte immediately                     */
#define ASYNC_SETBREAKOFF    0x0045  /* Sets break off                                 */
#define ASYNC_SETMODEMCTRL   0x0046  /* Sets modem control register                    */
#define ASYNC_STOPTRANSMIT   0x0047  /* Stops device from transmitting                 */
#define ASYNC_STARTTRANSMIT  0x0048  /* Starts a transmission                          */
#define ASYNC_SETBREAKON     0x004B  /* Sets break on                                  */
#define ASYNC_SETDCBINFO     0x0053  /* Sets device control block information          */
#define ASYNC_GETBAUDRATE    0x0061  /* Retrieves current baud rate                    */
#define ASYNC_GETLINECTRL    0x0062  /* Gets line characterstics of serial device      */
#define ASYNC_GETCOMMSTATUS  0x0064  /* Retrieves communications status                */
#define ASYNC_GETLINESTATUS  0x0065  /* Retrieves current line status                  */
#define ASYNC_GETMODEMOUTPUT 0x0066  /* Retrieves modem-control output signals         */
#define ASYNC_GETMODEMINPUT  0x0067  /* Retrieves modem control register               */
#define ASYNC_GETINQUECOUNT  0x0068  /* Retrieves number of characters in input queue  */
#define ASYNC_GETOUTQUECOUNT 0x0069  /* Retrieves number of characters in output q     */
#define ASYNC_GETCOMMERROR   0x006D  /* Retrieves communications error                 */
#define ASYNC_GETCOMMEVENT   0x0072  /* Retrieves communications event mask            */
#define ASYNC_GETDCBINFO     0x0073  /* Retrieves device control block information     */

#define GENERIC         11      /* category: generic device control commands */
#define FLUSHINPUT      1       /* function: flush input buffer */
#define FLUSHOUTPUT     2       /* function: flush output buffer */

typedef struct _DCBINFO {
    USHORT usWriteTimeout;
    USHORT usReadTimeout;
    BYTE   fbCtlHndShake;
    BYTE   fbFlowReplace;
    BYTE   fbTimeout;
    BYTE   bErrorReplacementChar;
    BYTE   bBreakReplacementChar;
    BYTE   bXONChar;
    BYTE   bXOFFChar;
} DCBINFO;

typedef struct _RXQUEUE {
    USHORT cch;
    USHORT cb;
} RXQUEUE;
#else
 #if !defined(BSEDEV_INCLUDED)
 #define BSEDEV_INCLUDED
 #endif
#endif
