        name    TASK
        page    80,130
        title   TASK -- Accepts keyboard input in a .BAT file.
        subttl  _______  Written by:  Davy Crockett  _______

;       ---------------------------------
;       :   Davy Crockett Productions   :
;       :   5807 Cherrywood Lane, 104   :
;       :   Greenbelt, Maryland 20770   :
;       ---------------------------------

; Modification History              Date Written: 10 September 1985

; 01/20/86 : changed from ASK to TASK.                  Ver 1.1

; TASK -- This little program accepts a single keystroke
;         and sets the error level on return to DOS.

; Execute with:  TASK <prompt> <$valid-responses>
;
; Both <prompt> and <$valid-responses> are optional.
; If a prompt is not supplied, TASK simply waits for a key
; to be pressed and returns an ErrorLevel equal to the ASCII
; code of the key pressed.
;
; The valid responses must begin with a "$".
; If a string of valid responses is not supplied,
; TASK will accept any key pressed and return the code.
; All input is converted to upper case before it is
; checked against the validation table.

cr      equ     0DH             ; carriage return
lf      equ     0AH             ; line feed
eol     equ     '$'             ; ascii eol sign

prompt  equ     80H             ; buffer for command tail

cseg    segment para public 'CODE'

        assume  cs:cseg,ds:cseg

        org     100H            ; start .COM at 100H

task    proc    far

;       Check for a Prompt String

        mov     si,prompt       ; point to command tail
        lodsb                   ; pick up the first character
        test    al,al           ; is there anything there?
        jz      accept_input    ; no, jump to get input
        xor     ah,ah           ; yes, find the end
        add     ax,prompt+1     ;  of the prompt line
        mov     di,ax           ; move pointer to proper reg
        mov     al,eol          ; load EOL indicator
        stosb                   ; mark the end of prompt
        mov     al,0            ; end of tail marker
        stosb                   ; assure end of tail marker

        mov     si,prompt+2     ; point to start
scan_loop:
        lodsb                   ; pick up the byte
        cmp     al,eol          ; found a dollar sign?
        jnz     scan_loop       ; no, continue scan
        lodsb                   ; pick up the next byte
        cmp     al,0            ; end of command tail?
        jz      end_scan        ; yes, skip move
        mov     di,offset vtable ; point to destination
move_loop:
        call    to_upper        ; convert to upper case
        stosb                   ; store this byte
        lodsb                   ;  and pick up the next
        cmp     al,eol          ; end of validation string?
        jnz     move_loop       ; no, continue moving

end_scan:
        mov     dx,prompt+2     ; point to the beginning
        mov     ah,09H          ; load function code
        int     21H             ; display the prompt

;       Accept a single keystroke from the user

accept_input:
        mov     ah,08H          ; load function code
        int     21H             ; accept a keystroke
        call    to_upper        ; convert to upper case
        cmp     al,0            ; function key pressed?
        jnz     validation      ; no, go to validate
        mov     ah,08H          ; strip out extended
        int     21H             ;  key
        jmp     razz            ;   and razz the user

;       Scan for Verification Table & Validate

validation:
        mov     si,offset vtable ; point to validation string
        cmp     byte ptr[si],0  ; validations supplied?
        jz      input_accepted  ; no, accept this byte
valid_loop:
        cmp     byte ptr[si],0  ; end of string?
        jz      razz            ; yes, invalid key
        cmp     al,byte ptr[si] ; valid byte?
        jz      input_accepted  ; yes, jump to process
        inc     si              ; bump the pointer
        jmp     valid_loop      ; no, continue validation

;       Invalid input, Razz the user

razz:
        mov     ah,02H          ; load function code
        mov     dl,07H          ;  & beep code
        int     21H             ; beep the user
        jmp     accept_input    ; return for proper input

;       Return keystroke as Error Level

input_accepted:
        push    ax              ; save the keystroke
        mov     dl,al           ; move input to DL reg
        mov     ah,02H          ; load function code
        int     21H             ; display keystroke
        mov     dl,cr           ; display CR
        mov     ah,02H          ;
        int     21H             ;
        mov     dl,lf           ; display LF
        mov     ah,02H          ;
        int     21H             ;
        pop     ax              ; retrieve keystroke
        mov     ah,4CH          ; set error code & return
        int     21H             ;

vtable  dw      128 dup(0)      ; validation table storage

task    endp

;       Convert lower case to UPPER CASE

to_upper        proc    near
        cmp     al,'a'          ; smaller than little "a"?
        jb      pass_char       ; yes, skip conversion
        cmp     al,'z'          ; bigger than little "z"?
        ja      pass_char       ; yes, skip conversion
        sub     al,20H          ; no, convert
pass_char:
        ret                     ; return to main
to_upper        endp

cseg    ends

        end     task
