Title   DirOf   Check for a directory - 10/05/87 - Davy Crockett

;       ͻ
;          Davy Crockett Productions   
;          5807 Cherrywood Lane, 104   
;          Greenbelt, Maryland 20770   
;       ͼ

RetNear Macro
        DB      0C3H
        Endm

Cseg    Segment
        Assume  DS:Cseg, SS:Cseg, CS:Cseg, ES:Cseg

        Org     100H

Null    Equ     00H
CR      Equ     0DH
LF      Equ     0AH
Parms   Equ     80H

DirOf:
        Mov     BX,Parms                ; point to trailer
        Cmp     Byte Ptr [BX],Null      ; anything there?
        Jnz     GetDefault              ; yes, continue
        Jmp     DisplayHelp             ; no, display help screen

GetDefault:
        Mov     AH,19H                  ; function code to
        Int     21H                     ;  obtain default drive
        Add     AL,'A'                  ; adjust to ascii
        Mov     DriveName,AL            ;  and save for later

        Mov     SI,Offset 2[Parms]      ; point to trailer
        Mov     DI,Offset DriveName     ; point to buffer
        Cmp     Byte Ptr 1[SI],':'      ; drive included?
        Jz      MoveTrailer             ; yes, use it
        Mov     DI,Offset 2[DriveName]  ; no, use default drive

MoveTrailer:
        Lodsb                           ; pick up a byte
        Cmp     AL,CR                   ; end of trailer?
        Jz      TerminateTrailer        ; yes, go make ASCIIZ
        Stosb                           ; no, store this byte
        Jmp     Short   MoveTrailer     ;  and look for more

TerminateTrailer:
        Xor     al,al                   ; terminate the string
        Stosb

CheckForDisk:
        Call    Ready                   ; disk in drive?
        Jc      NoDiskExit              ; no, exit stage left
SetDTA:
        Mov     DX,Offset DiskBuffer    ; point to DTA
        Mov     AH,1AH                  ; Set DTA function
        Int     21H                     ; set Data Transfer Address
FindFirst:
        Mov     DX,Offset DriveName     ; point to path name
        Mov     CX,10H                  ; attribute = dir's only
        Mov     AH,4EH                  ; FindFirst Function
        Int     21H                     ; find the directory
        Jc      NotFoundExit            ; error, exit stage left
StatusTest:
        Cmp     Byte Ptr 21[DiskBuffer],10H ; Dir?
        Jz      FoundExit
FindNext:
        Mov     AH,4FH                  ; FindNext Function
        Int     21H                     ; get another one
        Jnc     StatusTest              ; go check this one

NotFoundExit:
        Mov     AL,1                    ; not found return code
        Jmp     Short   DirOfExit       ; exit state left
FoundExit:
        Mov     AL,2                    ; found the bugger!
        Jmp     Short   DirOfExit       ; exit state left
DisplayHelp:
        Mov     DX,Offset FileName      ; point to message
        Mov     AH,09H                  ; display string function
        Int     21H                     ; StdOut
NoDiskExit:
        Mov     AL,0                    ; no disk return code
DirOfExit:
        Mov     AH,4CH                  ; terminate a process
        Int     21H                     ; exit stage left

Ready:
        Mov     AL,DriveName            ; drive letter
        And     AL,5FH                  ; upper case
        Sub     AL,'A'                  ; adjust to binary
        Mov     BX,Offset DiskBuffer    ; disk buffer address
        Mov     CX,1                    ; number of sectors
        Mov     DX,0                    ; beginning sector number
        Int     25H                     ; absolute disk read
        Pop     BX                      ; remove flags from stack
        RetNear                         ; exit stage right

DriveName       DB      '?:'
FileName        Equ     $
                DB      CR,LF,LF
                DB      '* DirOf * Version 1.0 * 05 Oct 1987 '
                DB      '* Davy Crockett *',CR,LF,LF
                DB      'Tests for the existence of a Sub-Directory. ',CR,LF,LF
                DB      '    Execute:  DirOf [pathname]  ',CR,LF,LF
DiskBuffer      Equ     $
                DB      '    Return Code = 0, no diskie in the drive.',CR,LF
                DB      '    Return Code = 1, directory does not exist.',CR,LF
                DB      '    Return Code = 2, directory was found.',CR,LF,LF
                DB      '$'

DirOfLen        Equ     (This Byte) - (Offset DirOf)
Filler          Equ     432 - DirOfLen
                DB      Filler DUP(0)
CopyRight       Equ     $
                DB      'ͻ '
                DB      'Davy Crockett '
                DB      ' Productions  '
                DB      ' 05 Oct 1987  '
                DB      'ͼ'

Cseg    Ends

End     DirOf
