; DXF2DWG.LSP   10/26/94  BY: David Bunch
;Do a Redirected DIR output of user specified .DXF files to a FILE so
;we can read them & create a SCRIPT file to run
(defun c:dxf2dwg (/ COUNT E_RD E_WR FN SLEN R_PT W_PT DXFNM DWGNM DPRNM TP TOT
                    PREFIX)
 (setq FN (getstring "\nEnter .DXF file names to convert [*.DXF] : "))
 (setq SLEN (strlen FN))			;get length of string
 (setq E_RD 0 E_WR 0 DPRNM "" TOT 0)
 (if (= SLEN 0) (setq FN "*.DXF"))	;If user hit RETURN, use default
;Use environment Variable TEMP for the path of where to store the
;redirected DIR file & SCRIPT file.  If it does not exist use current
;default directory
 (setq PREFIX (getvar "DWGPREFIX"))
  (if (not (setq TP (getenv "TEMP"))) (setq TP PREFIX))
;Add a "\" to the end of PATH, if it does not exist.
  (if (not (wcmatch TP "*\\")) (setq TP (strcat TP "\\")))
  (setq DIRNAM (strcat TP "DXF2DWG.IN"))
  (setq EXEC (strcat "DIR " FN " \> " DIRNAM))
  (command "._SHELL" EXEC)				;Send DOS DIR command
  (setq SCRNAM (strcat TP "DXF2DWG.SCR"))
  (if (setq W_PT (open SCRNAM "w")) (setq E_WR 1))	;Open Script file
  (if (setq R_PT (open DIRNAM "r")) (setq E_RD 1))	;Open DIR file
  (if (and (= E_RD 1) (= E_WR 1))		;If both opens were successful
   (progn
    (setq COUNT 0)				;Intialize .DXF file counter
    (while (setq RD_LINE (read-line R_PT))	;Read all of DIR file
     (setq SLEN (strlen RD_LINE))		;Get length of string
     (setq RD_LINE (strcase RD_LINE))		;convert to UPPERCASE
;Does it have .DXF extension?
     (if (wcmatch RD_LINE "*DXF*")
      (progn
       (setq TOT (+ TOT 1))
       (setq X 0 ATOM_CHR 0)
       (while (and (or (/= ATOM_CHR 32)
                       (/= ATOM_CHR 9)
		       (/= ATOM_CHR 46)) (< X SLEN))
        (setq ATOM_CHR (ascii RD_LINE))		;extract next char. from string
        (setq RD_LINE (substr RD_LINE 2))
        (if (or (= ATOM_CHR 32)(= ATOM_CHR 9)(= ATOM_CHR 46))
         (progn
          (if (/= DPRNM "")
           (progn
            (setq DXFNM (strcat DPRNM ".DXF"))
            (setq DWGNM (strcat DPRNM ".DWG"))
            (if (and (findfile DXFNM) (not (findfile DWGNM)))
             (progn
              (princ (strcat "\n" "\"" DXFNM "\""))
;The "=" after the name sets NO PROTYPE in NEW command
              (write-line (strcat "_NEW " DPRNM "=") W_PT)
              (write-line (strcat "_DXFIN " DPRNM) W_PT)
              (write-line (strcat "_SAVE " DPRNM) W_PT)
              (setq COUNT (+ COUNT 1))
             )
             (if (findfile DXFNM)
              (princ (strcat "\n" "\"" DWGNM "\"" " already exists!"))
              (princ (strcat "\n" "\"" DXFNM "\"" " not found!"))
             )
           )
           (setq DPRNM "")
	   (setq X SLEN)
          )
         )
        )
         (progn
          (setq DPRNM (strcat DPRNM (chr ATOM_CHR)))    ;else
         )
        )                                          ;endif
        (setq X (+ 1 X))
       )                                            ;end WHILE
      )
     )
    )
   )
  )
;Write delete command to SCRIPT file.  This will allow the script to delete
;itself after it is done.  If you have SHARE loaded you will get an
;Abort, Retry, or Fail on this.  If you hit retry it will delete
;it the next time.  If you don't have SHARE running it will usually lock up,
;so I have commented out this line
;  (write-line (strcat "_SHELL del " SCRNAM) W_PT)
  (close R_PT)				;close input file
  (close W_PT)				;close output .SCR file
  (princ)
  (setq EXEC (strcat "DEL " DIRNAM))
  (command "._SHELL" EXEC)		;Delete DIR input file
  (if (/= COUNT 0)			;Were there any valid files to convert
   (progn
    (princ (strcat "\n" (itoa COUNT) " of " (itoa TOT) " File(s) to convert\n"))
    (getstring "Hit Return to continue or ^C to abort\n")
    (command "._SCRIPT" SCRNAM)		;run script we just created
   )
   (progn
    (setq EXEC (strcat "DEL " SCRNAM))
    (command "._SHELL" EXEC)
    (princ (strcat "\nNo files to convert!"))
   )
  )
 (princ)
)
