//========================================================================//
//=               D C L   C O D E   G E N E R A T O R                    =//
//========================================================================//
//=  File        : DCG.DCL                                               =//
//=  Description : DCL Definitions for DCG                               =//
//=  Version     : 0.90-BETA                                             =//
//=  Author      : Carlos Legarreta                                      =//
//=  Date        : February 1, 1994                                      =//
//========================================================================//

dcl_settings : default_dcl_settings { audit_level = 3; }

/*---------------------------------------------------------*/
/* DCG : Main Program Dialogue Box                         */
/*---------------------------------------------------------*/
dcg : dialog {
    key = "dcg";
    : row {
        : boxed_column {
            label = "DCL Work File";
            : text { 
                key = "dcg_dclfile"; 
                width = 31; 
            }
        }
        : boxed_column {
            label = "Dialogue Box Name";
            : text { 
                key = "dcg_dlgname"; 
                width = 31; 
            }
        }
    }
    : row {
        : column {
            : button {
                label = "    File    ";
                key = "dcg_file";
                mnemonic = "F";
            }
            : button {
                label = "  Options   ";
                key = "dcg_opti";
                mnemonic = "O";
            }
        }
        : column {
            : button {
                label = "  View DCL  ";
                key = "dcg_view";
                mnemonic = "V";
            }
            : button {
                label = "  Edit DCL  ";
                key = "dcg_edcl";
                mnemonic = "E";
            }
        }
        : column {
            : button {
                label = "Dialog Name";
                key = "dcg_name";
                mnemonic = "N";
            }
            : button {
                label = "  ACAD.DCE  ";
                key = "dcg_adce";
                mnemonic = "A";
            }
        }
        : button {
            label = " Preview... ";
            key = "dcg_prev";
            mnemonic = "P";
            height = 3.3;
        }
    }
    : spacer { height = 0.5; }
    : row {
        : list_box {
            label = "Predefined Elements:";
            key = "dcg_pred";
            height = 10;
            width = 25;
            fixed_width = true;
        }
        spacer_1;
        : boxed_column {
            children_alignment = centered;
            : button {
                key = "tile_add";
                label = ">> Add >>";
                mnemonic = "A";
            }
            : button {
                key = "tile_edt";
                label = "Edit";
                mnemonic = "E";
            }
            : button {
                key = "tile_rep";
                label = "Replace";
                mnemonic = "R";
            }
            : button {
                key = "tile_del";
                label = "Delete";
                mnemonic = "D";
            }
            : button {
                key = "tile_mov";
                label = "Move";
                mnemonic = "M";
            }
        }
        spacer_1;
        : list_box {
            label = "Selected Elements:" ;
            key = "dcg_slct";
            height = 10;
            width = 25;
            fixed_width = true;
        }
    }
    spacer;
    : row {
        : column {
            : row {
                fixed_width = true;
                alignment = right;
                : ok_button {
                    label = "Exit";
                    mnemonic = "E";
                    key = "dcg_exit";
                }
                : spacer { width = 1; }
                : help_button { key = "dcg_help"; }
                : spacer { width = 1; }
                : info_button { key = "dcg_info"; }
            }
            errtile;
        }
        : column {
            : row {
                spacer_0;
                : image {
                    key = "dcg_img";
                    width = 3.5;
                    height = 1;
                    color = -15;
                }
            }
        }
    }
}

/*---------------------------------------------------------*/
/* DCG_FILE : File functions menu.                         */
/*---------------------------------------------------------*/
dcg_file : dialog {
    label = "File";
    : row {
        : column {
            width = 12;
            : button {
                label = "New...";
                key = "file_new";
                mnemonic = "N";
            }
            : button {
                label = "Open...";
                key = "file_opn";
                mnemonic = "O";
            }
            : button {
                label = "Merge...";
                key = "file_mrg";
                mnemonic = "M";
            }
        }
        : column {
            width = 12;
            : button {
                label = "Save...";
                key = "file_sav";
                mnemonic = "S";
            }
            : button {
                label = "Save As...";
                key = "file_sas";
                mnemonic = "A";
            }
            : button {
                label = "Print";
                key = "file_prn";
                mnemonic = "P";
            }
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            help_button;
        }
    }
}

/*---------------------------------------------------------*/
/* DCG_FILE_NEW : Confirm deletion of current dlg box      */
/*---------------------------------------------------------*/  
dcg_file_new : dialog {
    label = "New";
    : text {
        label = "   Clear current Dialog?   ";
    }
    : row {
        spacer_1;
        : button {
            label = "Yes";
            key = "accept";
            mnemonic = "Y";
        }
        : button {
            label = "No";
            key = "cancel";
            mnemonic = "N";
            is_default = true;
            is_cancel = true;
        }
        spacer_1;
    }
}

/*---------------------------------------------------------*/
/* DCG_OPTIONS : Options menu dialogue box                 */
/*---------------------------------------------------------*/ 
dcg_options : dialog {
    label = "Options";
    : row {
        : boxed_column {
            label = "DCL Code Generator";
            : toggle {
                label = "Confirm on [DELETE]?";
                key = "dcg_confdel";
            }
            : toggle {
                label = "Auto [EDIT] after [ADD]?";
                key = "dcg_autoedt";
            }
            : toggle {
                label = "Auto load ACAD.DCE?";
                key = "dcg_autodce";
            }
            : toggle {
                label = "Full-screen view DCL code?";
                key = "dcg_dlgview";
            }
            : toggle {
                label = "Hide DCG before [PREVIEW]?";
                key = "dcg_hidedcg";
            }
            spacer;
            : row {
                : edit_box {
                    label = "TAB Spacing:";
                    key = "dcg_tabs";
                    edit_width = 2;
                    edit_limit = 1;
                }
                : slider {
                    key = "dcg_slid";
                    min_value = 0;
                    max_value = 5;
                    action = "(set_tile \"dcg_tabs\" $value)";
                    width = 12;
                }
            }
            : popup_list {
                label = "Printer Port:";
                key = "dcg_prntdev";
                mnemonic = "P";
                list = "NONE\nPRN\nLPT1\nLPT2\nCOM1\nCOM2";
                edit_width = 6;
            }
        }
        spacer;
        : boxed_column {
            label = "DCL Code Settings";
            : boxed_radio_column {
                label = "Semantic Audit Level";
                key = "dcl_sett";
                : radio_button {
                    label = "0: No Checking";
                    key = "0";
                    mnemonic = "0";
                }
                : radio_button {
                    label = "1: Errors";
                    key = "1";
                    mnemonic = "1";
                }
                : radio_button {
                    label = "2: Warnings";
                    key = "2";
                    mnemonic = "2";
                }   
                : radio_button {
                    label = "3: Hints";
                    key = "3";
                    mnemonic = "3";
                }
            }
            spacer;
            : row {
                : edit_box {
                    label = "TAB Spacing:";
                    key = "dcl_tabs";
                    edit_width = 2;
                    edit_limit = 2;
                }
                : slider {
                    key = "dcl_slid";
                    min_value = 0;
                    max_value = 30;
                    action = "(set_tile \"dcl_tabs\" $value)";
                    width = 12;
                }
            }
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button { is_default = false; }
            spacer_1;
            : button {   
                label = "  Save  ";
                key = "opt_save";
                mnemonic = "S";
                is_default = true;
            }        
            spacer_1;
            cancel_button;
            spacer_1;
            help_button;
        }
    }
}

/*---------------------------------------------------------*/
/* DCG_DLGNAME : Input Dialogue Box for "[DIALOG NAME]"    */
/*---------------------------------------------------------*/  
dcg_dlgname : dialog {
    label = "Dialogue Box Name";
    initial_focus = "dlg_name";
    spacer;
    : edit_box {
        label = "Name:";
        key = "dlg_name";
        mnemonic = "D";
        edit_width = 30;
        edit_limit = 60;
    }
    spacer;
    ok_cancel_help;
    errtile;
}

/*---------------------------------------------------------*/
/* DCG_VIEW_DCLCODE : Dialog to View Current DCL Code.     */
/*---------------------------------------------------------*/
dcg_view_dclcode : dialog {
    label = "DCL Script Code";
    initial_focus = "dcl_code";
    : text {
        key = "dcl_sett";
        width = 65;
    }
    : list_box {
        key = "dcl_code";
        width = 65;
        height = 15;
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            spacer_1;
            help_button;
        }
    }
} 

/*---------------------------------------------------------*/
/* DCG_VIEW_ACADDCE : Dialog to View ACAD.DCE Error File.  */
/*---------------------------------------------------------*/
dcg_view_acaddce : dialog {
    label = "ACAD.DCE Error File";
    initial_focus = "dce_text";
    : list_box {
        key = "dce_text";
        width = 65;
        height = 15;
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            ok_button;
            spacer_1;
            help_button;
        }
    }
}

/*---------------------------------------------------------*/
/* DCG_MOVE : MOVE Tile Dialogue Box.                      */
/*---------------------------------------------------------*/
dcg_move : dialog {
    label = "Move";
    initial_focus = "dcg_slct";
    : text {
        key = "dcg_text";
        width = 25;
    }
    : list_box {
        key = "dcg_slct";
        height = 10;
        width = 25;
    }
    ok_cancel_help;
    errtile;
}
/*---------------------------------------------------------*/
/* DCG_DELETE_CONFIRM : Confirm "[DELETE]" command         */
/*---------------------------------------------------------*/
dcg_delete_confirm : dialog {
    key = "del_lbl";
    spacer;
    : column {
        children_alignment = centered;
        : text { 
            width = 30;
            key = "del_msg";
        }                  
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {        
                label = "  Yes  ";
                key   = "dcg_yes";
                mnemonic = "Y";
            }
            spacer;
            : button {  
                label = "  No  ";
                key   = "dcg_no";
                mnemonic = "N";
            }
        }
    }
    spacer;
}

/*---------------------------------------------------------*/
/* DCG_OPEN_CONFIRM : Confirms "[OPEN]" if DCL not saved.  */
/*---------------------------------------------------------*/
dcg_open_confirm : dialog {
    label = "WARNING!";
    spacer;
    : row {
        : column {
            children_alignment = centered;
            : text { label = " Current dialog has been modified. "; }
            : text { label = "ALL CHANGES WILL BE LOST."; }
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {
                label = "Continue...";
                is_default = false;
            }
            spacer;
            : cancel_button { 
                label = "   Cancel   ";
                is_default = true; 
            }
        }
    }
    spacer;
}

/*---------------------------------------------------------*/
/* DCG_EXIT : Confirm "[EXIT]" Dialogue Box                */
/*---------------------------------------------------------*/
dcg_exit : dialog {
    key = "ext_lbl";
    spacer;
    : column {
        children_alignment = centered;
        : text { 
            width = 35;
            key = "ext_msg";
        }
    }
    spacer;
    : column {
        : row {
            fixed_width = true;
            alignment = centered;
            : ok_button {        
                label = "  Yes  ";
                key   = "dcg_yes";
                mnemonic = "Y";
            }
            spacer;
            : button {  
                label = "  No  ";
                key   = "dcg_no";
                mnemonic = "N";
            }
        }
    }
    spacer;
}

/*---------------------------------------------------------*/
/* DCG_INFO : Product Information Dialog                   */
/*---------------------------------------------------------*/
dcg_info : dialog {
    label = "Information";
    : row {
        spacer_1;
        : image {
            key = "dcg_img";
            height = 4;
            aspect_ratio = 1.5;
            color  = -15;
        }
        : column {
            : row {
                children_alignment = bottom;
                : text {    
                    label = "                          ";
                    key   = "inf_text1";
                }
            }
        }
    }
    : row {             
        : text { 
            label = "_______________________________________"; 
        }
    }
    : row {
        : column {
            children_alignment = centered;
            : text {
                label = "";
                key   = "inf_text2";
            }
            : text {     
                label = "";
                key   = "inf_text3";
            }
            : text {
                label = "";
                key   = "inf_text4";
            }
        }
    }
    spacer;
    ok_only;
}


//========================================================================//
//=  PROTOTYPES & SUBASSEMBLIES - Used by Some Dialogue Box Definitons   =//
//========================================================================//

/*---------------------------------------------------------*/
/* DCG_EDT_LABEL : "TILE LABEL" Edit Box                   */
/*---------------------------------------------------------*/
dcg_edt_label : edit_box {
    label = "Label: ";
    key   = "edt_label";
    mnemonic = "L";
}

/*---------------------------------------------------------*/
/* DCG_EDT_VALUE : "TILE VALUE" Edit Box                   */
/*---------------------------------------------------------*/
dcg_edt_value : edit_box {
    label = "Value: ";
    key   = "edt_value";
    mnemonic = "V";
}

/*---------------------------------------------------------*/
/* DCG_EDT_KEY : "TILE KEY" Edit Box                       */
/*---------------------------------------------------------*/
dcg_edt_key : edit_box {
    label = "Key:   ";
    key   = "edt_key";
    mnemonic = "K";
}

/*---------------------------------------------------------*/
/* DCG_EDT_ACTION : "ACTION" Edit Box                      */
/*---------------------------------------------------------*/
dcg_edt_action : edit_box {
    label = "Action:";
    key = "edt_actio";
    mnemonic = "A";
}

/*---------------------------------------------------------*/
/* DCG_EDT_MNEMONIC : "TILE MNEMONIC" Edit Box w/ Slider   */
/*---------------------------------------------------------*/
dcg_edt_mnemonic : row {
    key = "mnemonic";
    : edit_box { 
        label = "Mnemonic:";
        key   = "edt_mnemo";
        mnemonic = "M";
        edit_width = 1;
        edit_limit = 1;
    }
    : slider {
        key = "edt_mnesl";
        min_value = 1;
        max_value = 10;
        action = "(set_tile \"edt_mnemo\" (substr (get_tile \"edt_label\") (atoi $value) 1))";
        width = 12;
    }
}

/*---------------------------------------------------------*/
/* DCG_EDT_LIST : "LIST" Edit Box                          */
/*---------------------------------------------------------*/
dcg_edt_list : edit_box {
    label = "List:";
    key = "edt_list";
    mnemonic = "L";
}

/*---------------------------------------------------------*/
/* DCG_EDT_TABS : "TABS" Edit Box                          */
/*---------------------------------------------------------*/
dcg_edt_tabs : edit_box {
    label = "Tabs:";
    key   = "edt_tabs";
    mnemonic = "T";
}

/*---------------------------------------------------------*/
/* DCG_EDT_ENABLED : "...IS ENABLED" Toggle Switch         */
/*---------------------------------------------------------*/
dcg_edt_enabled : toggle {
    label = "Enabled";
    key = "edt_enabl";
    mnemonic = "E";
}

/*---------------------------------------------------------*/
/* DCG_EDT_TABSTOP : "...IS TAB STOP" Toggle Switch        */
/*---------------------------------------------------------*/
dcg_edt_tabstop : toggle { 
    label = "TAB Stop";
    key = "edt_tabst";
    mnemonic = "T";
}

/*---------------------------------------------------------*/
/* DCG_EDT_ACCEPT : "ALLOW ACCEPT" Toggle Switch           */
/*---------------------------------------------------------*/
dcg_edt_accept : toggle {
    label = "Allow Accept";
    key   = "edt_accep";
    mnemonic = "A";
}

/*---------------------------------------------------------*/
/* DCG_EDT_ALIGNMENT : "ALIGNMENT" Popup List              */  
/*---------------------------------------------------------*/
dcg_edt_alignment : popup_list {
    label = "Alignment:";
    mnemonic = "A";
    list = "Default\nCentered\nLeft\nRight\nTop\nBottom";
}

/*---------------------------------------------------------*/
/* DCG_EDT_ATTRIB1 : "..IS ENABLED/TAB STOP" Subassembly   */
/*---------------------------------------------------------*/
dcg_edt_attrib1 : boxed_row {
    label = "Attributes";
    dcg_edt_enabled;
    dcg_edt_tabstop;
}

/*---------------------------------------------------------*/
/* DCG_EDT_ATTRIB2 : "...IS ENABLED/TAB STOP/ALLOW ACCEPT" */
/*---------------------------------------------------------*/
dcg_edt_attrib2 : boxed_row {
    label = "Attributes";
    dcg_edt_enabled;
    dcg_edt_tabstop;
    dcg_edt_accept;
}

/*---------------------------------------------------------*/
/* DCG_EDT_IMGCOLOR : Color Popup List for Image tiles     */
/*---------------------------------------------------------*/
dcg_edt_imgcolor : popup_list {
    label = "Color: ";
    key   = "img_clist";
    mnemonic = "C";
    list = "Default\nWhite\nBlack\nRed\nYellow\nGreen\nCyan\nBlue\nMagenta\nDialog line\nDialog foreground\nDialog background\nGraphics background";
}

/*---------------------------------------------------------*/
/* DCG_EDT_IMGRATIO : Image "ASPECT RATIO" Attribute       */
/*---------------------------------------------------------*/
dcg_edt_imgratio : row { 
    : edit_box {
        label = "Aspect Ratio:";
        key   = "img_ratio";
        mnemonic = "A";
        edit_width = 3;
    }
    : slider {
        key = "img_rtosl";
        min_value = 0;
        max_value = 100;
        action = "(set_tile \"img_ratio\" $value)";
        width = 12;
    }
}

/*---------------------------------------------------------*/
/* DCG_EDT_CHILDREN : Cluster's Children Attributes - Sub. */
/*---------------------------------------------------------*/
dcg_edt_children : boxed_column {
    label = "Cluster Children";
    : dcg_edt_alignment { key = "edt_calig"; }
    : row {
        : toggle {
            label = "Fixed Height";
            key = "edt_cfhgt";
        }
        : toggle {
            label = "Fixed Width";
            key = "edt_cfwdt";
        }
    }
} 

/*---------------------------------------------------------*/
/* DCG_EDT_SIZE : Size/Layout Attributes - Subassembly     */
/*---------------------------------------------------------*/
dcg_edt_size : boxed_column {
    label = "Size/Layout";
    : row {
        : edit_box {
            label = "Width: ";
            key   = "edt_width";
            edit_width = 2;
        }
        : slider {
            key = "edt_wdtsl";
            min_value = 0;
            max_value = 99;
            action = "(set_tile \"edt_width\" $value)";
            width = 12;
        }
        : toggle {
            label = "Fixed";
            key = "edt_wdtfx";
        }
    }
    : row {
        : edit_box {
            label = "Height:";
            key   = "edt_heigh";
            edit_width = 2;
        }
        : slider {
            key = "edt_hgtsl";
            min_value = 0;
            max_value = 99;
            action = "(set_tile \"edt_heigh\" $value)";
            width = 12;
        }
        : toggle {
            label = "Fixed";
            key   = "edt_hgtfx";
        }
    }
    : dcg_edt_alignment { key = "edt_align"; }
}

//========================================================================//
//=       EDIT COMMAND - Dialog Definitions for all Tile Elements        =//
//========================================================================//

/*---------------------------------------------------------*/
/* DCG_EDIT_DIALOG : Dialogue Box Attributes           #00 */
/*---------------------------------------------------------*/
dcg_edit_dialog : dialog {
    label = "EDIT: Dialogue Box";
    initial_focus = "edt_label";
    : boxed_column {
        label = "Attributes";
        dcg_edt_label;
        dcg_edt_value;
        dcg_edt_key;
        : edit_box {
            label = "Initial Focus:";
            key = "edt_focus";
            mnemonic = "I";
        }
    }
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_BUTTON : "BUTTON" Attributes               #01 */
/*---------------------------------------------------------*/
dcg_edit_button : dialog {
    label = "EDIT: Button";
    initial_focus = "edt_label";
    dcg_edt_label;
    dcg_edt_key;
    dcg_edt_action;
    dcg_edt_mnemonic;
    spacer;
    : boxed_row {
        label = "Button Is...";
        : column {
            : toggle {
                label = "Default";
                key = "edt_defau";
            }
            : toggle {
                label = "Cancel";
                key = "edt_cance";
            }
        }
        : column {
            dcg_edt_enabled;
            dcg_edt_tabstop;
        }
    }
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_EDITBOX : "EDIT BOX" Attributes            #02 */
/*---------------------------------------------------------*/
dcg_edit_editbox : dialog {
    label = "EDIT: Edit Box";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            : boxed_column {
                label = "Edit...";
                : row {
                    : edit_box {
                        label = "Width:";
                        key   = "edt_ewidt";
                        mnemonic = "E";
                        edit_width = 3;
                        edit_limit = 3;
                    }
                    : slider {
                        key = "edt_ewdsl";
                        min_value = 0;
                        max_value = 256;
                        action = "(set_tile \"edt_ewidt\" $value)";
                        width = 12;
                    }
                }
                : row {
                    : edit_box {
                        label = "Limit:";
                        key   = "edt_limit";
                        mnemonic = "L";
                        edit_width = 3;
                        edit_limit = 3;
                    }   
                    : slider {
                        key = "edt_lmtsl";
                        min_value = 0;
                        max_value = 256;
                        action = "(set_tile \"edt_limit\" $value)";
                        width = 12;
                    }
                }
            }
        }
        : column {
            : boxed_row {
                label = "Attributes";
                : column {
                    dcg_edt_enabled;
                    dcg_edt_tabstop;
                }
                : column {
                    dcg_edt_accept;
                }
            }
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_IMAGE : "IMAGE" Attributes                 #04 */
/*---------------------------------------------------------*/
dcg_edit_image : dialog {
    label = "EDIT: Image";
    initial_focus = "edt_key";
    dcg_edt_key;
    dcg_edt_imgcolor;
    dcg_edt_imgratio;
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_IBUTTON : "IMAGE BUTTON" Attributes        #05 */
/*---------------------------------------------------------*/
dcg_edit_ibutton : dialog {
    label = "EDIT: Image Button";
    initial_focus = "edt_key";
    dcg_edt_key;
    dcg_edt_action;
    dcg_edt_imgcolor;
    dcg_edt_attrib2;
    dcg_edt_imgratio;
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_LISTBOX : "LIST BOX" Attributes            #06 */
/*---------------------------------------------------------*/
dcg_edit_listbox : dialog {
    label = "EDIT: List Box";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            dcg_edt_list;
            dcg_edt_tabs; 
        }
        : column {
            : boxed_row {
                label = "Attributes";
                : column {
                    dcg_edt_enabled;
                    dcg_edt_tabstop;
                }
                spacer;
                : column {
                    : toggle {
                        label = "Multiple Select";
                        key   = "edt_multi";
                    }
                    dcg_edt_accept;
                }
            }
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_POPUPLIST : "POPUP LIST" Attributes        #07 */
/*---------------------------------------------------------*/
dcg_edit_popuplist : dialog {
    label = "EDIT: Popup List";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            dcg_edt_list;
            dcg_edt_tabs;
        }
        : column {
            : row {
                : edit_box {
                    label = "Edit Width:";
                    key   = "edt_pwidt";
                    mnemonic = "E";
                    edit_width = 3;
                }
                : slider {
                    key = "edt_pwdsl";
                    min_value = 0;
                    max_value = 256;
                    action = "(set_tile \"edt_pwidt\" $value)";
                    width = 12;
                }
            }
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        } 
    }
    spacer;
    ok_cancel_help;
}   
  
/*---------------------------------------------------------*/
/* DCG_EDIT_RBUTTON : "RADIO BUTTON" Attributes        #08 */
/*---------------------------------------------------------*/
dcg_edit_rbutton : dialog {
    label = "EDIT: Radio Button";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_SLIDER : "SLIDER" Attributes               #09 */
/*---------------------------------------------------------*/
dcg_edit_slider : dialog {
    label = "EDIT: Slider";
    initial_focus = "edt_key";
    : row {
        : column {
            dcg_edt_key;
            dcg_edt_action;
            : row {
                : edit_box {
                    label = "Def Value:" ;
                    key   = "edt_value";
                    mnemonic = "V";
                    edit_limit = 6;
                    edit_width = 6;
                }
                : slider {
                    key = "edt_valsl";
                    min_value = -32768;
                    max_value = 32767;
                    value = "0";
                    action = "(set_tile \"edt_value\" $value)";
                    width = 12;
                }
            }
            : row {
                : edit_box {
                    label = "Min Value:";
                    key   = "edt_minva";
                    mnemonic = "i";
                    edit_limit = 6;
                    edit_width = 6;
                }
                : slider {
                    key = "edt_minsl";
                    min_value = -32768;
                    max_value = 32767;
                    value = "0";
                    action = "(set_tile \"edt_minva\" $value)";
                    width = 12;
                }
            }
            : row {
                : edit_box {                 
                    label = "Max Value:";
                    key   = "edt_maxva";
                    mnemonic = "a";
                    edit_limit = 6;
                    edit_width = 6;
                }
                : slider {
                    key = "edt_maxsl";
                    min_value = -32768;
                    max_value = 32767;
                    value = "10000";
                    action = "(set_tile \"edt_maxva\" $value)";
                    width = 12;
                }
            }
            : row {
                : edit_box {
                    label = "Small Inc:";
                    key   = "edt_small";
                    mnemonic = "S";
                    edit_width = 6;
                }
                : slider {
                    key = "edt_smlsl";
                    min_value = 0;
                    max_value = 1000;
                    action = "(set_tile \"edt_small\" $value)";
                    width = 12;
                }
            }
            : row {
                : edit_box {
                    label = "Big Inc:  ";
                    key   = "edt_bigin";
                    mnemonic = "B";
                    edit_width = 6;
                }
                : slider {
                    key = "edt_bigsl";
                    min_value = 0;
                    max_value = 10000;
                    action = "(set_tile \"edt_bigin\" $value)";
                    width = 12;
                }
            }
        }
        : column {
            : boxed_radio_row {
                label = "Layout";
                key = "edt_layou";
                value = "edt_horiz";
                : radio_button {
                    label = "Horizontal";
                    key   = "edt_horiz";
                    mnemonic = "H";
                }
                : radio_button {
                    label = "Vertical";
                    key   = "edt_verti";
                    mnemonic = "V";
                }
            }
            spacer;
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}
   
/*---------------------------------------------------------*/
/* DCG_EDIT_SPACER : "SPACER" Attributes               #10 */
/*---------------------------------------------------------*/
dcg_edit_spacer : dialog {
    label = "EDIT: Spacer";
    initial_focus = "edt_key";
    dcg_edt_key;
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_TEXT : "TEXT REGION" Attributes            #11 */
/*---------------------------------------------------------*/
dcg_edit_text : dialog {
    label = "EDIT: Text Region";
    initial_focus = "edt_label";
    dcg_edt_label;
    dcg_edt_value;
    dcg_edt_key;
    : boxed_row {
        : text {
            label = "Attribute:";
        }
        : toggle {
            label = "Text is Bold";
            key = "edt_bold";
            mnemonic = "B";
        }
    }
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_TOGGLE : "TOGGLE" Attributes               #12 */
/*---------------------------------------------------------*/
dcg_edit_toggle : dialog {
    label = "EDIT: Toggle";
    initial_focus =  "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_COMMENT :  #13 */
/*---------------------------------------------------------*/
dcg_edit_comment : dialog {
    label = "EDIT: Comment(s)";
    initial_focus = "edt_lin1";
    : row {
        : popup_list {
            label = "Type:  ";
            key = "edt_type";
            list = "Slash - //\nC type - /* */";
            edit_width = 16;
        }
        spacer;
        : toggle {
            label = "Indent with code";
            key = "edt_indt";
        }
    }
    spacer;
    : edit_box {
        label = "Line 1:";
        key = "edt_lin1";
    }
    : edit_box {
        label = "Line 2:";
        key = "edt_lin2";
    }
    : edit_box {
        label = "Line 3:";
        key = "edt_lin3";
    }
    : edit_box {
        label = "Line 4:";
        key = "edt_lin4";
    }
    : edit_box {
        label = "Line 5:";
        key = "edt_lin5";
    }
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_COLUMN : "COLUMN" Attributes               #13 */
/*---------------------------------------------------------*/
dcg_edit_column : dialog {
    label = "EDIT: Column";
    initial_focus = "edt_key";
    dcg_edt_key;
    dcg_edt_size;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_ROW : "ROW" Attributes                     #14 */
/*---------------------------------------------------------*/
dcg_edit_row : dialog {
    label = "EDIT: Row";
    initial_focus = "edt_key";
    dcg_edt_key;
    dcg_edt_size;
    spacer;
    dcg_edt_children;
    spacer;
    ok_cancel_help;
}    

/*---------------------------------------------------------*/
/* DCG_EDIT_BCOLUMN : "BOXED COLUMN" Attributes        #15 */
/*---------------------------------------------------------*/
dcg_edit_bcolumn : dialog {
    label = "EDIT: Boxed Column";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_key;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_children;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}  

/*---------------------------------------------------------*/
/* DCG_EDIT_BROW : "BOXED ROW" Attribues               #16 */
/*---------------------------------------------------------*/
dcg_edit_brow : dialog {
    label = "EDIT: Boxed Row";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_key;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_children;
        }
        : column {
            dcg_edt_attrib1;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}

/*---------------------------------------------------------*/
/* DCG_EDIT_RCOLUMM : "RADIO COLUMN" Attributes        #17 */
/*---------------------------------------------------------*/
dcg_edit_rcolumn : dialog {
    label = "EDIT: Radio Column";
    initial_focus = "edt_value";
    dcg_edt_value;
    dcg_edt_key;
    dcg_edt_action;
    spacer;
    dcg_edt_children;
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_RROW : "RADIO ROW" Attributes              #18 */
/*---------------------------------------------------------*/
dcg_edit_rrow : dialog {
    label = "EDIT: Radio Row";
    initial_focus = "edt_value";
    dcg_edt_value;
    dcg_edt_key;
    dcg_edt_action;
    spacer;
    dcg_edt_children;
    spacer;
    dcg_edt_size;
    spacer;
    ok_cancel_help;
}
  
/*---------------------------------------------------------*/
/* DCG_EDIT_BRCOLUMN : "BOXED RADIO COLUMN" Attributes #19 */
/*---------------------------------------------------------*/
dcg_edit_brcolumn : dialog {
    label = "EDIT: Boxed Radio Column";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_attrib1;
        }
        : column {
            dcg_edt_children;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
}        

/*---------------------------------------------------------*/
/* DCG_EDIT_BRROW : "BOXED RADIO ROW" Attributes       #20 */
/*---------------------------------------------------------*/
dcg_edit_brrow : dialog {
    label = "EDIT: Boxed Radio Row";
    initial_focus = "edt_label";
    : row {
        : column {
            dcg_edt_label;
            dcg_edt_value;
            dcg_edt_key;
            dcg_edt_action;
            dcg_edt_mnemonic;
            spacer;
            dcg_edt_attrib1;
        }
        : column {
            dcg_edt_children;
            spacer;
            dcg_edt_size;
        }
    }
    spacer;
    ok_cancel_help;
} 
//========================================================================//
