comment	|

	This program reads and reports the current contents of the Inter-
	Application Communications Area (IAC).

	The IAC is 16 bytes beginning at addr 0040:00F0h. Any program can
	write information to the IAC for another program to read. Please
	note: unless the first program directly	invokes the second program,
	it cannot protect the IAC from being altered by an intervening program.
	The IAC can be used, for instance, to pass an address from one program
	to the next.

	Written for MASM 5.0 by Hardin Brothers for PCResource. The original
	appeared in the April 1988 issue of their magazine. Entire contents of
	the April 1988 issue (C) Copyright 1988 by
				IDG Communications/Peterborough, Inc.

	Hardin Brothers is a freelance programmer and technical writer. Write
	to him at 280 N. Campus Ave., Upland, CA  91786. Enclose a self-
	addressed, stamped envelope for a reply.

v1.1, 27 Sep 88 Toad Hall Tweak
- Converted to .COM format
- Adding a little local buffer so we can move the entire IAC buffer in
  locally.
- Convert entire IAC area data into hex, THEN display it.
- Using LODSB and STOSB for snarfing bytes from IAC, then stuffing
  to our buffer.
- Learned something about the XLAT instruction (how to override the
  expected DS: segment)!  By the way, unless you're doing an override,
  you don't HAVE to specify BX ("xlat bx").  "xlat" is just fine.
  BX is unchanged, so you don't HAVE to reload it each call.
- Adding a little test:  stuff a message in the IAC area for the
  NEXT time we run this program!  Gives us something to read beside
  0's.
David Kirschbaum
Toad Hall
kirsch@braggvax.ARPA

	|

LF	equ	0Ah		; linefeed char
CR	equ	0Dh		; carriage return char
STDOUT	equ	1		; standard output device
IACLEN	equ	10H		; IAC buffer is 16 bytes long		v1.1

EXIT	macro	val
;	mov	AH, 4Ch		; INT 21h service 4Ch: exit from program
;				; also returns a value. replaces old INT 20h.
;	mov	AL, val		; return value byte
	mov	ax,4C00H + val	; faster as a word			v1.1
	int	21h
	endm

Cseg	SEGMENT PUBLIC PARA 'Code'		;			v1.1
	ASSUME	CS:Cseg, DS:Cseg, ES:Cseg	;			v1.1

	org	100H				;			v1.1

start	proc	near			;				v1.1
	mov	DX, offset title$	; addr DS:DX points to output	v1.1
					; string			v1.1
	mov	CX, LTITLE		; output string byte count
	mov	BX, STDOUT		; write to standard output device
	mov	AH, 40h			; service 40h: write to file/device
	int	21h

	mov	AX, 0040h		; BIOS information segment
	mov	DS,ax			; Initialize for snarfing	v1.1
	ASSUME	DS:Nothing		; Just to be neat		v1.1

	mov	SI, 0F0h		; DS:si = start of IAC
	call	Hexify			; Hexify into hexbuff, display	v1.1

;v1.1 Some new fiddling:
;First move the entire IAC buffer into our local iacbuff and play with it.
;Then move some local data into the IAC buffer and do it again.

	call	Snarf_IAC		; Move IAC data into local buffer

	push	DS			; save that 40H IAC segment
	mov	ax,CS
	mov	DS,ax
	ASSUME	DS:CSeg,ES:Cseg		; Now working in local buffers

	mov	si,offset iacbuff	; Hexify the local buffer this time
	call	Hexify			; Hexify DS:si and display it.

	pop	ES			; ES = IAC segment
	mov	si,offset title$ +2	; Move our little intro text
	mov	di,0F0H			; ES:di = vector to IAC buffer
	mov	cx,IACLEN SHR 1		; IAC buffer length in words
	rep	movsw			; Move our text into the IAC

	mov	ax,CS
	mov	ES,ax			; ES = our code segment again

	call	Snarf_IAC		; Move the new IAC buffer back in
	mov	dx,offset iacbuff	; our buffer
	mov	cx,IACLEN		; nr bytes to write
	mov	BX, STDOUT		; write to standard output device
	mov	AH, 40h			; service 40h: write to file/device
	int	21h

	EXIT	0			; normal termination value
Start	endp

Snarf_IAC	proc	near		;				v1.1
	push	DS
	mov	ax, 0040H		; BIOS data area
	mov	DS,ax
	mov	SI, 0F0h		; DS:si = start of IAC
	mov	CX, IACLEN SHR 1	; length of IAC in words
	mov	di, offset iacbuff	; ES:di = local buffer
	rep	movsw			; move it in
	pop	DS
	ret
Snarf_IAC	endp


	ASSUME	DS:Nothing		;a reminder			v1.1

;Enter with DS:si pointing to buffer you wish hexified.			v1.1
Hexify	proc	near			;				v1.1
	mov	di, offset hexbuff	; ES:di = hex buffer		v1.1
	mov	BX,offset hexasc	; DS:BX points to ASCII		v1.1
	mov	cx,IACLEN		; nr bytes to hexify		v1.1
	cld				; insure forward		v1.1
lp:
	lodsb				; Get a byte from DS:si		v1.1
	call	Convert			; convert bytes to ASCII hex,
					; stuff in hex buffer		v1.1
	loop	lp			; continue loop
	mov	ax,0A0DH		; Terminate hex string with CR/LF v1.1
	stosw
	push	DS			; Save DS a sec			v1.1
	mov	ax,CS			;				v1.1
	mov	DS,ax			;				v1.1
	ASSUME	DS:Cseg			;				v1.1

	mov	cx,di			; string end +1			v1.1
	mov	dx,offset hexbuff	; hex string to display		v1.1
	sub	cx,dx			; - start = chars to display	v1.1
	mov	BX, STDOUT		; write to standard output device
	mov	AH, 40h			; service 40h: write to file/device
	int	21h
	pop	DS			; restore DS			v1.1
	ret
Hexify	endp				;				v1.1

Convert	proc	near			;				v1.1
	mov	dx,cx			; preserve cx loop counter	v1.1
	mov	AH, AL			; keep copy of byte
	mov	CL, 4			; set nibble count
	shr	AL, CL			; move top nibble down
	xlat	CS:[bx]			; translate nibble to hex char v1.1
	stosb				; store Hex char		v1.1
	mov	AL, AH			; restore byte
	and	AL, 0Fh			; mask top nibble
	xlat	CS:[bx]			; translate			v1.1
	stosb				; store char			v1.1
	mov	ax,' h'			; 'h ', reversed		v1.1
	stosw				; store in the string		v1.1
	mov	cx,dx			; restore cx			v1.1
	ret
Convert	endp				;				v1.1

hexasc	db	'0123456789ABCDEF'

title$	db	CR, LF
	db	'Contents of Inter-Application Communication Area'
	db	' (IAC):', CR, LF, CR, LF
LTITLE	equ	$-title$

iacbuff equ	$			;move IAC buffer into here	v1.1
					;for processing (16 bytes long)	v1.1
hexbuff	equ	iacbuff + IACLEN	;buffer to build hex string	v1.1

Cseg	ends
	end	start
