#include <conio.h>
#include <stdio.h>
#include <math.h>

#include "genetic.h"

class Test: public Genetic {
public:
	Test(int x, int y, int z) : Genetic(x,y,z) {};
	float GetFitness(char*, int);
	void ShowChromosome(char*, int);
};

float Test::GetFitness(char* chromo, int size) {
// two variables function minimalization

    float x, y, f;

		x = GetBinValue(chromo,0,size/2)*100.-50.;
		y = GetBinValue(chromo,size/2,size/2)*100.-50.;
		f = x*x/200.+y*y/200.+cos(x)*cos(y);

	return -f;
}

void Test::ShowChromosome(char* chromo, int size) {
	printf("X = %f, Y = %f, F(X,Y) = %f\n",
				 GetBinValue(chromo,0,size/2)*100.-50.,
				 GetBinValue(chromo,size/2,size/2)*100.-50.,
				 -GetFitness(chromo, size));
}

void main() {
	Test t(100,5,20);

    while (!kbhit()) {
		t.Epoch();
	}
}

