
//  GENETIC.H
//  Simple genetic algorithm implementation
//  Piotr Rotkiewicz, piro@chem.uw.edu.pl, 1995
//  Borland C++ 3.1

#include <stdlib.h>
#include <values.h>

class Genetic { // basic genetic class

private:
    char **Population, **NewPopulation, **Elite;
    float *FitnessTable;
    int PopulationSize, ChromosomeSize, EliteSize;
    float MutationProb, COProb, SelectionFactor;
    float RND(void)
        { return (float)random(MAXINT)/(float)MAXINT; }
    void RandomizeChromosome(char *Chromosome);

public:
    Genetic(int, int, int); // constructor
    ~Genetic(void); // destructor

    void Mutation(void);
    void CrossingOver(void);
    void Selection(void);
    void Epoch(void);

    float GetBinValue(char*, int, int);
    // converts chromosome into real value

    virtual float GetFitness(char*, int)
        { return 0; } // fitness

    virtual void ShowChromosome(char*, int)
        { } // shows best chromosome
}; // Genetic

