
// GENETIC.CPP
// Genetic class implementation

#include <iostream.h>
#include <math.h>

#include "genetic.h"

Genetic::Genetic(int PopulationSize, int EliteSize,
								 int ChromosomeSize)
// constructor
{
	Genetic::PopulationSize = PopulationSize;
	Genetic::ChromosomeSize = ChromosomeSize;
	Genetic::EliteSize = EliteSize;

		Population = new char* [PopulationSize];
		if (Population)
			for (int i=0; i<PopulationSize; i++) {
				Population[i] = new char [ChromosomeSize];
				RandomizeChromosome(Population[i]);
			}

		NewPopulation = new char* [PopulationSize];
		if (NewPopulation)
			for (int i=0; i<PopulationSize; i++)
				NewPopulation[i] = new char [ChromosomeSize];

		Elite = new char* [EliteSize];
		if (Elite)
			for (int i=0; i<EliteSize; i++) {
				Elite[i] = new char [ChromosomeSize];
				RandomizeChromosome(Elite[i]);
			}

		FitnessTable = new float [PopulationSize];

		randomize();

		// default values of the simulation parameters
		MutationProb = 0.005;
		COProb = 0.40;
		SelectionFactor = 0.90;
} // Genetic

Genetic::~Genetic(void)
// destructor
{
		for (int i=0; i<PopulationSize; i++)
			delete[] Population[i];
		delete[] Population;

		for (i=0; i<PopulationSize; i++)
			delete[] NewPopulation[i];
		delete[] NewPopulation;

		for (i=0; i<EliteSize; i++)
			delete[] Elite[i];
		delete[] Elite;

		delete [] FitnessTable;
} // ~Genetic

void Genetic::Mutation(void)
// mutation operation
{
		for (int i=0; i<PopulationSize; i++)
			for (int j=0; j<ChromosomeSize; j++)
				if (RND()<MutationProb) // mutacja pojedynczego genu
					Population[i][j] = 1-Population[i][j];
} // Mutation

void Genetic::CrossingOver(void)
// crossing-over operation
{
		for (int i=0; i<PopulationSize; i++)
			if (RND()<COProb) {
				int j = random(PopulationSize);
				if (i!=j) {
					int pos = random(ChromosomeSize);
					for (int k=0; k<pos; k++) {
						// swap positions
						char temp = Population[i][k];
						Population[i][k] = Population[j][k];
						Population[j][k] = temp;
					}
				}
			}
} // CrossingOver

float Genetic::GetBinValue(char* Chromosome,
													 int Position, int Size)
// converts chromosome binary value to (0,1)
{
	float val=0;
		for (int i=Position; i<Position+Size; i++)
			val += Chromosome[i]*pow(2.0,-(i-Position+1));
	 return val;
} // GetBinValue

void Genetic::Selection(void)
// performs selection
{
	float MinFitness=MAXFLOAT;
	float MaxFitness=-MAXFLOAT;
	int BestChromo, N=0;

        // copy chromosomes from the elite group
		for (int i=0; i<EliteSize; i++)
			memcpy(Population[i], Elite[i], ChromosomeSize);

        //
        // find best chromosome
        for (i=0; i<PopulationSize; i++) {
            FitnessTable[i] = GetFitness(Population[i],ChromosomeSize);
			if (FitnessTable[i]<MinFitness)
				MinFitness=FitnessTable[i];
			if (FitnessTable[i]>MaxFitness) {
				MaxFitness=FitnessTable[i];
				BestChromo=i;
			}
		}

        //
		ShowChromosome(Population[BestChromo],ChromosomeSize);

        //
        // choose new population
		if (MaxFitness!=MinFitness) {
			while (N<PopulationSize) {
				int Num=random(PopulationSize);
				if (SelectionFactor*RND()<
						(FitnessTable[Num]-MinFitness)/
						(MaxFitness-MinFitness))
					memcpy(NewPopulation[N++], Population[Num],
								 ChromosomeSize);
			}

            // find best for the "elite group"
			for (int j=0; j<PopulationSize-1; j++)
				for (i=j; i<PopulationSize; i++) // bubblesort
					if (FitnessTable[i]>FitnessTable[j]) {
						float tmp = FitnessTable[i];
						FitnessTable[i] = FitnessTable[j];
						FitnessTable[j] = tmp;
						char *tmp_chromo = Population[i];
						Population[i] = Population[j];
						Population[j] = tmp_chromo;
					}

            //
			for (int i=0; i<EliteSize; i++)
				memcpy(Elite[i], Population[i], ChromosomeSize);

            //
			for (i=0; i<PopulationSize; i++)
				memcpy(Population[i], NewPopulation[i],
							 ChromosomeSize);
		}
} // Selection

void Genetic::RandomizeChromosome(char *Chromosome)
// create random chromosome
{
		for (int i=0; i<ChromosomeSize; i++)
			Chromosome[i]=random(2); // 0 lub 1
} // RandomizeChromosome

void Genetic::Epoch(void)
// single simulation step
{
	Mutation();
	CrossingOver();
	Selection();
} // Epoch

