Declarer Play

Introduction
Counting
Inferences from Opening Leads
Holdup Plays
Holding Off Drawing Trumps
More On Finesses
Backward Finesse
Order of Suit Development
Cross-Ruff
Ruff-and-Sluff
Squeeze
Strip and Throw-In
Trump Coup
Necessary Assumptions
Safety Plays
Transportation And Unblocking
Avoiding the Dangerous Opponent
Loser-On-Loser
En Passant
Winner-On-Winner
Dummy Reversal
Playing the Odds
More Percentages
Tricky Plays
//

Introduction:

Before making the plays discussed in this course file, you must often have a
good idea of the shape and strength of each of the opponents' hands.

While you should make a practice of trying to keep a count on the cards
played, you can tell a lot about the opponents' hands by how they bid and
lead.

This course file will touch briefly on counting and card inferences and then
get into playing techniques.
//

Counting:

[North]
T x x
A T x x
K J x
x x x

[South]
Q x x
K Q J x x
A 9 x
A K

Against South's 4H contract, West leads the KS and AS.

When East discards on the AS, West leads a low Spade which East ruffs.

Before taking the "obvious" QD finesse, lets count cards:

Q: How many Spades did West start with?

A: 6. East had 1 and N-S have 6.
//

[West]
A K J x x x

South plays three rounds of trumps
   (West follows each time),
cashes the KC
   (West follows with a Club),
and leads a trump to dummy
   (West discards a Spade).
A low Club is led from dummy and ruffed
   (West follows with a Club).

Q: How many Diamonds does West have?

A: 1. West started with 6 Spades and has played 3 Hearts and 3 Clubs.

Lead a Diamond to the King and hope that West's one is the Queen or Ten. In
this case the TD falls, so finesse the QD by leading to the A-9 in South's
hand.

[West]
A K J x x x
x x x
T
Q J x

//

Inferences from Opening Leads:

If West bid and East did not, you already know where most of the points are.
If your side has 20 HCP and neither West nor East bid, you might surmise that
the other 20 HCP are split evenly between the two opponents.

As declarer, West's opening lead can tell you even more about the opponent's
high card holdings.

If West leads a King, he should have A-K or K-Q in the suit. If he leads a Q,
J, or Ten, he is probably leading the top of a series such as Q-J-T or T-9-8.
If he leads 4th-high in a suit, the Rule of Eleven can tell you how many high
cards East has in the suit.

If West makes a top-of-nothing type lead or a trump lead, it's a pretty good
bet he does not have any of the types of holdings just mentioned, particularly
touching honors.
//

Holdup Plays:

[W]
K Q J x x x

[N]
x x

[E]
???

[S]
A T x

If the opponent leads a suit in which you have only one stopper, it is usually
a good idea to put off winning the trick until you think the leader's partner
is also playing her last card in the suit.

For example, if West opened a Weak-2 (showing 6 cards) and S-N have 5 of the
suit between them, then that just leaves 2 for East, so you could take the 2nd
round instead of holding off for the 3rd.

If you can calculate that East has only one card in the suit, you can safely
take the opening lead.
//

[Erase]
[N]
A K x x x

[S]
x x

Another common "holdup" or "ducking" play is when you are trying to establish
a suit in dummy (whether in NT or a suit contract) and you have no other
entries to dummy outside of that suit.

With the holdings shown, your only hope of making 4 tricks in Spades is if
they split 3-3 in the opponent's hands.

Normally, you might play A, then K, then a small one, but if you do that, you
have no way to get back to the dummy to take the last two Spades.

So instead, you play a low Spade from your hand AND from dummy on the first
trick. That way, you have a Spade to lead from your hand when you get the lead
back and if Spade are split 3-3, dummy's Ace-King will establish the suit.
//

[N]
J x x
J T x x
A K x x
x x

[S]
A x
A Q x x x
Q x x
K J x

[Bid]
1H
Pass
2H
Pass
3H
Pass
4H

As declarer, when West leads a suit in which you have the Ace, do not just
automatically take the trick. Analyze whether forcing West to lead again can
help you.

If West leads the KS and you have the hand shown, you should most definitely
duck and let West lead again since any lead he makes (except Diamonds, which a
look at the Dummy will discourage) will give you a trick.

An exception would be if you have reason to believe that East might be short
in the suit led and able to ruff the second round. For example, if West had
preempted with 3S before your side took the bid at 4H, you know that East only
has 1 Spade at most.

Also, you should not duck if West can change to another suit that would hurt
you more than the suit originally led, or if you have a chance to establish a
suit in dummy on which to throw your losers in the suit led.
//

Holding Off Drawing Trumps:

[South]
A x
K J T x x x x x
x
J x

[West]
T x x
A
Q J T x x
K x x x

[North]
K Q J x
x
K x x
Q T 9 x x

[East]
x x x x
Q x x
A x x x
A x

[Bid,North]
Pass
Pass
4H

In a trump contract, you generally want to draw trumps before playing winners
in other suits so that the opponents do not ruff your winners. However, you
should not draw trumps without counting winners/losers first.

In the deal shown, West led the QD, dummy played the K, and East won the Ace,
leading back a Diamond which South ruffed. In addition to the Diamond lost,
South has at least one Heart loser and 2 Club losers, for down one.

If South plays Spades, he can discard a Club loser on dummy's third Spade. If
Spades split 5-2, an opponent will ruff the 3rd Spade and South will go set.
Nevertheless, South has no choice because if he leads trumps first, whoever
takes the Ace can grab up the two Club tricks.

In this case, South makes an overtrick because not only do Spades split 4-3,
but West would have to use the AH to ruff the fourth round of Spades, so West
gains nothing by ruffing while South discards his last Club.
//

More On Finesses:

[N]
A J 9

[S]
x x x

[W]
K T x

[E]
Q x x x

Finesses are not just done on high honors. With the N-S cards, the only way to
win two tricks is to finesse with the 9 the first time.

If West has the 10 and either the K or the Q, the 9 will force East's honor
and the next time you can finesse the remaining honor with the Jack.
//

[N]
A x x x

[S]
Q x x x

[W]
K x

[E]
J T x

If you must win 3 tricks with these cards, you learned in Level I that you
first play the Ace and then lead toward the Queen. If that wins and Spades
split 3-2, your 4th card will be good.

However, if you have reason to believe that West has the King, your only hope
is that the King is doubleton.

Play the Ace, but then play a low card from both dummy and your hand.

If the King drops, your Queen brings in the opponent's last card and your 4th
card is good.
//

[Erase]
[N]
Q x x x

[S]
K x x x

If you have this holding and you need three tricks, your only hope (short of
an opponent simply leading the Ace, which a good player will not do) is that
the Ace is doubleton.

First you must successfully finesse the Ace. Often times you can get an idea
from the bidding and play of the cards which opponent is more likely to have
the Ace.

Assuming the finesse works, then you lead a small card from your hand and
dummy and hope the Ace falls. If it does, then the suit has split 3-2 and your
other honor will establish your fourth card.

All of this (Ace-doubleton, 3-2 split, finessing the Ace) sounds like a long
shot, but a long shot is better than no shot.
//

Backward Finesse:

[North]
A 8 7

[East]
T 6 5

[South]
K J 9

[West]
Q 4 3

With the hands shown, it is possible for South to pick up three tricks without
losing one with a "Backward Finesse".

(Normally, you would cash the Ace and then finesse through the K-J, so to take
a backward finesse, you must have some reason to believe that West has the
Queen.)

South must lead the JS. If West covers, dummy's Ace wins and a low Spade is
led back to the K-9, finessing East's Ten.

If West ducks the JS, South lets it ride and then takes the Ace and King.
//

Order of Suit Development:

[Bid,N]
1D
Pass
2C
Pass
2D
Pass
2NT
Pass
3NT

[N]
K Q T
x x x
A Q J x x
K x

[S]
A J x
Q J T
T 9
Q J T 9 x

West leads the 2H against South's 3NT. South can count 3 Spades, 1 Heart
(eventually) and the Ace of Diamonds.

South can get 4 more Diamonds if the finesse works and they split 3-3.

Or South can get 4 Clubs by forcing out the Ace, no matter how they split and
without a finesse, making Clubs look like the superior suit to attack.

Now you have to consider whether or not E-W can win enough Hearts (after
you play your stopper on the frist trick) to set the contract.

We'll examine that possibility on the next screen.
//

[+]
[W]
x x x
A K 5 2
K x x
A x x

[E]
x x x x
x x x
x x x
x x x

If West leads the 2H and it his 4th-highest Heart, then by definition he must
have only 4 Hearts.

After you take the Heart lead, that leaves 3 Hearts for West along with the AC
for a total of 4 tricks

If E-W can only take 4 tricks, N-S's 3NT bid makes.

In this situation, it makes no sense to try the finesse, since attacking Clubs
cannot possibly lose.
//

[+]
[W]
x x x
A K 5 4 2
K x
A x x

[E]
x x x x
x x
x x x x
x x x

However, if West leads the 4 of Hearts and East follows with the 3, it is
possible that West also has the 2 and thus has five Hearts.

Now if South tries to force the AC, E-W will win that trick plus West will
take four more Hearts to set 3NT.

In this situation, South has no choice but to try the finesse and hope it
works.

Leading 4th-high is a way of communicating with partner, but the opponents
are listening too, as we've just seen. In the section on False Card Leads
in L2-PLAY1, we saw how to fool the opponent who listens too closely.
//

Cross-Ruff:

[N]
Q
A T x x
K J x
A Q x x x

[S]
A x x x x
Q J 9 x
Q x x
T

Against 4H, West leads the AD followed by a small Diamond and you have a perfect
hand for cross-ruffing:

- a long suit in each hand opposite a singleton,
- high trumps in both hands,
- a 4th suit too short to be set up,
- the ability to start the cross-ruff without giving up the lead. If you give up
the lead, the opponents can lead trumps, depriving you of the ability to ruff
with them.

After taking the KD, you cash the QD (always cash your winners before starting
to cross-ruff), then AS, ruff a Spade, AC, ruff a club, etc.

By the time the opponents run out of Clubs and Spades, you are ruffing with high
trumps so it would do them no good to ruff, except with the King if held by
East (North could over-ruff with the Ace if West has it.) You lose only 1
Diamond and maybe the KH.

//

[N]
A x x x
K J x x
Q 9 8 x
x

[S]
K Q J x x
-
K J 7 x
A Q x x

At 4S, it looks like N-S have another good cross-ruff hand.

On the lead of a small Heart, the JH was played from dummy which forced the AH
from East which was ruffed by South.

Now let's analyze the N-S hands: (1) only 1 Diamond loser, (2) a low Club can be
discarded on dummy's good KH, leaving only two Clubs to be ruffed, so there is
really no point in a cross-ruff in this hand.

A really good cross-ruff hand is fairly uncommon. Hands that deceptively look
like good cross-ruff hands are much more common.

So be careful of automatically starting a cross-ruff whenever you get long
suits opposite shortness.
//

[North]
J T 8 7
A Q J x
K T x x
x

[South]
A K x x
x
Q x x x
A J x x

Q: In 4 Spades with the hands shown and KC led, should you play a cross-ruff?

A: Yes. You lack the transportation to ruff out enough losers to set up either
hand.

But this is not a straightforward cross-ruff. You could immediately start
cross-ruffing (after taking the Aces), but when you are done, E-W will likely
get the QS and three Diamond tricks.

An alternative is to take the Heart finesse first. If it loses, then you can
discard two Diamonds on Hearts, trading two losers for one. If it wins, you
can discard one Diamond on the AH, again reducing your losers by one.

You are not worried about the finesse losing and East leading a trump because
at most, you are only going to ruff 3 Clubs in dummy and 2 Hearts in South's
hand.
//

[+]
In the actual game, the Heart finesse won; a Diamond was discarded on the AH,
and a low Diamond was led to the Queen which also held (East has the AD).

South was then able to cross-ruff three Clubs in dummy (after taking the Ace)
and two Hearts in hand, leaving the A-K of Spades as additional winners for a
total of 11 tricks.
//

Ruff-and-Sluff:

[N]
x
x x

[S]
x
A x

If your opponent's lead a suit in which you have a void in both the dummy's
hand and your hand, you can take a "ruff-and-sluff", meaning that you ruff in
one hand and discard ("slough off") a loser from the other hand.

If you have the cards shown with Spades as trumps and the opponent's lead a
Diamond or Club, you can throw a low Heart from South's hand and ruff in
North's hand. Note that without the ruff-sluff, there is no way for you to
avoid a Heart loser.

When you are defending, you must always be careful of giving declarer a
ruff-sluff.

As declarer, you should be alert for opportunities to induce the opponents to
lead into a ruff-sluff. (See "Strip and Throw-In".)
//

Squeeze:

[N]
Q
x x
x

[E]
--
J
J x x

[S]
--
--
K Q x

[W]
J x x x

A "squeeze" occurs when no matter which card a player discards, it creates a
winner for the opponent.

In the deal shown, when the QS is played from dummy, East is squeezed. If she
throws the Heart, dummy's Hearts are good. If she throws a Diamond, South will
win 3 Diamond tricks.

Many times you can squeeze an opponent without even trying or being aware of
it just by running a long suit, which forces the opponents to come up with
discards. To intentionally set up squeezes requires a good mental image of
what cards the opponents hold. In this case, you have to know that East has
the Hearts AND Diamonds.

[Pause]
[East]
x
--
J x x

[West]
J x x
J

If instead, the cards are as shown, then when the QS is led, E-W both follow
suit and retain their winners in Hearts and Diamonds.
//

[Erase]
[North]
x x x x
x
A x x
A K Q T x

[South]
K T x x
K J 9
Q x x
J x x

In 3NT, you can often squeeze your opponents simply by running a long suit.
They will many times have to discard from THEIR long suit in order to protect
the other suits.

However, in the deal shown South will squeeze HIMSELF if he runs dummy's
Clubs. The reason is that South does not have top cards in the other suits and
having to discard on dummy's last two Clubs will cause him to lose control of
the side suits.

In this situation, South must attack the side suits first in order to develop
those tricks and run the Club winners later.

Although looking for the rare intentional squeeze opportunity can often be a
waste of time, it certainly helps to be aware of the affect of running long
suits on your own hand.
//

[N]
K
A x
x

[S]
-
K x x
A

[W]
A
Q J T

Here are the elements needed to execute a squeeze:

1. The player being squeezed must need every one of his cards. In the example
shown, West's AS is needed to stop North's KS. West's Q-J-T are needed to stop
South's 3rd Heart.

2. Declarer must have only one loser (the third Heart, in this example).

3. Of the two (or three) suits being squeezed, the "threat" in at least one
suit must be in the hand that follows the player being squeezed. Example, the
KS is a threat sitting over West that keeps West from throwing the AS.

4. Adequate N-S transportation must exist to allow cashing the winners that
are set up.
//

[Erase]
A lot has been written about squeezes in bridge literature and you often see
them in newspaper bridge columns. The reason why is that they are so artistic,
but the fact is that they are fairly rare.

Squeezes require a very special layout of cards. If the layout occurs, you
also need some revealing bids by the opponents to give you clues as to who
holds the key cards. Then you need for the opponents not to foul things up
when they lead. For example, a hand could be ideally layed out to squeeze an
honor out of East, and then West leads the suit and gives you a free finesse,
making the squeeze unnecessary.

Or you may have what looks like a good squeeze play to set up the fourth card
in a suit and the suit splits 3-3, making the squeeze unnecessary. Or you
squeeze an honor and it could have been finessed anyway.
//

[N]
A x x x
x x x
x

[E]
-
A x x x
A K x x

[S]
K Q J x
Q J T x

In preparation of this course file, dozens of hands were generated without a
single simple squeeze surfacing.

More common is the Developmental Squeeze in which you can generate an extra
trick in a holding that has more than one loser.

With the cards shown, the AS is led from dummy. East is known (by the bidding
or play) to have 4 Hearts and 4 Diamonds left, so whichever suit she discards,
South discards the other.

If East discards a Heart, South discards a Diamond and then leads Hearts to
develop a 4th trick in that suit.
//

[Erase]
[N]
A Q x x

[S]
x x

Q: With Hearts as trumps, West leads the 9S against the Spade holding shown.
Should you finesse with the Queen?

A: No. It's unlikely that West would lead away from the King against a suit
contract. His lead looks like either a doubleton or singleton.

If it is a singleton, you give up two tricks by playing the Queen when East
leads back another Spade for West to ruff.

Rather than throw away the QS to East's King, play the Ace and retain the
Queen as a threat card to squeeze East with. You don't have to be planning a
squeeze, but in a case like this, you may get one without trying.
//

Strip and Throw-In:

[N]
A x x x
A x x x
A x
A K J

[S]
K T 9 x x
Q T
Q x
x x x x

Whenever possible, you should forego taking a finesse that has only a 50-50
chance of winning if you have a better alternative available.

Against 4S, West leads the 4C. South has finesses available in all four suits,
including a high-percentage double-finesse in Spades against the Q-J.

Q: What should South play from dummy on Trick 1?

A: JC. In the first place, the 4C sure looks like 4th highest being led from
the QC.

In the second place, South cannot avoid losing a Club eventually, so he may as
well try the finesse right away.
//

[+]
Q: The JC wins and declarer turns to trumps. Should he take the double-finesse
in Spades?

A: No. Remember "8 Ever, 9 Never"?

First play the AS. When E and W both follow low, the remaining 2 Spades (Q-J)
may be divided between 2-0, 1-1, 0-2.

If they are either 2-0 or 0-2, you cannot avoid losing 1 trick, so you may as
well play the King.
//

[+]
[N]
x x
A x x x
A x
A K

[S]
T 9 x
Q T
Q x
x x x

Q: West plays the JS under the King and East discards a Diamond, leaving the
cards shown. Which suit should you play next?

A: C. You can put West in the lead by playing to his QS. If you first remove
his Clubs, all he will have left is Hearts and Diamonds and he will have to
give you a free finesse.

If he has the King of either or both suits, he gives you a trick you could not
have won if you had tried finessing by leading a small card to the Queen.

This is called a Strip and Throw-In (also called the Elimination) because you
first strip out or eliminate the suit you do not want led and throw the
opponent into the lead so that he has to lead a suit which you do want led.
//

Trump Coup:

[N]
A x x
-

[E]
x
K J

[S]
x
A Q

A trump coup is an endplay in which you win an extra trump trick which you
could not have made by straight leads.

In the hands shown, if South leads the AH, East's KH becomes high. If he leads
the QH, East takes it with the KH, obviously.

So South leads a Spade to dummy's Ace. On the lead of another Spade from
dummy, East must play a Heart and which ever one he leads, South can overtake
it, picking up both Hearts.

If East had the A-Q and South the K-J, the same principle applies, but with
South being satisfied to win one Heart rather than having to lose both.
//

[Erase]
[N]
A K Q x x
-
x x

[E]
x x x
K J
x x

[S]
x x x
A Q x x

The trump coup is as simple as it looks, although one trick to be aware of is
that for it to work, declarer must have the same length in trumps as East when
dummy's suit is led.

In the example shown, South will lead Spades to dummy and ruff two Diamonds in
return to set up the final trump coup position shown on the previous screen.

Note that when the hand is reduced to the point where both East and South have
two trumps left, it doesn't matter what is led from dummy. In other words, it
does not have to be a winner. East is forced to ruff anyway, allowing South to
score and extra trump trick.
//

Necessary Assumptions:

[North]
x x x
x x x x
A Q J x
J x

[South]
A K Q J T x x
K J
x x
x x

[Bid,W]
Pass
Pass
Pass
4S

A common theme in planning your play as declarer is making the "necessary
assumption".

This means that if a certain holding by opponents is absolutely required to
have any chance of making your bid, you must assume that the holding does
indeed exist.

In the hand shown, West leads the KC, then the QC on which East plays the AC
and returns a low Heart.

If West has the AH and East the QH, then you want to play the JH from South's
hand, but if West has the QH and East the AH, you must play the KH from South.

Since West and East both passed, we know that neither has 12+ HCP, but all we
know from the cards played is that West has 5 points and East, 4. That leaves
plenty of room for either to have 4 points for the Ace of Hearts.
//

However, with 2 Club tricks lost and at least one sure Heart loser, you cannot
hope to make the contract unless West has the KD so that the finesse will
work.

Adding 3 for the KD to West's 5 points already played gives him 8 HCP. If he
has the AH too, that is 12 HCP and he probably would have opened, so you must
assume that East has the AH.

It is very possible that West does NOT have the King of Diamonds and DOES have
the Ace of Hearts, but if so, you are set anyway.

A "necessary assumption" does not guarantee that you will not go set if the
cards break badly. It may even be that the odds are greatly against the lay of
the cards being exactly what you need. But if that is your only chance to make
the contract, then you must hope for the best.
//

Safety Plays:

[North]
A K Q J x x

[South]
x x

A safety play is one in which you give up a trick that may have not been
necessary to lose in order to guarantee the contract.

Sometimes this is done to keep a dangerous opponent off lead. Other times it
is done to protect against a bad split which is statistically unlikely, but
which if it DID occur, would be the only thing that could set the contract.

For example, if you are in a 6NT contract and have the Spade suit shown with
dummy having no side entries, you will be able to make 7NT if opponent's cards
in dummy's suit split no worse than 4-1, allowing you to make six Spade
tricks, but you would go set if they split 5-0 and you only make four Spade
tricks.

Although the odds are greatly against the 5-0 split, there is no reason to
take a chance in rubber bridge for the sake of an overtrick if it risks going
set, so you should give up a trick early by playing a low Spade from dummy.
//

[Erase]
[North]
J x x

[South]
A K x x x

South has this trump holding in a 6S contract with no possible side-suit
losers. If trumps split 3-2, South cannot lose more than one trick by simply
playing A-K. If the Q is doubleton, South will make an overtrick.

If East has Q-T-9-x, South will lose two tricks no matter what he does.

If West has Q-T-9-x, South will lose two tricks if he plays A-K, leaving West
with the Q-T and the lone JS in dummy. To protect against this distribution,
South can play the AS, but must lead a low Spade towards the Jack before
playing the KS.

If the QS is doubleton, South gives up an overtrick, but assures the contract
against a 4-1 split in West's hand.
//

Transportation And Unblocking:

[N]
A 6 3
Q x x x
T 9 x
T x x

[S]
K 9 8 4 2
J T x
x x
A Q x

Against 2S with the hands shown, West starts with three rounds of Diamonds,
South ruffing the third round and leading two rounds of trumps, everyone
following and leaving one high trump out.

South leads a Heart, West taking the A-K and leading a third Heart which East
ruffs. East leads a low Club, South puts up the Queen which wins. Now what?

If South did not notice the tranportations problems on the first trick, it is
too late to ask "Now what?". South has a losing Club left, a good QH in dummy,
but cannot get to it unless he preserved the 2S in his hand.

He must ruff the 3rd Diamond with the 4 and lead the 8 to dummy's Ace when
drawing trumps. If he did that, he can now lead the 2S to dummy's 6S;
otherwise, he is down 1 trick.
//

[Erase]
[N]
A T 9 7
K T 5 4
K 5 2
T 9

[Bid]
1C
Pass

This hand illustrates ducking, blocking, and transportation, in addition to
bidding exceptions, so lets start with the bidding:

Q: What does North bid over South's 1C?

A: 1H. Bid the lower major first.

[Bid+N]
1H
Pass
1NT
Pass

Q: What are the most points South is likely to have:
      14, 16, 18?

A: 14. With more points, he would have to bid more energetically than a simple
1NT response.

Q: What should North bid: Pass, 2S, 2NT, 3NT?

A: 2NT. In NT, North's three Tens and other high spot cards are worth quite a
bit, but do not rate any HCP's, so a Pass is too timid.

There is no point in 2S since if South had 4 of them, he would have bid them.
North doesn't have enough to jump to 3NT since North could still have a
minimum opener, so North should invite by bidding 2NT.

Next we'll look at the play of the deal.
//

[+]
[Bid+N]
2NT
Pass
3NT

[S]
6 3 2
A 9 8
J 4 3
A K Q 8

Q: West leads the 7D. Which Diamond should declarer play from dummy?

A: 2. If you play the King and East has the Ace, he will win it and then if
West has the QD, it will take your JD and E-W will run off all their Diamonds.

If you play low and East plays the QD and leads back a Diamond, your King will
win a trick no matter who has the Ace.

If you play low and West has A-Q, your Jack will win the first trick and
dummy's King will win a trick later.

Q: East takes the QD. How many sure winners does South have?

A: 7. A-K-Q of Clubs, a Diamond, A-K of Hearts, and AS.
//

Q: Which suit is likely to produce two more tricks?

A: H. You can take a repeated finesse on the Q-J of Hearts with a 67% chance
of at least one of the finesses working.

Q: East leads back the 4C. What should South play?

A: AC. If both the Heart finesses lose, you can finesse for the JC later.

Q: What do you play next?

A: 8H. Ordinarily in this situation you want to play the Ace first in case one
of the missing honors falls.
//

Let's say you do play the Ace fist and then take the first finesse which
loses, East leading back a Club again.

Now you HAVE to play the 8C because if the second Heart finesse loses, you
will not have a Club left in dummy with which to take the finesse.

But if you take the finesse and it wins, you are stuck in Dummy. You have no
Clubs left in dummy for getting back to South's hand and no other winner's in
South's hand to go to. So you MUST retain the AH for transportation.

Holding the AH often would result in your being blocked in your hand after
Hearts are established, but in this case, you have the AS in dummy for
transportation after playing the AH.
//

Avoiding the Dangerous Opponent:

[North]
K J 2
x x
K x

[South]
A T 3
K x
A x

Q: With the cards shown, which way should South finesse for the QS if there
are no clues as to who has the QS? (1) Lead the 3S from South? (2) Lead the 2S
from North?

A: 2. Lead the 2S from North's hand. If you lead the 3S from South and the
finesse loses, East would be able to switch to a Heart and if West has the
Ace, take two quick tricks.

If you finesse into West's hand, he cannot attack Hearts without making your
KH good.

You do not have to know for sure whether or not West has the AH, it's enough
to know that he might have and that you should take steps to avoid that
possibility.
//

[North]
x
x x
Q 9 x x x
Q T 9 x x

[South]
A x x
A Q x
K T x x
A K J

Q: At a contract of 5D, a Spade is led to South's Ace. Should South (1) lead a
low Diamond to dummy's Queen or (2) to dummy's 9D, or ruff a Spade and lead a
low Diamond back (3) to the KD or (4) to the TD?

A: 4. Ruff a Spade and lead a low Diamond back to the 10.

This is a more advanced example of keeping the dangerous opponent off lead. In
this case, the danger - attacking Hearts - is less obvious.

The key is that you can afford to lose two Diamond tricks as long as you do
not lose a Heart trick.
//

If you lead a low Diamond to the QD and East wins the Ace and forces out your
Ace of Hearts, then IF you lose another Diamond to the JD, that player will
go after a Heart trick.

When you take the deep finesse into West's hand, West cannot attack Hearts
without letting your QH take a trick.

Now you have time to draw trumps and throw Heart losers on dummy's Clubs.
//

Loser-On-Loser:

[North]
Q J T x x
K x
A x x
x x x

[South]
--
A Q J T x x
K x x
x x x

Playing a loser from one hand on a loser led from the other hand is a neat
trick that lets you make hands that look unmakeable even at double-dummy.

With the cards shown and West leading a KS against 4H, South can ruff, lead a
Heart to the King, and lead the QS.

From the lead of the KS, West is known to have the AS; otherwise, South could
try a ruffing finesse against East.

Since a ruffing finesse is impossible when the AS is in West's hand, South
discards a Club loser on the Spade.

West can win with the AS, but can only take two Clubs now. Later, South will
discard a Diamond loser on dummy's good JS.
//

En Passant:

[N]
x
-
A Q

[E]
-
Q
K x

[S]
-
J
x x

[W]
A K Q

The En Passant Coup is really a Trump Coup (see Index), but is also akin to
the loser-on-loser concept.

With Hearts as trumps and the cards shown, South could take a Diamond finesse
with only a 50% finesse chance of success. In this case it would fail, East
would draw South's last trump, and South would win only one trick - the AD.

Instead, South can guarantee two tricks by leading a Diamond to dummy's Ace,
then leading a Spade from dummy.

If East ruffs the Spade, South discards his other losing Diamond and his trump
wins the last trick. If East discards, South can ruff. Either way, South wins
a second trick with his low trump.
//

Winner-On-Winner:

[North]
x x
A x x
J x x x
A x x x

[South]
K Q J T 9 8 x
K x
Q T 9 x
-

[Bid,East]
3H
4S

This is an unusual situation, but one that does arise from time-to-time, in
which you must discard a winner on a winner.

West leads the JH. Since East's bid shows 7 Hearts, West's Jack must be a
singleton. If East has the Ace of trump, he can give West a Heart ruff after
winning the AS.

With 2 sure Diamond losers and a Spade loser, South cannot afford to give up a
Heart ruff. The way to prevent it is to win the AH in dummy, lead the AD and
discard South's King of Hearts, even though it is the high Heart.

Now if East tries to give West a Heart ruff, South can foil it by ruffing
high.
//

Dummy Reversal:

[North]
K x
K Q J x
A x x
A Q x

[South]
Q J x x
A x x x
x x x x
x

[Bid,North]
1C
Pass
1H
Pass
4H

In some deals, dummy's hand may be easier to set up than declarer's. In this
situation, you ruff dummy's losers with declarer's trumps and draw trumps with
dummy's trumps, thus the name "dummy reversal".

Therefore the two keys to look for in trying a dummy reversal is a short suit
in declarer's hand which declarer can ruff and enough high trumps in dummy's
hand for drawing trumps.

When dummy is the stronger hand, as in the deal shown, it can be very natural
to play a dummy reversal.

With these cards, South's small trumps would be used to ruff dummy's Club
losers and you would then draw trumps with dummy's high Hearts.

Assuming trumps break normally, N-S will lose at most a Spade and two
Diamonds.
//

[North]
Q T J
T x x
Q x x
A x x x

[South]
A K T x x
J x x
A K x x
x

[Bid]
1S
Pass
2S
Pass
4S

The deal on the prior screen made a dummy reversal obvious, but with the
bidding and hands shown, the criteria are also met: North has high trumps and
South has a short suit.

South has 4 losers: 3 Hearts and a Club, if you try to set up South's hand.

But you can set up dummy's hand by ruffing North's 3 Club losers and using
dummy's Spades both for transportation to dummy (in order to lead Clubs) and
at the same time, to draw trumps.

South doesn't even have to worry about being overruffed, since he can ruff
with high trumps.

North loses at most the three unprotected Hearts, making the contract.
//

Playing the Odds:

In a Level I Course, the finessing principle of "Eight Ever, Nine Never" was
explained: the odds favor taking a finesse for the Queen if your side holds 8
cards in a suit, but favor playing off the Ace and King if you hold 9 cards.

It frequently helps to know what the odds are in various situations when
playing a hand. Here are some of the more common ones, assuming you have no
information to indicate that the cards are NOT randomly distributed:

2 Cards Split:    3 Cards Split:
     48% - 2-0           22% - 3-0
     52% - 1-1           78% - 2-1

4 Cards Split:    5 Cards Split:
     10% - 4-0           04% - 5-0
     40% - 2-2           28% - 4-1
     50% - 3-1           68% - 3-2
//

6 Cards Split-    7 Cards Split-
     01% - 6-0           <1% - 7-0
     15% - 5-1           07% - 6-1
     36% - 3-3           31% - 5-2
     45% - 4-2           62% - 4-3

You don't need to memorize each percentage, but you should remember the
general range. In particular, you can remember that with an even number of
cards out, the odds do NOT favor their splitting exactly even.

With an odd number of cards out, the odds DO favor them splitting as evenly as
possible. For example, 4 cards are more likely to split 3-1 than 2-2. Five
cards are more likely to split 3-2 than 4-1 or 5-0.
//

[Erase]
You can roughly estimate the odds of splits that have a difference of more
than 1 (eg: 4-2, but not 4-3) by subtracting the two values and dividing the
result into 100.

For example, the odds of a 3-1 split are 100/(3-1) or 50%. The odds of a 4-1
split are roughly 100/(4-1) or 33%. The tables show that the true odds of a
4-1 split are 28%, but 33% is close enough for practical purposes.

To refine it further, subtract 2% times the difference. Eg: 100/(4-1)-2*(4-1).
You usually don't need this refinement. It's enough to know that the odds for
one alternative are 60-80% and for another are 25-40%.

Now we will look at some practical examples.
//

[North]
A K Q x x

[South]
x x

Q: With the cards shown and no other entries to dummy, are you more likely to
win more tricks by (1) playing off the top three Spades or (2) first ducking a
Spade?

A: 2. Ducking a Spade. If you play the top three cards, you will win 5 tricks
if they split 3-3, but otherwise you can only take three tricks. The odds
tables say that six cards will split 3-3 only 36% of the time.

If you duck a Spade and then play the A-K-Q, you win 4 tricks if the cards
split better than 5-1, which is 84% of the time.

Again, this assumes that you have no reason to believe that the cards are NOT
divided randomly. Also, if you MUST have all 5 cards to make your bid, you
have no choice but to play for the 3-3 split, despite the odds being against
it.
//

[North]
A K J
x x x

[South]
x x
A K Q x

Q: With the hands shown, should you try for the (1) 3-3 split in Hearts or (2)
finesse in Spades?

A: 2. The finesse in Spades has a 50% chance of winning while a 3-3 split in
Hearts only has a 36% chance.

If you cannot remember that a 3-3 split is 36%, you can calculate the odds on
a 4-2 split as 100/(4-2)=50% -2*(4-2)=46% and a 5-1 split as 100/(5-1)=25%
-2*(5-1)=17%

Now add 46% and 17% and subtract from 100% to get 37%.

This all sounds more complicated than it really is. In fact, if you leave off
the "-2*(4-2)" type adjustments, you would still get the right answer in this
case.
//

[North]
A K Q x x
x x x
x x
x x x

[South]
x
K x x
A K Q J x x x
K Q

South is in 5D with Spades led. South plays 2 top Spades from dummy,
discarding a Heart. With a sure Club loser, South cannot afford to lose two
Hearts.

South can play a third Spade and discard another Heart without getting ruffed
if the 7 Spades out split 4-3, or he can take the Heart finesse, hoping that
East has the Ace.

Q: What % of the time will East have the AH? (1) 25%, (2) 50%, (3) 75%

A: 2. In random distribution, it's a 50-50 shot.

Q: Calculating (or remembering) the odds of a 4-3 split, which play is safer:
(1) playing a third Spade or (2) finessing for the AD?

A: 1. The odds of a 4-3 split are 62%
//

More Percentages:

If two honors are out, they will be split between the two opponents 52% of the
time, both with West 24% and both with East 24% of the time.

If there is a 2-1 split and a King out, it will be singleton 26% and doubleton
74%.

Q: If you have 10 trumps and the King is out, should you (1) play the Ace and
try to drop the King or (2) finesse?

A: 2. The finesse will work 50% of the time, the drop only 26%.
//

[Erase]
If your side has 8 cards in a suit, the odds of a particular card (such as the
Queen) in the opponents' hands being singleton are 6%; doubleton, 28%;
tripleton, 40%; quadrupleton(?), 22%; and a 5-0 split, 4%.

Q: You have 8 trumps missing the Queen. What percentage of the time will
playing the A-K drop the Queen? (Enter as ##%.)

A: 34%. When it is doubleton or singleton.

Q: What percentage of the time will finessing for the Queen win? (Enter as
##%.)

A: 50%. That makes the finesse the better play.
//

[North]
A K Q T x

[South]
x x

With the hands shown, South needs to make all five Spade tricks. South can
play A-K-Q and hope that either Spades split 3-3 or that if they split 4-2,
the Jack is doubleton, which will happen 18% of the time (9% of the time
doubleton in East, 9% in West).

Or South can finesse for the Jack which will win if West has the Jack but lose
an unnecessary trick if it is single or doubleton in East's hand.

Q: What are the odds of the 3-3 split? (Enter as ##%.)

A: 36%.

The odds of a 4-2 split are 45% and 18% of the time, the Jack will be
doubleton and thus playing A-K-Q will also win those times. So add 18% of 45%
(or 8%) to the 35% to raise the odds for this option to 43%. This still leaves
the 50% finesse a better bet.
//

[Erase]
Note that in calculating odds, you only add favorable percentages. For
example, you add the doubleton Jack odds to the 3-3 split odds, but you do not
deduct from the finesse odds the percentage of the time that the finesse will
lose an unnecessary trick to a doubleton or singleton Jack in the East hand.

Calculating odds can get very complex. You cannot expect to master and
remember all of the odds at once, but you should go over this section until
you have a good general feel for when it is better to play for a drop or to
take a finesse.

If you just can't remember any of this, go back to "Eight ever, nine never",
which will get you through a lot of hands.
//

Tricky Plays:

You can often manufacture tricks by making the opponents play the odds.

Say that you are in 4H. Dummy has K-J-x-x of Diamonds and you have a small
singleton.

As soon as possible (but usually after drawing trumps), take the finesse on
the KD.

If West has the Ace, he is almost certain to hold off playing it, particularly
if he thinks partner has the QD.

If you wait until you already have 9 tricks, West will not let you get away
with this and will play the Ace right away.
//

[North]
A Q J x x

[East]
K x x

[South]
T x

You hold these cards, but your astute counting of points and analysis of the
bidding makes you pretty certain that East has the KS, dooming a normal
finesse.

So instead of taking the finesse, you lead the small Spade to the Ace and lead
a small Spade back.

There is a chance that East will think you are trying to ruff out the suit to
set it up and will hold off the KS, allowing you to make the TS.
//

[End]
