Bidding

Introduction
Weak(er) Notrumps
Opening in 3rd And 4th Chairs
Inverted Minors
Opening 4-Card Majors
Blackwood After Interference
Key-Card and Roman Blackwood
Gerber Ace Asking
Splinter Bid
Stayman
  Using Staymen to Bid a Minor
  Stayman With Interference
Jacoby Transfer Bids
Texas Transfer Bids
Minor Suit Stayman
Minor Suit Transfers
Splinter Bid with Transfers
Lebensohl
1NT Forcing
Weak Jump-Shift
19-Point Forcing Openings
Negative Double
Reverse Drury
Notrump Game Try
Fourth Suit Forcing
Truscott/Jordan 2NT
Invisible Cue Bids
Lightner Double
Unusual Notrump
Responsive Doubles
Astro
5 of a Major
Grand Slam Force
Flannery
Flint
Solid Minor Preempts
Landy
Precision 1 Club
Jump Cue Bid
Be Logical
//

Introduction:

Level I focused more on bidding than on play. Level II reverses that, with
this being the only Level II course file on bidding.

The three level II courses on playing cover:
Opening leads and defensive play around the opening lead.

Declarer play.

Defensive play beyond the opening lead.

//

Weak(er) Notrumps:

In Level I, we said that it takes 16-18 points to open 1NT.

Some people play 15-17 points instead. Some play 16-18 in 1st and 2nd chairs
and 15-17 in 3rd and 4th chairs.

Others still play "weak NT" and open 1NT with around 12-15 points.

In "Kamikaze Notrump", 1NT is opened with 10-12 points.
//

Opening in 3rd And 4th Chairs:

[Bid,W]
Pass
Pass
Pass
???

[S]
A J x x x
x x
K x x
Q x x

If you have 10-12 points and your partner has already passed, you should have
in mind that it is unlikely that your side has game. Chances are, you are
going to be competing for a part score.

In third chair, you may want to bid a hand that is a shade weaker than your
normal opening strength if you have a suit that is good enough to compete with
up to the 2 or 3 level and/or is good enough for partner to lead if the
opponents win the bid.

With the hand shown, your Spade suit has a natural advantage over Hearts in
bidding for a part score, since you can buy the bid at a lower level than the
opponents.

It is important that your partner is aware that you may make a light open in
3rd and 4th chairs so that he doesn't do anything rash, like jumping to game.
//

[S]
x x
Q J x x x
A x x
K x x

With a hand like this one, you should pass, especially in 4th chair where your
pass will result in the deal being thrown in.

You don't have a very robust Heart suit to bid or to have partner lead and if
the opponents have Spades, they will probably reenter the bidding and steal it
from you.

You and your partner should also agree that your weak 2 bids in 3rd and 4th
chair do not require the usual quality (2 of top 3, etc) since it is unlikely
that your passed partner can take you to game.

You might want to open 2S with a suit that looks like "Q-J-x-x-x-x".
//

Inverted Minors:

[Bid,N]
1D
Pass
???

[S]
x
x x x
Q J x x x
K x x x x

Q: What should South normally bid?

A: 2D. Unless partner has a real barn-burner, you are unlikely to have game.
You have no desire to play NT, and a major suit fit is out of the question, so
if your side is to compete for a part score, it has to be in Diamonds.

The problem is that it is relatively painless for the opponents to enter the
bidding in the majors against 2D.

Since you already know that 3D is your likely limit, wouldn't it be nice to be
able to bid it right away?

That's what Inverted Minors are for. In response to an opening bid of a minor
suit, a jump raise is weak and preemptive (leaving the opponents less room to
bid) and a single raise is stronger (leaving YOUR side MORE room to bid).
//

Opening 4-Card Majors:

Relatively few people open 4-Card Majors any more, but you need to understand
it in case you pick up a partner or opponents who do.

The main difference is that you would open a 5-card major even if it were very
weak, but opening a 4-card major requires a very good suit -- at least 4 HCP.

The minor suits can be weaker, but if you have too many points to pass and do
not have a good biddable suit, you must open 1C.

Unlike 5-card majors, you would never open a 3-card Diamond suit when playing
4-card majors.

As with 5-card majors, if you have two 4-card suits, you should bid the higher
one first. If you have a good 4-card Spade suit and 5 Hearts, you still bid
Spades first.
//

In responding in the 4-Card Major system, you must have 4 cards in your
partner's suit to raise him, of course.

As with 5-card majors, each rebid by the opener promises extra length.

If partner opens 1D or 1C, it does not deny a 4-card major; it only denies a
very good 4-card major, so if you have a four-card major, you should bid it.

If you have a good grasp of 5-card majors, most of the other bidding of 4-card
majors is similar, but adjusted to allow for one less trump.
//

Blackwood After Interference:

[Bid,N]
1H
2D
3H
4D
4NT
5D
???

[S]
J x
A x x x
K Q x x
Q J T

If partner bids 4NT to ask you for Aces and East throws in a 5D bid, you can
no longer respond as the convention requires.

One alternative is to start your Ace-showing bid with the next suit. For
example, if East bids 5D, you would bid 5H with all or none, 5S with one, etc.

DOPI is an attractive alternative to the above because it uses less bidding
space.

DOPI stands for Double=0, Pass=1. With two Aces, you bid the next available
suit, etc.

With the hand and bidding shown, you would Pass to show 1 Ace.
//

Key-Card and Roman Blackwood:

In Key-Card Blackwood, the King of trumps is counted in with Aces. The only
modification is that just as 5C shows 0 or 4 Aces (or now, "key cards"), 5D
shows 1 or 5 key cards.

In Roman Key-Card Blackwood -
- 5C shows 0 or 3 key cards.
- 5D shows 1 or 4 key cards.
- 5H shows 2 or 5 and the Q of trump.
- 5S shows 2 or 5 without the Q of trump.
//

In plain Roman Blackwood -
- 5C shows 0 or 3 Aces.
- 5D shows 1 or 4 Aces.
- 5H shows 2 Aces of the same color
     or of touching suits.
- 5S shows 2 unlike Aces.
//

Gerber Ace Asking:

[Erase]
[Bid,N]
1S
Pass
2NT
Pass
4C
Pass
???

[S]
J x
A x x
K Q x x
K J x x x

In the Level I course, no means was provided for asking for Aces over a NT
bid. Bidding 4NT over a NT bid is a quantitative bid, not Ace asking.

The Gerber convention substitutes a JUMP to 4C in place of 4NT when NT is the
main focus. As with 4NT, you simply go up the suits to show Aces:

4D = all or none
4H = 1
4S = 2
4NT = 3

DOPI works the same way over interference bids as it does with Blackwood.
//

You have to be more alert with Gerber to make sure that partner is asking for
Aces and not bidding his Club suit. A JUMP to 4C is normally Gerber.

After 4C-Gerber, 5C asks for Kings.
//

Splinter Bid:

[Erase]
[Bid,N]
1H
2C
4C

[S]
A x x
K Q x x
A J T x
x

A splinter bid is an artificial jump bid indicating trump support, an interest
in slam if partner has a good hand, and a singleton or void in the suit bid.

The bidding shown is an example: South's bid of 4C over East's 2C is a very
clear-cut splinter bid.
//

Stayman:

[Erase]
[Bid]
1NT
Pass
2C
Pass
???

[S]
K Q x x
J x x x
A Q x
K Q

Q: What do you bid with South's cards in this sequence?

A: 2H.

North's 2C bid is asking you to bid a 4-card major if you have one.

Most partnerships play that if you have two 4-card majors, you bid the lower
one first.

Bidding 2S would deny having 4 Hearts.
//

  Using Staymen to Bid a Minor:

[N]
K Q x
A x x
x
K Q x x x x

[S]
J x x x
K Q x
A J x x
A J

[Bid]
1NT
Pass
2C
Pass
2H
Pass
3C
Pass
???

With the hands and bidding shown, a new aspect of Stayman is shown.

North is not interested in 4-card majors at all. Instead, this sequence is
desinged to indicate a strong hand with a very good Club suit and an interest
in slam.

If North had bid 3C as a direct response to 1NT, it would indicate a weak
hand. (2C is Stayman, so 3C is the lowest that a weak hand with long Clubs
could bid.)
//

  Stayman With Interference:

West Doubles -

In most partnerships, it takes NT opening strength to double an opening bid of
1NT.

With 7+ points, North should redouble. With a hand very poorly suited for NT,
bid 2 of your suit.

West Overcalls a Suit -

You (North) can no longer bid Stayman, but you can ask partner for a major by
bidding the opponent's suit.

Because this raises the level of bidding very high, you must have enough
points to make game (9+).
//

East Doubles North's 2C -

(This is normally a lead-directing double by East, asking West to lead Clubs.)

If South does not have a 4-card major, then with a good Club suit, South
should redouble. With 4+ Clubs, South should pass.

If South passes, North can redouble with 3+ Clubs or bid 2D with 4-4-4-1
distribution.
//

East Overcalls North's 2C -

[Bid]
1NT
Pass
2C
2S
Pass
Pass
2NT
Pass
3H
Pass
4H

[N]
x x
K Q x x
A x x x
J x x

[S]
K x x
A J x x
K x
A Q T x

South can bid a 4-card major, but only on the 2 level. If East overcalls with
2S, South cannot bid 3H to show a 4-card Heart suit.

If South cannot bid 2 of a major, he can double for penalties or pass.

If South passes, North can double for penalties if East has bid North's 4-card
major.

If North bids 2NT instead of doubling, it implies that his suit was the other
major and South can bid that suit over 2NT. (See bidding.)
//

Jacoby Transfer Bids:

[Bid]
1NT
Pass
2D
Pass
2H

[N]
x x
Q J T x x x
x x x
x x

[S]
K Q x x
A x
A J x
K x x x

It may be worth a trick or two to have the stronger hand be the declarer,
since the strong hand is more likely to have holdings like K-x and A-Q-x for
West to lead into, giving declarer a free finesse.

Transfer bids are artificial bids which "transfer" the bid to the stronger
hand by getting that player to be the first to bid the real trump suit.

Jacoby transfer bids are used in response to 1NT and usually in conjunction
with Stayman.

To get partner to bid 2S or 2H, you bid the suit below it, as shown in the
diagrams.
//

A 5+ card suit is required to bid Jacoby, since the notrump opener could have
as few as 2 of your suit.

If you have a very weak hand, you have to be satisfied with a possible 5-2
fit.

If you have enough to push towards game, after partner's forced bid, you can
bid 2NT to show a 5-card suit and a balanced hand.

If you have an unbalanced hand, bid 3 or 4 of your suit, depending on your
points.
//

To show 5-5 in the majors, you can bid 2D and after partner's forced 2H
response, bid 2S.

That way if partner has only 2 Hearts but more Spades, he can raise Spades.

[Pause]
[Bid]
1NT
Pass
2D
Pass
???

[S]
K x
Q x x x
A K x x
K Q J T

Upgrading Opener's Hand -

If North makes a transfer bid and South has a hand like the one shown (maximum
NT points, ruffing value in Spades), North should bid more aggressively to try
for game.

North should bid 3H instead of 2H, to show maximum values and a good fit.
//

Texas Transfer Bids:

[Bid]
1NT
Pass
4H
Pass
4S

[N]
Q J T x x x x
-
x x
x x x x

Texas transfers are similar to Jacoby, but on a higher (4D/4H) level.

It requires a 6-card suit and a hand with virtually no possibility of slam.
(With an interest in slam, use Jacoby: 1NT-2D, 2H-4H

A rule of thumb is to have as few as 3 HCP and less than 12 total points.

If West bids before North bids 4D/4H, North's bid is still considered a Texas
transfer unless West has bid above 3C.
//

Minor Suit Stayman:

[N]
x
x x
K x x x x
Q J T x x

[S]
A J x x
K Q x x
A x x
K x

[Bid]
1NT
Pass
2S
Pass
2NT
Pass
3C
Pass
3D

If you are using Jacoby transfers, you will normally never bid 2S over 1NT.

Rather than waste a bid, you can use 2S to ask for minor suits. It requires a
very distributional minor suit hand and an interest in game and possibly slam.

A response of 2NT (3NT with a maximum NT opener and good major suit stoppers)
over 2S denies a 4-card minor.

A response of 3 of a major implies 4-card support for at least one of the
minors and a weakness in the unbid major. If the 2S bidder has strength in
the unbid major, he can bid 3NT; otherwise, he should bid one of his minor
suits.

//

Rebid by the Minor Suit Stayman bidder -

A bid of 3 of a minor over 2NT is not forcing. In the bidding shown, however,
South properly corrects to his longer minor suit.

A bid of 4 of a minor over 2NT or 3 of a major is forcing to game. A raise to
4 over 3 of a minor is invitational to game.

A bid of a major suit shows a void or singleton and is invitational to slam.
//

Minor Suit Transfers:

[Bid]
1NT
Pass
???

[N]
x
x x x
x x x
Q x x x x x

With a hand like the one shown, North would rather be in Clubs than NT, but he
bidding 2C is Stayman and 3C shows more points and risks that partner may bid
again.

A minor suit transfer promises 6+ cards in the suit above the one bid and can
be made with 0 points. Partner must bid the suit after which North will pass.

To transfer to 3D, North bids 2C, but to transfer to 3C, North must bid 2NT
(since 2S is Minor Suit Stayman).

What happens if you have a hand with which you would normally respond 2NT to
1NT? We'll see on the next screen.
//

[N]
Q J x
K x x
x x x
K x x x

[Bid]
1NT
Pass
2C
Pass
???

Since minor suit transfers take away the natural 2NT response to 1NT, a way is
needed to show a real 2NT type hand.

The answer is to bid 2C Stayman and then bid 2NT over partner's response.
//

Splinter Bid with Transfers:

[Bid,N]
1NT
Pass
3S

[S]
x
A K x x
K Q x x
Q x x x

If you use all the transfer bids, you never need to respond to 1NT with 3D,
3C, or 3S.

So these bids can be put to use to show a three-suiter with a singleton or
void, such as South's hand.
//

Lebensohl:

[Bid,N]
1NT
2S
2NT
Pass
3C
Pass
3H

[S]
x x
Q J T x x x
x x
x x x

Levensohl is for dealing with interference bids. Its purpose is to let you
sign off at the 3 level with a weak, distributional hand and when the
opponent's bid keeps you off the 2 level.

Over the interference bid (2S in the example shown), you bid 2NT. Partner MUST
respond 3C.

If Clubs is your suit, you can pass partner's 3C response; otherwise, bid your
suit and partner should (but is not required to) pass.

If you bid 3H directly over the interference bid instead of 2NT, it indicates
a stronger hand (10+ points).
//

1NT Forcing:

In Level 1, a 1NT response to an opening bid was considered weak.

Alternatively, it can be used as a one-round forcing bid over a major suit
opening.

It shows 6-12 points, inability to raise partner and, when made over 1H,
less than four Spades.

If opener cannot rebid his suit (ie: shorter than 6) and doesn't have another
4+ card suit to bid, opener bids 2 of his better minor suit (Clubs, if both
minors are 3 cards).

The 1NT bidder's rebid over 2 of a minor is covered on the next screen.
//

[Bid,N]
1S
Pass
1NT
Pass
2D
Pass
2H
Pass
Pass
Pass

[N]
A T x x x
T x x
A Q x
Q x

[S]
x
K Q J x x x
x x x
x x x

With a good 5- or 6-card suit, South can bid it on the 2 or 3 level.

This shows a hand with less than 10 points, since with 10+, you would have bid
2H directly.

If 1NT were not forcing, this is the kind of hand you would end up playing in
1NT because South lacks the points to bid 2H over 1S. (1NT is doomed with this
holding most of the time because of the Club weakness.)
//

[Bid,N]
1S
Pass
1NT
Pass
2D
Pass
2S
Pass
Pass
Pass

[S]
J x x x x
x
x x x
x x x x

The theory here is that you are preempting the opponents with this sequence
with a hand that would not justify a raise ordinarily.

Frankly, if your opponents have 25+ points between them, it's highly unlikely
that they are going to quietly keep passing, but it can't hurt to try.

[Pause]
[Bid,N]
1S
Pass
1NT
Pass
2D
Pass
2S
Pass
Pass
Pass

[S]
x x
K x x x
x x x
K Q x x

The sequence shown illustrates a worst-case scenario where an 8-card fit could
not be found.

Still, playing in a 5-2 fit is not too bad and may even play better than at
1NT.
//

[Bid,N]
1S
Pass
1NT
Pass
2C
Pass
Pass
Pass

[S]
x x
x x x x
x x
K Q x x x

North may be forced to bid with 3 small Clubs, so South needs every bit of his
5-card Club support in order to pass or to raise Clubs.

With, say, the Ace of Hearts thrown into South's hand, South could afford to
raise to 3C.

If North had bid 2H instead of 2C, he would be promising a 4-card Heart suit.
Again, South would pass with a very weak hand and raise according to the
number of points held.
//

Weak Jump-Shift:

It makes sense to keep the bidding slow with strong hands so as not to use up
bidding space and to bid as high as possible as quickly as possible with weak
hands in order to restrict the opponent's bidding space.

The weak jump-shift bid fills this bill.

[Pause]
[Bid,N]
1C
Pass
2S

[S]
Q J T x x x
x x x
x x
x x

[Pause]
[Bid,N]
1C
Pass
3S

[S]
K J T x x x x
x x x
x x
x

This is an example of an even more preemptive jump-shift.
//

[Bid]
1C
Pass
2S
Pass
???

[S]
x
K Q x x
x x x
A K x x

Without a very unusual hand, opener will pass a weak jump-shift, even if she
does not like the suit.

[Pause]
[S]
x x
A K x x
K Q x
A K J x

With a very strong hand (19+ points), South will bid 2NT as a game force.

[Pause]
Q x x
K Q x x
x x
A J x x

With a minimum opener and good trump support, South may raise to the 3 level
for preemptive purposes and North is expected to pass.

[Pause]
[Bid]
1H
Pass
2S
Pass
???

[S]
x
A Q x x x x
K Q J x x
x

With a 2-suiter and poor trump support for partner, South should bid his other
suit. North may pass or correct to South's original suit.
//

The bidding of weak jump-shifts is the same even when the opponents interfere.

Double and triple jump-shifts show 7+ cards and are still weak, except that in
some cases, Splinter Bids take precedence (assuming that you use them).
//

19-Point Forcing Openings:

This system is based on the popular idea that perfectly good opening bids
should not be wasted on hands that rarely arise if they can be used to
describe hands that more frequently arise.

When playing Weak 2's, the 2C forcing bid is used with a hand that is within a
trick of game. A much more common hand is one in the 19+ range with which you
can make game if partner has a minimum response (6+).

So in this system, any hand of 19+ points, balanced or unbalanced, is opened
2C.

One advantage this has is that if you open the bidding on the 1 level, partner
knows that you canNOT have 19+ points. This may immediately settle the
question for partner of whether your side has game, slam, or just a
part-score.

This one factor alone makes this system very worthwhile.
//

[Bid]
1D
Pass
2C
Pass
3D
Pass
3NT
Pass
???

[S]
x x x
K x
A K Q J T x
A Q

This is a typical example of how the 19-point 2C bid makes bidding easier (and
this is an example you probably will not find in books on other bidding
systems).

What is South to bid now? This hand is worth 19-21 points or more. (It's hard
to put a value on 6 quick tricks.)

North has not limited the strength of her hand.

But you are already at the 3NT level and neither partner has any idea of the
true strength of the other partner. If South had opened 2C to show 19+ points,
at least North would have a better idea of whether a slam was in reach.
//

[Erase]
[Bid]
1S
Pass
2C
Pass
3NT
Pass
Pass
Pass

[N]
Q J
J T x
K Q x
K J T x x

[S]
A K T x x
K Q x
A x x
A x

One difference between the 19-Point 2C and a regular strong-2 opening is that
that if partner has opening strength, she bids 3C. (This says nothing about
her Club holding.)

Look at the hands and bidding shown. A slam is being missed, but with regular
strong-2 requirements, it is almost impossible to find.

South cannot jump to 2NT, which is only invitational. He cannot bid 4NT, which
is Blackwood. He can't jump in Spades or Clubs, which shows greater length. He
can only bid 3NT.

[Pause]
[Bid]
2C
Pass
3C
Pass
3S
Pass
3NT
Pass
6NT

With the bidding now shown, North's 3C bid shows opening strength. Now South
can add his 20 and partner's 13 and see slam. (If North had even more points,
like 16+, she could raise to 7NT.)
//

[Erase]
Opening a 19+ 2C affects other bids.

[S]
A K Q x x
K x x x x
K Q
x

In Level I, Course 3, we saw that a player may have to open 1H to start a
Reverse even though Spades might have been a better suit.

With 3 small Spades and 3 small Hearts, North might raise Hearts and N-S will
never find their better Spade suit.

Another situation we don't like is when you have to reverse and your two
5-card suits are Hearts and Diamonds. Again, if you bid Diamonds first and
partner raises them, you have a hard time finding a Heart fit.

In fact, if partner raises the first bid of an intended reverse, you may have
trouble ever showing your strength.

With this system, South opens 2C to show his strength and then bids his better
suit.
//

[Erase]
Another difference in this system is that a jump to game in opener's suit is
considered a "shut-up" bid which opener should pass.

Without this system, there is a greater risk that a slam might be missed if
you jump to game and it turns out that partner has a 19+ hand.

With this system, there is a risk that opener will have a hand with 24+ points
and partner may pass on the second round (2C-2D, 2H-Pass) and miss game.

So for opener to show a 24+ point hand, he must jump on the second round
(2C-2D, 3H-4H).
//

The bidding in this sytem is very similar to a normal strong 2C opening with
the following exceptions:

1. After a positive response from partner (ie: anything but 2D), you can still
stop short of game in case of a misfit and minimum hands on both sides.

2. Partner responds with 3C to show an opening-strength hand and thus a strong
interest in slam.

3. The even-rarer 2NT and 3NT strength hands are still opened 2C and the
balance and strength shown later.

This frees up 2NT and 3NT for more common types of hands, as seen on the next
screen.
//

[Erase]
[S]
x
x
Q J x x x
K Q x x x x

[Bid]
2NT
Pass
3C

In the 19-Point Forcing 2C system, an opening bid of 2NT is used for
preempting with a hand 2-suited in the minors. (See "Unusual 2NT" for
responses.)

Many people already play that an "unusual 2NT" overcall shows the minors or
the two lower unbid suits. This system just lets you OPEN the same bid instead
of only being able to overcall with it.

With the hand shown, you cannot open a weak 2C because 2C is a strong bid and
you don't have enough Clubs to open 3C. Opening 2NT is the only way to preempt
with this hand.

[Pause]
[Bid,N]
Pass
Pass
Pass
3NT

[S]
K x
x x
x
A K Q J x x x x

Opening 3NT is used for a "Gambling 3NT" bid, which is made with a long, solid
suit, usually in the minors.

The gamble is that the opponents will lead a suit that you or dummy can
capture, after which you rip off your solid suit tricks. This bid is safer in
3rd or 4th chair.
//

[Bid]
2C
Pass
2D
Pass
2H
Pass
2S
Pass
Pass
Pass

[N]
x x x x x
x x
J x x
x x x

[S]
A J x
A K Q x x
K Q x
x x

You must let your opponents know before you start play that you use a 19-point
2C opening, as well as what your 2NT and 3NT bids mean.

Nevertheless, we have found that part of the appeal of opening 2C is that
opponents are less inclined to jump into the bidding on the 2 level after you
have made a "strong, forcing opening" (and rightfully so), even though the bid
is not as strong as usual.

As a result, you will be able to win some bids without interference that the
opponents would have otherwise competed for, such as shown at right where N-S
only have half the high card points in the deck, yet E-W never bid.

Without this system, bidding might have gone 1H-Pass-Pass-2C, all pass.
//

Negative Double:

[Bid,N]
1C
1H
Dbl

[S]
A x x x
x x
K x x x x
x x

The negative double is a very simple and useful concept. Its basic purpose is
to find a 4-4 fit in the majors.

After partner has opened and the opponent on your right overcalled, you can
double to show the two unbid suits (most often) or at least the unbid major.
With more than 4 of the unbid major, you would simply bid it.

If the two suits already bid are Hearts and Spades, than your negative double
shows Clubs and Diamonds.

If the opponent bids above the 3 level, a double is normally treated as being
for penalties rather than as negative.
//

Reverse Drury:

[Bid]
Pass
Pass
1S
Pass
2C
Pass
2D

A problem with opening with weaker hands in 3rd and 4th position is that
partner, who is a passed hand, may have a hand worth game opposite a good hand
but not opposite a weak one.

Drury is used when partner opens 1 of a major in 3rd or 4th chair. The Drury
bidder must have around 10 points and either trump support for partner or a 6+
card suit.

The Drury convention calls for responder to bid 2C. Responses to the 2C bid by
opener show:

    2D -- full opening bid (13+ points).
    2 of the same major -- a weak hand. This is
       artificial and doesn't promise extra length.
    2H (after opening 1S) -- a weak hand with
       at least 4 Hearts.
//

[+]
[Bid+E]
Pass
2S

If North rebids his major suit, showing a weak hand, South can just pass.
If North bids 2H after opening 1S, South can pick the major suit he likes
best.

If North bids 2D to show 13+ points, South:
    raises partner to show a normal Drury holding,
    jumps in partner's suit to show extra trumps,
    bids his own suit to deny trump support,
    bids NT with a flat hand.
//

Notrump Game Try:

In Level I we stressed that trumps do not produce any more tricks than a
notrump contract unless you can use trumps that would not have otherwise won
tricks to ruff cards in partner's hand that would not have otherwise have won
tricks.

If you and your partner have hands that will NOT produce extra trump tricks
and if you have hands that will play all right in notrump, it is easier to
make 3NT than 4 of a major.

[Bid]
1H
Pass
2H
Pass
2S
Pass
3NT

[N]
A Q x
x x x
J x x x
Q x x

[S]
x x
K Q J x x
K Q x
A x x

One situation that can arise is when partner raises your suit and you have a
5-3-3-2 type of hand, stoppers in all but the doubleton, and enough points to
invite to game. Instead of bidding 3 of your suit to invite, make an
artificial bid of your doubleton suit.
//

[+]
If partner has a hand like the one shown, she will bid NT because she knows
that you are left with 3-3 in the minors and she has no shortness there to be
able to ruff in.

[Pause]
[N]
A Q x
x x x x
x x
K x x x

With a hand like this one, North would bid 4S because she can ruff the third
round of Diamonds, thus producing an extra trump trick.
//

[Erase]
[Bid]
1H
Pass
2H
Pass
3H

[S]
x
A Q x x x
K Q x x
x x x

Another part of the Notrump Game Try is Preemptive Reraises.

If South passes 2H with the bidding shown, E-W are likely to come back with
2S. By raising to 3H with a minimum hand, you are more likely to keep them out
of the bidding.

[Pause]
[Bid]
1H
Pass
2H
Pass
2NT
Pass
4H

[N]
A Q x
x x x x
x x x x
K x

[S]
x x
K Q J x x
K Q x
A x x

With a 16-18 point hand and a desire to invite partner to game, instead of
bidding 3 of your suit, you bid 2NT.

If partner is at a minimum (6-8 points), she rebids your suit at the 3 level.
If she has enough to accept the invitation to game, she bids it.
//

[Pause]
[Erase]
[Bid]
1C
Pass
1H
Pass
2H
Pass
3H
Pass
Pass
Pass

[N]
x
K Q x x x
x x x
J x x x

[S]
A Q x
A x x x
x x
K x x x

The notrump game try can be used not just by opener, but any time that a
player would normally bid a suit a third time to invite to game.

In the bidding shown, North's reraise to 3H is preemptive. With a stronger
hand, North must bid 2NT or 3 of a suit to show a doubleton in 4-4-3-2 type
distribution.
//

[Erase]
[Bid]
1C
Pass
1H
Pass
2H
Pass
2S
Pass
3D
Pass
3NT

[N]
x x
A Q x x
K J x
x x x x

[S]
A x
K x x x
Q x x
K J x x

When both partner's have 4 trumps, an extra trump trick can be generated by
ruffing in either hand, so the only time you would want to be in notrump,
normally, would be when both players have identical distribution.

After the raise in Hearts, North bids 2S to show the doubleton, South's 3D bid
shows that he also has 2-4-3-4 distribution with a Spade doubleton and a
Diamond tripleton.

With this information, South bids game in notrump. With the hands shown, there
is a very good chance that 3NT will make and 4S would not.
//

Fourth Suit Forcing:

[Bid,N]
1C
Pass
1H
Pass
1S
Pass
???

[S]
A x
K Q x x x
x x x
Q x x

What can South bid now? If he bids 2H, partner may pass and miss game. It's
risky to bid 2NT without a Diamond stopper. You can't raise Clubs or Spades.

Bid 2D. Bidding the fourth suit in this situation is an artificial bid that is
forcing for one round and does not promise anything about the suit.

North can raise partner with 3 cards in South's first bid suit, or she can
rebid one of her suits to show 5+. With a strong hand (18+), North can
jump-raise or make a jump-rebid, as long as that does not take her beyond the
3 level.

Although South does not promise 4+ cards in the fourth suit, he may have them.
If North has 4+ in the suit, she can raise the suit to look for a fit.

If North cannot make any of these bids, she must bid 2NT with a minimum hand
and 3NT with a strong hand.
//

[+]
South is not required to bid again if North makes a minimum response.

When using this convention, you have the problem of how to show a hand that is
really two-suited.

With a minimum hand, make one of the bids already described. With enough
strength to invite opener to game (10-12 points), rebid the 4th suit if below
the 3NT level.

With enough points to force opener to game (14+), jump in the 4th suit if
below 3NT, bid and rebid the 4th suit above the 3 level, or bid 3NT.

This convention is off if the opponents interfere.
//

Truscott/Jordan 2NT:

After South has opened a major and West made a takeout double, North bids 2NT
with a 10-12 point hand and 4+ trump support. This is not a real NT bid, but
an aritificial jump raise.

This frees up the jump raise for preemptive use with less than 10 points and
4+ trump support. (With 3 trumps, just make a normal single raise.)

With 13+ points, force to game by making a splinter bid if you have a
singleton or void, or by bidding 3NT with a balanced hand.

If South opens 1 of a minor and you are using inverted minors, a raise to the
3 level is already weak and preemptive, so 2NT is natural and not an
artificial raise.
//

[Erase]
[Bid,N]
1S
Dbl
Rdbl

[S]
x
A Q x x
K x x x
Q x x x

Since the redouble is no longer needed to show trump support and a good hand,
shows a hand that will play well on defense.

Although it does not deny trump support, it is a bid uniquely suited for hands
like the one shown in which you do not have trump support and the opponents
will have to bid one of your 4-card suits. This is even more appealing if the
opponents are vulnerable and you are not, since the penalty points could be
more than your points for making game.

If you have trump support plus a good defensive hand, you can redouble first
and raise partner later.
//

Invisible Cue Bids:

[Bid,N]
1S
2NT
3C

Opponents can make a number of different overcalls to show two-suited hands
(Unusual NT, Michaels, Roman Jump Overcall, Astro) that it is handy to have a
way to deal with them.

In the bidding shown, East uses the Unusual NT to show a hand two-suited in
the minors. Therefore, a bid of one of the minors by South has to be a cue bid
of the opponent's suit.

South's 3C cue bid shows 10+ points and trump support for North.

If South bids the higher of the two suits (Diamonds, in this case), it
promises 10+ points and a least 5 cards in the fourth suit (Hearts).

A jump in the opponent's suit (4C/4D) is a splinter bid game force raise of
partner's suit which shows a singleton or void in the suit bid.
//

When playing Invisible Cue Bids, a double of the opponent's bid by opener's
partner shows a hand with 10+ HCP that will defend well against either of the
opponent's two suits.

A single OR jump raise or a bid of a new suit shows 6-9 points.

A bid of 2NT or 3NT promises stopper's in the opponent's suits

It is possible that an opponent could make an overcall promising two suits and
not have one of the suits. If you have that suit, the problem is how to show
it.

The solution is to pass with a weak hand or double with a 10+ point hand and
bid your suit the next time.

//

Lead-Directing Doubles:

[Bid]
1NT
Pass
2C
Dbl
2D
Pass
3NT

[E]
x x x
x x
A x x
K Q J x x

When the opponents are bidding towards game or slam and your partner is likely
to be the one to lead, you can tell him which suit to lead if the opponents
mention that suit and you double it, as in the auction shown.

If you have to lead and partner did NOT double 2C in the above bidding, you
can infer that partner does NOT have Clubs. You should look for another suit
to lead.

[Pause]
[Bid]
1H
Pass
1S
Pass
4H
Pass
4NT
Pass
5D
Pass
6H

In the bidding shown, if West has a good Diamond holding, it does him no good
to double South's Diamonds because West is going to be the one to lead.

In fact, a double in that situation could hurt E-W, since it would tell
declarer who has the Diamonds.
//

[Bid,E]
1S
1NT
2D
3NT
Dbl

When East doubles the final NT bid, it directs West to lead one of the
following suits in this order:

1. the suit bid by the leader
2. the suit bid by the doubler
3. dummy's first bid REAL suit
4. leader's WEAKER major

Dummy's REAL suit is the one indicated by a transfer bid. For example, if
North bids 2D playing Jacoby transfers, his real suit is Hearts.

The purpose of #4 is that if East has a powerful major suit, West is going to
be weak in that suit, so this is the only way to get him to lead it.

If you consider leader's weaker major to be his "Tiniest" suit, you can use
this acronym to remeber the order: "WENT" for West's suit, East's suit,
North's first suit, west's Tiniest suit.
//

Lightner Double:

[Bid]
1C
Pass
1D
Pass
2H
Pass
4H
Pass
4NT
Pass
5C
Pass
6H
Pass
Pass
Dbl

Lightner Double is a lead-directing double of a voluntarily bid slam (ie: not
a against a sacrifice at slam level).

It asks partner NOT to lead a suit bid by your side and to lead one of the
following suits in this order:

1. a non-trump suit bid by N-S
2. leader's longest suit

If N-S have bid more than one side suit, West has to figure out which one to
lead.

In the bidding shown, East had a chance to make a lead-directing double of 5C
and did not, so West can assume that East wants Diamonds led. (Some people
play Lightner with different meanings, so ask your partner and opponents.)
//

Unusual Notrump:

[Bid]
1D
2NT
Pass
3H

[W]
x
K x x x x
x x
A Q x x x

[E]
Q x x x
J x x
K x x x
K x

A 2NT overcall of an opponent's bid shows a hand with 5+ in each of the two
lower unbid suits and partner must bid one of those suits.

In the bidding shown, the two lower unbid suits are Hearts and Diamonds.
East's Hearts are better, so she bids those. West can pass with a weak hand,
bid the longer suit with greater than 5-5 distribution, or cue bid or bid NT
to show a very strong hand (17+ HCP).

With a stronger hand, East would jump in Hearts to game. With a very weak
hand and very good trump support, East could jump in Hearts, not to make game
but to obstruct the opponents.

With a very strong hand East would cue bid the opponent's suit. If West had a
weak hand, he must bid the lower suit. With a game or slam going hand, West
should bid something else.
//

You do not have to JUMP in NT to make an unusual NT bid. Any NT bid over
strong bids by the opponents is unusual.

Bidding 2NT over a strong 2 bid (eg: 2C-2NT), over 1NT, over a 2-over-1
response (eg: 1S-Pass-2H-2NT) or over a single major raise (eg:
1S-Pass-2S-2NT) shows a weak hand with the two lowest unbid suits.

Even 1NT by a passed hand (Pass-Pass-Pass-1S-1NT) is unusual, since you
cannot possibly have a NT strength hand.

Bidding 4NT over an opening bid of 4 of a major by the opponents is unusual
(eg: 4S-Pass-Pass-4NT). Over 4S, it promises the 3 other suits. Over 4H, it
promises only the minors. If you had Spades, you would double 4H rather than
bid 4NT, which takes you past the 4S level.
//

Michaels Cue Bid

Instead of using a cue bid of the oponent's suit to show strength, it can be
used much like the Unusual NT to show a two-suited hand of any strength.

A cue bid of a minor shows the majors. A cue bid of a major shows the other
major and "a minor to be named later".

The cue bidder's partner can
  - bid one of the promised suits,
  - bid 2NT with no preference,
  - jump in one of partner's suits with a weak
      hand and very good trump support,
  - cue bid the opponent's suit to show interest
      in game or slam,
  - bid a self-sustaining suit not promised by partner.
//

Responsive Doubles:

[Bid]
1C
Dbl
2C
Dbl

A Responsive Double ("RD") is one made after partner has doubled, the next
opponent has raised, and you do not have a suit preference yourself. It shows
6+ points if made on the 2 level, 8+ on the 3 level, 10+ on the 4 level.

An RD of a major shows the minors, since you could bid the other major
yourself with 4+.

An RD of a minor shows that you either have the majors or a hand suitable for
NT.

Respond to an RD by counting your points and bidding accordingly.

A double is not an RD if the opponents did not bid and raise a suit or if a
preemptive bid was made (eg: 2H-Dbl-3H-Dbl).
//

Astro:

Astro is a way to get into the bidding after an opponent opens 1NT. It require
9+ HCP and a 5-4 two-suited hand.

A 2C overcall of 1NT promises 4+ Hearts and a minor suit. 2D promises 4+
Spades and another suit.

Responses by Astro's partner:
- 2 of the promised major shows 3+ cards.
- 2S over 2C shows 6+ cards in Spades.
- 3C over 2D shows 6+ cards in Diamonds.
- 2NT asks Astro bidder to show his suit.
- a jump in any suit is inviting to game.
- a jump to game is a sign-off.
- 2D over 2C, or 2H over 2D, denies any of the
    above holdings and asks partner to bid.

The first 3 bids are weak, non-forcing bids.
//

5 of a Major:

[Bid]
1H
Pass
3H
Pass
4D
Pass
4S
Pass
5H

When trying for slam, Blackwood, Gerber, and even control asking cue bids may
not give you the exact information you need to decide whether to go to small
slam, grand slam, or to stop short of slam.

If you freely bid 1 over game in a major, that is obviously a slam try. This
convention calls for your partner if she has a control in the opponent's suit.

If the opponents did not bid, it asks for a control of a suit not bid by your
side. In the bidding shown, South is asking for North's controls in Clubs.

North passes short of slam with no controls, bids 6 with second round control,
bids 5NT with a King (not singelton), bids the suit being asked about to show
1st round control, or bids some other suit to show 1st round control of that
suit PLUS the one asked about.

If the opponents have not bid and N-S have not bid 3 of the suits, then 5 of a
major cannot possibly be asking for information about a side suit. Instead, it
is asking about the trump suit.

North passes if he expects two trump losers from the bidding, bids 6 if one
loser is expected, and bids 7 with solid trumps.
//

Grand Slam Force:

Grand Slam Force is not a "force". You bid 5NT after trumps have been agreed
to ask partner to bid 7 with two of the top 3 or otherwise bid 6.

If a trump suit has not been agreed, it is the implied trump suit (eg:
3S-5NT).

Alternatively, partner can make more informative responses:

- 6C (assuming C aren't trumps) shows A and K.
- 6D shows the Q or enough length to bring in the Q
    (eg: partner has shown 6 cards and you have 5).
- 6 of the trump suit to deny the above.
- 7 of the trump suit to show 2 of the top 3 trumps.

After 4NT Blackwood, 5NT is asking for Kings, so another bid is needed for a
Grand Slam Force: bid 6 of the cheapest suit below the trump suit (cannot be
used with Clubs as trumps, obviously).
//

Flannery:

Under the assumption that a weak 2D opening has little preemptive value, that
bid is used to show five Hearts and four Spades - a holding that is otherwise
difficult to show and still stay below the 3 level.

Opener's partner responds according to the points and holdings in those suits
or bid 2NT to ask for features.

Over 2NT, opener bids:
- 3C or 3D to show 3 cards in C or D.
- 4C or 4D to show 4 cards in C or D.
- 3H to show a minimum hand and 2-2 in C-D.
- 3S to show a strong hand with 2-2 in C-D.
- 3NT is like 3S but also shows an honor in
    each of the minor suits.
//

Flint:

After partner opens 2NT to show 22-24 points, it may be difficult to stop
short of game even if you have a hand with no points.

Bidding 3D over 2NT shows a hand with less than 2 points.

Opener must respond 3H to the 3D bid, after which the 3D bidder can pass with
a Heart suit or correct to 3S with a Spade suit. (Obviously, either a Heart or
Spade suit is required.)
//

Solid Minor Preempts:

If your taste does not lean towards the Gambling 3NT when you have a 6- or
7-card minor suit headed by the A-K-Q, you might want to use Solid Minor
Preempts.

A preempt of 3D or 3C is reserved for the holding just described and little or
no outside strength.

Partner can then bid 3NT if she has the other suits stopped.

You can still preempt in Clubs or Diamonds on the 2 or 4 levels with the usual
proviso that you must go set no more than 2 if vulnerable, 3 if
non-vulnerable.
//

Landy:

After an opening bid of 1NT, overcall 2C to show a two-suited hand in the
minors or 2D to show both majors.

This is actually known as Revised Landy. The original Landy only uses 2C to
show the majors.

This sort of "takeout" bid is needed because a double of 1NT is mostly for
penalties instead of takeout.
//

Precision 1 Club:

There are many strong, artificial 1C opening systems. Most of them involve
countless additional artificial bids. Precision 1 Club uses more Standard
American type bidding.

Opening 1C shows 16+ points, says nothing about Clubs, and is forcing.

Since 16-18 point notrumps are no longer applicable, weak notrumps (13-15
points) are used; however, 2NT is still used to show a balanced hand with
22-24 points.

A response of 1D shows less than 7 HCP. All other bids by opener or responder
are natural.

Complete treatment of the Precision Club system is a separate CSBT course.
//

Jump Cue Bid:

[Bid,W]
1S
Pass
Pass
3S

[S]
x x x
A
A K
A K Q J x x x

With an opponent bidding ahead of you and you having a game-force strength
hand but no stopper in the opponent's suit, you can ask partner to bid 3NT by
making a jump cue bid in the opponent's suit.

One possible holding is shown. Opposite a passed hand, it is unlikely that you
are missing slam. In fact, you may not even be able to make 5C if you have 3
quick Spade losers, which is why you would rather be in 3NT.

[Pause]
[Bid,N]
1C
1H
3H

[S]
A K x x
x x x
A Q J x
J x

The jump cue bid can also be used after partner has bid, as shown.
//

Be Logical:

It takes about 13 points to open, about 26 for game in the Majors, about 33
for a small slam, etc.

These are general guidelines for which there are frequent exceptions. To make
the most of your cards, you must always ask yourself what the bidding tells
you about the other hands and how that changes the value of your hand.

Many, many slams have been made with fewer than 20 HCP. Many game bids have
gone set with more than 26 points.

The next screen is a quick test of your ability to reason beyond counting
points.
//

[Bid]
1H
Pass
3H
Pass
???

[S]
K Q x
K T x x x x
A J T
x

Q: What would you bid with South's cards?

A: 4NT. North's jump only promises 13-15 points and heart support. You only
have 13 HCP, 15 total points. Sounds like just enough for game and not enough
for slam, right?

But ask yourself what 15 points could North have that would NOT give you a
good shot at slam.

With as little as 3 Hearts to the Queen (which is the least that North is
likely to have for his jump raise), you may have only 1 loser in each suit
even if partner has no Aces. With 13-15 points, he is bound to have at least
1, probably 2, and maybe 3 Aces.

With 28-30 points, if North has only 1 Ace, you have enough points to safely
sign off at 5S.
//

[End]
