Basic Declarer Play and Defense

Basics of Play
The Mechanics
Correcting Illegal Plays
Defense - Leading Against Game
  Leading Your Partner's Suit
  Leading The Unbid Major
  Leading From A Long Suit
  Leading Against Slam
Declarer - Drawing Trumps
  When NOT to Draw Trumps
  Planning Your Play
  The Finesse
    The Double Finesse
    The Repeatable Finesse
    The Bare Finesse
    Not a Bare Finesse
    Not Any Finesse
    Ruffing Finesse
    To Finesse, or Not to Finesse
    Eight Ever, Nine Never
  Establishing a Side Suit
  Playing at Notrump
    Keeping the Dangerous Opponent Off Lead
    The "Holdup" Play
Establish Your Long Suits in NT
Defensive Plays
  "Second Hand Low"
  "Third Hand High"
  "Play an Honor on an Honor"
  "Punch Declarer, Not Dummy"
  "Return Your Partner's Lead"
  "Through Strength, Up to Weakness"
  Things to Watch For On Defense
  Giving Card Count
Review
//

Basics of Play:

This course covers some of the basic strategies of the play of bridge.

It assumes that you have completed the courses on bidding. If you have not,
you should go back to the index and load them.
//

The Mechanics:

[Bid,N]
1C
Pass
1H
Pass
2H
Pass
Pass
Pass

[S]
x x
J x x x
K x x
A x x x

[N]
Q x x x
A K Q x
x
K x x x

Review Questions:

Q: Bidding goes as shown. Who is Declarer?

A: S. The first person to bid the suit (or notrump) which becomes the final
contract is "Declarer".

Q: With South as Declarer. Who leads on the first trick?

A: W. The player to Declarer's left always leads first.

In bridge diagrams, South is always made declarer and West always leads.

This has nothing to do with the way bridge is bid or played, it is just a
convenience for writing about bridge hands.
//

[Erase]
An oddity of bridge not mentioned in the bidding section (because it has no
bearing on bidding) is that after West leads the first card, North (Declarer's
partner) lays her cards down on the table face up across the table from the
Declarer, and Declarer plays both hands.

North's hand is called the Dummy (no offense intended).

North lays down the cards divided into suits.

Each suit is fanned vertically (like in solitaire) so that the top of each
card can be seen above the card in front of it.

The trump suit, if any, is always placed on Declarer's left and the other
suits are alternated by color.
//

As discussed in the section on bidding, you must play a card in the same suit
led ("follow suit") if possible.

If you are void in the suit led, you may play any other card you wish
("discard") or "trump" the trick.

The high card played in the suit led wins the trick, unless the trick is
trumped, in which case the high trump card wins. The winning hand leads next.

In Rubber Bridge, the first player on the E-W team to win a trick picks up the
four cards played, turns them face down, and places each trick in an
overlapping stack in front of her so that the tricks may be easily counted.

Declarer does the same with the tricks he wins. After winning 6 tricks,
Declarer collapes the 6 overlapping stacks into one stack, which is called the
"book". This makes it easier to see how many tricks have been made towards the
bid.
//

Q: Declarer has made his book and has 2 other tricks stacked beside it. On a
contract of 5 Diamonds, how many more tricks does Declarer have to win?

A: 3. (5-2)

Q: How many tricks does the E-W team have to take to set 3NT?

A: 5. If the book is 6 tricks and N-S have to take 3 of the remaining 7
tricks, then if E-W take more than 4 tricks, they will set N-S.

Q: How many tricks do E-W have to take to set 6S?

A: 2. If N-S must take 6 of the 7 tricks over the book to make their bid, then
E-W have to take 2 tricks to set them.
//

Q: The contract is 4 Spades. During the hand, East leads the KD, Declarer
plays the AD, West plays the 3S, Declarer plays 8S from Dummy. Who wins the
trick?

A: Dummy. Dummy's 8 of Spades is a higher trump than West's 3S.

When the dummy wins the trick, declarer must lead a card from dummy's hand.

When declarer wins a trick in his own hand, he must lead from his hand.
//

Correcting Illegal Plays:

The two most common illegal plays are "revoking" and playing out of turn.

Revoking is not following suit when it is possible to do so. If it is caught
immediately, you can substitute a legal card and the card played becomes a
"penalty card".

If the revoke is not discovered until after the offender or his partner has
played on the next trick, the revoked trick and any subsequent tricks won by
the offender's side are transferred to the opponents.

There are some additional complications in the rules, but the above should do
for social play.
//

If a defender exposes a card out of turn, declarer can accept it as the lead
(if it was the offender's partner's turn to lead) or make it a "penalty card"
and require the correct opponent to lead.

Declarer cannot be penalized because he has no partner to leak information
to.

A penalty card must be left face up on the table and played at the first legal
opportunity. If more than one can be legally played, declarer picks.

Again, there are lots of complications, but for social play, the rule above
should be sufficient.
//

Defense - Leading Against Game:

In most contracts in a suit, E-W should try to take their winning cards
quickly before South has a chance to draw trumps and discard losing cards on
dummy's high cards or long suit.

In NT game contracts, E-W should hold off taking high cards right away.
Instead, you should try to "establish" your long suit by forcing out
Declarer's high cards in that suit.

Then when you get back into the lead by winning with your high cards in other
suits, you can win tricks with the last cards in your long suit.

Establishing a long suit usually does not work in defense of a suit contract
because by the time you have established it, Declarer will probably be out of
the suit and will trump your remaining cards in the suit.
//

[W]
A x
K Q x
x x x
K x x x x

Against a contract of 4S, West should lead the KH.

This forces out the AH and makes your QH good.

Then when you get the lead back with the Ace of trumps, you can cash your
Queen of Hearts.

You should NOT lead Clubs in this situation because if Declarer holds A-Q of
Clubs, he will be able to win the trick with the Queen.

It should be obvious that you would never lead a bare honor, such as the King
of Clubs, at least not if you hope to win the trick.

That is just giving it away, unless you have strong reason to believe that
partner has the Ace or Queen.
//

Holding the same cards against 3NT, you should lead a small Club.

True, this still lets declarer win the QC if holding the AQ, but the object is
to establish your longest suit.

If you can force out declarer's top Clubs and eventually take three Club
tricks, you could set 3NT by taking the AS, KH, and three Clubs.
//

[W]
A x
K x x
x x x
K x x x x

With these cards against 4S, you should lead either the AS followed by a small
Spade, or a small Diamond.

The point is to not give away a possible trick by leading away from a bare
King in either Hearts or Clubs.

An advantage to leading Ace and another Spade is that if Declarer was planning
on ruffing some of his losers in Dummy before drawing trumps, you have foiled
his plans by leading trumps.

Again, with this holding against any NT contract, you should lead a small Club
and establish that suit.

Against a partial game contract in a suit, such as 1S or 2S, you could also lead
a small Club. Since N-S were not strong enough to bid game, the chances are
better that your partner may have some high cards.
//

[W]
Q x x
x x
A x x x
Q J T x

Q: What do you lead against 3 Hearts?

A: QC. You do not want to lead away from single honors in Spades or Diamonds.
When your top 3+ cards in a suit are consecutive ("touching"), then you should
lead the top one.

With QJTx, you would also lead the Q against a NT contract, but with QJ92, you
would lead the 2.

A little ditty for remembering which suit and card to lead against NT is: "Lead
the 4th from the highest in your longest and your strongest."

There is a good reason for leading 4th-highest which we will get into in a
more advanced level of this series. For now, if you can remember to lead a low
card in your longest and strongest suit against NT, you'll do well.
//

  Leading Your Partner's Suit:

If your partner entered the bidding, it's often a good idea to lead her suit,
unless you have some overwhelming reason not to. (If the lead turns out to be
bad, you might politely inquire of partner why she jumped into the bidding
with a poor suit.)

[Bid]
1H
Pass
2H
2S
4H

[W]
K x
x x
x x x x
x x x x x

Q: What do you (West) lead against 4H?

A: KS. Since partner bid Spades, there is a good chance she has either the Ace
or Queen (or both).

If partner has the Ace, she will play low on the first trick. You continue with
the small Spade and partner wins the Ace, then leads back another Spade for you
to ruff (trump).

If partner's top cards are QJ of Spades, Declarer will take your King with the
Ace, but then partner's Q-J are good.
//

If you have 3 or more of partner's suit headed by an honor, do not lead the
honor. Lead a low card.

The idea is that if you have K-x-x, partner has A-J-T-x and declarer Q-x-x,
you can crunch declarer's Queen.

You lead low. Partner plays the Ace and leads a low card back. Declarer puts
up the Queen and you play the King, and then lead back your last card in the
suit to partner's J-T, which are now high.

The reason this doesn't work if you just have K-x is that you do not have a
small card to lead back on the third round. The suit is "blocked" in your
hand.
//

  Leading The Unbid Major:

[Bid]
1C
Pass
1S
Pass
1NT
Pass
3NT

[W]
K x x x x
x x x
x
Q x x x

Your 4- and 5-card suits were both bid by the opponents (not uncommon in a NT
contract), so you do not want to lead them.

Your best bet is to lead the unbid major, Hearts.

You know from the bidding that South does not have 5 Hearts (because he would
have opened 1H).

North probably does not have 4 of them (because she would have bid the Hearts
before Spades and her Spades cannot be that good because she happily leaped to
game in NT rather than rebidding her Spades).

Lead your highest Heart. If you lead a low one, partner may think you are
leading from 4 or more.
//

  Leading From A Long Suit:

[Bid]
1NT
Pass
3NT

[W]
x x x
x x x
-
Q x x x x x x

West has a long Club suit, but no "entries" (sure winners) in other suits, so
even if you establish the Club suit, you cannot get back in your hand to run
it.

With an entry-less hand, do not just blindly lead from your longest and
strongest. Instead, lead the unbid major.

With the same holding against a suit contract, it is possible that partner
will be able to trump Clubs, since you have so many of them.

It's even more likely that opponents will be trumping them, but with such a
weak holding, it may be your best hope.

If the bidding had started with East bidding a Spade, you should lead a Spade
with this holding.
//

[Erase]
[W]
K Q 7
5 4
T 3 2
A 9 8 7 6

Q: What do you lead against 4H?

A: KS.

Lead K from KQ against a suit contract. Also lead the K from AK.

When you lead the King and declarer does not take the trick with the Ace, it
tells partner that you probably have it.

Q: What do you lead against 3NT?

A: 7C.

Lead the 4th from the highest in your longest and strongest.
//

[W]
K 9 8
K 7 6
5 4
A 9 8 3 2

Q: What do you lead against 2H?

A: 5D.

You do not want to lead away from a single honor, which lets out the other 3
suits.

Also leading from a doubleton is nice because if partner happens to have A-K,
she may lead a third Diamond for you to ruff.

Q: What do you lead against 1NT with the same cards?

A: 3C. -- The same as against 3NT.
//

[Bid,N]
1S
2H
4S

[W]
K 7 5
9 3
K Q 8 7 5 4
7 2

Q: What do you lead?

A: 9H.

If partner has KQ of Hearts, it is important to force out the opponents' Ace
so that partner's top cards are good.

With this holding, you might even get a ruff on the third round of Hearts. KD
is not a bad lead either.

You do NOT want to lead from your King of trump and there is nothing to hope
for by leading Clubs.
//

  Leading Against Slam:

[Erase]
Against a small slam, declarer must often guess where an important Ace, King
or Queen is, so as always, avoid leading an honor or leading away from a lone
honor.

N-S are probably solid in the trump suit, so if you have no other safe leads,
it is probably safe to lead a trump, although this lets declarer control the
play and possibly discard losers on dummy's high cards.

If you have a holding like KQ or QJT in a "side" suit (ie: not the trump suit),
lead the top of one of those holdings.

If you have a lone honor and have any reason to hope that partner also might
hold an honor in the suit, lead a small card in that suit.

Unless partner has actually bid the suit, you would never lead YOUR honor,
hoping that partner has one too.
//

Declarer - Drawing Trumps:

In a suit contract unless you have a compelling reason to leave trumps out, you
should make sure you have drawn opponents' trumps.

If you start playing high cards in side suits for no reason other than to win
tricks, your opponents may trump with what would otherwise be a small,
worthless trump.

In order to know when all the trumps are in, you have to be able to keep a count
of the cards played by suit.

A good memory for counting cards and remembering which cards have been played
and who is out of cards, etc, is important in all card games, such as
blackjack, Hearts, and bridge.
//

If you do not have a great memory, you may not be able to remember the count
on EVERY suit, but it is critical as declarer that you have a count on trumps.

One easy way to remember is keep track of how many rounds of trumps have been
played and how many players followed suit.

If trumps were played three times and one opponent didn't follow on the third
round, you can quickly add 4+4+3 and know that 11 trumps have been played.

If you have two left in your hand, then you know all the trumps are accounted
for.
//

After drawing trumps, you usually want to quit playing them.

You want to keep some trumps in reserve in order to keep control of the hand.

For example, if you play all your trumps and the opponents have a long running
suit, you have no way of stopping them.

If you held onto a trump, then when they try to run a long suit, you can ruff.
//

[N]
Q 8 7 6
K 9 8
4
K Q J 7 5

[W]
T 9 5
A 3
8 5 3 2
9 8 4 3

[E]
J 2
J 6 4 2
A K Q T 9 7
T

[S]
A K 4 3
Q T 7 5
J 6
A 6 2

N-S are in 4S. West leads the 3C. If you start running Clubs before drawing
trumps, East will trump the second round.

If you draw trumps and do not keep count but instead keep leading every time
you see West follow, then you will run out of trumps.

You can now safely run the Clubs for 5 tricks and you made the 4 trump tricks
for a total of 9 tricks, but you still need one more. You can develop another
trick in Hearts by forcing the opponents' Ace of Hearts out, but then they will
run all their Diamonds and you have no trumps left with which to stop them.

If you had counted trumps and stopped leading them once you knew they were all
in, you would still have a trump left to use in stopping the Diamond run.
//

  When NOT to Draw Trumps:

[Erase]
[N]
Q J x
x x
A x x
K Q x x x

[S]
A K x x x
A x x
K x x
x x

1. If you need to ruff losers using dummy's trumps, you may not be able to
draw trumps first.

Example:

In a contract of 4S, South's possible losers include 1 Club, 1 Diamond, and 2
Hearts, for down 1.

You can avoid going down by playing the AH and a small Heart and then ruffing
the third Heart with a trump in dummy.

However, if you draw trumps first, you won't have any trumps left in dummy, so
it is critical that you play the Ace and small Heart first.

Then when you get the lead back, you can play your last Heart and ruff it in
dummy.
//

[Erase]
2. If the only trump left out is high.

Lets say N-S have 9 trumps between them and the Queen is out. You play the Ace
and King, but trumps split 3-1 and the Queen remains out.

It is usually not good to play trumps again and use two of your trumps (one
from your hand and one from the dummy) to pull one trump from the opponent, so
just leave it out and let the opponent take it any time.

One exception to this rule is if you want to run a long suit in dummy and don't
want the opponent to use his trump in the middle of your run.

In cases like that, go ahead and lead trumps to force out the high one and
when you get the lead back, you can run dummy's long suit.
//

  Planning Your Play:

After West has led and dummy's cards are displayed, the first thing you, as
Declarer, should do before touching a single card is plan your play.

If you wait until you've played a card, it may be too late.

If you are in a suit contract, count your possible losers, just as we did in
the previous example, then try to plan your play to turn possible losers into
winners. The following sections will tell you ways to do that.

Another approach, particularly good if both dummy and declarer have singletons
or voids, is to count winners instead of losers.

To count losers, you normally focus on the hand with more trumps. (Assume for
now that declarer has more trumps than dummy.)
//

If you have K-x and dummy has A-x-x, you have no losers in the suit. After
playing A-K, dummy has a loser, but it is normally Declarer's hand that you
are trying to set up.

If you have K-x-x and dummy has A-x, you may have no losers if you can ruff
your third card in dummy after playing the A-K.

If you have A-Q and dummy has x-x, assume you have a loser. You cannot count
on the opponents playing in such a way as to let you win the Queen when they
have the King.

If you have K-Q-x-x and dummy has x-x-x, you may have 3 losers unless dummy
has enough trumps to ruff after drawing the opponent's trumps. Your King will
force the Ace. Your Queen will then win a trick, but your two little ones will
be losers unless the opponents cards split 3-3.
//

Another critical part of planning is transportation.

It does no good to laboriously set up a long suit in dummy and then discover
you have no way to get to dummy to play its winning cards.

Likewise, you can't take a finesse in your hand (see below) if you cannot get
to dummy to lead the low card.

In a "friendly" game, your opponents may razz you to hurry up if you spend too
much time studying the cards.

Good opponents will spend the time analyzing their own hands and planning
THEIR play. So anyone who would try to hurry you is too inexperienced to
understand the need for planning ahead.

Your revenge will be in beating them severely.
//

  The Finesse:

[N]
A Q

[E]
5 4

[S]
3 2

[W]
K 6

The most basic play in bridge and the most difficult, sometimes, for novices
to grasp is the finesse. Here is an example of a finesse:

Dummy has AQ of Spades. You have 3 and 2. If you lead the 3 and West plays low
and you play the Ace of Spades, your Queen will lose to the King on a later
trick no matter which opponent has it (except on the rare occassion that East
has a King singleton).

Therefore, your BEST chance to win with the QS is to follow with it instead of
the Ace. If East has the King, the Queen will still lose, but everything else
being equal, half the time West will have the King and by "taking a finesse",
the Queen will win.

Kings are not the only cards finessed for. Any play in which you lead to a
card which will win if the first opponent has the higher card and lose if the
second opponent has a higher card is a finesse.
//

[Erase]
[N]
A Q x x
K J x
Q x x
K x x

[S]
J x x
A x x x
x x x
x x x

Q: In which of dummy's suits can you take a finesse? (List the first letter of
the suits starting with the highest ranking. Example: "H, D")

A: S, H, D, C.

Leading a card to any of these suits will win if West has the missing high
card and will lose if East has it.

That is the definition of a finesse.
//

    The Double Finesse:

[N]
A J T
2
3
4

[S]
4 3 2
A
A
A

[W]
K 9 8
3
4
5

[E]
Q 6 5
4
5
6

When two cards in a sequence are missing (the K and Q in the deal shown), you
can take a double finesse. Lead a low Spade and assuming that West plays low,
you play the Jack. If East has either the King or the Queen, she wins the
trick.

But when you get the lead back, you take a second finesse in Spades. Now only
one honor is missing between the Ace and the Ten.

If East has both the King and the Queen, you lose two tricks (which you can do
nothing about, no matter how you play the suit), but those times when West has
at least one of the two, you win a trick with the Jack or Ten.

Everything else being equal, there is a 50% chance of winning a single finesse,
but a 67% chance of winning one trick in a double finesse.
//

[N]
A Q T
2
3
4

[S]
4 3 2
A
A
A

[W]
K 9 8
3
4
5

[E]
J 6 5
4
5
6

This is another double finesse situation. The missing cards do not have to be
touching.

With the hands shown, you would lead towards dummy. If West plays low, you put
up the Ten of Spades. It loses to the Jack, but next time you put up the Queen
and finesse the King.

Another double finesse holding would be K-J-x. Lead low and put up the Jack.

If West has the Queen and East has the Ace, you force out the Ace and your
King is good.

If East plays the Queen on the first round, you try again with a bare finesse
on the King, hoping that West has the Ace.
//

    The Repeatable Finesse:

[Erase]
[N]
A Q J
2
3
4

[E]
T 9 8
3
4
5

[S]
7 6 5
A
A
A

[W]
K 4 3
5
6
7

In the deal shown, the Spade finesse is repeatable because

(1) North has a touching sequence of cards below the missing honor.

(2) South has enough Spades to lead for repeated finesses.

(3) South has winners for transportation back to his hand after winning the
first finesse.

If South only had 1 Spade, you could only win 2 Spade tricks - the first
finesse with the Queen and the Ace.

Since you cannot finesse with the Jack, all you can do is lead it out and it
will lose to the King.
//

    The Bare Finesse:

[Erase]
[N]
A x x
2
3
4

[S]
Q x x
A
A
A

[W]
K J T
3
4
5

[E]
x x x
x
x
x

With the hands shown, you can take a finesse, but not by leading the Queen
towards the Ace.

Say that you lead the Queen and West has the King. He will "cover an honor
with an honor" by playing the King.

If you cover the King with the Ace from dummy, that leaves the opponents' Jack
high.

If East has the King, West plays low and you play low from dummy, East wins
the trick, so you lose the Queen either way.
//

[E]
K J T
3
4
5

[W]
x x x
x
x
x

The proper way to finesse it is to play a low Spade to the Ace and then a low
Spade from dummy back to the Queen.

If West has the King, he will take your Queen.

But if East has the King, then when you lead back from dummy, if East plays
the King, you play low and your Queen is good.

If East has the King but plays low, you play the Queen and it wins.

The reason for playing the Ace first is to drop the King if somebody is
holding it singelton. However, if you have A-x-x opposite Q-x, you cannot cash
the Ace first. If you do, you are left with the Q in your hand and when the
King is played, the Queen falls.
//

    Not a Bare Finesse:

If dummy has A-Q-x and you have x-x-x, you can win at most 2 tricks if the
finesse wins. If dummy has A-x-x and you have Q-x-x, you can still win 2
tricks if the bare finesse wins.

However, if dummy has A-Q-J and you have T-x-x, you can win 3 tricks. If dummy
has A-x-x and you have Q-J-T, you cannot win 3 tricks by taking a bare
finesse.

But if you have touching honors, you do not have to take a bare finesse.

If you lead the Q from Q-J-T and West plays the King, you take it with dummy's
Ace and your Jack and Ten are high.
//

    Not Any Finesse:

If dummy and you hold A-Q and x-x, you will not lose any tricks if the finesse
wins.

However, if dummy has A-x and you have Q-x, you will lose a trick even if East
has the King and plays it on the lead from dummy. You are left with Ace on the
board and Q in hand.

If dummy has A-Q-J-T and you have a singleton, you can take one finesse, but
even if it wins, if West has K-x-x in the suit, his King will win the third
round because you cannot take a second finesse.

[Pause]
[N]
A x x
A x
x x x
x

[S]
J T 9
Q x
A x
A x

Q: With the hands shown, which card should South lead for a finesse?

A: JS. There is no finesse in Hearts.
//

    Ruffing Finesse:

[N]
K Q J T
A
x
x

[E]
A x x
x
x x
x

[S]
-
A x
A x x
A x

If dummy has a touching sequence (such as North's) with a higher card out and
South is void in the suit, you can still finesse the suit.

Lead the King. If East covers it with the Ace, you ruff, return to dummy, and
your Q-J-T are good, allowing you to discard losers on them.

If East plays low or discards, you discard a loser. If West has the King, he
wins the trick, but meanwhile, you have gotten rid of a card from your hand
which you would have lost anyway, and now the Q-J-T are good for making more
discards.

At best, you lose no tricks in the suit; at worst, you lose one trick, but you
get rid of a loser from your hand at the same time.
//

    To Finesse, or Not to Finesse:

[N]
A Q x
Q x x
x x x x x
x x

[S]
x
K J x x x
A x
Q J T 9 8

On opening leads, you are often faced with a situation like this one where a
small Spade has been led by West against 4H.

Whether you finesse or not depends on what your other cards are. With the
hands shown, you cannot lose by finessing. Whether the finesse wins or loses,
you can discard South's small Diamond on the AS. So if it wins, you pick up an
extra trick and if the finesse loses, you are no worse than you were before,
having traded a Diamond loser for a Spade loser.

[Pause]
[N]
A Q x
Q x x
x x x x x
K x

[S]
x
A K J x x
K x
Q J T 9 8

With this holding, if the finesse loses, E-W have the chance to take two
Diamond winners (assuming West has the AD) before you can discard a loser on
the AS.

So the key is to finesse ONLY if you have a protected, avoidable loser that
you can discard later.
//

[+]
An "avoidable" loser is a low card which cannot be established as a winner
by having a long suit and/or honors but which is protected from being
immediately taken by the opponents' high cards.

With K-Q-2 opposite x-x-x, assuming that the opponents do not simply lead the
Ace and let you play the 2 on it, you have one UNavoidable loser (the K, to
force out the A) and one avoidable loser, the 2.

There is no chance of the 2 winning a trick because the suit is too short, so
if you can discard the 2, you can "avoid" losing a trick. The 2 is also
"protected" by the K-Q, meaning that the opponents cannot simply rip off
winners in the suit.
//

[+]
With K-2, you may have 2 losers if the Ace is held by the opponent after you.

The 2 is "protected" on the opening lead, but if West leads to East in another
suit and East leads back through your K-2 and West has the Ace, your 2 is NOT
protected.

So with K-2 of Diamonds, you should NOT take the finesse on the opening Spade
lead unless you have strong reason to believe that East has the Ace of
Diamonds.

An exception to the above paragraph is if you bid 4S and you have 4 losers
(down 1) if you do NOT unload the 2D. In that case, you must take the gamble
and finesse, hoping that if it loses, E-W will not be able to take two winners
in Diamonds.
//

    Eight Ever, Nine Never:

[N]
A T x x
x
-
-

[E]
Q x
x
x
x

[S]
K J x x x
-
-
-

[W]
x x
x
x
x

It's not wise to take a finesse for the Queen if the odds favor playing the high
cards in the suit and getting the Queen to drop.

Everything else being equal, you should take the finesse if your side has 8 or
fewer cards.

With more than 8 cards, you should play the Ace and King and try to catch the
Queen in either a singleton or doubleton.

"Everything else being equal" means that you do not have any indication that
the suit might NOT be split equally.

However, if one opponent opened with a preempt, for example, it reduces the
odds that the cards are split equally and you might assume that the
non-preempting opponent has the Queen.
//

  Establishing a Side Suit:

[Erase]
[Bid]
1S
Pass
4S

[N]
J x x x
A Q x x x
K x x
x

[S]
K Q x x x
x x
A x
Q J x x

Without analyzing everything in this deal, let it suffice to say that you need
some tricks to make 4S. One source might be to establish dummy's Heart suit.

To establish the suit with minimal loss, first take the finesse. Whether that
wins or loses, at your next opportunity, you will play the Ace of Hearts and
then a small Heart which you will ruff in your hand.

If the 6 cards that were outstanding split 3-3, then dummy's last two Hearts are
winners.

If they split 4-2, then get back to dummy and ruff another Heart, leaving
dummy's last Heart a winner.

If Hearts are split no worse than 4-2, dummy's Hearts are good for one or two
Club discards.
//

  Playing at Notrump:

Start by counting your winners and possible winners and see how many tricks
you need to develop.

If you have enough tricks to make game, don't get fancy, just take your
winners.

If you have to develop tricks, then against good opponents, timing is
everything.

You have to set up your long suit(s) before the opponents set up theirs, and
the opponents have the advantage of leading their suit first.
//

[Erase]
[N]
A x x
x x x
K J x x
x x x

[S]
K Q J x
K Q x
A x x
A Q x

Q: The contract is 3NT. How many winners do N-S have?

A: 8. Four Spades, 1 Heart (after forcing out the Ace), 2 Diamonds, 1 Club.

Q: In what suits can declarer possibly get the 9th trick?

A: D, C. Declarer can finesse in either suit.

Q: Which finesse should declarer try first?

A: D. Everything else being equal, try the longer suit first to avoid
establishing the opponent's longer suit.

In addition, if the Diamond finesse loses but Diamonds split 3-3 (in the
opponents' hands), you can establish the 4th Diamond in dummy as a winner.
Warning: the Diamond finesse may not be safe. (Click on Continue.)
//

    Keeping the Dangerous Opponent Off Lead:

[N]
A x x
x x x
K J x x
x x x

[S]
K Q J x
K Q x
A x x
A Q x

In a NT game, you often have one suit which is weaker than others.

You may have a stopper in a suit only if one opponent leads rather than the
other, and your strategy must be to keep the "dangerous" opponent off the
lead.

For example, if West leads a low Heart and you win the King on the first
trick, you will lose 4 tricks immediately if East gets to lead through your
Q-x holding into what is probably West's A-J-x-x.

However, if West has to lead from A-J-x-x into your Q-x, you still have
another stopper. In this situation, you should take the Club finesse before
trying the Diamond finesse so that if it loses, the dangerous opponent does
not get the lead. If it loses, then try the "dangerous" finesse.
//

    The "Holdup" Play:

A common ploy in playing NT is the "holdup" play.

If you have Axx in Spades and West leads a Spade, don't play your Ace until
the third round.

If Spades split 5-2-3-3 (with West holding 5), then when you play the Ace on
the third round, East also plays her last Spade.

So even if she gets the lead, she cannot play Spades. West sits there with two
good Spades he cannot play. (Making him the "dangerous" opponent, by the way.)

In contrast, if you play the Ace right away, then when East gets in, she will
have Spades left to lead to partner to run.
//

Establish Your Long Suits in NT:

In NT, the first thing you generally want to do is establish your long suits.

If you have Q-J-T-x-x of Diamonds, you want to force the Ace and King out of
the opponents so that the rest of your Diamonds will be winners.

If you have A-x-x of a suit and dummy has K-x, the LAST thing you want to do
is play that suit.

If you play the Ace and King early on, the opponents may be sitting there with
their own QJTxxx suit to run when they get in, and you just made it possible
for them.

In general, when playing notrump (whether as declarer or defender) you should
hold off playing your high cards and try to force the high cards out of your
opponent in order to make the lower cards in your longer suit(s) good.
//

If you are defending against NT -

If you lead your 4th highest in your longest and strongest and declarer takes it
and leads the suit right back, it means...

- he's a fearless bluffer
- he's a very poor player.
- he has an even better holding in that suit than you do.

If you are holding A-Q-J-x-x-x, it's probably one of the first two, but if
your suit is more like Q-J-x-x, then it is probably the latter.

In that case, forget your suit and try to find a suit your partner likes.
//

Defensive Plays:

When dummy comes down, you should study it and plan your defense while declarer
is planning his play.

If you see a long suit with lots of high cards, it's a good bet that you have to
take your winners quickly before declarer draws trumps and starts running the
side suit.

If you see a void or singleton or even a doubleton, there's a good chance that
declarer will try to ruff losers before drawing trump.

Your best defense may be to lead trumps in that case.
//

  "Second Hand Low":

[N]
Q x x

[S]
J x x

[W]
K x x

[E]
A x x

This old saw means that when defending, if you are the second hand to play (ie:
declarer or dummy led), you usually should play low.

For example, if declarer leads a small Spade, you (West) should play low with
the cards shown.

If partner has the Ace and declarer has the Jack, partner's Ace will take
dummy's Queen and your King will still be available to take declarer's Jack.

Another relevant quote is "use an honor to take an honor" - in other words, do
not waste a high card when all you can take is a low card.
//

[Erase]
[N]
A J T

[W]
K Q x

One exception to "second hand low" is if South leads a small card to take a
double finesse.

If you play low and declarer plays dummy's Jack, you may never win a trick if
South only has two Spades. (His second one goes on the Ace.)

In a situation like this, you should play one of your touching honors if you
have any reason to believe that declarer only has 2 cards in the suit.

In notrump, you might still get your King (or Queen) in the long run, but if
you see that giving up the trick to the Jack right away will let declarer make
his bid, you should play one of your honors.
//

  "Third Hand High":

[Erase]
[N]
J x x

[E]
Q T x

When sitting East, your partner will usually lead his 4th highest in his
longest and strongest suit against notrump.

You should play the highest card necessary to force declarer to play HIS
highest card.

For example, if Jxx is on the board and you have QTx, play the Q if declarer
plays the J; otherwise, play the Ten.

If you have touching cards (eg: KQJ), play the lowest. If the Jack forces the
Ace out of declarer, your partner may be able to figure out that you have the
King and Queen.

If you play the King and declarer plays the Ace, partner hasn't a clue as to
who has the last two honors.
//

  "Play an Honor on an Honor":

[N]
A x x

[E]
J T x

[S]
Q x x

[W]
K x x

We have seen that if dummy has Axx and declarer has Qx, declarer must lose a
trick... but only if you play right.

If declarer leads the Q and you don't cover it with the King, then he will let
it ride and win a trick he should not have.

If you cover it and declarer plays the Ace from dummy then the Jack, held by
your side, is good.
//

  "Punch Declarer, Not Dummy":

[Erase]
If you lead K from AKQxxx against a suit contract and see xxx in dummy, it may
be a good idea to keep leading this suit every chance you get.

What is usually a drawback (declarer can ruff in) can backfire on declarer if
he has to use up his trumps on your long suit and thus loses control of the
hand.

For example, if declarer had a 5-3 trump fit with dummy and uses one trump to
stop your initial run of your suit, then has to use another one when you get
back in the lead, he ends up with only 3 trumps in his hand.

At best (for declarer), he will have to use them up drawing trumps if they
split 3-2 in E-W's hands.

At worst (for declarer), trumps will split 4-1 or 5-0 and the opponents will
end up with more trumps than declarer.
//

However, it is rarely correct to lead a suit that dummy can ruff, since declarer
can ruff in dummy and still maintain control of the trump suit in this hand.

The same is true if dummy has enough trumps (4+) to maintain control if
declarer has to ruff.

What this rule should really say is to "punch" the one with the fewer trumps.

If declarer opened a convenient minor and dummy raised with 5 of them, then
declarer is the hand with the short trump suit.

In that case, you would lead a long suit if you saw it short on the board and
try to force declarer to use up the dummy's trumps.
//

  "Return Your Partner's Lead":

Barring any good reason to the contrary, it is usually a good idea to return
your partner's lead.

It may be that partner was trying to establish a suit or was playing a
singleton and wants to ruff, etc.

If you fail to return his lead in such situations, you should have a VERY good
reason for it.
//

  "Through Strength, Up to Weakness":

[N]
x x x

[E]
A Q x

[S]
K J x

[W]
x x x

If you are West and have to lead during play and don't have a good lead, a
general rule is to lead to the strength of the board.

You don't want to lead to AKQJT, but if you lead to KJx, partner may be
holding AQ.

If you lead a suit in which the dummy is weak, you are probably giving declarer
a "free finesse" on your partner.

With the hands shown, South will have to guess at how to finesse the suit, and
may guess wrong, but if you lead the suit, it takes all the guesswork out of
it.

In addition, if declarer could not have gotten safely to the board twice to
take the double finesse, then you have just given him a trick.
//

[Erase]
[N]
A Q T
x x x

[E]
x x x
x x x

[S]
x x x
K J x

[W]
K J x
A Q T

Likewise, if dummy is on your right (ie: you are East), then lead to its
weakness, if you don't know what else to lead.

The last thing you want to do is lead up to a "tenace" like A-Q, K-J, etc, in
dummy and put your partner under the hammer.

But if you can lead through a K-J holding in declarer's hand into A-Q in your
partner's, you will make your partner a happy person.

With the hands shown, you (East) should lead a small Heart.
//

  Things to Watch For On Defense:

[N]
Q x x

[W]
K x x

[E]
A x x

[S]
J x x x

You may not always be able to detect the following situations, but you should be
alert for them. If it appears that these situations may exist, look for safer
leads, if possible:

1. In notrump, you do not want to be the first to lead a suit in which the
honors may be split.

If declarer has to play this suit first, he will lose both the Queen and the
Jack.

If you lead the suit, declarer will play a low card from dummy ("duck it") and
whether East plays the Ace or not, declarer will eventually get a trick from
the Queen or Jack.

This also gets back to not leading away from a lone honor.
//

[N]
Q x x x

[E]
x x x

[W]
A K x x x

[S]
x

2. You (West) made an opening lead of K from the cards shown. East and
declarer both followed suit.

If you play the Ace next, there is a good chance that with only four cards out
originally in that suit, declarer is now void.

If you play the Ace, declarer will trump it, so you don't get a trick and
dummy's Queen will then be good for a discard.

Even if declarer is not void and doesn't ruff your Ace, you still make dummy's
Queen high for a later discard for declarer.
//

  Giving Card Count:

This gets close to being a Level II topic, but it is a simple enough concept and
one which you can use in every deal.

When your side is defending, it is helpful to know how many cards your partner
has in a suit.

It is usually not possible to give an exact count, but you can indicate
whether you have an odd or even number of cards, which can often be enough
information to let partner deduce the count.

To indicate an even number of cards, play a higher one first and then a lower
one on the next round. From Q-T-6-2, play the 6 first and the 2 next. Common
sense: Don't do this if it will give away a trick, such as playing Ace from
A-2.

To indicate an odd number, play the lowest first.
//

[Bid]
1S
Pass
2D
2H
2S
Pass
4S

[N]
Q x x
Q J T
A x x x x
K x

[E]
x x
A K x x x x
x x x
x x

Example: You're holding the East cards. Partner leads a card in your suit -
the 5H. Declarer plays the Ten from dummy. You play the King and declarer
plays the 3.

There are now two cards left outstanding (not in your hand nor in dummy).

If partner has those two cards (meaning that declarer is void), and you lead
the King, declarer will ruff it and make dummy's Queen high.

However, if both partner and declarer have a Heart left, you can play the Ace
on the second round and declarer cannot ruff.

Then when you play a third round, partner may get to ruff the trick. If
declarer ruffs, partner may be able to over-ruff him.
//

So it is important to know if partner started with two or three Hearts.

Well, since partner led the 5 and declarer played the 3, and the 2 is still
missing in action, that indicates that partner was starting a high-low signal
to indicate an even number of cards.

That means that he started with two and so did declarer, so you should
continue with the Ace of Hearts.

If partner led the 2, you know that he has an odd number. Unfortunately, you
have to guess at whether he has 1 or 3.

Since you know that South has a 6-card Spade suit, the odds are that he has
the singleton Heart.
//

Review:

[N]
A T 4 2
7
A K 9 7 3
K J 3

[S]
K J 9
A J T 8 5
J 6 5
A 5

Q: Against your 3NT, West leads the 3S. How many tricks do N-S have?

A: 8. West has given you a free finesse in Spades, so you get the Jack along
with the Ace and King. Then 1 Heart, 2 Diamonds and 2 Clubs.

Q: Which finesse should you take for the 9th trick.

West is almost certainly leading from the Queen of Spades. The proper play is
to take the first trick with the Jack, then cash the King of Spades, then lead
the 9 to take the finesse.

On the off chance it loses, you should attack Diamonds next, since that is
your longest suit.
//

[Erase]
[S]
A J x x
A Q x
x
A Q J x x

Q: North opens 1S. What should South bid?

A: 2C. You should not miss a chance to describe your hand. There is no danger
of partner passing at this point.

North responds 2NT, indicating...
- no more than 5 Spades, since she didn't rebid them.
- a balanced hand.
- a minimum hand, since 2NT is the weakest bid available.

Q: What do you bid now?

A: 4NT. Bid the Blackwood Convention to ask partner for the number of Aces he
has. Your hand is worth 21 points in support of Spades and partner has at
least 12. Let's bid some slam!
//

[Bid,N]
1S
Pass
2C
Pass
2NT
Pass
4NT
Pass
5D
Pass
???

Q: Partner bids 5D in response to your 4NT. Your bid?

A: 5NT. Partner shows 1 Ace and you have the other 3.

When your side has all the Aces, you should ask for Kings unless an
unfavorable response would take you past 6 of your suit.

For example, if your suit is Diamonds and you are missing all the Kings, there
is a good chance that asking for Kings with 5NT will get partner to respond
with 6H.

You would probably not want to bid 7D with 2 Kings outstanding, but partner's
6H response to show 2 Kings has taken you past 6D.

In that situation, you would have no choice but to bid 6D after asking for
Aces. The same principle applies when asking for Aces with 3 or 4 out and your
suit is Clubs or Diamonds.
//

[Bid+S]
5NT
Pass
6H
Pass
???

Q: Partner responds 6H. What is your bid?

A: 6S. You are missing two Kings, so sign off.

This is where describing your hand instead of jumping straight to slam can pay
off. Partner knows you have a Club suit (and probably fewer than 4 Hearts and
4 Diamonds, since you did not bid either of those suits before jumping to
4NT).

Partner also knows your side has all the Aces but is missing one or more
Kings. If partner has the King of your suit (Clubs), then since you have shown
a powerhouse hand, partner might gamble that you have the rest of the honors
in Clubs and that the running Club suit could let North discard losers.

With this information, a confident North could bid 7S.
//

[Bid+S]
6S
Pass
7S

[N]
K Q T x x
T x x
A x x
K x

Q: North is at 7S. East leads a Spade. How many winners do N-S have off the
top?

A: 12. Assuming no worse than a 4-2 split in Clubs, you get 5 trumps, 5 Clubs,
and the 2 red Aces. The 13th trick can come from ruffing a Diamond in South's
hand.

Win the Spade, play the Ace of Diamonds and ruff a Diamond in South's hand,
draw trumps, and start running Clubs.

Play a low Club to the King and the small Club to the Ace.

Then play the Q and J. If Clubs split 4-2 or 3-3, the rest of your Clubs are
good.

If Clubs split 5-1 or 6-0, then ruff a Club in dummy and take the Heart
finesse.
//

Two important points to note in the planning and play of the hand -

(1) You can only generate another trick by ruffing in the hand that has the
fewer trumps, usually the dummy.

The hand with the long trumps is going to win tricks with his little trumps
already, so you can't count 5 trumps in North's hand and then more tricks for
ruffing in North's hand. That's counting them twice, obviously.

(2) Always plan your transportation between declarer and dummy before playing
a single card.

This is a simple example, but if you played the Ace of Clubs from South and
then played a small Club to North's King, you may not be able to get back to
South's hand to run the rest of the Clubs.
//

[Erase]
[S]
A J T x
K x x
K
A K Q x x

Q: What do you bid with South's cards?

A: 1C. The hand is not quite strong enough for a 2C opening.

[Bid]
1C
Pass
1H
Pass
???

Q: North responds with 1H. What do you bid now?

A: 2S. If you bid 1S, partner can pass with 6 points and you miss game.
Partner knows that you only have a 4-card Spade suit, since you did not open
1S.

[Bid+S]
2S
Pass
3H
Pass
???

Q: North bids 3H. What do you bid?

A: 4NT. North is showing 5+ Hearts. South's solid Clubs are worth a lot in a
slam, as is the singleton and the King of trumps. So let's ask for Aces.
//

[Bid+S]
4NT
Pass
5D
???

Q: North responds 5D. Your bid?

A: 6H. North promises 1 Ace. With an Ace missing, you sign off at 6.

[Bid+S]
6H

[N]
x x
A Q J x x
Q J x x x
T

Q: North is declarer at 6H. East leads a low Heart. How many tricks do N-S
have off the top?

A: 9. -- 1 Spade, 5 Hearts, 3 Clubs.

Q: What suit is most likely to produce the needed tricks?

A: D.

Before drawing trumps, play the King of Diamonds to force out the Ace. When
you get the lead back, play a low Diamond and ruff it. Then draw trumps and
your Q-J of Diamonds are good.
//

Q: Instead of leading a low Heart, East leads the King of Spades. What suit
should you play next?

A: C.

Play A-K of Clubs and discard the last Spade from North's hand.

Then when E-W get the lead with the Ace of Diamonds and try to cash the Queen
of Spades, you can ruff it in North's hand.

If you do not get rid of your losing Spade first, then when you play Diamonds
to force the opponent's Ace of Diamonds, they will also cash their Spade
winner and set you.
//

[Erase]
[N]
J x x
A x
K J T x
K J x x

[S]
A T x
T x
A x x
A T x x x

Q: Against your 3NT, West leads the KH. How many winners do you have?

A: 6.

Q: How do you play to get 3 more tricks?
      1. Finesse in Diamonds?
      2. Finesse in Clubs?
      3. Play Ace-King of Clubs and hope for
                the Queen to drop?

A: 3. That's the "8-Ever, 9-Never" ditty.

Q: The QC drops and you run all the Clubs. Now do you finesse the Diamonds?

A: No. With the 5 Clubs, you have exactly 9 tricks. Don't risk the contract
taking unnecessary finesses.
//

[Erase]
[Bid]
1C
Pass
1S
Pass
1NT
Pass
2NT
Pass
3NT
Pass
Pass
Pass

[W]
J 6
K 5 4 2
4
A J 9 7 6 2

Q: What do you (West) lead against 3NT?

A: 2H. When an opponent has bid your suit, look for another lead if you do not
have solid honors at the top.

In this case, you have four cards in the unbid major, so that makes an
attractive alternative.

A Club lead is almost sure to give up a trick to South. If someone else leads
Clubs, you may be able to pull in the whole suit.
//

[End]
