Responding to Opening Bids

Introduction
"New Suit Forcing"
Responding to 1H or 1S with < 6 Points
Responding to 1H or 1S with 6-10 Points
Responding to 1C or 1D with 6-10 Points
Jump Raises with 11+ Points
Jump Response in NT to a Suit Bid
Jump Shift Response to a Suit Bid
Responding on the 2 Level with 10+ Points
Responding to Notrump Openings
Stayman Response to NT
Responding to "2 Clubs Forcing" Opening Bid:
Responding to Weak 2's
Responding to Preemptive Bids
//

Introduction:

The previous course covered an Introduction to Bridge and Opening Bids.

This course covers Responding to Opening Bids.
The following two courses cover Rebids By Opener, and Competitive Bidding,
respectively.

It is assumed you have completed the first course before starting this one.
If you have not, go back to the Index and load the first course.

The last course in Level I will cover the play of the game.
//

"New Suit Forcing":

Most partners play that bidding a suit not previously bid forces partner to
bid again. Examples: 2D over 1H, 1S over 1H.

If your partner and both your opponents pass after you bid, that would be 3
passes in a row, which would end the bidding. By forcing partner to bid, you
are assured of being able to bid again.

Exceptions to the "new suit forcing" convention are

- bidding 1NT over any opening bid is considered a weak response and is
non-forcing.

- opener bidding a new suit below the level of 2 of his original suit is a
weak "suit preference request" bid. Partner can pass if she prefers the 2nd
suit bid.
//

[Erase]
[Bid,N]
1S
Pass
1NT
Pass
2D
Pass
???

[S]
x x
K x x
x x x x
K x x x

Q: With the bidding sequence shown, does South have to bid again?

A: No. South is weak and prefers Diamonds to Spades, so he can pass 2D.
//

[Bid,N]
1H
Pass
2C
Pass
2S
Pass
???

[S]
x x
K x
A x x x
K x x x x

Q: Your hand looks pretty weak. Do you have to bid again in the sequence
shown?

A: Yes.

Partner bid a new suit over 2 of the level of her original suit. (2S is higher
than 2H.)

In addition, partner has bid a "reverse" by bidding her lower ranking major
first.

Partner needs a strong hand (17+ points) to bid a reverse which may force you
to the 3 level to show a preference for one of her suits.

With partner's 17+ points, your side may have enough points for game.
//

[Bid,N]
1S
Pass
1NT
Pass
2H
Pass
???

[S]
x x
K x x
x x x
K x x x x

Q: Now your hand is even weaker. Do you still have to bid again?

A: No.

A 1NT response warns partner that you have a very weak hand and that you will
pass unless partner makes a very strong bid.

Partner bid below the level of 2 of her opening Spade suit, which is
non-forcing.

If your Spade and Heart holdings were reversed, you would bid 2S. North should
treat 2S as a weak response indicating a preference for Spades over Hearts and
should not bid again.
//

Responding to 1H or 1S with < 6 Points:

[Erase]
First some review questions. Assume partner opened 1S:

Q: How many cards does partner have in Spades?

A: 5+.

Q: How many total points does partner have?

A: 12+.

The "+" tells you that there are still a lot of unknowns about partner's hand.
She could have a minimum opener or a very strong one just short of a 2C
forcing opener. She could have a balanced hand or a big two-suiter.

Until you have enough information to arrive at the optimum final bid, you
should proceed slowly and make bids that will accurately describe your hand.
//

[Erase]
[Bid,N]
1S
Pass
???

[S]
x
Q x x x x
x x x x
x x x

Q: How many points does South have?

A: 4. Sort of. Two for the Queen and 2 for the singleton. However, since the
singleton is in your partner's suit, it might not be of any value.

With fewer than 6 points, you normally must pass, even if you have a void in
partner's suit. It may be hard to pass, but anything else could just make
matters worse. For example, partner may just rebid her suit on the next level.

If partner has as few as 12 points and you have 2 HCP, your side could have as
few as 14 HCP out of 40. Since East has already passed, she probably doesn't
have many points.

Chances are, West, who hasn't had a turn to bid yet, has enough points to bid
and your partner's 1S opener is not going to be left in.


//

Responding to 1H or 1S with 6-10 Points:

[Bid,N]
1S
Pass
???

[S]
J x x
A Q J x x
x x
x x x

With 3+ cards in your partner's major suit, and 6-10 points, raise him to the
2 level, no matter what else you hold.

With such few points, you cannot afford to do much bidding, so you must ignore
your own nice-looking suit(s) and bid the known 5-3 (or better) fit.

With a minimum opener, partner will pass your single raise, but if partner has
one of those 19+ hands, he will bid again.
//

[Bid,N]
1H
Pass
1S

[S]
A Q x x
x x
Q x x x
x x x

If partner opens 1H and you lack Heart support (fewer than 3) but have 4 or
more Spades, bid 1 Spade.

You CAN bid a new suit with 6-10 points if still on the 1 level.

You must have 5 cards in your suit to OPEN 1 of a major, but you only need 4
cards to make a "1-over-1" bid.

Since you do not have a 5-3 major fit, you are looking for a 4-4 fit. A bid of
1S over 1H only promises 4 Spades, so if you have more, you may have to show
it by rebidding them later.

If you cannot raise partner and cannot bid a new suit on the 1 level, you must
bid 1NT, even if you have a good unbid suit.
//

[Bid,N]
1S
Pass
1NT

[S]
-
A Q x x x
x x x x
x x x x

This "artificial" 1NT bid does not mean you have a strong desire to play in NT
or that you have stoppers in any suits. It just means that you have a weak
hand and don't like the suit bid by partner.

Unlike most "new suit" bids, responding 1NT to partner's opening bid is not
forcing. Partner will probably pass unless he has a really strong hand or
can't stand NT.

For example, if partner has 6 or more Spades and a hand poorly suited for NT,
he will probably bid 2 Spades over your 1NT. At this point you must pass, even
if you have a void in Spades.

You have already told partner that you have a weak hand and don't like Spades.
There is no need to bid again to say: "Hey, I really, really mean it!!"
Chances are there is no suit your side has that will play any better than
partner's, despite your void. By continuing to bid, you just increase the
number of tricks by which you will go set.
//

[Erase]
[S]
K x x
K x
x x x
Q x x x x

Q: Partner opens 1S. What do you respond with South's cards?

A: 2S. Raise with 3+ of your partner's major suit and 6-10 points.

Q: Partner opens 1H. What do you bid with the same cards?

A: 1NT. You cannot raise with less than 3-card support, cannot bid 1S with
less than 4 cards, and cannot bid a minor suit on the 2 level with 6-10
points, yet with 8 HCP, you must bid something.
//

[S]
A K J T 9
4 3 2
8 6
9 7 5

Q: Partner opens 1H. What do you bid?

A: 2H. Even though you could bid Spades on the 1 level, your hand is too weak
to do a lot of bidding.

Bidding another suit before showing a trump fit is how you show an interest in
game.

At this point, your hand is too weak to spark an interest in game.

If partner shows a very strong hand on his next bid, THEN you can bid on.

For example, if partner raises your 2H to 3H, inviting you to bid game if you
are at the top of your range for a simple raise, you would gladly bid 4H.
//

[S]
x x
A K J x x
x x x
x x x

Q: Partner opens 1S and you have the South cards. Your bid?

A: 1NT. You cannot bid 2H with less than 10 points.
//

[S]
x
x
A K x x x x x
Q x x x

Q: Partner opens 1S. What do you bid?

A: 2D.

You only have 9 High Card Points, but don't forget to count the distributional
points for the two singletons, for a total of 13 points.
//

[S]
-
J x x x
x x x x x
x x x x

Q: Partner opens 1S. What do you bid?

A: Pass.

You must accept that sometimes there are misfits that you can do nothing
about.

The best you can do is minimize the damage.

You do that by not increasing the bidding level when you have a subminimum
hand.

And by not raising the level, you increase the chances that an opponent will
decide to jump in the bidding and get you out of the mess.
//

[S]
5 4 3 2
T 9
A Q J 9 7
6 2

Q: Partner opens 1H. What do you bid? (Count points.)

A: 1S.

You are looking for an 8-card trump suit.

Partner has only shown 5 Hearts by opening 1H, so you cannot raise with only 2
Hearts, and you do not have enough points to bid Diamonds on the 2 level.

It is still possible that your side has a 4-4 Spade suit.

If partner has 4 Spades, she could not have opened them (assuming you play
5-card majors to open), so you should bid 1 Spade over partner's 1H to let her
know that you have 4 Spades, no matter how poor your Spades are.
//

[S]
-
x
A x x x x x
Q x x x x x

Q: Partner opens 1H. What do you bid?

A: 2D.

Based on what we have discussed so far, you do not have enough points to bid
on the 2 level, but this is an example of how strange distributional hands can
throw the usual guidelines out the window.
//

Responding to 1C or 1D with 6-10 Points:

[Bid,N]
1D
Pass
???

Q: What is the minimum number of Clubs or Diamonds partner must have to open
1C or 1D?

A: 3. If partner does not have a 5-card major, she may have to open a
"convenient minor". (See North's hand.)
//

[N]
A x x
K Q x x
K x x
J x x

[S]
Q x x x
A x x x
x x x x
x

[Bid+S]
1H

Partner's bid of 1D indicates that she does NOT have a 5-card major. So you
now must try to see if your side has a 4-4 fit in the majors.

If you have 4 cards in both Hearts and Spades, bid Hearts first.

If partner has 4 Spades and fewer than four Hearts, she will bid 1S over your
1H and you have found your 4-4 fit.

However, if partner has the holding shown and you were to bid Spades first,
she would have to bid on the 2 level to show her 4-card Heart suit.

If you bid 1 Heart over 1D and partner does NOT bid 1S, odds are that she does
NOT have a 4-card Spade suit, so there is no 4-4 fit in Spades.
//

[+]
If you have 5+ Spades and 4 Hearts, you DO bid Spades first.

With a 5-card major in your hand, you are no longer looking for a 4-4 fit, but
a 5-3 fit.

Since partner will never bid a 3-card suit on her own, it is up to you to bid
your 5-card suit first. Then if you get the chance, you can bid the 4-card
suit later.

If you had 5 Hearts and 4 Spades, you would bid Hearts first, but if partner
did not raise Hearts and did not bid Spades, there would be no point in
bidding Spades later since partner has denied a 4-card Spade suit.
//

[Erase]
[N]
A x x
K Q x x
J x x
K x x

[S]
J x
x x x
x x x
A Q x x x

If you do not have a 4-card major, but you have 5 or more in your partner's
minor suit, you can raise partner.

Since partner only promised 3 in his minor suit, you MUST have 5+ to assure at
least a 5-3 fit.

If partner opens 1C, you can raise to 2C.

If partner opens 1D, you must bid 1NT with South's cards.

You should not bid on the 2 level with less than 10 points, so you cannot bid
2C.
//

[Erase]
[S]
x x
K x x x
A J x x x
x x

Q: Partner opens 1D. What do you bid?

A: 1H.

Even though you are sure of at least a 5-3 Diamond fit, a 4-4 fit in a major
suit is preferable because it is worth more points. If partner cannot raise
your Heart suit, you may be able to bid diamonds later.
//

[S]
x x
x x
K x x x
A x x x x

Q: Partner opens 1D. Your bid?

A: 1NT.

- You cannot raise Diamonds with less than 5 cards in Diamonds.

- You do not have enough points to bid 2C.

- You do not have a 4-card major.

- You cannot Pass with 6+ points.

That leaves 1NT.
//

Jump Raises with 11+ Points:

When partner opens 1H or 1S, the first thing you have to do is revalue your
hand.

If you have more than 3 cards in your partner's suit, your distribution points
must be upgraded because you will be able to trump more in your short suits.

Add 2 more points for a void and one more for a singleton. Remember, this is
only if you have MORE than 3 of your partner's trumps in the majors.

If you have a suit of 5+ cards headed by AK or AQJ in addition to trump
support, you should consider that a plus since partner may be able to discard
losers on it.
//

[S]
x x x x x
-
A K x
K x x x x

Q: Partner opens 1S. How many points is your void worth now?

A: 5.

A void is normally worth 3 points.

When you have more than 3 of your partner's trumps, you can add another 2
points for a void.
//

[Erase]
[Bid,N]
1S
Pass
2H

[S]
A x x
K Q x x x
K x
x x x

With 11-15 points and trump support (3+), you have a good shot at game.

Since 26 points are generally needed for a game in the majors, if you have 11
or 12 points and partner has 14-15 points, you have about enough for game.

Because you already know that your side has enough points to bid at higher
levels, you have plenty of bidding space and do not have to be in a hurry to
raise your partner.

You can usually give a better description of your hand by bidding your suits
first and raising your partner later.
//

[Bid,N]
1S
Pass
3S

[S]
A x x
Q x x x
K x
K x x x

If you do not have another good suit to bid and you have 3+ trump support, you
will have to raise your partner's major suit.

With just 11-15 points and 3-card support (or 4-card support and no voids or
singletons or other hand-strengthing features), make a "jump raise" to the 3
level.

With this specific description of your hand, partner can make a very precise
bid.

She will pass if she opened with minimum points and push on if her hand is
good enough.
//

[Bid,N]
1S
Pass
4S

[S]
Q x x x
A x x
x
K x x x x

If you have 4+ trump support, no other biddable suits, and a feature such as a
singleton or void, you should jump straight to game with 11-15 points.

Responding 4S to an opening of 1S does not indicate a super-strong hand, it is
a "limit" bid, which means that you have bid the limit of what you think your
side can make.

If your partner has a very strong hand (18+ points or extremely
distributional), she may bid on; otherwise, she should just pass.
//

[Erase]
[S]
x
J x x
A Q x x x
K x x x

Q: Partner opens 1H. How many total points do you have?

A: 12. Ten HCP and 2 for the singleton.

Q: What do you bid with this hand?

A: 2D.

If partner has a minimum opening hand, you may not quite have enough points
for game. By describing your hand before raising Hearts, you give partner more
information with which to evaluate her hand.

If she holds Kxx of Diamonds, for example, she knows that you have a valuable
"double fit", which always plays stronger than indicated by High Card Points.
//

[S]
K 3 2
Q J 7 5
Q 8 6 4
A 5

Q: Partner opens 1S. Your bid?

A: 3S. Your side suits are not long enough nor strong enough to be worth
mentioning.
//

[Bid,N]
1S
Pass
???

[S]
K J x x
x
J x x x x
A Q x

Q: Partner opens 1S. How many total points do you have?

A: 14.

11 HCP, the original 2 for a singleton, and an extra 1 for having a singleton
and more than 3 cards in partner's trump suit.

Q: What do you bid?

A: 4S.

With your 4-card trump support and singleton Heart, you are almost assured of
game.
//

Jump Response in NT to a Suit Bid:

[Bid,N]
1S
Pass
2NT

[N]
K Q x x x
A Q x
Q J x
x x

[S]
x x
K x x
A x x x
A K x x

Jump to 2NT with
-  13-15 points,
-  no good suits to bid,
-  less than 3-card trump support, and
-  stoppers in the three unbid suits.

If partner has a reasonably balanced hand like North's, she will probably
raise to 3NT for game (and you had BETTER have stoppers in her weak suit!!).

If she has an unbalanced hand, she will take you out of notrump.

If she rebids her suit, do not be afraid to rebid notrump if your hand
dictates it.
//

[N]
A Q J x x x x
Q
K x x
x x

[S]
x x
K J x
A J x x
K Q x x

[Bid,N]
1S
Pass
2NT
Pass
3S
Pass
???

North's rebid on the 3-level of her Spades without support from partner
indicates a very strong Spade suit with 6+ cards.

Should South bid 3NT or 4S?

There are two advantages to being in a suit contract rather than notrump:

(1) in a suit contract, you can keep an opponent from running a long suit by
trumping, and

(2) you may be able to make more of your side's trump tricks by trumping short
suits in the responder's hand.
//

[+]
With the cards shown, South has pretty good strength in the other suits for
stopping runs, and South cannot expect to trump other suits in his hand before
trumps are drawn.

So from South's perspective, his side might as well play in notrump.

However, don't be surprised if North bids 4 Spades anyway.

North knows that you must have 2 Spades (you do not jump to 2NT with a
singleton), so she is assured of a 9-card suit. She may feel safer playing the
contract in Spades rather than NT.
//

[+]
[Bid+S]
3NT
Pass
4S
Pass
???

Q: If North does bid 4S, what do you bid?

A: Pass.

You were trying to steer the bidding to a 9-trick notrump game.

Partner has taken you to a 10-trick Spade game.

There is no point in pressing on in NT now.

With North's weak bidding, there is no point in considering slam. So pass.
//

[Erase]
[N]
A Q J x x x x
Q
K x x
x x

[S]
K x x x
K J x x
x
A Q x x

If instead of the cards shown before, South has the cards shown now, then
South can make more tricks in a suit contract than in NT by trumping Diamonds
after one round has been played.

In a NT contract, N-S might win 7 Spades, 2 Hearts, maybe 1 Diamond, and maybe
2 Clubs.

In a Spade contract, N-S would win the same cards, but South could also trump
a diamond, winning a trick that could not be won in NT.

So with this holding, South would rather be in Spades.

IMPORTANT: Trumping only provides extra tricks when done with trumps that
would not have otherwise won tricks and they are used to trump cards from the
other hand which would not have otherwise won tricks.
//

[Erase]
If North has KQJT9 of Clubs and you have a singleton and a lot of trump
support, you do not get any extra tricks by trumping Clubs for the following
reason:

You have to lose one round of Clubs to the Ace before you can start trumping,
but once the Ace is in, North's cards are all high, so you would be trumping
your own good cards.

A more common holding is something like QJ2 in North and K3 in South. South
cannot ruff until the 3rd round, by which time the remaining honor is good.

A holding where trumps can be made good is Kxxx opposite xx. South's first
little card goes on the opponent's Ace, the other on North's King. Now South
can ruff North's last 2 little cards in the suit.
//

[N]
K x
x x x x

[S]
A Q J T 9
x

Q: With the hands shown and Spades as trump, how many extra tricks can South
win by ruffing?

A: 0. South's Spades are already winners.

[Pause]
[N]
K Q x x
x
x x

[S]
A x x x
x x x

Q: How many extra Spade trump tricks can North make with the cards shown?

A: 2. North's two little Spades can be used to ruff South's 2nd and 3rd
Hearts.

[Pause]
[N]
K Q x x
x
x x

[S]
A x x x
K Q J

Q: Now how many extra trump tricks can North make?

A: 0. After the KH forces the Ace, South's Q and J are good.
//

Q: How many extra trump tricks can South make?

A: 2. South can ruff North's two little Diamonds and still draw trumps with
his Ace and North's K-Q of Spades.

[Pause]
[N]
Q J
-
x x

[S]
A K
x x

Q: How many extra Spade trump tricks can South make?

A: 2.

Even though South's Spades look like winners, they duplicate winners in
North's hands.

That is, if South ruffs with the A-K of Spades, he can still win two trump
tricks with North's Q-J.
//

Jump Shift Response to a Suit Bid:

[Bid,N]
1H
Pass
2S

[S]
A K x x x x
Q x x
A x x
x

With 13+ points and a good suit, make a "jump shift" bid. This means you jump
the bidding up beyond the next minimum level and shift to your suit.

With the bidding shown, 2S bid by South over 1H is a jump shift because the
minimum bid would have been 1S over 1H.

If partner opens 1S and you want to jump shift in Hearts, you have to jump to
the 3 level.

To make a jump shift, you should have a good idea from your hand and from
partner's opening bid what the trump suit is going to be.

With the deal shown, you intend to raise Hearts next whether partner rebids
Hearts or a new suit (unless partner raises your Spades).
//

[+]
[S]
A K Q x x x
x
A x x x
x x

With this holding, you cannot support partner's Hearts, but you have a Spade
suit that is nearly self-sufficient.

Even if partner doesn't like Spades, you might find a 4-4 Diamond fit.

So with this hand, you can make a jump-shift in Spades.
//

[Erase]
[S]
K x
K x x x
A K x x
A x x

With the hand shown, you should not jump shift in response to an opening bid
of 1S. Instead, just bid 2H and try to show your strength later.

The problem with this hand is that you do not have trump support nor a very
good suit. If you jump shift to 3H, you do not have much bidding room left to
find a fit with partner.

Also, partner will be expecting a much better Heart suit for you to bid it on
the 3 level and could raise you to game with 3 small Hearts.

Without the King of Diamonds, you could have jumped to 2NT with your 14
points, but the 17 points in this hand falls outside the 13-15 point range for
that bid.
//

[Erase]
Q: How many points do you need to jump-shift?

A: 13+. -- and a good suit and/or trump support.

[S]
A Q J x x x
x x
K Q J x
K

Q: North opens 1C. What do you respond? (Always count points first.)

A: 2S. This is a jump shift in your very good Spade suit with 16+ points.
//

[Erase]
[S]
K x
K Q x x x
A x
A x x x

Q: North opens 1S. What do you bid?

A: 2H. (Not a 3H jump-shift.)

Your heart suit is not good enough to force partner to play in it and you do
not have enough Spades to raise partner.

When you are not sure of where your final contract will be, do not jump shift.
Conserve bidding space until you find a fit, then bid strongly.
//

Responding on the 2 Level with 10+ Points:

[Erase]
[Bid,N]
1S
Pass
2H

[S]
x x
A Q x x x
K x
J x x x

A 2-Over-1 response is a non-jump bid on the 2 level, such as 2C over 1H or 2H
over 1S.

The closer to 10 points your hand drops, the better your suit should be to
bid on the 2 level.

If partner has opened with a minimum, there is no assurance that you have game
even if you have 12 points, particularly if you are not sure of a trump fit
yet.

With a hand like South's, the good 5-card Heart suit is worth a 2H bid.
//

[+]
[S]
x x
A J x x
K Q x
K J x x

With this hand, your Heart suit is not as good, but you have 14 HCP.

Even if North is at a minimum, you are almost assured of game and a bid of 2H
is acceptable.

You can bid the Heart suit to look for a 4-4 fit, knowing that if it isn't
there, you almost surely have game at 3NT.

In fact, if North raises to 3H, you should bid 3NT to indicate that you were
bidding a 4-card suit and not a 5-carder. It's possible that if she didn't
have anything better to bid North might have raised you with 3, hoping that
you had 5.
//

[+]
[S]
x x
K x x x
A Q x
Q x x x

With a weaker hand like the one shown, you have a difficult bid.

You cannot raise partner with fewer than 3.
You don't have a good enough suit to bid on the 2 level.
Your hand is too strong for 1NT and too weak for 2NT.

Books usually don't show you hands that don't neatly fit the bidding system,
but you are going to see plenty of them when you play.

About all you can do with this hand is bid 2H and run to 3NT if partner
raises.
//

Responding to Notrump Openings:

[Erase]
Responding to 1NT -

A 1NT opening bid tells you your partner has 16-18 points, no 5-card major,
potential stoppers in every suit and no singletons or voids and no more
than one doubleton, normally.

Such precise knowledge makes it easy to respond.

Game in NT normally takes 26 points, so if you have less than 8 points and
partner has a maximum of 18, you are unlikely to have game.

With less than 8 points,
- pass 1NT with a balanced hand,
- bid 2 of a suit if you have a long suit (6+).

Partner is supposed to pass your weak suit bid.
//

With 8-9 points, you have enough points for game if partner is at the top of
her 16-18 point range.

- With a balanced hand, bid 2NT. Partner will raise to 3NT if she was at the
top of here range and pass otherwise.

- With an unbalanced hand, jump to 3 of your suit. Partner will pass if she is
at the bottom of her range. Otherwise, partner will raise you to game if she
likes your suit or bid 3NT if she doesn't.
//

[Erase]
[S]
K x
x x x x
A x x
x x x x

Q: Partner opens 1NT. Your bid?

A: Pass. You have less than 8 HCP. (The distribution point doesn't count in
NT.)
//

[S]
x
Q x x x x x
Q x
x x x x

Q: What do you respond to 1NT with this hand?

A: 2H.

This is a weak bid showing a hand unsuitable for playing NT and a 6-card or
better suit.

In NT, South's hand may win no tricks. In 2H, the hand should win several
trump tricks.

Partner is expected to pass after this weak bid.
//

[Erase]
[S]
K x
A x x
Q x x x
x x x x

Q: Your response to 1NT with South's cards?

A: 2NT.

With your 9 points, your side can make game if partner is at the top of her
16-18 bid.

Partner will pass with a minimum NT opener.
//

[Bid,N]
1NT
Pass
3S
Pass
3NT
Pass
4S

[N]
A x
K Q J x
A x x
K x x x

[S]
K J x x x x
x
Q x x x
x x

With a 5-card major, a singleton or void, and 8-9 points, jump to 3 of the
major in response to 1NT.

Partner will either raise you to game in the major or will bid 3NT.

With a hand like the one shown and South promising only 5 cards in Spades,
North properly bids NT again.

If you have a hand like South's that is much better suited for 4S than for
notrump, you should not be afraid to rebid your suit.
//

[Bid,N]
1NT
Pass
3NT

[N]
A Q x x
K x x
A x x
K J x

[S]
x x
x
K Q J x x x x
x x x

You should be cautious of steering from a 9-trick notrump game into an
11-trick minor suit game unless your distribution is something like 6-5 in the
minors (eg: 6 Diamonds and 5 Clubs).

Even a distributional hand like the one shown can still play well at NT
because your Diamonds will probably be good for 7 quick tricks.

(Your partner better have the Ace of Diamonds to open 1NT or she lied about
having a stopper in Diamonds.)

Bidding 3NT when a hand has a long running suit is a bit of a gamble, but
being able to take 7 tricks "off the top" makes it a pretty good bet as long
as partner has the promised stopper.
//

[Erase]
[Bid,N]
1NT
Pass
3NT

[S]
A x x
K x
Q J T x
x x x x

With 10-13 points and a balanced hand like South's, you have a sure game in NT
and are unlikely to have slam (unless you have an unusual feature like a long
suit with all the high cards).

So with a hand like this, you can jump straight to 3NT.
//

[Erase]
[Bid,N]
1NT
Pass
3S
Pass
4S

[S]
K Q x x x
x x
A x x x
K x

With 10-13 points, an unbalanced hand and a major suit of 5+ cards, jump to 3
of the suit.

If partner really likes the suit, she may revalue her hand and try for slam.

Otherwise, she will raise to game in either the suit or notrump.
//

[Bid,N]
1NT
Pass
4NT
Pass
6NT

[N]
A K x
K J x x
A x x x
K x

[S]
Q J T x
A T x
K Q x
Q T x x

With 14-17 points and a balanced hand, bid 4NT. This is a point count bid that
tells your partner you have 14-17 points.

If partner is at the top of her NT bid, she will bid small slam (6NT).

If she isn't quite sure, she may bid 5NT, asking YOU to bid 6 if you are at
the top of your 14-17 points (if not, you should pass 5NT).

With a quantitative bid like this, if you have the minimum required to make
the bid, you should consider the quality of your hand.

For example, you do not get points for the three Tens in South's hand, but
they are valuable cards in this contract.
//

[Erase]
With 18+ points and a balanced hand, bid 5NT over 1NT.

This is a point count bid.

Partner will bid 7NT if she was at the top of her opening bid or 6NT
otherwise.

On the once-in-a-lifetime deal where partner opens 1NT and you have 22+
points, just bid 7NT.
//

If you have an unbalanced hand and 14+ total points, go for slam.

One way to do this would be to jump to 3 of your suit if it is a major. Then
if partner raises to 4, you could bid 5 of the suit.

This tells partner to bid 6 if she was at the top of her notrump opening or if
she REALLY likes your suit; otherwise, she should pass at 5.

If you have a minor suit, you could jump to 4. Your partner should be aware
that this is a slam try and bid game or slam according to how good her hand
is.
//

All of this may seem like a lot to remember, but it really isn't.

All you have to remember that it takes 16-18 points to open 1 NT, about 26
points to make game (a few more in the minors), 33 for a small slam, and 37
for a grand slam.

Then all you have to be able to do is

- count the points in your hand
- add your points to partner's 16-18
- bid according to how close you are to
       having the points for game or a slam.
- if your hand is unsuited for notrump and
       you have a major suit, bid it at a
       level indicated by your side's total points.
//

Stayman Response to NT:

[S]
J x x x
J T x x
x x x x
x

In Level 1, few conventions are covered, but Stayman is one of the most widely
used. The Stayman Convention is an attempt to find a 4-4 fit in the majors
after 1NT is bid.

Over an opening bid of 1NT, you bid 2C, asking partner to bid a 4-card major.

If opener does not have a 4-card major, he will bid 2D.

With two 4-card majors, partner will bid the lower one first. So a response of
2S denies a 4-card Heart suit. (Some partnerships reverse this. Ask to be
sure.)

A 2C bid requires 8+ points or a weak but distributional hand. With a hand
like South's, you bid 2C with the intention of passing ANY response by
partner, including the 2D negative bid. (This won't work with a singleton
Diamond, since you could not pass 2D.)
//

[Bid,S]
1NT
Pass
2C
Pass
2H
Pass
3H
Pass
4H

[N]
x
A x x x
K x x x
x x x x

[S]
A x x
K x x x
Q J T x
A Q

In the bidding sequence shown, North prefers to bid in a suit because of the
singleton Spade, so North bids 2C.

South bids 2H to show a 4-card Heart suit.

With 9 total points and partner's 16-18, there is a good shot at game.

A bold North might have jumped straight to 4H instead of just raising to 3.

A more cautious bid is to ask partner to bid 4H if he is at the top of his NT
opener.

South can now add a distribution point for the doubleton and raise to game.
//

[Bid,S]
1NT
Pass
2C
Pass
2D
Pass
2NT
Pass
Pass

[N]
x
A x x x
K x x x
x x x x

[S]
A x x
K x x
Q J T x
A Q x

In this sequence, South denies a 4-card major by responding 2D.

North has to sign off at 2NT, showing a minimum hand.

Since South is at a minimum too, he passes.
//

[Bid]
1NT
Pass
2C
Pass
2D
Pass
3S
Pass
???

[N]
A K x x x
A x x x
x x x
x

[S]
A x
K x x
Q J T x
A Q x x

North asks South for a 4-card major.

South denies one, but North can still try for a 5-3 fit in Spades, so North
bids 3S to show 5 Spades and 10+ points.

With less than 10 points, North would just bid 2S to show the 5-card suit. The
jump to the 3 level is forcing to game. (South must continue bidding until
game is reached.)

If South's Spade and Heart holdings were reversed, he would bid 4S, but with
only 2 cards in Spades, South bails out to 3NT.

If North had one more Spade and one less Diamond or Club, she would bid 4S
over 3NT.
//

[Erase]
[Bid]
2NT
Pass
3C
Pass
???

[S]
A K x x
K J x
A K x x
K Q

Q: South opens a 23-point hand with 2NT. Partner bids 3C. South's bid?

A: 3S.

Stayman works the same over 2NT and 3NT opening bids as it does over 1NT.
//

Responding to "2 Clubs Forcing" Opening Bid:

In response to the 2 Club opening, you cannot pass, not even with 0 points.

With less than 7 points, bid 2D. This is an artificial bid which says nothing
about your Diamonds. Partner will then bid her suit. Again, you cannot pass,
even with 0 points. You must bid again.

If partner then simply rebids her suit, you can pass.

With 7+ points, bid 2 of your suit or 2 NT if you have a balanced hand.

After making this "positive response", you cannot pass short of game, even if
partner simply rebids her suit as mentioned above.
//

[Bid,N]
2C
Pass
2D
Pass
3C
Pass
???

[S]
x x x x
x x x x
x x x
x x

Q: You have 0 points. What do you bid with South's cards?

A: 3H.

You cannot pass.

Partner has not rebid her suit yet because the opening 2C bid was artificial.

If North rebids 4C, you can pass.
//

[Erase]
[S]
A Q x x x x
x x
x x x x
x

Q: North opens 2C. What do you bid?

A: 2S. You have 9 total points and a good 6-card suit.
//

[S]
K x x
A x x
Q x x
x x x x

Q: North opens 2C. What do you bid?

A: 2NT. You have 9 HCP and a balanced hand.
//

Responding to Weak 2's:

Review:

Q: North opens 2S. How many points must she have?

A: 6-12.

Q: How many Spades must she have?

A: 6.

Q: How many Spade honors must she have?
   (1) any 2 honors.
   (2) 2 of the top 3, or 3 of the top 5.
   (3) the top 3.

A: 2.
//

[Bid,N]
2S
Pass
???

[S]
x x
A J x
A Q x x
K Q x x

With a strong hand like the one shown, you have a good chance of making game.

You can explore that possibility by bidding 2NT.

If North has a minimum hand (6-9 points), she will just rebid her suit and you
can pass.
//

[+]
[Bid,N]
2S
Pass
2NT
Pass
3D
Pass
3NT

If North has a better hand (10-12 points), she will bid some "feature" in her
hand over your 2NT response.

A feature is a holding that would be considered a potential "stopper" in a NT
bid (eg: A, Kx, QJx). Usually you are not as interested in partner having a
stopper as you are in knowing that she has another suit to be used for
transportation to her hand after her long suit has been established.

Since partner should not open a weak-2 with a two-suited hand, you are assured
that partner is not bidding a second suit when she bids her feature, so there
should be no chance for confusion with this bid.

If North bids 3D over your 2NT, showing a stopper in Diamonds, you can bid
3NT with the cards shown.
//

[Erase]
[Bid,N]
2S
Pass
3S

[S]
J x x x
x
K Q J x x
x x x

With a weak hand like South's opposite a 2S opener, you should raise to 3S.

The point is to try to rob the opponents of bidding space so that they have
to start their bidding on the 4 level.

Even if they get to game in 4H, there is a chance that they are missing a
slam.

You do not have to worry about North bidding again.

By partnership agreement, North cannot bid again over a simple raise of a
weak-2 opening.
//

Responding to Preemptive Bids:

Review: Partner opens 3S.

Q: How many points does he have? (1) Less than 10. (2) 11-15. (3) 16+.

A: 1. A preempt is normally made with a very weak hand.

Q: How many cards does he have in his suit?

A: 7+.

The only time you want to bid over partner's preemptive bid is if you have a
very strong hand or a very weak one.

[S]
x x
A Q x x
A K x
K Q J x x

With South's 19 points, raising partner's 3S preempt to 4S is not
unreasonable.
//

[S]
x x x x
Q
K Q J x x
x x x

With a very weak holding, you should "extend the preempt" by raising partner's
suit.

There is a very good chance that E-W have game and probably have slam.

By raising partner's 3S to 4S (or higher, if E-W are vulnerable and you are
not), you may steal the bid and at the very least, you rob the opponents of
bidding space.

Because communication is so important in arriving at the optimum contract,
anytime you can disrupt the opponent's communication, you reduce the odds that
they will find the optimum contract.
//

[Erase]
This is the end of the course on Responding to Opening Bids.

The next course in this series is on Rebids in Noncompetitive Bidding.

To continue to the next course, simply click on the right arrow (>>>>)
button.

//

[End]
