// MessageWindow - creates a window for displaying centred text.
// Jason Hood.
// 12 & 13 July, 1996.
// Tidied 1 August.

#ifndef _msgwin_h
#define _msgwin_h

#include <tws/window.h>
#include <tws/button.h>

class MessageWindow : public Window {

public:

  const int Margin = 15;                // The distance from the frame

  MessageWindow(const char* title = "") :
    Window(NULL, title, 0, 0, 0, 0,     // Will be resized to the correct values
           WA_SAVEAREA | WA_VISABLE | WA_CAPTION | WA_BORDER | WA_SYSBOX),
    // An empty window is the caption & system box plus all the margins
    width(FWIDTH*2+Margin*2 + StringWidth(title, SysFont) + SysBoxIcn->width),
    height(CAPTION_HEIGHT+FWIDTH+Margin*2),
    head(NULL), line(NULL)
  {}

  ~MessageWindow();

  void Write(char* text = "", int col = 0, FONT* font = SysFont);
  void Run();

protected:

  void PaintWindow(int x1, int y1, int x2, int y2);

  void cmSysBox() {                     // Use the system box to close it
    ws.StopRunningEvents();
  }

  DECLARE_RESPONSE_TABLE;

  int width, height;

  struct LineStatus {                   // Use a linked-list to store the lines
    char *text;                         // The pointer to the string, not a copy
    int col;
    FONT *font;
    LineStatus *next;
  } *head, *line;

};

#endif

