/*
  Program:      Mine Mayhem
  File:         mine.h
  Date:         July, 1996 to February, 1997

  Definitions for the main menu.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#ifndef _mine_h
#define _mine_h

#include <tws/menu.h>
#include <tws/static.h>
#include <tws/button.h>
#include <dos.h>

#define VERSION "1.00"

#define ID_SEPARATOR         -1

#define ID_GAME_BEGINNER     11
#define ID_GAME_INTERMEDIATE 12
#define ID_GAME_EXPERT       13
#define ID_GAME_CUSTOM       14
#define ID_GAME_RANDOM        1
  #define ID_GAME_RANDOM2     2
  #define ID_GAME_RANDOM3     3
  #define ID_GAME_RANDOM4     4
  #define ID_GAME_RANDOM5     5
  #define ID_GAME_RANDOM6     6
  #define ID_GAME_RANDOM7     7
  #define ID_GAME_RANDOM8     8
  #define ID_GAME_RANDOM9     9
  #define ID_GAME_RANDOM10   10
#define ID_GAME_EXIT         15

#define ID_OPTIONS_CONFIG    20
#define ID_OPTIONS_TIMES     21

#define ID_HELP_CONTENTS     30
#define ID_HELP_ABOUT        31


PopupMenuRes RandomMenuRes[] =
{
  { " &2", ID_GAME_RANDOM2,  0, 0 },
  { " &3", ID_GAME_RANDOM3,  0, 0 },
  { " &4", ID_GAME_RANDOM4,  0, 0 },
  { " &5", ID_GAME_RANDOM5,  0, 0 },
  { " &6", ID_GAME_RANDOM6,  0, 0 },
  { " &7", ID_GAME_RANDOM7,  0, 0 },
  { " &8", ID_GAME_RANDOM8,  0, 0 },
  { " &9", ID_GAME_RANDOM9,  0, 0 },
  { "1&0", ID_GAME_RANDOM10, 0, 0 }
};

#define NO_RANDOM_ITEMS 9


PopupMenuRes GameMenuRes[] =
{
  { "&Beginner",     ID_GAME_BEGINNER,     0, 0 },
  { "&Intermediate", ID_GAME_INTERMEDIATE, 0, 0 },
  { "&Expert",       ID_GAME_EXPERT,       0, 0 },
  { "&Custom",       ID_GAME_CUSTOM,       0, 0 },
  { "&Random",       ID_GAME_RANDOM,       NO_RANDOM_ITEMS, RandomMenuRes },
  { NULL,            ID_SEPARATOR,         0, 0 },
  { "E&xit",         ID_GAME_EXIT,         0, 0 }
};

#define NO_GAME_ITEMS   7


PopupMenuRes OptionsMenuRes[] =
{
  { "&Configuration", ID_OPTIONS_CONFIG, 0, 0 },
  { "&Times",         ID_OPTIONS_TIMES,  0, 0 }
};

#define NO_OPTIONS_ITEMS 2


PopupMenuRes HelpMenuRes[] =
{
  { "&Contents", ID_HELP_CONTENTS, 0, 0 },
  { NULL,        ID_SEPARATOR,     0, 0 },
  { "&About",    ID_HELP_ABOUT,    0, 0 },
};

#define NO_HELP_ITEMS   3


MenuRes MainMenuRes[] =
{
  { "&Game",    NO_GAME_ITEMS,    GameMenuRes    },
  { "&Options", NO_OPTIONS_ITEMS, OptionsMenuRes },
  { "&Help",    NO_HELP_ITEMS,    HelpMenuRes    },
};

#define NO_MAIN_ITEMS   3


class MainMenu : public AutoMenu
{
public:

  MainMenu(Window* parent, int x, int y, int w) :
    AutoMenu(parent, MainMenuRes, NO_MAIN_ITEMS, x, y, w) {}

protected:

  void cmGameNew(int level);
  void cmGameExit() { ws.StopRunningEvents(); }

  void cmOptionsConfig();
  void cmOptionsTimes();

  void cmHelpContents();
  void cmHelpAbout();

  DECLARE_RESPONSE_TABLE;
};


class MainMenuWindow : public Window
{
  friend class MainMenu;
public:

  MainMenuWindow();
  ~MainMenuWindow() { delete menu; delete tym; }

protected:

  void cmGame(BOOL UpdateOnly = FALSE);
  void cmAuto(BOOL UpdateOnly = FALSE);
  void Timer();                         // Display the current time

  DECLARE_RESPONSE_TABLE;

  MainMenu* menu;
  IconButton *GameButton, *AutoButton;
  StaticText* tym;
  struct time old_time;
};

#endif

