/*
  Program:      Mine Mayhem
  File:         mine.cc
  Date:         July, 1996 to February, 1997

  Initialise TWS, create the graphics, load the options and times, process the
  main menu. Save the options and times and destroy the graphics.

  Freeware, Copyright 1996-7 Jason Hood.

  You are free to use this code, or a portion thereof, as long as an
  appropriate acknowledgement is made.
*/

#include <tws/help.h>
#include "mine.h"
#include "board.h"
#include "options.h"
#include "times.h"
#include "msgwin.h"
#include "myconfig.h"
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include "menuicon.h"
#include "faces.h"
#include "digits.h"
#include "squares.h"


MainMenuWindow* Main;

BoardWindow* Board;

int Game, Start, Finish, ClearButton,
    MinGridX, MaxGridX, MinGridY, MaxGridY;

BOOL isMarks, isWrap, isAutoMark, isAutoOpen;

Layout Custom, Random;

Times times;

FONT *FixedFont, *SysFont1;
BYTE HighLightColour;

inline void MainMenu::cmGameNew(int level)
{
  Board->NewGame(level);
}

inline void MainMenu::cmOptionsConfig()
{
  OptionDlg().Run();
  Main->cmGame(TRUE); Main->cmAuto(TRUE);
}

inline void MainMenu::cmOptionsTimes()
{
  times.Display(Board->GetLevel());
}

void MainMenu::cmHelpContents()
{
  HelpDataBase* help = new HelpDataBase("mine.hlp");
  HelpWindow* temp = new HelpWindow(NULL, help, "Contents", 100, 100,
                               ws.GetDeskWidth()-100, ws.GetDeskHeight()-100);
  temp->Setup();
}

void MainMenu::cmHelpAbout()
{
  MessageWindow About("About");
  About.Write("Mine Mayhem", HighLightColour, SysFontBoldItallic);
  About.Write();
  About.Write("Jason Hood", 0, SysFontBold);
  About.Write();
  About.Write("Version "VERSION);
  About.Write("Copyright 1996-7");
  About.Run();
}

// Usually this would go before the functions, but for the functions to be
// inlined they must go first.
DEFINE_RESPONSE_TABLE(MainMenu, AutoMenu)
  if (ev->Type == W_COMMAND &&
      (ev->p1 >= ID_GAME_RANDOM2 && ev->p1 <= ID_GAME_CUSTOM))
  {
    cmGameNew(ev->p1);
    return TRUE;
  }
  E_COMMAND(ID_GAME_EXIT, cmGameExit)
  E_COMMAND(ID_OPTIONS_CONFIG, cmOptionsConfig)
  E_COMMAND(ID_OPTIONS_TIMES, cmOptionsTimes)
  E_COMMAND(ID_HELP_CONTENTS, cmHelpContents)
  E_COMMAND(ID_HELP_ABOUT, cmHelpAbout)
END_RESPONSE_TABLE


#define ID_GAME_BUTTON  40
#define ID_AUTO_BUTTON  41

DEFINE_RESPONSE_TABLE(MainMenuWindow, Window)
  E_BUTTONUP(ID_GAME_BUTTON, cmGame)
  E_BUTTONUP(ID_AUTO_BUTTON, cmAuto)
  E_TIMER
END_RESPONSE_TABLE

MainMenuWindow::MainMenuWindow() :
  Window(NULL, NULL, 0, 0, ws.GetDeskWidth()-1, SysFont->height+FWIDTH*2+4,
         WA_VISABLE | WA_BORDER)
{
  int hyt = SysFont->height+4, wid = hyt >? MENUICONW+4,
      ox = (ws.GetDeskWidth() - (wid*2+4))/2, oy = FWIDTH,
      icon = (Game == CROSS) ? MENUCROSS : (isWrap) ? MENUWRAP : MENUCLEAR;
  menu = new MainMenu(this, FWIDTH+2, FWIDTH+2, ox-6);
  GameButton = new IconButton(this, ID_GAME_BUTTON, ox, oy, ox+wid-1, oy+hyt-1,
                                    MenuIcon[icon]);
  ox += wid+4;
  icon = (isAutoMark == TRUE) + (isAutoOpen == TRUE)*2 + MENUNONE;
  AutoButton = new IconButton(this, ID_AUTO_BUTTON, ox, oy, ox+wid-1, oy+hyt-1,
                                    MenuIcon[icon]);
  gettime(&old_time);
  char buffer[6];
  sprintf(buffer, "%d:%02d", old_time.ti_hour, old_time.ti_min);
  wid = 7*SysFont->width;
  tym = new StaticText(this, buffer, w-FWIDTH-2-wid, FWIDTH+2, wid);
  Paint(); RefreshWindow();
  ws.StartTimer(this, 250);
}


// Use the game button to display the current game and to select a new one.
// Wrap-around is regarded as a game type. The order is then:
//   CLEAR (no wrap-around) -> CROSS -> CLEAR (wrap-around).
void MainMenuWindow::cmGame(BOOL UpdateOnly)
{
  if (Board->GameinProgress()) return;
  if (!UpdateOnly)
  {
   if (Game == CLEAR && !isWrap)
   {
     Game = CROSS; Board->AdjustGame();
   }
   else if (Game == CROSS)
   {
     Game = CLEAR; isWrap = TRUE;
     Board->AdjustWrap();
   }
   else // Game == CLEAR && isWrap
   {
     Game = CLEAR; isWrap = FALSE;
     Board->AdjustWrap();
   }
  }
  int icon = (Game == CROSS) ? MENUCROSS : (isWrap) ? MENUWRAP : MENUCLEAR;
  GameButton->ChangeIcon(MenuIcon[icon]);
  GameButton->Paint(); GameButton->RefreshWindow();
}


// Use the automatic button to display the automatic options and select a new
// one. The order is:
//   No Automatic -> AutoMark -> AutoOpen -> Both Automatics.
void MainMenuWindow::cmAuto(BOOL UpdateOnly)
{
  if (Board->GameinProgress()) return;
  if (!UpdateOnly)
  {
    if (!isAutoMark && !isAutoOpen) isAutoMark = TRUE;
    else if (isAutoMark && !isAutoOpen)
    {
      isAutoMark = FALSE; isAutoOpen = TRUE;
    }
    else if (!isAutoMark && isAutoOpen) isAutoMark = TRUE;
    else // isAutoMark && isAutoOpen
    {
      isAutoMark = isAutoOpen = FALSE;
    }
  }
  int icon = (isAutoMark == TRUE) + (isAutoOpen == TRUE)*2 + MENUNONE;
  AutoButton->ChangeIcon(MenuIcon[icon]);
  AutoButton->Paint(); AutoButton->RefreshWindow();
}


// Update and display the current time, ensuring it's displayed using the
// system font (since fixed font could be in use).
void MainMenuWindow::Timer()
{
  struct time new_time;
  gettime(&new_time);
  if (new_time.ti_min == old_time.ti_min) return;
  old_time = new_time;
  char buffer[6];
  sprintf(buffer, "%d:%02d", old_time.ti_hour, old_time.ti_min);
  if (SysFont == FixedFont) {
    SysFont = SysFont1;
    tym->SetText(buffer);
    SysFont = FixedFont;
  }
  else tym->SetText(buffer);
}


void InitGraphics();
void deInitGraphics();
int  InitOptions();
void SaveOptions();


int main()
{
  srandom(time(NULL));

  ws.Init("mine.cfg");
  SysFont1 = SysFont;
  char* fixedfont, fixed[256];
  fixedfont = ws.GetConfigItem("fixed_font");
  if (fixedfont != NULL)
  {
    strcpy(fixed, fixedfont);
    strcat(fixed, ".fnt");
    FixedFont = LoadFont(fixed);
    if (FixedFont == NULL) FixedFont = SysFont;
  }
  else FixedFont = SysFont;

  HighLightColour = (ws.GetConfigItem("highlight_colour") == NULL) ? 25 : //Blue
                     atoi(ws.GetConfigItem("highlight_colour"));

  InitGraphics();
  int startlevel = InitOptions();

  Main = new MainMenuWindow;

  Board = new BoardWindow(startlevel);

  ws.RunEvents();

  SaveOptions();
  delete Board;
  deInitGraphics();
  if (FixedFont != SysFont) DeleteFont(FixedFont);
  return 0;
}


// Read in the options, the current custom and random games, set the minimum
// and maximum grid sizes. Check that the custom and random games are in range.
// Load the times.
int InitOptions()
{
  MyConfigFile config("mine.ini");

  Game          = config.GetInt("Game",        CLEAR);
  Start         = config.GetInt("Start",       ONE_REPOS);
  Finish        = config.GetInt("Finish",      ALL_OPENED);
  ClearButton   = config.GetInt("ClearButton", CLRLEFT);
  isMarks       = config.GetInt("Marks",       FALSE);
  isWrap        = config.GetInt("Wraparound",  FALSE);
  isAutoMark    = config.GetInt("AutoMark",    FALSE);
  isAutoOpen    = config.GetInt("AutoOpen",    FALSE);

  Custom.width  = config.GetInt("Custom.Width");
  Custom.height = config.GetInt("Custom.Height");
  Custom.mines  = config.GetInt("Custom.Mines");

  Random.width  = config.GetInt("Random.Width");
  Random.height = config.GetInt("Random.Height");
  Random.mines  = config.GetInt("Random.Mines");

  MinGridX = MinGridY = 8;
  MaxGridX = (ws.GetDeskWidth() - (FWIDTH*2+4*2+2)) / SQUAREW;
  MaxGridY = (ws.GetDeskHeight() - (SysFont->height+FWIDTH*2+4+4) -
              (4+DIGITH+4+FACEICONH+5+5+FWIDTH*2)) / SQUAREH;

  Custom.width = MinGridX >? Custom.width <? MaxGridX;
  Custom.height = MinGridY >? Custom.height <? MaxGridY;
  int area = Custom.width * Custom.height;
  Custom.mines = (area/10 + (area%10 != 0)) >? Custom.mines <? area/2;

  Random.width = MinGridX >? Random.width <? MaxGridX;
  Random.height = MinGridY >? Random.height <? MaxGridY;
  area = Random.width * Random.height;
  Random.mines = (area/10 + (area%10 != 0)) >? Random.mines <? area/2;

  times.Load();

  return config.GetInt("Level", BEGINNER);
}


// Save the options, the current custom and random games, and the times.
void SaveOptions()
{
  MyConfigFile config("mine.ini");

  config.WriteInt("Level",         Board->GetLevel());
  config.WriteInt("Game",          Game);
  config.WriteInt("Start",         Start);
  config.WriteInt("Finish",        Finish);
  config.WriteInt("ClearButton",   ClearButton);

  config.WriteInt("Marks",         isMarks);
  config.WriteInt("Wraparound",    isWrap);
  config.WriteInt("AutoMark",      isAutoMark);
  config.WriteInt("AutoOpen",      isAutoOpen);

  config.WriteInt("Custom.Width",  Custom.width);
  config.WriteInt("Custom.Height", Custom.height);
  config.WriteInt("Custom.Mines",  Custom.mines);

  config.WriteInt("Random.Width",  Random.width);
  config.WriteInt("Random.Height", Random.height);
  config.WriteInt("Random.Mines",  Random.mines);

  times.Save();
}


// Create all the graphics.
void InitGraphics()
{
  const BYTE col[] = { 192,             //  0 - Grey
                       149,             //  1 - Dark grey
                       235,             //  2 - White
                       20,              //  3 - Black
                       230,             //  4 - Yellow
                       146,             //  5 - Dark yellow
                       128,             //  6 - Dark red
                       200,             //  7 - Red
                       25,              //  8 - Blue
                       38,              //  9 - Green
                       23,              // 10 - Dark blue
                       41               // 11 - Cyan
                     };
  int j;

  for (j = 0; j < MENUICONS; j++)
  {
    MenuIcon[j] = BuildBuffer(MenuIconBuffer[j], MENUICONW, MENUICONH, col);
  }
  for (j = 0; j < FACEICONS; j++)
  {
    FaceIcon[j] = BuildBuffer(FaceIconBuffer[j], FACEICONW, FACEICONH, col);
  }
  for (j = 0; j < DIGITS; j++)
  {
    Digit[j] = BuildBuffer(DigitBuffer[j], DIGITW, DIGITH, col);
    SmallDigit[j] = BuildBuffer(SmallDigitBuffer[j],
                                SMALLDIGITW, SMALLDIGITH, col);
  }
  for (j = 0; j < SQUARES; j++)
  {
    Square[j] = BuildBuffer(SquareBuffer[j], SQUAREW, SQUAREH, col);
  }
}


// Destroy all the graphics.
void deInitGraphics()
{
  int j;
  for (j = 0; j < SQUARES; j++) DeleteBuffer(Square[j]);
  for (j = 0; j < DIGITS; j++)
  {
    DeleteBuffer(SmallDigit[j]);
    DeleteBuffer(Digit[j]);
  }
  for (j = 0; j < FACEICONS; j++) DeleteBuffer(FaceIcon[j]);
  for (j = 0; j < MENUICONS; j++) DeleteBuffer(MenuIcon[j]);
}

