// tourn(ament).cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// selection routines for tournament selection........

// What is tournament selection ?
// Tournament selection randomly selects a number of genetic programs from the population.
// The fitness of each member of this group are compared with each other and the best
// replaces the worst.

// Why should I use tournament selection ?
//  This method is one which can be easily implemented using a parallel
// methodology and seems to result in a quicker solution in a search than the fitness
// proportionate method to be used by Koza. No idea why really it just seems to give better
// emperical results though some people ( Howard Oakley ?? ) find that with certain
// problems ( he studies chaotic data series of blood flow ) tournament selection actually
// gives worst results.  So be careful with the selection method you choose and check a
// few methods out before doing thousands of runs.



// include gpmain ( pop, gpv, gp and gene )
#include "gpmain.hpp"

// At the moment the tournaments are set at 5 which I believe is considered small
#define TournamentSize 5


// This function is used within generate.cc to get the parents and child for steady
// state reproduction. Note that each individual parent and child is selected from
// a DIFFERENT tournament, this may or may not be the implementation you want but is
// easily alterable.....
GP** Population::SelectParentsAndChild()
{
// set up array to put answer into....
	GP *pgpReturn[3];

// select the two parents using the select best method as coded below....
	pgpReturn[0] = SelectBest();
	pgpReturn[1] = SelectBest();

// select child which is the worst from a tournament....
	pgpReturn[2] = SelectWorst();

	return pgpReturn;
}

// Tournament Select: returns best gp from tournament of size specified....
GP* Population::SelectBest()
{
// Set up array to place tournament members into array.....................
	GP *pgpTournament[TournamentSize];
	GP *pgp;                  

// select members using random selection method............................
	for ( int i = 0; i < TournamentSize; i++ )
		pgpTournament[i] = Select();

// set up initial members for best members.......................
	pgp = pgpTournament[0];
		
// run through the whole tournament competing with each member to calculate
// the best of these members.....................................
	for ( i = 0; i < TournamentSize; i++ )
	{
// if tournament member is better than best so far, swap...
		if ( pgp->iFitness < pgpTournament[i]->iFitness )
			pgp = pgpTournament[i];
	}

// return gp selected............................
	return pgp;
}


// SelectWorst: returns worst gp from tournament of size specified....
GP* Population::SelectWorst()
{
// Set up array to place tournament members into array.....................
	GP *pgpTournament[TournamentSize];
	GP *pgp;                  

// select members using random selection method............................
	for ( int i = 0; i < TournamentSize; i++ )
		pgpTournament[i] = Select();

// set up initial members for member........................................
	pgp = pgpTournament[0];
		
// run through the whole tournament competing with each member to calculate
// the worst of these members...............................................
	for ( i = 0; i < TournamentSize; i++ )
	{
// if tournament member is worse than worst so farm swap....................
		if ( pgp->iFitness > pgpTournament[i]->iFitness )
			pgp = pgpTournament[i];
	}

// return gp selected.......................................................
	return pgp;
}


// tourn.cc
