// terminal.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Terminal Set system using C++ and all the ease of OOP programming
// By Adam Fraser 07 March 93 -> 24 April 1994

// The main block of code for using Terminal Set made up of to classes
//  Terminal and TS (TerminalSet) is all very simple I hope...........
// see documentation for more details.................................

// RECENT IMPROVEMENTS

// .. At long last the terminal set interpreter understands random real values
// which the user can set within a certain range by using the defined value
// of RandomReal.... hurrah !!

// converted to using unsigned int's rather than char's as GNU C 2.5.8 doesn't
// seem to like them very much and also will give me greater range if Terminal
// and terminal set increases over 256

// include the class definitions of Terminal and TS
#include "terminal.hpp"

// include the random number generator definition
#include "gprand.hpp"

// for variable list
#include <stdarg.h>

// for memory allocations
#include <stdlib.h>


// terminal set now allows random numbers to be generated this global variable
// is the range of numbers which is allowable within the mechanism and is given
// by the user in TS::TS( unsigned int, ... )
unsigned int NumberOfDifferentValues;


//  MAIN CODE...

unsigned int terminal( Terminal *pt )
{
	return pt->uiTerminal;
}
// The main block for Terminal Set creation reads in the number of Terminals
// and a variable list (va_list) of these Terminal values
//  for example...
//                                      Terminal Set = new TS( 3, 1,2,3,RandomReal,10 );
// NB all values first then a RandomReal term which is defined in terminal.hpp
// this allows a number of random numbers to be created.  The range of these
// values is given by the next value in the list.
TS::TS( unsigned int noofargs, ... )
{
	va_list ap;                               // ap =  variable list
	Terminal *pt;

// necessary for variable list to start it up.............................
	va_start( ap, noofargs );                      

// why would anyone send 0 to terminal set creation but if they do return.
	if ( noofargs == 0 ) return;                           

// allocate memory for the terminal set from the number of arguments......
	if ( !(ptHeader = (Terminal *)calloc( noofargs, sizeof( Terminal ) ) ) )
		ExitSystem( "TS::TS" );

// set length of terminal set used in other terminals and part of TS class
	uiLength = noofargs;

// set pointer to a terminal to the start before reading in values..........
	pt = ptHeader;

// allocate all the terminal values from variable list....................
	for ( int i = 0; i < noofargs; i++, pt++ )
	{
		pt->uiTerminal = va_arg( ap, unsigned int );

// if this terminal is random real value then we had better read in the range
// of these values next and place it in a global variable
		if ( pt->uiTerminal == RandomReal )
			NumberOfDifferentValues = va_arg( ap, unsigned int );
  }

// necessary to close variable list 
	va_end( ap );                            
}

// destructor for the Terminal set........................................
TS::~TS()
{
// if the terminal set exist and terminals within this set exist free memory
	if ( this )     if ( ptHeader ) free( ptHeader );
}

// Up to the programmer to make sure n is below total length of terminal set
Terminal* TS::Nth( unsigned int n )
{
// set a pointer to terminal to the start
	Terminal *pt= ptHeader;

// move through the Terminal set until n is reached.........................
	for ( unsigned int i = 1; i < n; i++, pt++ );

//.... then return the Terminal at this position............................
	return pt;
}

// This Terminal would probably have been better written with loads of temp
//  variables my software eng lecturer of yesteryear would not be happy...
// Basically this chooses a value from the Terminal set...
Terminal* TS::Choose()
{
// return a Nth member where N is a random number in the range 0 -> uiLength
	return ( Nth( ( gp_rand() %  uiLength ) + 1 ) );
}


// THIS NEXT SECTION OF CODE IS NOT USED WITHIN GPCPP BUT MAY BE HELPFUL
// IF YOU WISH TO IMPROVE THE CODE WITHIN THIS SECTION


// Print Terminals... using ostream
// Print out individual Terminal & arguments.....
ostream& operator << ( ostream& os, Terminal *pt )
{
	os << "Terminal : " << pt->uiTerminal << endl;
	return os;
}

// Prints out complete Terminal set not particulartly useful for GP
// but for debugging well it's the bees knees.....
ostream& operator << ( ostream& os, TS *pts )
{
// if a Terminal set exists.......
	if ( pts )
	{
// set up Terminal ptr to star and set up a length of Terminal set variable
		Terminal *pt = pts->ptHeader;
		unsigned int uil = pts->uiLength;

// move through the Terminal set printing out each Terminal in turn
		while ( uil-- ) os << pt++;
	}
	return os;
}

// a standard constructor for Terminal (not used within gpcpp)
Terminal::Terminal()
{
	uiTerminal = 0;
}

// a standard constructor for TerminalSet (not used within gpcpp)
TS::TS()
{
	ptHeader = NULL;
}

// terminal.cc










