// probable.cpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Selects the best and worst member using a probablistic fitness function in the population
// based loosely on John Holland's original roulette wheel though the code is a port of Jon Rush
// ga code for artificial nervous systems...

// For information see John Koza 'Genetic Programming' or
// David Goldberg 'Genetic Algorithms for Search and Optimisation'

// include gpmain ( pop, gpv, gp, gene )
#include "gpmain.hpp"
// for random number generator
#include "gprand.hpp"

// MAIN CODE

// BugBug 17 Oct 1993 APF
// before this is called Population::TotalFitness must be called <...?????

// Equivalent roulette wheel selection
GP** Population::SelectParentsAndChild()
{
	GP *pgpReturn[3];
	GP *pgp = pgpHeader;

	pgpReturn[0] = NULL;
	pgpReturn[1] = NULL;
	pgpReturn[2] = NULL;

// if total fitness is zero may as well use random selection as there is no bias
	if ( uliFitness == 0 )
	{
		pgpReturn[0] = Select();
		pgpReturn[1] = Select();
		pgpReturn[2] = Select();
	}
	else
	{
// select a random number between 0 -> TotalFitness of Population
		unsigned long randbestfitness1 = gp_rand() % uliFitness;
		unsigned long randbestfitness2 = gp_rand() % uliFitness;
// select a random number between 0-> MaximumSumFitness - TotalFitness of Population
		unsigned long randworstfitness = gp_rand() % ( MaximumSumFitness - uliFitness );
// set up all initial values
		unsigned int pop = PopulationSize;
		unsigned long bestsum = pgp->iFitness;
    unsigned long worstsum = MaximumFitness - pgp->iFitness;
	
// loop through whole population
		while ( pop-- )
		{
	pgp++;
// summate fitnesses of strings as we move through population
			bestsum += pgp->iFitness;
			worstsum += ( MaximumFitness - pgp->iFitness );

// if we have not selected member yet and we are greater thar randbestfitness1
			if ( (bestsum >= randbestfitness1) && !(pgpReturn[0]) ) pgpReturn[0] = pgp;

// if we have not selected member yet and we are greater thar randbestfitness2
			if ( (bestsum >= randbestfitness2) && !(pgpReturn[1]) ) pgpReturn[1] = pgp;

// if we have not selected member yet and we are greater thar randworstfitness
      if ( (worstsum >= randworstfitness) && !(pgpReturn[2]) ) pgpReturn[2] = pgp;
		}
	}

// check that we have selected GP
	if ( !(pgpReturn[0]) ) pgpReturn[0] = pgp;
	if ( !(pgpReturn[1]) ) pgpReturn[1] = pgp;
  if ( !(pgpReturn[2]) ) pgpReturn[2] = pgpHeader;

// return three member array..
  return pgpReturn;
}

