// loadsave.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


//       Loading and saving a genetic program with all the structure intact...
//       Designed By Adam Fraser March 93 for the genetic programming system...

// RECENT IMPROVEMENTS

// Automatically Defined Functions...

// include gp ( and gene therefore )
#include "gp.hpp"

// Save genetic program on stream os..
ostream& GP::Save( ostream& os )
{
// set starting point of
	Gene **ppg = ppgHeader;

// loop through adfs saving genetic trees as you go
	for ( int i = 0; i < RootandADF; i++, ppg++ )
		if ( *ppg )     (*ppg)->Save( os );

// save both the length and fitness of the genetic program
	os << endl << iLength << " " << iFitness << endl;

// return os even though we had a reference...
	return os;
}

ostream& Gene::Save( ostream& os )
{
// save the value of gene and then a space
	os << iValue << " ";

// if child output a 'c ' and then loop back to the top with child as gene
	if ( pgChild ) { os << "c "; pgChild->Save( os ); }
// else output 'o ' on stream..
	else           os << "o ";

// if next output a 'n ' and then loop back to the top with next as gene
	if ( pgNext )  { os << "n "; pgNext->Save( os ); }
// else output 'o ' on stream..
	else           os << "o ";

// return os even though we had a reference...
	return os;
}

// input genetic structure on stream is..
istream& GP::Load( istream& is )
{
	char ch;

// move to the part of the stream with a '#'
	while ( ch != '#' ) is >> ch;

// set up start of new Gene...
	Gene **ppg = ppgHeader;

// loop through adfs allocating new genes and loading genetic trees
	for ( int i = 0; i < RootandADF; i++, ppg++ )
	{
		if ( !(*ppg = new Gene) ) ExitSystem( "GP::Load" );

		(*ppg)->Load( is );
	}

// input both the fitness and the length of genetic program
	is >> iLength >> iFitness;

// return is even though we had a reference..
	return is;
}

istream& Gene::Load( istream& is )
{
	char ch;

// input value of gene
	is >> iValue;

	is >> ch;

// if we read in a 'c' = child create block and loop around for new child
	if ( ch == 'c' )
	{
		if ( !(pgChild = new Gene) ) ExitSystem( "Gene::Load" );
		pgChild->Load( is );
	}

	is >> ch;

// if we read in a 'n' = next create block and loop around for new next
	if ( ch == 'n' )
	{
		if ( !(pgNext = new Gene) ) ExitSystem( "Gene::Load" );
		pgNext->Load( is );
	}

// return is even though we had a reference..
	return is;
}


// loadsave.cc
