// gp.hpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Genetic Program class definitions   -> defined generally in gp.cpp


#ifndef __GP

#define __GP

// include all the genes def'ns
#include "gene.hpp"

// this global variables is the number of subtrees a genetic program has
// when dealing with adfs.  We generally have a root tree calling the adfs
// in some evolved order.  This value is set by the number of adfs defined
// by the user in 'gp.ini'
extern unsigned int RootandADF;  // defined in gpv.cpp

// these definitions are for the different types of creation method
// available to the genetic programming system and are set by the user
// using the gp.ini system.
// variable tree to maxdepth creation
#define VARIABLE        0
// all branches go to maxdepth creation
#define GROW            1
// half and half of the the two types shown below. This is the
// creation method of Koza...
#define RAMPEDHALF      2
// variable branches up to max depth ofcreation with this
// parameter being increased as we move through population
#define RAMPEDVARIABLE  3
// grow branches equal to max depth ofcreation with this
// parameter being increased as we move through population
#define RAMPEDGROW      4


//As Gene, GP is also struct with all the benefits and worries that bring..
struct GP
{
//Poiner to a pointer of genes which are the headers for each tree of the adfs
	Gene **ppgHeader;
// the fitness and length of a particular genetic program                                
	unsigned int iFitness;             // if fitness gets over 65535 oh dear
	unsigned int iLength;                                                    // If length gets over 65535 oh dear

// prints out genetic program because of adf's this must be coded by the user...
	friend ostream& operator << ( ostream& os, GP *gp );

	GP();
	GP( GP* );                                                                                                                      // new copy
	~GP();
	void Copy( GP* );                         // overwriting copy
// calculated the depth of a GP
	int Depth();
// calculate length of Gp both returning a value and setting uiLength
	int Length();

// creates a genetic program with specific depth and method of creation
	void Create( unsigned int, int );         // create.cpp

// crosses two GPs altering the implicit object
	void Cross( GP*, GP* , int = 17 );             // cross.cpp

// this function is not presently used but is there for the future
	void Mutate();

// compares two gp together
	unsigned int Compare( GP* );                       // compare.cpp

// evaluates a genetic program ( generally by calling evaluate fitness()
	void Evaluate( unsigned int );            // eval.cpp

// loads & saves the data structure of the gp to be reused
	ostream& Save( ostream& os );             // loadsave.cpp
	istream& Load( istream& is );
};


#endif
