// gp.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Version 0.40
// By Adam Fraser , 10 March 1993 ->21 February 1994

// Genetic Program definitions for Class system...

// Notes for the whole block ....

// RECENT IMPROVEMENTS

// Unfortunately because of ADF's the pointer  to the actual genes of a program
// is also a pointer itself. This does not lend itself to easily understandable code

// Again because of ADFs the GP print function has to be defined by the user and
// therefore has been moved into the evolving code section

// ADFs mean that GP::Choose and GP::Nth are unworkable and unnecessary as function
// which called them must know which adf was chosen so it was easier to use the
// functions in Gene class Gene::Choose() and Gene::Nth() see gene.cpp

// Finally we know have Automatically Defined Functions these have been implemented
// through currently a global variable:
//                                                              unsigned int RootandADF
// which is used continually through this code.....


// include gp def'ns note this also includes gene def'ns
#include "gp.hpp"
// for memory allocation functions
#include <stdlib.h>


// MAIN CODE...


// Class function definitions
GP::GP()
{
// allocate size of memory block for header to genes because of ADFs this is
// a variable size set by RootandADF
	if ( !(ppgHeader = (Gene **)calloc( RootandADF, sizeof(Gene*) ) ) )
		ExitSystem( "GP::GP" );
// set fitness and length to zero...
	iFitness = 0;
	iLength = 0;
}

// Destroys a GP would  be stupid to misuse   07/06/93
GP::~GP()
{
// if gp exists.....
	if ( this )
	{
// .... and a pointer to the gene headers exist .....
		if ( ppgHeader )
		{
			Gene **ppg = ppgHeader;

// .... delete each header gene in each adf if it exists and then ..... 
			for ( int i = 0; i < RootandADF; i++, ppg++ )   if ( *ppg )     delete *ppg;

// ... delete the whole block of pointers to gene headers
			free( ppgHeader );                    
		}
	}
}

// Copies a genetic program from one place to another with NO links to old
// gp...................     APF 09/06/93

// Also sets copy fitness to old fitness and length to old length
GP::GP(GP *pgp)
{
// set up the new GP to copy into
	if ( !(ppgHeader = (Gene **)calloc( RootandADF, sizeof(Gene*) ) ) )
		ExitSystem( "GP::GP" );

// set up the area to be copied and place to be copied into
	Gene **ppgCopy = pgp->ppgHeader, **ppg = ppgHeader;

// Move through all the genetic program to be copied adfs.....
	for ( int i = 0; i < RootandADF; i++, ppg++, ppgCopy++ )
	{
// .....making sure the area to be copied exists and....
		if ( *ppgCopy )
		{
// ....creating a new Gene and copy into this if it does....
			if ( !(*ppg = new Gene( *ppgCopy )) )   ExitSystem("GP::GP( GP* )");
		}
// and if they dont setting things to NULL
		else *ppg = NULL;
	}

// set up length and fitness to be like the other one
	iLength  = pgp->iLength;
	iFitness = pgp->iFitness;
}


// Copy GP leaving the GP header memory at the same location used in the
// reproduction operation...
// another way of explaining this is that is an overwrite copy
void GP::Copy( GP *pgp )
{
// set up the area to be copied and place to be copied into
	Gene **ppgCopy = pgp->ppgHeader, **ppg = ppgHeader;

// Move through all the genetic program to be copied adfs.....
	for ( int i = 0; i < RootandADF; i++, ppg++, ppgCopy++ )
	{
// ...deleting and genetic program trees already there and...
		if ( *ppg )     delete *ppg;
// .....making sure the area to be copied exists and....
		if ( *ppgCopy )
		{
// ....creating a new Gene and copy into this if it does...
			if ( !(*ppg = new Gene( *ppgCopy )) ) ExitSystem( "GP::Copy" );
		}
// and if they dont setting things to NULL
		else *ppg = NULL;
	}

// set up length and fitness to be like the copied one
	iFitness = pgp->iFitness;
	iLength  = pgp->iLength;
}


// Returns length of a genetic program     APF 08/06/93
// This is, of course, also the structural complexity of the system but length
// is so much shorter to type and reduces scientific linguistic complexity
int GP::Length()
{
// set length of string to zero
	unsigned int iLen = 0;

// if the gp exists......
	if ( this )
	{
// ...point to the block we want to work on.....
		Gene **ppg = ppgHeader;
// .... and move through each adf in turn calculating summated length
		for ( int i = 0; i < RootandADF; i++, ppg++ )
			if ( *ppg ) (*ppg)->Length( iLen );
	}

// place this in variable within object
	iLength = iLen;

// and also return this value just in case somebody wants it straight away
	return iLength;
}

//Returns maximum depth, useful for crossover and maybe elsewhere APF 10/06/93
int GP::Depth()
{
// set maximum depth to zero, so far 
	unsigned int iMaxDepthAll = 0;

// if the gp exists......
	if ( this )
	{
// ...point to the block we want to work on.....
		Gene **ppg = ppgHeader;
// .... and move through each adf in turn working out maximum depth for each adf..
		for ( int i = 0; i < RootandADF; i++, ppg++ )
    {
      unsigned int imaxdepth = 0;
			if ( *ppg )     (*ppg)->Depth( 0, imaxdepth );
// .. is this the maximum depth so far if it is keep it
			if (imaxdepth > iMaxDepthAll) iMaxDepthAll = imaxdepth;
		}
	}
	return iMaxDepthAll;
}

// gp.cc
