// generate.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Version 0.40 27 February 1994

// The generate function leads to this system being a Steady State GP and is the only
// seperation from Koza's 'Genetic Programming' so I shall elucidate to justify my case
// somewhat.  Koza uses a second population and reproduces and crossovers into this new
// population the next generation.  Unfortunately this program was initially written in
// DOS on a PC with a 640k memory barrier and I had to get two population fitted in this
// space..no way.  So instead I select good parents and a bad child and crossover into this.
//  This is a steady state GP as explained in Craig Reynolds work.....................
// The new GP is then evaluated and the loop continues and the new GP can be reselected
// IMMEDIATELY after ie there is no measure of age in the system.  I have not made careful
// studies of the population dynamics of such a system but hope it produces something which
// is similar (or even better !) than the two population method. The system works because I
// have run at least 10 different types of problems through it and got good results but, as
// usual, I cannot PROVE that it works.  Just so you would know.

// Because of demetic grouping and hopefully other such selecting operators I have decided
// to use default calling functions SelectBest() and SelectWorst() which  return a GP. 
// How you get those values I care not a jot....

// include gpmain ( and pop, gpv, gp and gene )
#include "gpmain.hpp"


// Generate is a fairly simple function
//   This is mainly because of improvements in the GP::Cross function....
void Population::Generate()
{
// loop for the number of crossovers necessary
	for ( unsigned int i = 0; i < PopulationSize; i++ )
	{
		GP *pgpMother, *pgpFather, *pgpChild;
		GP **pgpReturn;

// select parents and child from whatever selection mechanism you choose
// putting the result into a 3 member array.........................
		pgpReturn = SelectParentsAndChild();

// this code just transfers pointer into a different type of array while it is not
// particularly optimal code it does make things a little easier to understand...
		pgpMother = pgpReturn[0];
		pgpFather = pgpReturn[1];

// move return value into child to crossover parents into............................
		pgpChild = pgpReturn[2];

// note that this system would also allow a cross function of more than two parent
// this means that cross.cc needs to be rewritten but allows real addition to genetic
// programming mechanism. I have always found two sexes so constricting. 

// Mother is crossed with father and result placed in child. Max depth for crossover
// means strings don't become stupidly large....
		if ( (pgpChild != pgpMother ) && ( pgpChild != pgpFather ) )
		{
// take away old fitness of the child see the addition below for more details.....
			uliFitness -= pgpChild->iFitness;

// cross mum and dad into child............................
			pgpChild->Cross( pgpMother, pgpFather, MaximumDepthForCrossover );

// Evaluate this new string.............................................................
			pgpChild->Evaluate( NumberOfEvaluations );

// Necessary for probablistic fitness selection method can delete if you are definitely
// not going to use that type.  Adds new child fitness to the total fitness....
      uliFitness += pgpChild->iFitness;
		}
	}
}

//  generate.cc
