// gene.hpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------



// gene.hpp library defn's for genetic programming system
// most of the code is found in gene.cpp unless told otherwise

#ifndef __GENE

#define __GENE

#include <iostream.h>

// As nearly everything accesses Gene I have made this a struct leaving
// everything public while this is incredibly naughty in an OOP methodolgy
// it also means that something might work in the next five years.
// struct means all function are defined public rather class = private
struct Gene
{
// the value of gene, gpcpp deals only with numerical values 
	unsigned int iValue;      // if more than 65535 program blocks, change!!!
// pointers to child gene (if a function) and next gene (if part of a function arguments)
	Gene    *pgChild,
		*pgNext;

// print function of Gene 
	friend ostream& operator << ( ostream& , Gene* );

	Gene( unsigned int = 0 );                   // standard constructor
	Gene( Gene* );                                                  // new copy with no connection
	~Gene();
	void Copy( Gene* );                                             // overwriting copy;
	void Length( unsigned int& );               // length of a genetic program from this point
	int Depth( unsigned int, unsigned int& );   // return depth of gene from this point
	Gene* Nth( unsigned int& );                 // return a gene n points from this gene
	Gene* Choose();                             // choose a random member of a gene progrma
	
// each function belows creates a complete a genetic program from a gene 
	void CreateVariable( int );                     // create.cpp
	void CreateVariableChildren( int, int );
	void CreateGrow( int );
	void CreateGrowChildren( int, int );
  
// compare two genes together
	unsigned int Compare( Gene*, unsigned int );                                                                    // compare.cpp

// output and input of genes, this is the data structure not the english version
	ostream& Save( ostream& os );               // loadsave.cpp
	istream& Load( istream& is );
};

// a nice way of exiting when an error occurs...
extern void ExitSystem( char * );                   // defined in exit.cpp

// will be defined later...
class GP;

// these nextfour functions are the connection into the user's evolving code...

// evalutate the fitness of the genetic program over a number of evaluations
extern unsigned int EvaluateFitness( GP*, int );
// translates the numerical value of a gene into a string
extern ostream& (*TranslatePrint)( ostream&, Gene* );
// initialise the function and terminal set and any other global variables
extern void InitialiseGPS();
// cleans up at the end of a gp run
extern void CleanUpGPS();

#endif
