// function.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Function Set system using C++ and all the ease of OOP programming
// By Adam Fraser 07 March 93 -> 24 April 1994

// The main block of code for using Function Set made up of to classes
//  Function and FS (FunctionSet) is all very simple I hope...........
// see documentation for more details.................................

// RECENT IMPROVEMENTS

// converted to using unsigned int's rather than char's as GNU C 2.5.8 doesn't
// seem to like them very much and also will give me greater range if function
// and terminal set increases over 256

// include the class definitions of Function and FS
#include "function.hpp"
// definitions for random number generator
#include "gprand.hpp"
// definition for variable list system
#include <stdarg.h>
// for memory allocations  
#include <stdlib.h> 


//  MAIN CODE START

unsigned int function( Function* pf )
{
	return pf->uiFunction;
}

unsigned int arguments( Function *pf)
{
	return pf->uiArguments;
}

// The main block for Function Set creation reads in the number of functions
// and a variable list (va_list) of these function values and their arguments
//  for example...
//                                      Function Set = new FS( 3, 1,2,3, 2,2,3 );
// NB all values first and then their respective arguments !!!!! 
FS::FS( unsigned int noofargs, ... )
{
	va_list ap;                               // ap =  variable list
	Function *pf;

// necessary for variable list to start it up.............................
	va_start( ap, noofargs );                      

// why would anyone send 0 to function set creation but if they do return.
	if ( noofargs == 0 ) return;

// allocate memory for the function set from the number of arguments......
	if ( !(pfHeader = (Function *)calloc( noofargs, sizeof( Function ) ) ) )
		ExitSystem( "FS::FS" );

// set length of function set used in other functions and part of FS class
	uiLength = noofargs;

// set pointer to function to the start before reading in values..........
	pf = pfHeader;                           

// allocate all the function values from variable list....................
	for ( int i = 0; i < noofargs; i++, pf++ )
		pf->uiFunction = va_arg( ap, unsigned int );

// reset pointer to function back to start for args.......................
	pf = pfHeader;

// allocate all the function arguments from variable list.................
	for ( i = 0; i < noofargs; i++, pf++ )
		pf->uiArguments = va_arg( ap, unsigned int );    

 // necessary to close variable list 
	va_end( ap );                            
}

// destructor for the function set........................................
FS::~FS()
{
// if the function set exist and functions within this set exist free memory
	if ( this )     if ( pfHeader ) free( pfHeader );
}

// Up to the programmer to make sure n is below total length of function set
Function* FS::Nth( unsigned int n )
{
// set a pointer to function to the start
	Function *pf= pfHeader;

// move through the function set until n is reached.........................
	for ( unsigned int i = 1; i < n; i++, pf++ );

//.... then return the function at this position............................
	return pf;
}

// This function would probably have been better written with loads of temp
//  variables my software eng lecturer of yesteryear would not be happy...
// Basically this chooses a value from the Function set... APF 7/03/93
Function* FS::Choose()
{
// return a Nth member where N is a random number in the range 0 -> uiLength
	return ( Nth( ( gp_rand() %  uiLength ) + 1 ) );
}


// THIS NEXT SECTION OF CODE IS NOT USED WITHIN GPCPP BUT MAY BE HELPFUL
// IF YOU WISH TO IMPROVE THE COMPLETE CODE 


// Print functions... using ostream
// Print out individual function & arguments.....
ostream& operator << ( ostream& os, Function *pf )
{
	os << "Function : " << pf->uiFunction
		 << "Arguments: "       << pf->uiArguments << endl;
	return os;
}

// Prints out complete function set not particulartly useful for GP
// but for debugging well it's the bees knees.....
ostream& operator << ( ostream& os, FS *pfs )
{
// if a function set exists.......
	if ( pfs )
	{
// set up function ptr to star and set up a length of function set variable
		Function *pf = pfs->pfHeader;
		unsigned int uil = pfs->uiLength;

// move through the function set printing out each function in turn
		while ( uil-- ) os << pf++;
	}
	return os;
}

// a standard constructor for Function (not used within gpcpp)
Function::Function()
{
	uiFunction = 0;
	uiArguments = 0;
}

// a standard constructor for FunctionSet (not used within gpcpp)
FS::FS()
{
	pfHeader = NULL;
}

// function.cc


