// ant.cc -> My evolving code for Artificial Ant Problem

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Designed by Adam Fraser 17/06/93 

#include "gp.hpp"

#include "trail.hpp"
#include "ant.hpp"

// reset the ant
void ResetAnt( unsigned int );

// function code definitions
FITNESS IfFoodAhead( Gene* );
FITNESS Prog2( Gene* );
FITNESS Prog3( Gene* );

// Terminal code definitions
FITNESS TurnRight( void );
FITNESS TurnLeft( void );
FITNESS MoveForward( void );

// subordinate code
void MoveRight( void );
void MoveUp( void );
void MoveDown( void );
void MoveLeft( void );
int IsFoodHere( void );
int IsFoodAhead( void );
int IsFoodRight( void );
int IsFoodUp( void );
int IsFoodLeft( void );
int IsFoodDown( void );

//reset ant
void ResetAnt( unsigned int energy )
{
	glbAnt.x = 0;
	glbAnt.y = 0;
	glbAnt.Moving = 0;
	glbAnt.Energy = energy;
}

/* function code definitions */
FITNESS IfFoodAhead( Gene *pg )
{
// if thereis a food in the direction you are facing evaluate the first branch
	if ( IsFoodAhead() )    return Translate( pg );
// otherwise evolve the second branch.................
	else                    return Translate( pg->pgNext );
}

// Prog2 is a C/C++ port of the LISP function which summates branches and returns
// the results.  It is used to produce greater variety and ability in the genetic program
FITNESS Prog2( Gene *pg )
{
	FITNESS sum = 0;

	sum += Translate( pg );
	sum += Translate( pg->pgNext );

	return sum;
}

// Prog3 is a C/C++ port of the LISP function which summates branches and returns
// the results.  It is used to produce greater variety and ability in the genetic program
FITNESS Prog3( Gene *pg )
{
	FITNESS sum = 0;

	sum += Translate( pg );
	sum += Translate( pg->pgNext );
	sum += Translate( pg->pgNext->pgNext );

	return sum;
}


/* terminal code definitions */
// General note each terminal takes one energy point from the ant if used and also
// checks at the start to see if any energy is left...

// This is a function which operates only by side effects on the ant...............
FITNESS TurnRight( void )
{
// check to make sure there is energy left........................................
	if ( glbAnt.Energy == 0 ) return 0;

// Turnright this is equivalent to Moving - 1 and is used as what else happens if
//  we use Moving - 1 when Moving is 0..
	glbAnt.Moving = ( glbAnt.Moving + 3 ) % 4;

// decrease the energy of the ant...............................................
	glbAnt.Energy--;

// turning can not add to the fitness so return a 0....
	return 0;
}

// This is a function which operates only by side effects on the ant...............
int TurnLeft( void )
{
// check to make sure there is energy left........................................
	if ( glbAnt.Energy == 0 ) return 0;

// turn left by adding 1 to moving and keeping within constraint of 4
	glbAnt.Moving = ( glbAnt.Moving + 1 ) % 4;

// decrease the energy of the ant................................................
	glbAnt.Energy--;

// turning can not add to the fitness so return a 0..............................
	return 0;
}

int MoveForward( void )
{
// check to make sure there is energy left........................................
	if ( glbAnt.Energy == 0 ) return 0;

// which way is the ant moving ant move that way accordingly
	switch ( glbAnt.Moving )
	{
		case 0: MoveRight();
			break;
		case 1: MoveUp();
			break;
		case 2: MoveLeft();
			break;
		case 3: MoveDown();
			break;
	}

// decrease the energy of the ant...............................................
	glbAnt.Energy--;

// This also clears food out the way so it can't be eaten again
	return ( IsFoodHere() );
}

// moves ant right unless we have reached limit of the world where it does nothing
void MoveRight( void )
{
	if ( glbAnt.x < World_Horizontal )      glbAnt.x++;
}

// moves ant uunless we have reached limit of the world where it does nothing
void MoveUp( void )
{
	if ( glbAnt.y > 0)      glbAnt.y--;
}

// moves ant down unless we have reached limit of the world where it does nothing
void MoveDown( void )
{
	if ( glbAnt.y < World_Vertical) glbAnt.y++;
}

// moves ant left unless we have reached limit of the world where it does nothing
void MoveLeft( void )
{
	if ( glbAnt.x > 0) glbAnt.x--;
}

// checks for food within the system....
FITNESS IsFoodHere( void )
{
// is there food at the postion of the ant
	if ( World[glbAnt.x][glbAnt.y] == 1 )      // Note spaces will not be seen as they == 2 
	{
// if yes make ant eat the food and return a 1. The only way of getting a score
		World[glbAnt.x][glbAnt.y] = 0;           
		return 1;
	}
// else return a 0
	else    return 0;
}


int IsFoodAhead( void )
{
// which way is ant moving and check whether food is there...................
	switch (glbAnt.Moving)
	{
		case 0: return IsFoodRight();    /* is food right */
		case 1: return IsFoodUp();       /* is food up  */
		case 2: return IsFoodLeft();     /* is food left */
		case 3: return IsFoodDown();     /* is food down */
		default:return 0;
	}
}

// General Not for next four functions....
/* This code works because of a clever bit of C knowledge, C looks at the first
	 term in if statement if == false it then stops, therefore not causing
	 an error in the next statement...                      APF 13/06/93 */
int IsFoodRight( void )
{
	if ( ( glbAnt.x < World_Horizontal ) && ( World[glbAnt.x+1][glbAnt.y] == 1 ) ) return 1;
	else                                                      return 0;
}

int IsFoodUp( void )
{
	if ( ( glbAnt.y > 0 ) && ( World[glbAnt.x][glbAnt.y-1] == 1 ) ) return 1;
	else                                       return 0;
}

int IsFoodLeft( void )
{
	if ( ( glbAnt.x > 0 ) && ( World[glbAnt.x-1][glbAnt.y] == 1 ) ) return 1;
	else                                       return 0;
}

int IsFoodDown( void )
{
	if ( ( glbAnt.y < World_Vertical ) && ( World[glbAnt.x][glbAnt.y+1] == 1 ) ) return 1;
	else                                                    return 0;
}

// ant.cc
