// allelem(utation).cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------

// This block of code perform allele or swap mutation on a genetic program.  This comprised of
// code being swapped with other code with certain constraints.  Any terminal can be swapped
// with any other but functions can only be swapped with other functions with the same
// arguments.  This means that the mutation does not have to create new branches when different
// function types are swapped which seems implicitly wrong.. Adam Fraser 1994

#include "pop.hpp"
#include "function.hpp"
#include "terminal.hpp"
// for random number generators
#include "gprand.hpp"

void Population::Mutate( void )
{
// check that mutation has something to do.....
	if (NumberToMutate != 0 )
  {
// point to the first member of population
		GP *pgp = pgpHeader;
// pop = size of population
		unsigned int pop = PopulationSize;
// randomly work out position of first mutation
		unsigned int mutate = gp_rand() % NumberToMutate + 1;

// is first mutation within population if it is go for it...
		while ( mutate < pop )
		{
// mutate genetic program using whatever method you like
			(pgp + mutate)->Mutate();
// evaluate this new genetic program....
			(pgp + mutate)->Evaluate( NumberOfEvaluations );
// move the mutation to a new position and go around loop once again...
			mutate += gp_rand() % NumberToMutate + 1;
		}
	}
}       


// Swap or allele mutation
void GP::Mutate()
{
// point to a particular adf genetic tree
	unsigned int randtree = gp_rand() % RootandADF;
	Gene *pgGeneTree = *(ppgHeader + randtree);

	Gene *pg = pgGeneTree->Choose();

// if selected gene has a child branch then we must search through function set
	if ( pg->pgChild )
	{
// first of of all we have to work out how many arguments this function has
// there are two ways of doings this we can use parse tree and search for next members
// until we have none left and count this way.  Or we can genes iValue to search through
// the correct function set. I have used parse tree method.....

// set function set to the correct block
		FS *FunctionSet = FunctionSets[randtree];

// set up some variable args = 1 because to be a function it already has to have a chikld
// bNotFound is a boolean function to show we have found a function which is correct
		int args = 1, count = 0, bNotFound = 1;
// set gene to start of child
		Gene *pgTemp = pg->pgChild;

// move through arguments adding one to arg variable each time. This therefore
// counts the number of arguments a gene has....
		while ( pgTemp->pgNext ) { args++, pgTemp = pgTemp->pgNext; }

// this loop around either 10 times or until we find a function which can be swapped 
		while ( ( count++ < 10 ) && (bNotFound) )
		{
// choose a function at random from function set.....
			Function *pf = FunctionSet->Choose();

// check that the arguments match the arguments of function
			if ( arguments( pf ) == args )
			{
// check that it has a different value little point otherwise
				if ( function( pf ) != pg->iValue )
				{
// swap values and set boolean variable flag to show we have found function
					pg->iValue = function( pf );
					bNotFound = 0;
	}
			}
    }
	}
	else
	{
// set up correct terminal set for this problem........
		TS *TerminalSet = TerminalSets[randtree];

// choose a member from the terminal set with no worry about arguments
		pg->iValue = terminal( TerminalSet->Choose() );

// if the value you have chosen is RandomReal make iValue = random value in the range
// of 0 -> NumberOfDifferentValues set by user  these numbers go above 32768......
		if (pg->iValue == RandomReal ) pg->iValue = gp_rand() % NumberOfDifferentValues + 32768;
	}
}

// allelem.cc
