// select.cpp
// All the code for selections of a gp

// 20 October 1993 apf

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/

#include "gpmain.hpp"

#include <stdlib.h>    // rand()

#define TournamentSize 5

// Select a random member of the family....................................


GP* Population::Select()
{
	int randgp = rand() % PopulationSize;
	GP *pgp = this;

	for ( int i = 0; ( ( i < randgp ) && ( pgp->pgpNext ) ); i++ )
		pgp = pgp->pgpNext;

	return pgp;
}


//Returns the best of the generation for this family. The actual best not
//   a value of some weird probability............       APF 16/06/93

// Also this function searches for the shortest best GP rather than just
// stopping at the first value it founds....

GP* Population::Best()
{
	GP *pgp = this, *pgpBest = NULL;
	int iBest = -1;

// taken out error found by someone of allocating to a ptr not yet created
// a really stupid embarassing mistake really...........

	while ( pgp )
	{
		if ( pgp->iFitness >= iBest )
		{
// this next component searches for shorter gps (my form of editing..APF )

			if ( pgp->iFitness == iBest )
			{
				if ( pgp->iLength < pgpBest->iLength )
					pgpBest = pgp;
			}
			else
			{
				pgpBest = pgp;
				iBest = pgp->iFitness;
			}
		}
		pgp = pgp->pgpNext;
	}

	return pgpBest;
}


// Returns actual worst value in the pot. You will probably find that you
// have a lot of gps with a zero value so it chooses the first of these.

GP* Population::Worst()
{
	GP *pgp = this, *pgpWorst = NULL;
	int iWorst = MaximumFitness;

	while ( pgp )
	{
		if ( pgp->iFitness < iWorst )
		{
			pgpWorst = pgp;

			iWorst = pgp->iFitness;
		}
		pgp = pgp->pgpNext;
	}
	return pgpWorst;
}


// Selects the best member (probably) in the GP family......................

// BugBug 17 Oct 1993 APF
// before this is called Population::TotalFitness must be called <...?????

GP* Population::ProbableBest()
{
	if ( uliFitness == 0 ) return Select();
	else
	{
		unsigned long randfitness = rand() % uliFitness;
		unsigned long sum = 0;
		GP *pgp = this;

		while ( pgp )
		{
			sum += pgp->iFitness;
			if ( sum >= randfitness ) return pgp;
			pgp = pgp->pgpNext;
		}
		return this;   				  // default is first gp
	}
}

// Selects the worst member ( probably ) in the GP family...................
// before this is called Population::TotalFitness must be called <...?????

GP* Population::ProbableWorst()
{
	if ( uliFitness == 0 ) return Select();
	else
	{
		unsigned long randfitness = rand() % ( MaximumSumFitness - uliFitness );
		unsigned long sum = 0;
		GP *pgp = this;

		while ( pgp )
		{
			sum += ( MaximumFitness - pgp->iFitness );
			if ( sum >= randfitness ) return pgp;
			pgp = pgp->pgpNext;
		}
		return this;             // default is first gp
	}
}


// Tournament Select: returns a two member array of best and worst from a
//                    tournament of size specified...

GP** Population::TournamentSelect()
{
	GP *pgpTournament[TournamentSize];
	GP *pgpOutput[2];                  // Output[0] = best, Output[1] = worst

	for ( int i = 0; i < TournamentSize; i++ )
		pgpTournament[i] = Select();

	pgpOutput[0] = pgpTournament[0];
	pgpOutput[1] = pgpTournament[0];


	for ( i = 0; i < TournamentSize; i++ )
	{
		if ( pgpOutput[0]->iFitness < pgpTournament[i]->iFitness )
			pgpOutput[0] = pgpTournament[i];
		if ( pgpOutput[1]->iFitness > pgpTournament[i]->iFitness )
			pgpOutput[1] = pgpTournament[i];
	}

	return pgpOutput;
}

// select.cpp