// pop.cpp
//			By Adam Fraser 16/11/93

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/



#include "gpmain.hpp"

#include <time.h>

ostream& operator << ( ostream& os, Population *ppop )
{
	os << "Genetic Programming System in C++" << endl << endl;

  os << (GPVariables *)ppop << endl;

	time_t rTime;

	time( &rTime );

	os << "Date & Time Stamp: " << ctime(&rTime) << endl;

	return os;
}


// Creation of the population................................................

// BugBug 15/11/93will always make one variable ( this is a problem with the
// structure I have used, I can live with it...)

// BugBug 16/11/93 possible infinite loop which cannot be gauged in this function
//    the population is compared with every other member so pure diversity can
//    be used BUT when using small depths the number of possible permutations
//    drops severely. If using a small function and terminal set this could
//    cause a loop. It is worth noting though is not a problem until the
//    population you are trying to create becomes v.v. large...

Population::Population( int pop, int gen ) : GP(), GPVariables( pop, gen )
{
	GP *pgp = this;

	pgp->Create( VARIABLE, MaximumDepthForCreation );

  for ( int j = 2; j <= MaximumDepthForCreation; j++ )
  {
    int numbertocreate = PopulationSize / ( MaximumDepthForCreation - 1 );

    if ( j == 2 ) numbertocreate--;      // as we have already created one

	  for ( int i = 0; i < numbertocreate; i++ )
	  {
		  do
		  {
			  if ( pgp->pgpNext ) delete pgp->pgpNext;
			  if ( !(pgp->pgpNext = new GP ) ) ExitSystem( "Population::Create" );

			  switch (CreationType)
			  {
					case RAMPEDHALF     :     // if odd create ramped grow else
						if ( i % 2 ) pgp->pgpNext->Create( GROW, j );
						else         pgp->pgpNext->Create( VARIABLE, j );
						break;
					case RAMPEDVARIABLE :
						pgp->pgpNext->Create( VARIABLE, j );
						break;
          case RAMPEDGROW     :
            pgp->pgpNext->Create( GROW, j );
            break;
				  default     :
					  pgp->pgpNext->Create( CreationType, MaximumDepthForCreation );
					  break;
			  }
		  } while ( Compare( pgpNext ) );
		  pgp = pgp->pgpNext;
    }
	}
	pgp->pgpNext = NULL;
}

// Kills the GP Family......................................................

Population::~Population()
{
	GP *pgpOld = this->pgpNext, *pgp = this;

	while ( pgp )  // note other code had better work wonderfully
	{
		pgp = pgpOld->pgpNext;

		delete pgpOld;

		pgpOld = pgp;
	}
}

// Returns the total summated fitness of GP family..........................

unsigned long Population::TotalFitness()
{
	GP *pgp = this;
	unsigned long sum = 0;

	while ( pgp )
	{
		sum += pgp->iFitness;
		pgp = pgp->pgpNext;
	}

	uliFitness = sum;
	return sum;
}

// Returns the total summated stuctural complexity of GP family..........................

unsigned long Population::TotalLength()
{
	GP *pgp = this;
	unsigned long sum = 0;

	while ( pgp )
	{
		sum += pgp->iLength;
		pgp = pgp->pgpNext;
	}

	uliLength = sum;
	return sum;
}


// if you wish to use the depth function is some way you will have to place
// a new component in the GP class defn called iDepth....
/*
unsigned long Population::TotalDepth()
{
	GP *pgp = this;
	unsigned long sum = 0;

	while ( pgp != NULL )
	{
		sum += pgp->iDepth;
		pgp = pgp->pgpNext;
	}

	uliDepth = sum;
	return sum;
}
*/