// gpv(ariables).cpp    15/11/93  apf

// a nice simple structure to contain all the genetic programming variables
// this is inherited into the population class....

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/




#include "gpv.hpp"

ostream& operator << ( ostream& os, GPVariables *pgpv )
{
	os << "Population Size           : " << pgpv->PopulationSize << endl;
	os << "Number Of Generations     : " << pgpv->NumberOfGenerations << endl;
  os << "Creation Type             : ";
  switch( pgpv->CreationType )
  {
		case VARIABLE :
		  os << "Variable";
      break;
    case GROW :
		  os << "Grow";
      break;
    case RAMPEDHALF :
		  os << "Ramped Half and Half";
      break;
    case RAMPEDVARIABLE :
      os << "Ramped Variable";
      break;
    case RAMPEDGROW :
      os << "Ramped Grow";
      break;
    default       :
		  os << "Error...";
  }
	os << endl;
	os << "Number Of Evaluations     : " << pgpv->NumberOfEvaluations << endl;
	os << "Maximum Depth at creation : " << pgpv->MaximumDepthForCreation << endl;
	os << "Maximum Depth at Crossover: " << pgpv->MaximumDepthForCrossover << endl;
  os << "Maximum Fitness           : " << pgpv->MaximumFitness << endl;
  os << "Maximum Sum Fitness       : " << pgpv->MaximumSumFitness << endl;
	os << "Number To Crossover       : " << pgpv->NumberToCrossover << endl;
	os << "Number To Reproduce       : " << pgpv->NumberToReproduce << endl << endl;

	return os;
}

GPVariables::GPVariables( int pop, int gen )
{
	PopulationSize = pop;
	NumberOfGenerations = gen;

  ifstream ifs( "gp.ini" );

  if ( ifs ) Load( ifs );
  else                           // use defualts.....
  {
  	CreationType = VARIABLE;
   	NumberOfEvaluations = 500;

	  MaximumFitness = 144;
	  MaximumDepthForCreation = 6;
	  MaximumDepthForCrossover = 17;

    ofstream ofs( "gp.ini" );    // save defaults
    Save( ofs );
    ofs.close();
  }

  NumberToCrossover = ( 9 * PopulationSize ) / 10;
	NumberToReproduce = PopulationSize / 10;
	MaximumSumFitness = PopulationSize * MaximumFitness;

	cout << this;
}

void GPVariables::Save( ostream& os )
{
  os << "CreationType  : " << CreationType << endl;
  os << "Evaluations   : " << NumberOfEvaluations << endl;
  os << "MaxFitness    : " << MaximumFitness << endl;
  os << "MaxCreation   : " << MaximumDepthForCreation << endl;
  os << "MaxCrossover  : " << MaximumDepthForCrossover << endl;
}

void GPVariables::Load( istream &is )
{
  char ch = '0';

  while ( ch != ':' ) is >> ch;  is >> (int)CreationType;
  is >> ch;
  while ( ch != ':' ) is >> ch;  is >> NumberOfEvaluations;
  is >> ch;
  while ( ch != ':' ) is >> ch;  is >> MaximumFitness;
  is >> ch;
  while ( ch != ':' ) is >> ch;  is >> MaximumDepthForCreation;
  is >> ch;
  while ( ch != ':' ) is >> ch;  is >> MaximumDepthForCrossover;
}
