// gp.hpp

#ifndef __GP

#define __GP

#include "gene.hpp"

enum CREATIONTYPE { VARIABLE, GROW, RAMPEDHALF, RAMPEDVARIABLE, RAMPEDGROW };

// Genetic Program class definitions   -> defined in gp.cpp

struct GP
{
	Gene *pgHeader;
	int iFitness;                      // if fitness gets over 65535 oh dear
	int iLength;											 // If length gets over 65535 oh dear
	GP *pgpNext;
	friend ostream& operator << ( ostream& os, GP *gp );

public:

	GP();
	GP( GP* );  															// new copy
	~GP();
	void Copy( GP* );                         // overwriting copy
	void Create( CREATIONTYPE, int );         // create.cpp
	int Length();
	void Cross( GP* , int = 17 );
	Gene* Nth( int );
	Gene* Choose();
	int Depth();
	int Compare( GP* );
	void Evaluate( int );                              // defined in eval2.cpp
	ostream& Save( ostream& os );
	istream& Load( istream& is );
};


#endif