// function.hpp
// Function Set Class definitions  --> defined in funcset.cpp

#ifndef __FUNCTION

#define __FUNCTION

#include <stdarg.h>
#include <stdlib.h>     // for rand
#include <iostream.h>


class Function
{
	int iFunction;
	int iArguments;
	Function *pfNext;
	friend class FS;               // FS needs to access private bits, honest!
	friend ostream& operator << ( ostream&, Function* );
	friend ostream& operator << ( ostream&, FS*  );
	friend int function( Function *pf ) { return pf->iFunction; };
	friend int arguments( Function *pf ) { return pf->iArguments; }

public:

	Function();
};

class FS
{
	Function *pfHeader;						 // header to Function Set
	friend ostream& operator << ( ostream&, FS* );

public:
	FS();
	FS( int noofargs, ... );			 // Function values then arguments
	~FS();
	int Length();
	Function *Nth( int n );
	Function *Choose();

};

extern FS *FunctionSet;

extern void ExitSystem( char* );
#endif
