# set your file directories here, must do this before running app
# be sure to use forward slashes (/) instead of back slashes in your paths

# path of tkbsp binary
set exepath "c:/progra~1/games/unreal/maps/quake/tkbsp.exe"
# path of output storage; don't delete this line
set output "c:/progra~1/games/unreal/maps/quake/output.txt"
# path of your default .bsp directory
set bspdir "c:/progra~1/games/unreal/maps/quake/"

#############################################################################
# Visual Tcl v1.20 Project
#

#################################
# GLOBAL VARIABLES
#
global che28; 
global che29; 
global che32; 
global che33; 
global che34; 
global scalefac; 
global widget; 
global exepath;
global output;
global bspdir;
global file;
global cmdline;
global modelnum;
set scalenum "1"
set scalefac ""
set cmdline ""
set modelnum "0"
#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {

}

init $argc $argv


proc {main} {argc argv} {

}

proc {Window} {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 804 585
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "vt"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel \
        -background #c0c0c0 -cursor xterm 
    wm focusmodel $base passive
    wm geometry $base 488x405+141+47
    wm maxsize $base 804 585
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Bsp2t3d frontend"
    label $base.lab21 \
        -background #c0c0c0 -borderwidth 1 -justify left -text {Output log:} 
    label $base.lab23 \
        -background #c0c0c0 -borderwidth 1 -relief raised \
        -text {Current BSP file:} 
    button $base.but25 \
        -text {Select file} -command selectopen
    button $base.but26 \
        -text {Convert all} -command convertall
    button $base.but27 \
        -text {Convert one} -command convertone
    checkbutton $base.che28 \
        -background #c0c0c0 -text {Flip model horizontally} -variable che28 \
	-onvalue " -f" -offvalue "" 
    checkbutton $base.che29 \
        -background #c0c0c0 -text {Scale model by factor:} -variable che29 \
	-onvalue "" -offvalue "" 
    checkbutton $base.che32 \
        -background #c0c0c0 -text {Turn faces inside out} -variable che32 \
	-onvalue " -i" -offvalue ""
    checkbutton $base.che33 \
        -background #c0c0c0 -text {Include water surfaces} -variable che33 \
	-onvalue " -w" -offvalue ""
    checkbutton $base.che34 \
        -background #c0c0c0 -text {Include texture coords.} -variable che34 \
	-onvalue " -t" -offvalue ""
    entry $base.ent35 \
        -textvariable scalenum 
    button $base.but38 \
        -text Exit -command exitapp
    canvas $base.can40 \
        -background #ffffff -borderwidth 2 -height 132 -relief ridge \
        -width 377 
    $base.can40 create text 105 10 -text "Quake bsp to Unreal brush converter 1.01"
    $base.can40 create text 103 30 -text "Converter by Pointdexter, GUI by Bren86 "
    text $base.tex17
    label $base.lab17 \
        -borderwidth 1 -relief raised -text "current filename"
    entry $base.ent18 -textvariable modelnum

	wm protocol .top17 WM_DELETE_WINDOW {exitapp}
	bind .top17 <Control-q>  { exitapp }
	bind .top17 <Alt-F4> { exitapp }
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.lab21 \
        -x 10 -y 45 -width 61 -height 17 -anchor nw -bordermode ignore 
    place $base.lab23 \
        -x 90 -y 15 -width 81 -height 17 -anchor nw -bordermode ignore 
    place $base.but25 \
        -x 15 -y 10 -anchor nw -bordermode ignore 
    place $base.but26 \
        -x 20 -y 210 -anchor nw -bordermode ignore 
    place $base.but27 \
        -x 105 -y 210 -anchor nw -bordermode ignore 
    place $base.che28 \
        -x 10 -y 255 -anchor nw -bordermode ignore 
    place $base.che29 \
        -x 10 -y 280 -anchor nw -bordermode ignore 
    place $base.che32 \
        -x 9 -y 305 -width 135 -height 27 -anchor nw -bordermode ignore 
    place $base.che33 \
        -x 200 -y 255 -width 135 -height 27 -anchor nw -bordermode ignore 
    place $base.che34 \
        -x 200 -y 280 -width 135 -height 27 -anchor nw -bordermode ignore 
    place $base.ent35 \
        -x 150 -y 285 -width 31 -height 19 -anchor nw -bordermode ignore 
    place $base.but38 \
        -x 270 -y 210 -width 60 -height 38 -anchor nw -bordermode ignore 
    place $base.can40 \
        -x 15 -y 340 -width 385 -height 52 -anchor nw -bordermode ignore 
    place $base.tex17 \
        -x 15 -y 65 -width 456 -height 133 -anchor nw -bordermode ignore 
    place $base.lab17 \
        -x 90 -y 30 -width 381 -height 17 -anchor nw -bordermode ignore 
    place $base.ent18 \
        -x 185 -y 215 -width 31 -height 19 -anchor nw -bordermode ignore 
}

Window show .
Window show .top17

main $argc $argv

#############################################################################
# Functionality code


proc selectopen {} {
global exepath;
global output;
global bspdir;
global file;
set types {
	{{"Quake 1 BSP"} {.bsp}}
}
set file [tk_getOpenFile -filetypes $types -parent . -initialdir $bspdir]
if [string compare $file ""] {
	set filename $file
	.top17.lab17 configure -text $filename
	#no longer check if file exists file this is built in tk
	.top17.tex17 delete 0.0 end
	exec -keepnewline $exepath -l $file >$output
	set newnamefile [open $output r]
	while {![eof $newnamefile]} {		
		.top17.tex17 insert end [read $newnamefile 1000]	
	}
	close $newnamefile
}  
}


proc convertall {} {
	global file output exepath cmdline scalenum scalefac;
	set filename $file
	.top17.lab17 configure -text $filename
	#no longer check if file exists file this is built in tk
	.top17.tex17 delete 0.0 end
	exec -keepnewline $exepath -a$scalefac$cmdline $file >$output
	set newnamefile [open $output r]
	while {![eof $newnamefile]} {		
		.top17.tex17 insert end [read $newnamefile 1000]	
	}
	close $newnamefile
}

proc convertone {} {
	global file output exepath cmdline scalenum scalefac modelnum;
	set filename $file
	update
	.top17.lab17 configure -text $filename
	#no longer check if file exists file this is built in tk
	.top17.tex17 delete 0.0 end
	exec -keepnewline $exepath -e $modelnum$scalefac$cmdline $file >$output
	set newnamefile [open $output r]
	while {![eof $newnamefile]} {		
		.top17.tex17 insert end [read $newnamefile 1000]	
	}
	close $newnamefile
}

proc exitapp {} {
	destroy .top17
	destroy .
	exit
}

# update processing of the command line DON'T CHANGE
set standard 1
while {$standard == 1} {
	set cmdline "$che28$scalefac$che32$che33$che34"
	update
	set scalefac " -s $scalenum"
	update
	set scalenum "$scalenum"
	update
	set modelnum "$modelnum"
}
