/*##########################################################################
#   PROGRAM:      Unreal DLL-Maker Macro File
#   AUTHOR:       Chris Prince (aka Vulcoris) - cprince@u.washington.edu
#   DATE:         October, 1998
#   DESCRIPTION:  Useful macros for creating Unreal DLLs.
#   NOTE(S):      None.
##########################################################################*/

#ifndef __UNR_MACRO_H__
#define __UNR_MACRO_H__



//==================== Types =====================
typedef unsigned char       BYTE;

// (partial) Definition of the "FFrame" structure
struct FFrame
{
    void* unknown1;
    void* unknown2;
    BYTE* pJumpTable;  // <?> jump table used for parameters <?>
                       /// Have to increment this ptr before each
                       /// PARAMS_GET_xxx , and once when done
                       /// (PARAMS_FINISHED).
};


//==================== Macros ====================


// THINGS USED FOR EXPORTING PACKAGE, CLASS, AND FUNCTION IDENTIFIERS:

// generic dll-export macro
#define EXPORT  __declspec( dllexport )

// macro for exporting an *unmangled/undecorated* name
#define UNDEC_EXPORT(TheStuff)     extern "C" { EXPORT  TheStuff }


// macro for exporting package name
#define IMPLEMENT_PACKAGE(szPkg)   UNDEC_EXPORT( char GPackage[8] = "szPkg"; )

// macro for exporting a class
#define EXPORT_CLASS(TheClass)	   UNDEC_EXPORT( int autoclass##TheClass ; )
// macro for exporting a class member function
#define EXPORT_FUNC(TheClass,TheFunc)                                   \
    UNDEC_EXPORT(                                                       \
        void (##TheClass##::*int##TheClass##TheFunc##)(FFrame&, BYTE*&) \
        = &##TheClass##::TheFunc##;                                     \
    )



// THINGS USED FOR HANDLING PARAMETER PASSING:

// Macro used for getting input parameters out of a FFrame
#define PARAMS_FINISHED  Stack.pJumpTable++



// MISC

//
//#define NO_DEFAULT_CONSTRUCTOR(TheClass)  TheClass() {};   // ??????
//


#endif // __UNR_MACRO_H__
