#include <stdio.h>
#include <string.h>

typedef struct {
  char name[100];
  int kills[17];
  float killdie;
} playerrec;

int num;
playerrec players[16];

void status(FILE *f)
{
  int i, i1, i2;
  
  fprintf(f,"Victims:  ");
  for (i=0;i<num;i++)
    fprintf(f," %-10s",players[i].name);
  fprintf(f," tot\n");
  for(i=0;i<num;i++)
  {
    fprintf(f,"%c%9s",*("Killers             "+i),players[i].name);
    for (i1=0;i1<num;i1++)
      fprintf(f," %5d     ",players[i].kills[i1]);
    fprintf(f,"%4d\n",players[i].kills[16]);
  }
  fprintf(f,"%c%9s",*("Killers                 "+i),"total");
  for (i=0;i<num;i++)
  {
    i2=0;
    for (i1=0;i1<num;i1++)
      i2+=players[i1].kills[i];
    fprintf(f," %5d     ",i2);
    if (i2)
      players[i].killdie=(float)players[i].kills[16]/(float)i2;
    else
      players[i].killdie=99.99;
  }
  fprintf(f,"\n");
  fprintf(f,"%c%9s",*("Killers                       "+i+1),"kill/die");
  for (i=0;i<num;i++)
  {
    fprintf(f," %6.3f    ",players[i].killdie);
  }
  fprintf(f,"\n");
}

int main(void)
{
  char logname[255], buf[512], buf2[512];
  int i, i1;
  FILE *f;
  
  fprintf(stderr,"Copyright (c) 1996, Greg Alexander.  Distribute under the GNU Public License\n(copyleft) in the file COPYING.\n\n");
  fprintf(stderr,"Number of players? ");
  fflush(stderr);
  scanf("%d",&num);
  for (i=0;i<num;i++)
  {
    fprintf(stderr,"Player #%d: ",i+1);
    fflush(stderr);
    scanf("%s",players[i].name);
    for (i1=0;i1<17;i1++)
      players[i].kills[i1]=0;
  }
  fprintf(stderr,"Logname? ");
  fflush(stderr);
  scanf("%s",logname);
  f=fopen(logname,"r");
  if (!f)
  {
    fprintf(stderr,"Error opening \"%s\" for input!\n",logname);
    return(-1);
  }
  buf[0]=0;
  while (fgets(buf,500,f))
  {
    for(i=0;i<num;i++)
    {
      if (!strncmp(buf,players[i].name,strlen(players[i].name)))
      {
        if (!strncmp(&buf[strlen(players[i].name)]," killed ",8))
        {
          strcpy(buf2,&buf[strlen(players[i].name)+8]);
          for (i1=0;i1<num;i1++)
          {
            if (!strncmp(buf2,players[i1].name,strlen(players[i1].name)))
              break;
          }
          if (i1==num)
          {
            if (!strncmp(buf2,"himself",7))
              i1=i;
            else
              fprintf(stderr,"Error: \"%s\" unparsable!\n",buf);
          }
          players[i].kills[i1]++;
          if (i==i1)
            players[i].kills[16]--;
          else if (i<num)
            players[i].kills[16]++;
        } else if (!strncmp(&buf[strlen(players[i].name)]," died",5))
          players[i].kills[16]--;
      }
    }
    buf[0]=0;
  }
  status(stdout);
  fclose(f);
}