/*-------------------------------------------------------------------------
File    : token.c
Author  : John Carmack (id Software) and Cameron Newham.
Version : 1.0
Date    : 96/08/29

Description
-----------
Parses an array of char looking for tokens.

Comments
--------
This is almost verbatim from Carmack's code.
11-12-96 no change
-------------------------------------------------------------------------*/

#include "readmap.h"
#include "io.h"


/*--------------------------------------
Gets a Token
--------------------------------------*/
int GetToken (int crossline, char *token, int *scriptline, char *dat, int *loc)
{

  char *token_p;  /* a pointer into the token data */

  /* skip whitespace and ctrls */
skipspace:
  while (dat[*loc] <= 32)
  {
    if (dat[*loc] == '\0')
    {
      if (!crossline)
        Error (*scriptline, "Line is incomplete.\n");
      return FALSE;  /* End of data when error occured */
    }
    if (dat[(*loc)++] == '\n')
    {
      if (!crossline)
        Error (*scriptline, "Line is incomplete.\n");
        (*scriptline)++;  /* Try next line */
    }
  }

  if (dat[*loc] == '/' && dat[(*loc)+1] == '/')  /* check comment field */
  {
    if (!crossline)
      Error (*scriptline, "Line is incomplete.\n");
    while (dat[(*loc)++] != '\n')
    {
      if (dat[*loc] == '\0')
      {
        if (!crossline)
          Error (*scriptline, "Line is incomplete.\n");
        return FALSE;
      }
    }
    goto skipspace;
  }

  /* copy the token */
  token_p = token;

  if (dat[*loc] == '"')
  {
    (*loc)++;
    while (dat[*loc] != '"')
    {
      /* loop until we have a closing " */
      if (dat[*loc] == '\0')
        Error (*scriptline, "EOF is inside the quoted token\n");
      *token_p = dat[(*loc)++];
      token_p++;
      if (token_p == &token[MAXTOKEN])
        Error (*scriptline, "Token is too large\n");
    }
    (*loc)++;
  }
  else while (dat[*loc] > 32)
  {
    /* keep reading in the token */
    *token_p = dat[(*loc)++];
    token_p++;
    if (token_p == &token[MAXTOKEN])
      Error (*scriptline, "Token is too large\n");
  }

  *token_p = 0; /* null terminate the token string */

  return (TRUE);
}

