
//
// Hexen 2 game definition file (.fgd) PART 1 or 3
// version 0.91
//
// written by autolycus / autolycus@planetquake.com
// email me with improvements and suggestions
//

@Main = 
[
	Name: "Hexen 2"
	Palette: "hexen2.pal"
	DefaultClass: "func_door"
]

//
// worldspawn
//

@SolidClass = worldspawn : "World entity"
[
	message(string) : "Level name"
	worldtype(choices) : "Ambience" : 0 =
	[
		0 : "castle"
		1 : "egypt"
		2 : "meso"
		3 : "roman"
	]
	sounds(integer) : "CD track to play" : 1
]

//
// base marker definitions
//

@baseclass = Appearflags [
	spawnflags(Flags) =
	[
		256 : "Not in Easy" : 0
		512 : "Not in Normal" : 0
		1024 : "Not in Hard" : 0
		2048 : "Not in Deathmatch" : 0
	]
]

@baseclass = Targetname [ targetname(target_source) : "Name" ]
@baseclass = Target [ target(target_destination) : "Target" ]

//
// player starts, deathmatch, coop, teleport
//

@baseclass base(Appearflags) size(-16 -16 -32, 16 16 32) 
	color(0 255 0) = PlayerClass []

@PointClass base(PlayerClass, Targetname) = info_player_start : "Player 1 start" []
@PointClass base(PlayerClass, Targetname) = info_player_start2 : "Player 1 start" []
@PointClass base(PlayerClass) = info_player_deathmatch : "Player deathmatch start" []
@PointClass base(PlayerClass) = info_player_coop : "Player cooperative start" []
@PointClass base(PlayerClass, Targetname) = info_teleport_destination : "Teleport destination" []

@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = air_bubbles : "Air bubbles" []

@BaseClass base(Apeearflags) size(-8 -8 -44, 8 8 20) = Artifact
[
	spawnflags(Flags) =
	[
		1 : "Floating" : 0
	]
]

//
// Artifacts
//

@PointClass base(Artifact) = art_blastradius : "Blast Radius" []
@PointClass base(Artifact) = art_cubeofforce : "Cube of Force" []
@PointClass base(Artifact) = art_glyph : "Glyph" []
@PointClass base(Artifact) = art_haste : "Haste" []
@PointClass base(Artifact) = art_HealthBoost : "Health Boost" []
@PointClass base(Artifact) = art_invincibility : "Invincibility" []
@PointClass base(Artifact) = art_invisibility : "Invisibility" []
@PointClass base(Artifact) = art_manaboost : "Mana Boost" []
@PointClass base(Artifact) = art_polymorph : "Polymorph" []
@PointClass base(Artifact) = art_summon : "Summoning" []
@PointClass base(Artifact) = art_SuperHBoost : "Super Health Boost" []
@PointClass base(Artifact) = art_sword_and_crown : "Sword and Crown" []
@PointClass base(Artifact) = art_teleport : "Teleport" []
@PointClass base(Artifact) = art_tomeofpower : "Tome of Power" []
@PointClass base(Artifact) = art_torch : "Torch" []

@SolidClass base(Appearflags) = breakable_brush : "Breakable brush"
[
	spawnflags(Flags) =
	[
		1 : "Kill All" : 0
		2 : "Hierarchy" : 0
		4 : "No Link" : 0
		8 : "Check Name" : 0
		16 : "Ordered" : 0
		32 : "Translucent" : 0
		64 : "Invincible" : 0
		128 : "Invisible" : 0
	]
	flag(integer) : "Hierachial order"
	thingtype(choices) : "Material type" : 0 =
	[
		0 : "glass (default)"
		1 : "grey stone"
		2 : "wood"
		3 : "metal"
		4 : "flesh"
		5 : "fire"
		6 : "clay"
		7 : "leaves"
		8 : "hay"
		9 : "brown stone"
		10 : "cloth"
		11 : "wood & leaf"
		12 : "wood & metal"
		13 : "wood & stone"
		14 : "metal & stone"
		15 : "metal & cloth"
		16 : "spider web"
		19 : "clear glass"
		20 : "red glass"
	]
	health(choices) : "Health" : 0 =
	[
		0 : "Based on material"
	]
	abslight(integer) : "Absolute light level"
]

@SolidClass base(Appearflags) = brush_pushable : "Pushable brush"
[
	mass(integer) : "Mass" : 5
]

@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = camera_remote : "Camera"
[
	target(target_destination) : "Target (target_null)"
	wait(integer) : "Time in camera mode" : 3
	angles_x(integer) : "pitch (optional)"
	angles_y(integer) : "yaw (optional)"
]

@SolidClass base(Appearflags, Target, Targetname) = func_angletrigger : "rotating trigger"
[
	mangle(string) : "Mangle (x y z)"
	cnt(integer) : "Degrees per move"
	dmg(integer) : "Damage when blocked"
]

@SolidClass base(Appearflags, Target, Targetname) = func_button : "Button"
[
	spawnflags(Flags) =
	[
		1 : "Deactivated" : 0
		2 : "Fired only" : 0
		4 : "Fire multiple" : 0
	]
	speed(integer) : "Speed" : 40
	wait(choices) : "Wait" : 1 =
	[
		-1 : "Stay pressed"
	]
	lip(integer) : "Lip" : 4
	health(integer) : "Health"
	abslight(integer) : "Absolute light value"
	soundtype(choices) : "Sounds" : 0 =
	[
		0 : "steam metal"
		1 : "wooden clunk"
		2 : "metallic click"
		3 : "in-out"
	]
]

@SolidClass base(Appearflags, Targetname) = func_crusher : "Crusher"
[
	spawnflags(Flags) =
	[
		1 : "multiple" : 0
		2 : "slide" : 0
		4 : "start open" : 0
		8 : "end open" : 0
	]
	speed(integer) : "Speed" : 150
	dmg(integer) : "Damage" : 10
	lip(integer) : "Lip" : 4
	wait(integer) : "Wait" : 1
	soundtype(choices) : "Sounds" : 1 =
	[
		1 : "base fast"
		2 : "chain slow"
		3 : "guillotine"
	]
]

@BaseClass base(Appearflags, Targetname) = Door
[
	spawnflags(Flags) =
	[
		1 : "start open" : 0
		2 : "reverse" : 0
		4 : "dont link" : 0
	]
	message(string) : "Message"
	health(integer) : "Health (shootable)"
	speed(integer) : "Speed" : 100
	wait(choices) : "Wait" : 3 =
	[
		3 : "default (3)"
		-1 : "Never return"
	]
	dmg(choices) : "Damage" : 2 =
	[
		2 : "default (2)"
		666 : "instant kill (666)"
	]
	strength(integer) : "Strength" : 1
	soundtype(choices) : "Sounds" : 4 =
	[
		0 : "no sound"
		1 : "big metal door, swinging"
		2 : "big stone door, sliding"
		3 : "big wood door, swinging"
		4 : "normal wood door, swinging"
		5 : "big wood door, sliding"
		6 : "drawbridge"
		7 : "rotating walkway"
		8 : "big metal door, sliding"
		9 : "pendulum swinging"
	]
	puzzle_piece_1(integer) : "Puzzle Piece 1"
	puzzle_piece_2(integer) : "Puzzle Piece 2"
	puzzle_piece_3(integer) : "Puzzle Piece 3"
	puzzle_piece_4(integer) : "Puzzle Piece 4"	
	no_puzzle_msg(string) : "Puzzle message"
]

@SolidClass base(Door) = func_door : "Door"
[
	spawnflags(Flags) =
	[
		8 : "toggle" : 0
		16 : "slide" : 0
		32 : "normal move" : 0
		64 : "remove puzzle" : 0
		128 : "no puzzle" : 0
	]
	level(integer) : "movement length"
	lip(integer) : "Lip" : 8
	v_angle(string) : "Angle to turn" : "0 0 0"
	anglespeed(integer) : "Turning speed" : 0
]

@SolidClass base(Door) = func_door_rotating : "Rotating door"
[
	spawnflags(Flags) =
	[
		8 : "remove puzzle" : 0
		16 : "no puzzle" : 0
		32 : "toggle" : 0
		64 : "x axis" : 0
		128 : "y axis" : 0
	]
	flags(integer) : "Degrees of rotation"
	flags2(integer) : "Damage when touched"
	abslight(integer) : "Absolute light value"
]

@SolidClass base(Door) = func_door_secret : "Secret door"
[
	spawnflags(Flags) =
	[
		1 : "open once" : 0
		2 : "1st left" : 0
		4 : "1st down" : 0
		8 : "no shoot" : 0
		16 : "always shoot" : 0
		32 : "" : 0
		64 : "remove puzzle" : 0
		128: "no puzzle" : 0
	]
	t_width(integer) : "Override width"
	t_length(integer) : "Override length"
]

@SolidClass base(Door) = func_door_smashing : "Smashing door"
[
	spawnflags(Flags) =
	[
		2 : "" : 0
		8 : "toggle" : 0
		16 : "slide" : 0
		32 : "normal move" : 0
		64 : "remove puzzle" : 0
		128 : "no puzzle" : 0
	]
]

@SolidClass base(Appearflags) = func_illusionary : "Illusionary brush"
[
	spawnflags(Flags) =
	[
		1 : "translucent" : 0
		2 : "light" : 0
	]
	abslight(integer) : "Absolute light value"
]

@PointClass base(Appearflags, Targetname) size(-16 -16 0, 16 16 56) = func_monsterspawn_spot : "spawn spot"
[
	spawnflags(Flags) =
	[
		1 : "Imp" : 0
		2 : "Archer" : 0
		4 : "Wizard" : 0
		8 : "Scorpian" : 0
		16 : "Spider" : 0
		32 : "on death" : 0
		64 : "quiet" : 0
	]
	aflag(integer) : "Spawn order"
	cnt(integer) : "Number of spawns" : 17
	spawnername(string) : "Spawnername"
	wait(string) : "Time between spawns" : "0.5"
]

@PointClass base(func_monsterspawn_spot) size(-16 -16 0, 16 16 56) = func_monsterspawner : "spawner"
[
	spawnflags(Flags) =
	[
		128 : "trigger only" : 0
	]
]

@SolidClass base(Appearflags, Targetname) = func_newplat : "New plat"
[
	spawnflags(Flags) =
	[
		1 : "bottom start" : 0
		2 : "return to start" : 0
		4 : "continuous" : 0
	]
	speed(integer) : "Speed" : 150
	height(integer) : "Height"
	soundtype(choices) : "Sounds" : 1 =
	[
		1 : "base fast"
		2 : "chain slow"
	]
	wait(integer) : "Wait before moving" : 3
]

@SolidClass base(Appearflags, Targetname) = func_plat : "Plat"
[
	spawnflags(Flags) =
	[
		1 : "trigger low" : 0
	]
	speed(integer) : "Speed" : 150
	height(integer) : "Height"
	soundtype(choices) : "Sounds" : 1 =
	[
		1 : "pully"
		2 : "chain"
	]
	wait(integer) : "Wait before moving" : 3
]

@SolidClass base(func_button) = func_pressure : "Pressure plate"
[
	spawnflags(Flags) =
	[
		1 : "activate" : 0
		2 : "" : 0
		4 : "" : 0
	]
	mass(integer) : "Mass required"
]

@SolidClass base(Appearflags, Targetname) = func_reflect : "missilie relector"
[
	spawnflags(Flags) =
	[
		1 : "return" : 0
		2 : "toggle" : 0
		4 : "start open" : 0
	]
]

@SolidClass base(Appearflags, Targetname) = func_rotating : "Rotating object"
[
	spawnflags(Flags) =
	[
		1 : "start on" : 0
		2 : "reverse" : 0
		4 : "x axis" : 0
		8 : "y axis" : 0
		16 : "break" : 0
		32 : "gradual" : 0
		64 : "toggle reverse" : 0
		128 : "keep start" : 0
	]
	speed(integer) : "Speed" : 100
	dmg(integer) : "Damage when blocked" : 2
	lifetime(choices) : "Lifetime" : 0 =
	[
		0 : "Continuous"
	]
	wait(integer) : "Time between lifetimes" : 3
	thingtype(choices) : "Material type" : 0 =
	[
		0 : "glass"
		1 : "grey stone"
		2 : "wood"
		3 : "metal"
		4 : "flesh"
	]
	health(choices) : "Health" : 0 = 
	[
		0 : "Based on material"
	]
	abslight(integer) : "Absolute light value"
	anglespeed(integer) : "accel/decell time" : 10
]

@SolidClass base(Appearflags, Targetname) = func_rotating_movechain : "move chain"
[
	spawnflags(Flags) =
	[
		1 : "No angle chain" : 0
	]
	netname(string) : "Netname"
	dmg(integer) : "Damage on touch" 
	noise(string) : "Noise"
	noise1(string) : "Impact noise"
	wait(integer) : "Length of sound (for looping)"
	avelocity(string) : "Pitch/Yaw/Roll" : "0 0 0"
]

@SolidClass base(Appearflags, Targetname) = func_train : "Train"
[
	spawnflags(Flags) =
	[
		1 : "glow" : 0
		2 : "toggle" : 0
		4 : "return" : 0
		8 : "translucent" : 0
	]
	speed(integer) : "Speed" : 100
	dmg(integer) : "Damage when blocked" : 2
        soundtype(choices) : "Sound" : 1 =
	[
		1 : "ratchet metal"
	]
	distance(integer) : "Distance"
	anglespeed(integer) : "Speed of rotation" : 100
        wait(choices) : "Wait between moves" : 0 =
	[
		0 : "no wait"
		-1 : "stop"
		-2 : "explode"
	]
	pausetime(integer) : "Pause before explode"
	thingtype(choices) : "Material" : 1 =
	[
		0 : "glass"
		1 : "grey stone"
		2 : "wood"
		3 : "metal"
		4 : "flesh"
		5 : "fire"
		6 : "clay"
		7 : "leaves"
		8 : "hay"
		9 : "brown stone"
		10 : "cloth"
		11 : "wood & leaf"
		12 : "wood & metal"
		13 : "wood & stone"
		14 : "metal & stone"
		15 : "metal & cloth"
	]
	abslight(integer) : "Absolute light value"
]

@SolidClass base(Appearflags, Targetname) = func_wall : "Wall"
[
        spawnflags(Flags) =
	[
		1 : "Translucent" : 0
	]
	abslight(integer) : "Absolute light value"
]

@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = fx_colorbeam_end : "End of beam" []
@PointClass base(Appearflags, Target) size(-8 -8 -8, 8 8 8) = fx_colorbeam_start : "Start of beam"
[
        spawnflags(Flags) =
	[
		1 : "start off" : 0
	]
	noise(choices) : "Noise" : 1 =
	[
		1 : "no sound (default)"
		2 : "lightning"
	]
	wait(choices) : "Wait" : -1 =
	[
		-1 : "Triggerable"
	]
	color(choices) : "Color" : 0 =
	[
		0 : "red"
		1 : "blue"
		2 : "green"
		3 : "white"
		4 : "yellow"
	]
	lifespan(integer) : "Lifespan"
]

@SolidClass base(Appearflags) = fx_friction_change : "Friction change"
[
	friction(choices) : "Friction" : 1 =
	[
		1 : "normal (1)"
		0 : "slippery (> 0, < 1)"
		2 : "high (> 1)"
	]
]

@PointClass base(Appearflags, Targetname) size(-5 -5 -5, 5 5 5) = fx_particle_explosion : "particle explosion"
[
	spawnflags(Flags) =
	[
		1 : "flash" : 0
	]
	color(choices) : "Color" : 101 =
	[
		31 : "white"
		47 : "light blue"
		63 : "purple"
		79 : "light green"
		85 : "light brown"
		101 : "red (default)"
		117 : "light blue"
		133 : "yellow"
		149 : "green"
		238 : "red to orange"
		242 : "purple to red"
		246 : "green to purple"
		250 : "blue - green"
		254 : "yellow to blue"
	]
	exploderadius(integer) : "Exlpode radius (1 - 10)" : 5
	soundtype(choices) : "Sounds" : 1 =
	[
		0 : "no sound"
		1 : "rocket exlposion"
		2 : "grenade shoot"
	]
	counter(integer) : "Number of particles (1 - 1024)" : 512
]

@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = fx_smoke_generator : "smoker"
[
	wait(integer) : "Time between puffs" : 2
	thingtype(choices) : "Type of smoke" : 0 =
	[
		0 : "white puff"
		1 : "red"
		2 : "green"
		3 : "grey"
	]
]

@PointClass base(Appearflags) size(-16 -16 -16, 16 16 16) = info_intermission : "intermission camera"
[
	mangle(string) : "Pitch/Roll/Yaw" : "0 0 0"
]

@PointClass base(Appearflags, Targetname) size(-4 -4 -4, 4 4 4) = info_null : "null target" []

@BaseClass base(Appearflags, Target) size(-8 -8 -20, 8 8 45) = Item
[
	spawnflags(Flags) =
	[
		1 : "floating" : 0
	]
]

@PointClass base(Item) = item_armor_amulet : "armor amulet" []
@PointClass base(Item) = item_armor_bracer : "armor bracer" []
@PointClass base(Item) = item_armor_breastplate : "breastplate" []
@PointClass base(Item) = item_armor_helmet : "helmet" []
@PointClass base(Item) = item_health : "10 health" []
@PointClass base(Item) = item_mana_both : "Mana"
[
	spawnflags(Flags) =
	[
		2 : "big (30)" : 0
	]
]
@PointClass base(item_mana_both) = item_mana_blue : "blue mana" []
@PointClass base(item_mana_both) = item_mana_green : "green mana" []
@PointClass base(Item) size(-8 -8 -8, 8 8 8) = item_mirage : "Holoduke type thing" []
@PointClass base(Item) = item_spawner : "generic item spawner" []

@PointClass base(Appearflags, Targetname, Target) size(-8 -8 -8, 8 8 8) = light : "normal light"
[
	spawnflags(Flags) =
	[
		1 : "start low" : 0
	]
	light(integer) : "Brightness" : 300
	style(integer) : "Style" : 0
	lightvalue1(integer) : "Lowest light value" : 0
	lightvalue2(integer) : "Highest light value" : 11
	fadespeed(integer) : "Fade speed" : 1
]
@PointClass base(light) size(-10 -10 -40, 10 10 40) = light_flame_large_yellow : "flame" []
@PointClass base(light) size(-10 -10 -12, 12 12 18) = light_flame_small_white : "flame"[]
@PointClass base(light) size(-10 -10 -12, 12 12 18) = light_flame_small_yellow : "flame" []
@PointClass base(light) size(-8 -8 -8, 8 8 8) = light_gem : "gem light" []
@PointClass base(light) size(-8 -8 -8, 8 8 8) = light_globe : "globe" []
@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = light_thunderstorm : "thunderstorm"
[
	light(integer) : "Brightness" : 300
	wait(integer) : "Wait (1 - 100)" : 33
	dmg(integer) : "Lightning frequency" : 10
	lightvalue1(integer) : "Normal light value" : 11
	frags(integer) : "Lightning area radius" : 1000
]

@PointClass base(light) size(-8 -8 -8, 8 8 8) = light_torch_castle : "castle torch"
[
	health(integer) : "Health (shootable)"
]
@PointClass base(light_torch_castle) = light_torch_egypt : "egyptian torch" []
@PointClass base(light_torch_castle) = light_torch_meso : "meso torch" []
@PointClass base(light_torch_castle) = light_torch_rome : "roman torch" []
@PointClass base(light) size(-10 -10 -20, 10 10 20) = light_torch_small_walltorch : "walltorch"
[
	light(integer) : "Brightness" : 200
]

@PointClass base(Appearflags) size(0 0 2, 32 32 66) = misc_explobox : "Large exploding container" []
@PointClass base(Appearflags) size(0 0 2, 32 32 34) = misc_explobox2 : "Small exploding container" []

@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = misc_fireball : "Lava balls" []

@PointClass base(Appearflags) size(0 0 0, 32 32 32) = misc_fountain : "Fountain"
[
	angles(string) : "Angles (x y z)" : "0 0 0"
	movedir(string) : "Direction (x y z)" : "1 1 1"
	color(integer) : "Color" : 256
	cnt(integer) : "Number of particles" : 2
]

@PointClass size(-10 -10 -10, 10 10 10) = misc_noisemaker : "For optimization testing, starts a lot of sounds." []

@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = misc_teleporttrain : "Moving teleporter" []

