unit Textures;

interface

uses Objects;

type
 TNomEntree = array[0..15] of Byte;
 TEnteteTex = record
               Nom: TNomEntree;
               W,H: LongInt;
               Indexes: array[0..3] of LongInt;
              end;

var
 ListeTextures: PStringCollection;

procedure ExtraireTextures(var Liste: TStringCollection; const NomFich: String);
procedure PreparerBSP(const NomFich: String; var M: TStream);
procedure ChargeTextures;

implementation

uses QMObj, QMPak, QMUI, Crt;

const
 NomFichTex = 'QMDOSRT.TEX';

const
 SignatureWad2 = $32444157;   { 'WAD2' }

type
 TEnteteWad = record
               Signature: LongInt;   { 'WAD2' }
               NbEntrees, PosRep: LongInt;
              end;
 PEntreeRep = ^TEntreeRep;
 TEntreeRep = record
               Position, Taille, Idem, InfoType: LongInt;
               Nom: TNomEntree;
              end;
 PTableauPos = ^TTableauPos;
 TTableauPos = array[0..0] of LongInt;
 TEntreesBsp = (eEntities, ePlanes, eMipTex, eVertices,
                eVisiList, eNodes, eUnknown, eSurfaces,
                eLightmaps, eBoundNodes, eLeaves, eListSurf,
                eEdges, eListEdges, eHulls);
 TEntreeBsp = record
               Position, Taille: LongInt;
              end;
 TEnteteBsp = record
               Signature: LongInt;
               Entrees: array[TEntreesBsp] of TEntreeBsp;
              end;

procedure ChargeTextures;
var
 S: TBufStream;
begin
 if ListeTextures=Nil then
  begin
   S.Init(NomFichTex, stOpenRead, 1024);
   if S.Status<>stOk then
    Erreur('Texture list not found (file '+NomFichTex+')');
   New(ListeTextures, Load(S));
   S.Done;
  end;
end;

function ChercheTextureDans(const NomBsp, Cherche: String; var EnteteTex: TEnteteTex; var SF: PStream) : Boolean;
var
 S: PStream;
 Entete: TEnteteBsp;
 L, Origine, I, Nb: LongInt;
 Positions: PTableauPos;
 ChercheNomTex: String[63];
begin
 if NomBsp[1]='\' then
  begin  { texture personnelle, dj extraite dans un fichier }
   SF:=New(PBufStream, Init(QuakeDir + '\QMapExec' + NomBsp, stOpenRead, 512));
   SF^.Read(EnteteTex, SizeOf(EnteteTex));
   ChercheTextureDans:=True;
  end
 else
  begin  { recherche de la texture dans le fichier .bsp original de Quake }
   ChercheNomTex:=Cherche;
   if Cherche[Length(Cherche)]='*' then
    Dec(Byte(ChercheNomTex[0]));
   OuvrirEntreeQuake('maps/'+NomBsp+'.bsp', S);
   Origine:=S^.GetPos;
   S^.Read(Entete, SizeOf(Entete));
   if (Entete.Signature = $1C) or (Entete.Signature = $1D) then
    begin
     L:=Origine + Entete.Entrees[eMipTex].Position;
     S^.Seek(L);
     S^.Read(Nb, 4);
     GetMem(Positions, Nb*4);
     S^.Read(Positions^, Nb*4);
     for I:=0 to Nb-1 do
      begin
       S^.Seek(Positions^[I]+L);
       S^.Read(EnteteTex, SizeOf(TEnteteTex));
       if CompareText(CharToPas(EnteteTex.Nom), ChercheNomTex) = 0 then
        begin
         PasToChar(EnteteTex.Nom, Cherche);  { ncessaire au cas o
          on a cherch un nom se terminant par *; dans ce cas,
          Entete contient le nom original d'ID, c'est--dire sans * }
         SF:=S;
         ChercheTextureDans:=True;
         FreeMem(Positions, Nb*4);
         Exit;
        end;
      end;
     FreeMem(Positions, Nb*4);
    end;
   Dispose(S, Done);
   ChercheTextureDans:=False;
  end;
end;

function EcrireTexture(const Nom: String; var Dest: TStream; Necessaire: Boolean) : Boolean;
var
 S: PStream;
 Cherche: String;
 Entete: TEnteteTex;
 I: Integer;
begin
 EcrireTexture:=True;
 ChargeTextures;
 Cherche:=Nom+'=';
 LowerCase(Cherche);
 ListeTextures^.Search(@Cherche, I);
 if (I>=0) and (I<ListeTextures^.Count) then
  begin
   Cherche:=PString(ListeTextures^.At(I))^;
   I:=Pos('=',Cherche);
   if (CompareText(Copy(Cherche, 1, I-1), Nom) = 0)
   and ChercheTextureDans(Copy(Cherche,I+1,255),
   Nom, Entete, S) then
    begin
     Dest.Write(Entete, SizeOf(Entete));
     Dest.CopyFrom(S^, (Entete.W*Entete.H*85) div 64);
     Dispose(S, Done);
     Exit;
    end;
  end;
 if Necessaire then
  Erreur('Texture not found : '+Nom);
 EcrireTexture:=False;
end;

procedure ExtraireTextures(var Liste: TStringCollection; const NomFich: String);
var
 I, J: Integer;
 Dest: TBufStream;
 EnteteWad: TEnteteWad;
 Rep: TMemoryStream;
 Entree: TEntreeRep;
 TexAnimees: TStringCollection;
 S: TNomTex;
 Ch: Char;
begin
 Dest.Init(NomFich, stCreate, 1024);
 Dest.Write(EnteteWad, SizeOf(EnteteWad));
 Rep.Init(256,256);
 Entree.InfoType:=Ord('D');
 TexAnimees.Init(20,20);
 for I:=0 to Liste.Count-1 do
  begin
   S:=PString(Liste.At(I))^;
   if (Length(S)>=2)
   and (S[1]='+') and (S[2] in ['0'..'9', 'a'..'j']) then
    begin
     for Ch:='0' to '9' do
      begin
       S[2]:=Ch;
       if not TexAnimees.Search(@S, J) then
        TexAnimees.AtInsert(J, NewStr(S));
      end;
     for Ch:='a' to 'j' do
      begin
       S[2]:=Ch;
       if not TexAnimees.Search(@S, J) then
        TexAnimees.AtInsert(J, NewStr(S));
      end;
    end;
  end;
 for I:=0 to Liste.Count-1 do
  begin
   Entree.Position:=Dest.GetPos;
   S:=PString(Liste.At(I))^;
   if (Length(S)>=2)
   and (S[1]='+') and (S[2] in ['0'..'9', 'a'..'j'])
   and TexAnimees.Search(@S, J) then
    TexAnimees.AtFree(J);
   EcrireTexture(S, Dest, True);
   PasToChar(Entree.Nom, S);
   Entree.Taille:=Dest.GetPos-Entree.Position;
   Entree.Idem:=Entree.Taille;
   Rep.Write(Entree, SizeOf(TEntreeRep));
  end;
 EnteteWad.NbEntrees:=Liste.Count;
 for I:=0 to TexAnimees.Count-1 do
  begin
   Entree.Position:=Dest.GetPos;
   S:=PString(TexAnimees.At(I))^;
   if EcrireTexture(S, Dest, False) then
    begin
     PasToChar(Entree.Nom, S);
     Entree.Taille:=Dest.GetPos-Entree.Position;
     Entree.Idem:=Entree.Taille;
     Rep.Write(Entree, SizeOf(TEntreeRep));
     Inc(EnteteWad.NbEntrees);
    end;
  end;
 TexAnimees.Done;
 if EnteteWad.NbEntrees > Liste.Count then
  begin
   Str(EnteteWad.NbEntrees-Liste.Count, S);
   qmWrite('Added '+S+' animated texture frames', Yellow+16*Blue);
  end;
 EnteteWad.PosRep:=Dest.GetPos;
 Rep.Seek(0);
 Dest.CopyFrom(Rep, EnteteWad.NbEntrees*SizeOf(TEntreeRep));
 Rep.Done;
 EnteteWad.Signature:=SignatureWad2;
 Dest.Seek(0);
 Dest.Write(EnteteWad, SizeOf(EnteteWad));
 Dest.Done;
end;

procedure PreparerBSP(const NomFich: String; var M: TStream);
var
 EnteteBsp: TEnteteBsp;
 E: TEntreesBsp;
 Dest: TBufStream;
 Liste, P: PChar;
 ListeTex: TStringCollection;
 S: String[63];
 I, Pos0, T, Origine: LongInt;
 Positions: PTableauPos;
begin
 Origine:=M.GetPos;
 M.Read(T, SizeOf(T));
 Inc(Origine, T);
 M.Seek(Origine);
 M.Read(EnteteBsp, SizeOf(EnteteBsp));
 if (EnteteBsp.Signature<>$1C) and (EnteteBsp.Signature<>$1D) then
  Erreur('The encapsulated file is not a valid .bsp');
 Dest.Init(NomFich, stCreate, 1024);
 Dest.Write(EnteteBsp, SizeOf(EnteteBsp));
 Pos0:=SizeOf(EnteteBsp);
 for E:=Low(E) to High(E) do
  begin
   if EnteteBsp.Entrees[E].Position > 0 then
    begin  { entre code normalement, directement extraite }
     M.Seek(Origine + EnteteBsp.Entrees[E].Position);
     if EnteteBsp.Entrees[E].Taille>0 then
      Dest.CopyFrom(M, EnteteBsp.Entrees[E].Taille);
    end
   else  { entre spciale,  reconstituer }
    begin
     case E of
      eMipTex: begin  { textures }
                GetMem(Liste, EnteteBsp.Entrees[eMipTex].Taille);
                M.Seek(Origine - EnteteBsp.Entrees[E].Position);
                M.Read(Liste^, EnteteBsp.Entrees[eMipTex].Taille);
                ListeTex.Init(8,8);
                P:=Liste;
                S:='';
                for I:=1 to EnteteBsp.Entrees[eMipTex].Taille do
                 begin
                  if P^ in [#13,#10] then
                   begin
                    if S<>'' then
                     begin
                      ListeTex.AtInsert(ListeTex.Count, NewStr(S));
                      S:='';
                     end;
                   end
                  else
                   S:=S+P^;
                  Inc(P);
                 end;
                if S<>'' then
                 ListeTex.AtInsert(ListeTex.Count, NewStr(S));
                FreeMem(Liste, EnteteBsp.Entrees[eMipTex].Taille);
                I:=ListeTex.Count;
                Dest.Write(I, SizeOf(I));
                T:=4*I;
                GetMem(Positions, T);
                Dest.Write(Positions^, T);
                for I:=0 to ListeTex.Count-1 do
                 if PString(ListeTex.At(I))^=#1 then
                  Positions^[I]:=-1
                 else
                  begin
                   Positions^[I]:=Dest.GetPos - Pos0;
                   EcrireTexture(PString(ListeTex.At(I))^, Dest, True);
                  end;
                I:=Dest.GetPos;
                Dest.Seek(Pos0+SizeOf(I));
                Dest.Write(Positions^, T);
                Dest.Seek(I);
                FreeMem(Positions, T);
               end;
     else  { les autres entres ne doivent pas tre spciales dans cette version-ci }
      Erreur('The encapsulated .bsp does not contain enough information to be rebuilt');
     end;
     EnteteBsp.Entrees[E].Taille:=Dest.GetPos-Pos0;
    end;
   EnteteBsp.Entrees[E].Position:=Pos0;
   Pos0:=Dest.GetPos;
   if Pos0 and 3 <> 0 then
    begin  { alignement sur double-mot }
     I:=0;
     Dest.Write(I, 4-(Pos0 and 3));
     Inc(Pos0, 4-(Pos0 and 3));
    end;
  end;
 Dest.Seek(0);
 Dest.Write(EnteteBsp, SizeOf(EnteteBsp));
 Dest.Done;
end;

begin
 ListeTextures:=Nil;
end.