UNIT QMUI;

INTERFACE

uses Crt, Objects, Strings;

{$I SCANCODE.INC}

var
 Touches : PStringCollection;

PROCEDURE InitUI;
PROCEDURE Erreur(CONST Texte: STRING);
PROCEDURE qmWrite(CONST Texte: STRING; nTextAttr: Byte);
PROCEDURE InteractiveMode(Success: Boolean);
PROCEDURE MarqueDescription;
PROCEDURE FinProgramme(const CmdLine: STRING);
PROCEDURE PetiteEtoile;
FUNCTION UserInput(var S: STRING) : Boolean;
PROCEDURE AssociationTouches;

IMPLEMENTATION

uses QMPak;

var
 Origine, Blocage: Integer;
 Lignes: TStringCollection;

procedure MAJEcran;
var
 I: Integer;
 S: String[78];
begin
 for I:=0 to 20 do
  begin
   GotoXY(2, 3+I);
   if Origine+I < Lignes.Count then
    begin
     S:=PString(Lignes.At(Origine+I))^;
     TextAttr:=Ord(S[1]);
     S[1]:=' ';
     Write(S);
    end
   else
    TextAttr:=White+16*Blue;
   Write(Copy('                                                                               ',
    WhereX, 255));
   if I=0 then
    if Origine=0 then
     begin
      TextAttr:=White+16*Blue;
      Write('');
     end
    else
     begin
      TextAttr:=Black+16*Cyan+Blink;
      Write(#30);
     end;
   if I=20 then
    if Origine+20 >= Lignes.Count then
     begin
      TextAttr:=White+16*Blue;
      Write('');
     end
    else
     begin
      TextAttr:=Black+16*Cyan+Blink;
      Write(#31);
     end;
  end;
 GotoXY(1,1);
end;

procedure Erreur(const Texte: String);
begin
 Blocage:=MaxInt;
 qmWrite(Texte, Yellow + 16*Red);
 InteractiveMode(False);
 Halt;
end;

PROCEDURE qmWrite;
BEGIN
 Lignes.AtInsert(Lignes.Count, NewStr(Chr(nTextAttr)+Texte));
 Origine:=Lignes.Count-21;
 if Origine > Blocage then
  Origine:=Blocage;
 if Origine<0 then
  Origine:=0;
 MAJEcran;
END;

procedure MarqueDescription;
begin
 Blocage:=Lignes.Count;
end;

procedure InitUI;
var
 I: Integer;
begin
 TextAttr:=Black+16*LightGray;
 ClrScr;
 TextAttr:=LightGray+16*LightGray;
 Write('  ');
 TextAttr:=Red+16*LightGray;
 Write(' QUAKEMAP   Dos Run-time ');
 TextAttr:=Black+16*LightGray;
 WriteLn('     version 2.8                   (c) Armin Rigo');
 TextAttr:=White+16*Blue;
 Write( 'ͻ');
 for I:=3 to 23 do
  Write('                                                                              ');
 Write( 'ͼ');
 TextAttr:=Black+16*LightGray;
 Write(' Working, please wait...');
 Origine:=0;
 Blocage:=MaxInt;
 Lignes.Init(16,8);
 MAJEcran;
end;

procedure InteractiveMode;
var
 Ch: Char;
begin
 Blocage:=MaxInt;
 GotoXY(2,25);
 TextAttr:=Red+16*LightGray;
 Write('   Esc');
 TextAttr:=Black+16*LightGray;
 Write('  Quit      ');
 TextAttr:=Red+16*LightGray;
 Write(#24' '#25' PgUp PgDn Home End');
 TextAttr:=Black+16*LightGray;
 Write('  Scroll text      ');
 if Success then
  begin
   TextAttr:=Red+16*LightGray;
   Write('Enter');
   TextAttr:=Black+16*LightGray;
   Write('  GO !');
  end
 else
  begin
   TextAttr:=Red+16*LightGray+Blink;
   Write('           ERROR');
  end;
 GotoXY(1,1);
 Ch:=#0;
 repeat
  if Ch=#13 then Write(#7);
  Ch:=ReadKey;
  if Ch=#0 then
   begin
    Case ReadKey of
     'G': Origine:=0;
     'H': Dec(Origine);
     'I': Dec(Origine, 20);
     'O': Origine:=MaxInt;
     'P': Inc(Origine);
     'Q': Inc(Origine, 20);
    end;
    if Origine > Lignes.Count-20 then
     Origine:=Lignes.Count-20;
    if Origine < 0 then
     Origine:=0;
    MAJEcran;
   end;
 until (Ch=#27) or (Success and (Ch=#13));
 if Ch=#27 then
  FinProgramme(' /stop');
end;

procedure FinProgramme;
var
 Fich: Text;
begin
 TextAttr:=LightGray + 16*Black;
 GotoXY(1,1);
 DelLine;
 GotoXY(1,25);
 Assign(Fich, 'QMDOSRT~.BAT');
 {$I-}
 Append(Fich);
 {$I+}
 if IOResult=0 then
  begin
   Writeln(Fich, 'QM.BAT', CmdLine);
   Close(Fich);
  end;
 Halt;
end;

procedure PetiteEtoile;
var
 P: PString;
begin
 P:=PString(Lignes.At(Lignes.Count-1));
 P^[2]:=#15;
end;

function UserInput(var S: String) : Boolean;
var
 S0: String[77];
 Ch: Char;
begin
 GotoXY(2,25);
 TextAttr:=Red+16*LightGray;
 Write('   Esc');
 TextAttr:=Black+16*LightGray;
 Write('  Quit');
 ClrEol;

 MAJEcran;
 S0:=PString(Lignes.At(Lignes.Count-1))^;
 S:='';
 TextAttr:=White+16*Blue;
 repeat
  GotoXY(2+Length(S0)+Length(S), 2+Lignes.Count-Origine);
  Ch:={Upcase(}Readkey{)};
  case Ch of
   #13: UserInput:=True;
   #27: UserInput:=False;
   #8: if Length(S)>0 then
        S:=Copy(S, 1, Length(S)-1);
   #0: Readkey;
   else
    S:=S+Ch;
  end;
  GotoXY(2+Length(S0), 2+Lignes.Count-Origine);
  Write(S, ' ');
 until Ch in [#13, #27];

 GotoXY(1,25);
 TextAttr:=Black+16*LightGray;
 Write(' Working, please wait...');
 DisposeStr(Lignes.At(Lignes.Count-1));
 Lignes.AtPut(Lignes.Count-1, NewStr(S0+S));
 MAJEcran;
end;

procedure AssociationTouches;
var
 I, NbBind, Index: Integer;
 S: String;
 P: PString;
 Ch: Char;
 Dest: Text;
 EnBas: Boolean;
begin
 I:=0;
 NbBind:=0;
 while I<Touches^.Count do
  begin
   S:=PString(Touches^.At(I))^;
   if Copy(S, 1, 1) = #255 then
    begin
     if NbBind=0 then
      begin
       Lignes.FreeAll;
       qmWrite('Key binding', Yellow+16*Black);
       qmWrite('', 16*Blue);
       qmWrite('        Key   Action', Yellow+16*Blue);
       qmWrite('  ', Yellow+16*Blue);
      end;
     Inc(NbBind);
     Delete(S, 1, 1);
     while Length(S)<11 do
      S:=' '+S;
     qmWrite(' '+S+'   '+PString(Touches^.At(I+1))^, White+16*Blue);
     Inc(I, 3);
    end
   else
    Inc(I);
  end;
 if NbBind>0 then
  begin
   qmWrite('', 16*Blue);
   qmWrite('  Done', LightGreen+16*Blue);
   Index:=Lignes.Count-1;
   repeat
    EnBas:=Index=Lignes.Count-1;
    GotoXY(2,25);
    TextAttr:=Red+16*LightGray;
    Write('   Esc');
    TextAttr:=Black+16*LightGray;
    Write('  Quit     ');
    TextAttr:=Red+16*LightGray;
    Write(#24' '#25' ');
    TextAttr:=Black+16*LightGray;
    Write('  Move cursor     ');
    TextAttr:=Red+16*LightGray;
    Write('Enter');
    TextAttr:=Black+16*LightGray;
    if EnBas then
     Write('  Launch Quake')
    else
     begin
      Write('  Change key      ');
      TextAttr:=Red+16*LightGray;
      Write('F2');
      TextAttr:=Black+16*LightGray;
      Write('  Edit key');
     end;
    ClrEol;
    if Index<Origine then
     Origine:=Index;
    if Index>Origine+20 then
     Origine:=Index-20;
    PString(Lignes.At(Index))^[2]:=#16;
    MAJEcran;
    Ch:=ReadKey;
    PString(Lignes.At(Index))^[2]:=' ';
    case Ch of
     #0: begin
          case ReadKey of
           'G': Index:=0;
           'H': Dec(Index);
           'I': Dec(Index, 10);
           'O': Index:=MaxInt;
           'P': Inc(Index);
           'Q': Inc(Index, 10);
           '<': if not EnBas then
                 begin
                  qmWrite('', 16*Blue);
                  qmWrite('Enter key name : ', Yellow+16*Blue);
                  if UserInput(S) then
                   begin
                    P:=PString(Lignes.At(Index));
                    while Length(S)<11 do
                     S:=' '+S;
                    Move(S[1], P^[3], 11);
                   end;
                  Lignes.AtFree(Lignes.Count-1);
                  Lignes.AtFree(Lignes.Count-1);
                 end;
          end;
          if Index < Lignes.Count-NbBind-2 then
           Index:=Lignes.Count-NbBind-2;
          if Index >= Lignes.Count then
           Index:=Lignes.Count-1;
          if Index = Lignes.Count-2 then
           if EnBas then
            Dec(Index)
           else
            Inc(Index);
         end;
     #13: if not EnBas then
           begin
            TextAttr:=Yellow+16*Brown;
            GotoXY(26, 12); Write('Ŀ');
            GotoXY(26, 13); Write('     Press the new key    ');
            GotoXY(26, 14); Write('');
            GotoXY(2,25);
            TextAttr:=Red+16*LightGray;
            Write('   Esc');
            TextAttr:=Black+16*LightGray;
            Write('  Quit');
            ClrEol;
            GotoXY(1,1);
            while Port[$60]<128 do
             if KeyPressed and (ReadKey=#27) then
              Break;
            repeat
             I:=PORT[$60];
             if KeyPressed and (ReadKey=#27) then
              Break;
            until I<128;
            if (I>1) and (I<128) and (ScanCodes[I]^<>#0) then
             begin
              P:=PString(Lignes.At(Index));
              S:=StrPas(ScanCodes[I]);
              while Length(S)<11 do
               S:=' '+S;
              Move(S[1], P^[3], 11);
             end;
            while KeyPressed do
             ReadKey;
           end;
     #27: FinProgramme(' /stop');
    end;
   until (Ch=#13) and EnBas;
  end;
 I:=0;
 Index:=Lignes.Count-NbBind-2;
 Assign(Dest, FichierSortie('QMapExec.cfg'));
 Rewrite(Dest);
 while I<Touches^.Count do
  begin
   S:=PString(Touches^.At(I))^;
   if Copy(S, 1, 1) = #255 then
    begin
     S:=PString(Lignes.At(Index))^;
     Inc(Index);
     WriteLn(Dest, 'bind ', Copy(S, 3, 11), ' "', PString(Touches^.At(I+2))^, '"');
     Inc(I,3);
    end
   else
    begin
     Inc(I);
     WriteLn(Dest, S);
    end;
  end;
 Close(Dest);
 Dispose(Touches, Done);
end;

end.