PROGRAM QuakeMapDosRuntime;
{$N+,E-}

(*************************************************************)
(******                                                 ******)
(*****           DOS Run-time for QuakeMap 2.8           *****)
(******                                                 ******)
(*************************************************************)

USES Dos, Crt, Objects, QMObj, QMUI, QMPak, QPAcc, Textures, QMDescr;

VAR
 RepertoireQM : PRepertoireQM;
 NbEntrees    : INTEGER;
 CmdLine      : STRING;
 NomFichOrg   : String;

FUNCTION Ouvrir(const NomFich: String; var Rep : PRepertoireQM; var Nb : INTEGER) : Boolean;

VAR
 Intro : TIntroQM;

BEGIN
 SourceFile:=New(PBufStream, Init(NomFich, stOpenRead, 1024));
 SourceFile^.Read(Intro, SizeOf(Intro));
 IF SourceFile^.Status<>stOk THEN
  BEGIN
   Ouvrir:=False;
   Dispose(SourceFile, Done);
  END
 ELSE
  BEGIN
   IF Intro.Signature<>SignatureQM THEN
    Erreur('File '+NomFich+' is not a QuakeMap file');
   SourceFile^.Seek(Intro.PositionRep);
   GetMem(Rep, Intro.TailleRep);
   SourceFile^.Read(Rep^, Intro.TailleRep);
   IF SourceFile^.Status<>stOk THEN
    Erreur('File format error : '+NomFich);
   Nb:=Intro.TailleRep DIV SizeOf(TEntreeRepQM);
   Ouvrir:=True;
  END;
END;

PROCEDURE Init;

BEGIN
 InitUI;
 IF ParamCount=0 THEN
  Erreur('This program is not supposed to be run directly. Type QM for more info.');
END;

PROCEDURE OuvrirFichierNo(I : Integer);

VAR
 J : Integer;

BEGIN
 NomFichOrg:=ParamStr(I);
 J:=Length(NomFichOrg);
 while (J>0) and (NomFichOrg[J]<>'\') do
  Dec(J);
 IF Pos('.', Copy(NomFichOrg, J+1, 255)) = 0 THEN
  begin
   NomDescrip:=Copy(NomFichOrg, J+1, 255)+'.TXT';
   NomFichOrg:=NomFichOrg+'.qme';
  end
 else
  NomDescrip:=Copy(NomFichOrg, J+1, Pos('.',Copy(NomFichOrg,J+1,255))) + 'TXT';
 IF NOT Ouvrir(NomFichOrg, RepertoireQM, NbEntrees) THEN
  Erreur('File not found : '+NomFichOrg);
END;

procedure Vider(const Rep: String);
var
 S: SearchRec;
 SousRep: TStringCollection;
 I: Integer;
 F: File;
begin
 SousRep.Init(4,4);
 FindFirst(Rep+'*.*', AnyFile, S);
 while DosError=0 do
  begin
   if S.Attr and Directory = 0 then
    begin
     Assign(F, Rep+S.Name);
     {$I-}
     Erase(F);
     {$I+}
     I:=IOResult;
    end
   else
    if (S.Name<>'.') and (S.Name<>'..') then
     SousRep.Insert(NewStr(S.Name));
   FindNext(S);
  end;
 for I:=0 to SousRep.Count-1 do
  Vider(Rep+PString(SousRep.At(I))^+'\');
 SousRep.Done;
 {$I-}
 RmDir(Copy(Rep, 1, Length(Rep)-1));
 {$I+}
 I:=IOResult;
end;

PROCEDURE ProcessQME;

CONST
 NomInfoTypes : ARRAY[qmDescription..qmFileLnk] OF STRING[12] =
  (' Description',
   '         Map',
   'QuakeC patch',
   '    BSP file',
   'Texture def.',
   '   File def.',
   'Texture link',
   '   File link');

VAR
 NomF2   : STRING;
 Code, P : PPatch;
 NextCode: ^PPatch;
 F       : PStream;
 Descrip : Boolean;
 PremiereCarte: String[8];
 NoTexture : Integer;
 Impulse0  : Integer;
 Fichiers  : TStringCollection;
 FichierNo, I : Integer;

 procedure Process(RepertoireQM: PRepertoireQM; Count: Integer);
 var
  I, J, K: Integer;
  T, T2: LongInt;
  NomF: String;
  NomTex: String[19];
  Repertoire2: PRepertoireQM;
  Entete: TEnteteCarte;
  F: PStream;
  NewCode: PPatch;
  EnteteTex: TEnteteTex;
 begin
  for K:=0 to Count-1 do
   with RepertoireQM^[K] do
    if (Taille>0) and (InfoType = qmTextureDef) then
     begin
      ChargeTextures;
      SourceFile^.Seek(Position);
      SourceFile^.Read(T, SizeOf(T));
      for I:=1 to T do
       begin
        SourceFile^.Seek(Position+I*4);
        SourceFile^.Read(T2, 4);
        SourceFile^.Seek(Position+T2);
        SourceFile^.Read(EnteteTex, SizeOf(EnteteTex));
        Inc(NoTexture);
        Str(NoTexture, NomF);
        NomF:='temp\tex'+NomF+'.tmp';
        F:=New(PDosStream, Init(FichierSortie(NomF), stCreate));
        F^.Write(EnteteTex, SizeOf(EnteteTex));
        F^.CopyFrom(SourceFile^, (EnteteTex.W*EnteteTex.H*85) div 64);
        Dispose(F, Done);
        NomTex:=CharToPas(EnteteTex.Nom);
        LowerCase(NomTex);
        if ListeTextures^.Search(@NomTex, J) then
         ListeTextures^.AtFree(J);
        ListeTextures^.AtInsert(J, NewStr(NomTex+'=\'+NomF));
       end;
     end;
  for I:=0 to Count-1 do
   with RepertoireQM^[I] do
    if Taille>0 then
     begin
      if InfoType > High(NomInfoTypes) then
       qmWrite('Warning : entry '''+CharToPas(Nom)+''' is of unknown type', Yellow+16*Magenta)
      else
       qmWrite('  '+NomInfoTypes[InfoType]+' '#16' '+CharToPas(Nom), White+16*Blue);
      case InfoType of
       qmDescription: if not Descrip then
                       begin
                        ExtraireDescription(RepertoireQM^[I]);
                        Descrip:=True;
                       end;
       qmCarte: begin
                 NomF:=NomFichierCarte(RepertoireQM^[I], @Entete);
                 if not Entete.Modeles then
                  begin
                   if PremiereCarte='' then
                    PremiereCarte:=NomF;
                   ExtraireMap(RepertoireQM^[I], FichierSortie('maps/'+NomF+'.map'));
                   for T:=0 to Count-1 do
                    if (RepertoireQM^[T].InfoType = qmBSP0)
                    and (CompareText(NomFichierCarte(RepertoireQM^[T], Nil), NomF)=0) then
                     NomF:='';
                   if NomF<>'' then
                    begin
                     CmdLine:=CmdLine + ' /b ' + NomF;
                     PetiteEtoile;
                    end;
                  end;
                end;
       qmPatchQC: begin
                   if Taille > 65520-SizeOf(TPatch) then
                    Erreur('QuakeC patch is too large (>64kb)');
                   SourceFile^.Seek(Position);
                   GetMem(NewCode, SizeOf(TPatch)+Taille);
                   NewCode^.Taille:=SizeOf(TPatch)+Taille;
                   NewCode^.Suivant:=Nil;
                   NextCode^:=NewCode;
                   NextCode:=@NewCode^.Suivant;
                   NewCode^.NomPatch:=CharToPas(Nom);
                   SourceFile^.Read(NewCode^.Code, Taille);
                   PChar(@NewCode^.Code)[Taille]:=#0;
                  end;
       qmBSP0: begin
                NomF:=NomFichierCarte(RepertoireQM^[I], Nil);
                if PremiereCarte='' then
                 PremiereCarte:=NomF;
                SourceFile^.Seek(Position);
                PreparerBSP(FichierSortie('maps/'+NomF+'.bsp'), SourceFile^);
               end;
       qmFileDef: begin
                   SourceFile^.Seek(Position);
                   SourceFile^.Read(T, SizeOf(T));
                   SourceFile^.Seek(Position+T+SizeOf(T));
                   SourceFile^.Read(T2, SizeOf(T2));
                   if T2>255 then
                    T2:=255;
                   NomF[0]:=Chr(T2);
                   SourceFile^.Read(NomF[1], T2);
                   if CompareText(Copy(NomF, 1, 9), 'progs.dat')=0 then
                    begin
                     NomF:=Copy(NomF, 10, MaxInt);
                     while (NomF<>'') and (NomF[1]=' ') do
                      Delete(NomF, 1,1);
                     while (NomF<>'') and (NomF[Length(NomF)]=' ') do
                      Dec(Byte(NomF[0]));
                     if NomF<>'' then
                      Val(NomF, Impulse0, J)
                     else
                      J:=-1;
                     if J<>0 then
                      Impulse0:=Impulse0Def;
                     NomF:='Progs.dat';
                    end;
                   F:=New(PDosStream, Init(FichierSortie(NomF), stCreate));
                   SourceFile^.Seek(Position+SizeOf(T));
                   F^.CopyFrom(SourceFile^, T);
                   Dispose(F, Done);
                  end;
       qmFileLnk: begin
                   SourceFile^.Seek(Position);
                   SourceFile^.Read(T2, SizeOf(T2));
                   if T2>255 then
                    T2:=255;
                   NomF[0]:=Chr(T2);
                   SourceFile^.Read(NomF[1], T2);
                   J:=Length(NomFichOrg);
                   while (J>0) and (NomFichOrg[J]<>'\') do
                    Dec(J);
                   F:=SourceFile;
                   NomTex:=NomF;
                   LowerCase(NomF);
                   NomF:=Copy(NomFichOrg,1,J)+NomF+'.qme';
                   if not Fichiers.Search(@NomF, J) then
                    begin
                     Fichiers.Insert(NewStr(NomF));
                     qmWrite('', 16*Blue);
                     qmWrite('Processing linked '+NomTex+'.qme...', LightRed+16*Black);
                     IF Ouvrir(NomF, Repertoire2, J) THEN
                      BEGIN
                       NomF:=PremiereCarte;
                       T2:=Ord(Descrip);
                       Descrip:=True;
                       Process(Repertoire2, J);
                       PremiereCarte:=NomF;
                       Descrip:=Boolean(T2);
                       FreeMem(Repertoire2, J*SizeOf(TEntreeRepQM));
                       Dispose(SourceFile, Done);
                       qmWrite('Linked file process O.K.', LightRed+16*Black);
                      END
                     ELSE
                      BEGIN
                       qmWrite('File not found. This file is probably required for playing correctly.',Yellow+16*Blue);
                       qmWrite('But you can try ignoring this error and going on. Do you want to go on ? Y/N',Yellow+16*Blue);
                       if Upcase(ReadKey)<>'Y' then
                        Erreur(' No');
                      END;
                     SourceFile:=F;
                     qmWrite('', 16*Blue);
                    end;
                  end;
      end;
     end;
 end;

 procedure EffacerTemp;
 var
  F: File;
  I: Integer;
 begin
  while NoTexture>0 do
   begin
    Str(NoTexture, NomF2);
    Assign(F, QuakeDir+'\QMapExec\temp\tex'+NomF2+'.tmp');
    {$I-}
    Erase(F);
    {$I+}
    I:=IOResult;
    Dec(NoTexture);
   end;
  {$I-}
  RmDir(QuakeDir+'\QMapExec\temp');
  {$I+}
  I:=IOResult;
 end;

 procedure Renommer;
 var
  F: File;
 begin
  Assign(F, FichierSortie('progs.dat'));
  Rename(F, FichierSortie('progs.bak'));
 end;

BEGIN
 Impulse0:=-1;
 New(TexturesUtilisees, Init(8,8));
 Code:=Nil;
 NextCode:=@Code;
 CmdLine:='';
 PremiereCarte:='';
 Fichiers.Init(4,4);
 NoTexture:=0;
 for FichierNo:=1 to ParamCount do
  begin
   if FichierNo>1 then
    qmWrite('', 16*Blue);
   OuvrirFichierNo(FichierNo);
   qmWrite('Processing '+NomFichOrg+'...', Yellow+16*Black);
   qmWrite('', 16*Blue);
   Descrip:=False;
   LowerCase(NomFichOrg);
   if not Fichiers.Search(@NomFichOrg, I) then
    begin
     Fichiers.Insert(NewStr(NomFichOrg));
     Process(RepertoireQM, NbEntrees);
    end;
  end;
 Fichiers.Done;
 if CmdLine<>'' then
  begin
   qmWrite('', 16*Blue);
   qmWrite('  these maps need rebuilding', Yellow+16*Blue);
   PetiteEtoile;
  end;
 New(Touches, Init(4,4));
 if Code<>Nil then
  begin
   qmWrite('', 16*Blue);
   if Impulse0>=0 then
    begin  { patch d'un fichier Progs.dat dj modifi }
     Renommer;
     F:=New(PBufStream, Init(FichierSortie('progs.bak'), stOpenRead, 1024));
    end
   else
    begin
     Impulse0:=Impulse0Def;
     OuvrirEntreeQuake('progs.dat', F);
    end;
   Compiler(Code, F, FichierSortie('progs.dat'), Touches^, Impulse0);
    { 'Compiler' frees F itself }
   while Code<>Nil do
    begin
     P:=Code^.Suivant;
     FreeMem(Code, Code^.Taille);
     Code:=P;
    end;
  end;
 if TexturesUtilisees^.Count>0 then
  begin
   qmWrite('', 16*Blue);
   Str(TexturesUtilisees^.Count, NomF2);
   qmWrite('Extracting the '+NomF2+' used textures...', Yellow+16*Blue);
   ExtraireTextures(TexturesUtilisees^, FichierSortie(NomWadTmp));
  end;
 Dispose(TexturesUtilisees, Done);
 if Descrip then
  VoirDescrip;
 if NoTexture>0 then
  EffacerTemp;
 qmWrite('', 16*Blue);
 qmWrite('Everything went O.K. Press Enter to launch Quake.', Yellow+16*Black);
 CmdLine:=CmdLine+' /q';
 if PremiereCarte<>'' then
  CmdLine:=CmdLine+' +map '+PremiereCarte;
END;

     {qmTextureLnk: begin
                     GetMem(P, Taille);
                     SourceFile^.Seek(Position);
                     SourceFile^.Read(P^, Taille);
                     S:='';
                     for T:=1 to Taille do
                      begin
                       if P^ in [#13,#10] then
                        begin
                         if S<>'' then
                          begin
                           TexturesUtilisees^.Insert(NewStr(S));
                           S:='';
                          end;
                        end
                       else
                        S:=S+P^;
                       Inc(P);
                      end;
                     if S<>'' then
                      TexturesUtilisees^.Insert(NewStr(S));
                    end;}
{Dest:=New(PBufStream, Init('QMDOSRT.TEX', stCreate, 512));
 TexturesUtilisees^.Store(Dest^);
 Dispose(Dest, Done);}

BEGIN
 Init;
 ControleQuakeDir;
 Vider(QuakeDir+'\QMapExec\');
 ProcessQME;
 InteractiveMode(True);
 AssociationTouches;
 if Pos(' /b ', CmdLine)<>0 then
  ControleToolDir;
 FinProgramme(CmdLine);
END.