// Textures.h : header file
//
#ifndef TEXTURES_H
#define TEXTURES_H

typedef union
{
	BYTE		chan[4];
	unsigned	p;
} pixel32_t;


typedef struct
{
	char	texture[16];
	float	rotate;
	float	shift[2];
	float	scale[2];
} texturedef_t;


typedef struct
{
	char		name[16];
	
	int			width;
	int			height;
	CDIB  	*rep;
  CGLImage *glimage;
	BYTE		*data;
	pixel32_t	flatcolor;
  BOOL    alreadyScaled;
} qtexture_t;

#define	MAX_TEXTURES	1024

extern	int					tex_count;
extern	qtexture_t 		qtextures[MAX_TEXTURES];

void	TEX_InitFromWad (char *path);
qtexture_t *TEX_ForName (char *name);


typedef struct
{
	CBitmap *image;		// NXImage
	CRect	r;
	char	*name;
	int		index;
	int		display;	// flag (on/off)
} texpal_t;

#define	TEX_INDENT	10
#define	TEX_SPACING	16

/////////////////////////////////////////////////////////////////////////////
// CTextures dialog

class CTextures : public CInspector
{
// Construction
public:
	
	CTextures();   // standard constructor
  ~CTextures();
  BOOL Create(CWnd *pWnd);

  // Dialog Data
	//{{AFX_DATA(CTextures)
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTextures)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	float m_YScale;
	float m_XScale;
	float m_Rotate;
	float m_YShift;
	float m_XShift;
	CString currentwad;
	int selectedTexture;
	CEdit m_wndSearch;
	CListBox m_wndTexList;
	CButton m_wndInUse;
	CTextureStatic m_wndTexture;

	// Generated message map functions
	//{{AFX_MSG(CTextures)
	afx_msg void OnSelchangeTexlist();
	afx_msg void OnUpdateTexsearch();
	afx_msg void OnClear();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:

 const char* getCurrentWad();
 void initPaletteFromWadfile(const char *wf);
 int getSelectedTexture();
 void setSelectedTexture(int which);
 int getSelectedTexIndex();
 // Called externally
 char *getSelTextureName();
 void setTextureByName(char *name);

// New methods to replace the 2 above ones
 void setTextureDef(texturedef_t *td);
 void getTextureDef(texturedef_t *td);
 int searchForTextureInPalette(const char *texture);
 void clearTexinfo();
 void texturedefChanged();
};

extern	CTextures *texturepalette_i;

#endif
