// Textures.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "Textures.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTextures   *texturepalette_i = NULL;

CDIBPal  texPalette;
CDC      dcDisplay;
BOOL     bFirstImage;

#define	TYP_MIPTEX	'D'

int					tex_count;
qtexture_t  qtextures[MAX_TEXTURES];

typedef struct
{
	char		name[16];
	unsigned	width, height;
	unsigned	offsets[4];		// four mip maps stored
} miptex_t;


unsigned badtex_d[] = 
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0,0,0,0,0,0,0,0,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff
};

qtexture_t	badtex = {"notexture",16,16,NULL, NULL, (BYTE *)badtex_d, {0,0,255,255}, FALSE};

BYTE defaultPalette[] = 
{
 0, 0, 0   ,
15, 15, 15 ,
31, 31, 31 ,
47, 47, 47 ,
63, 63, 63 ,
75, 75, 75 ,
91, 91, 91 ,
107, 107, 107  ,
123, 123, 123  ,
139, 139, 139  ,
155, 155, 155  ,
171, 171, 171  ,
187, 187, 187  ,
203, 203, 203  ,
219, 219, 219  ,
235, 235, 235  ,
15, 11, 7      ,
23, 15, 11     ,
31, 23, 11     ,
39, 27, 15     ,
47, 35, 19     ,
55, 43, 23     ,
63, 47, 23     ,
75, 55, 27     ,
83, 59, 27     ,
91, 67, 31     ,
99, 75, 31     ,
107, 83, 31    ,
115, 87, 31    ,
123, 95, 35    ,
131, 103, 35   ,
143, 111, 35   ,
11, 11, 15     ,
19, 19, 27     ,
27, 27, 39     ,
39, 39, 51     ,
47, 47, 63     ,
55, 55, 75     ,
63, 63, 87     ,
71, 71, 103    ,
79, 79, 115    ,
91, 91, 127    ,
99, 99, 139    ,
107, 107, 151  ,
115, 115, 163  ,
123, 123, 175  ,
131, 131, 187  ,
139, 139, 203  ,
0, 0, 0        ,
7, 7, 0        ,
11, 11, 0      ,
19, 19, 0      ,
27, 27, 0      ,
35, 35, 0      ,
43, 43, 7      ,
47, 47, 7      ,
55, 55, 7      ,
63, 63, 7      ,
71, 71, 7      ,
75, 75, 11     ,
83, 83, 11     ,
91, 91, 11     ,
99, 99, 11     ,
107, 107, 15   ,
7, 0, 0        ,
15, 0, 0       ,
23, 0, 0       ,
31, 0, 0       ,
39, 0, 0       ,
47, 0, 0       ,
55, 0, 0       ,
63, 0, 0       ,
71, 0, 0       ,
79, 0, 0       ,
87, 0, 0       ,
95, 0, 0       ,
103, 0, 0      ,
111, 0, 0      ,
119, 0, 0      ,
127, 0, 0      ,
19, 19, 0      ,
27, 27, 0      ,
35, 35, 0      ,
47, 43, 0      ,
55, 47, 0      ,
67, 55, 0      ,
75, 59, 7      ,
87, 67, 7      ,
95, 71, 7      ,
107, 75, 11    ,
119, 83, 15    ,
131, 87, 19    ,
139, 91, 19    ,
151, 95, 27    ,
163, 99, 31    ,
175, 103, 35   ,
35, 19, 7      ,
47, 23, 11     ,
59, 31, 15     ,
75, 35, 19     ,
87, 43, 23     ,
99, 47, 31     ,
115, 55, 35    ,
127, 59, 43    ,
143, 67, 51    ,
159, 79, 51    ,
175, 99, 47    ,
191, 119, 47   ,
207, 143, 43   ,
223, 171, 39   ,
239, 203, 31   ,
255, 243, 27   ,
11, 7, 0       ,
27, 19, 0      ,
43, 35, 15     ,
55, 43, 19     ,
71, 51, 27     ,
83, 55, 35     ,
99, 63, 43     ,
111, 71, 51    ,
127, 83, 63    ,
139, 95, 71    ,
155, 107, 83   ,
167, 123, 95   ,
183, 135, 107  ,
195, 147, 123  ,
211, 163, 139  ,
227, 179, 151  ,
171, 139, 163  ,
159, 127, 151  ,
147, 115, 135  ,
139, 103, 123  ,
127, 91, 111   ,
119, 83, 99    ,
107, 75, 87    ,
95, 63, 75     ,
87, 55, 67     ,
75, 47, 55     ,
67, 39, 47     ,
55, 31, 35     ,
43, 23, 27     ,
35, 19, 19     ,
23, 11, 11     ,
15, 7, 7       ,
187, 115, 159  ,
175, 107, 143  ,
163, 95, 131   ,
151, 87, 119   ,
139, 79, 107   ,
127, 75, 95    ,
115, 67, 83    ,
107, 59, 75    ,
95, 51, 63     ,
83, 43, 55     ,
71, 35, 43     ,
59, 31, 35     ,
47, 23, 27     ,
35, 19, 19     ,
23, 11, 11     ,
15, 7, 7       ,
219, 195, 187  ,
203, 179, 167  ,
191, 163, 155  ,
175, 151, 139  ,
163, 135, 123  ,
151, 123, 111  ,
135, 111, 95   ,
123, 99, 83    ,
107, 87, 71    ,
95, 75, 59     ,
83, 63, 51     ,
67, 51, 39     ,
55, 43, 31     ,
39, 31, 23     ,
27, 19, 15     ,
15, 11, 7      ,
111, 131, 123  ,
103, 123, 111  ,
95, 115, 103   ,
87, 107, 95    ,
79, 99, 87     ,
71, 91, 79     ,
63, 83, 71     ,
55, 75, 63     ,
47, 67, 55     ,
43, 59, 47     ,
35, 51, 39     ,
31, 43, 31     ,
23, 35, 23     ,
15, 27, 19     ,
11, 19, 11     ,
7, 11, 7       ,
255, 243, 27   ,
239, 223, 23   ,
219, 203, 19   ,
203, 183, 15   ,
187, 167, 15   ,
171, 151, 11   ,
155, 131, 7    ,
139, 115, 7    ,
123, 99, 7     ,
107, 83, 0     ,
91, 71, 0      ,
75, 55, 0      ,
59, 43, 0      ,
43, 31, 0      ,
27, 15, 0      ,
11, 7, 0       ,
0, 0, 255      ,
11, 11, 239    ,
19, 19, 223    ,
27, 27, 207    ,
35, 35, 191    ,
43, 43, 175    ,
47, 47, 159    ,
47, 47, 143    ,
47, 47, 127    ,
47, 47, 111    ,
47, 47, 95     ,
43, 43, 79     ,
35, 35, 63     ,
27, 27, 47     ,
19, 19, 31     ,
11, 11, 15     ,
43, 0, 0       ,
59, 0, 0       ,
75, 7, 0       ,
95, 7, 0       ,
111, 15, 0     ,
127, 23, 7     ,
147, 31, 7     ,
163, 39, 11    ,
183, 51, 15    ,
195, 75, 27    ,
207, 99, 43    ,
219, 127, 59   ,
227, 151, 79   ,
231, 171, 95   ,
239, 191, 119  ,
247, 211, 139  ,
167, 123, 59   ,
183, 155, 55   ,
199, 195, 55   ,
231, 227, 87   ,
127, 191, 255  ,
171, 231, 255  ,
215, 255, 255  ,
103, 0, 0      ,
139, 0, 0      ,
179, 0, 0      ,
215, 0, 0      ,
255, 0, 0      ,
255, 243, 147  ,
255, 247, 199  ,
255, 255, 255  ,
159, 91, 83    
};             
               
/*             
==============  
TEX_InitPalette 
==============  
*/              
                
#define BRIGHT_FACTOR 1.5
               
BYTE Brighten(BYTE b)
{              
  UINT bb = b*BRIGHT_FACTOR;
  if(bb>255)   
    bb = 255;  
  return bb;   
}

RGBQUAD quakePalette[256];

void TEX_InitPalette (BYTE *pal)
{
  for (int i=0 ; i<256 ; i++)
	{
    quakePalette[i].rgbRed = Brighten(pal[0]);
		quakePalette[i].rgbGreen = Brighten(pal[1]);
		quakePalette[i].rgbBlue = Brighten(pal[2]);
		quakePalette[i].rgbReserved = NULL;
    pal += 3;
	}
}

/*
=================
TEX_ImageFromMiptex
=================
*/

void TEX_InitBadTex()
{
  BITMAPINFO *pBmpInfo = (BITMAPINFO *)SafeMalloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD)*256);
  BITMAPINFOHEADER &bmpHeader = pBmpInfo->bmiHeader;
  bmpHeader.biSize = sizeof(bmpHeader);
  bmpHeader.biWidth = badtex.width;
  bmpHeader.biHeight = badtex.height;
  bmpHeader.biPlanes = 1;
  bmpHeader.biBitCount = 8;
  bmpHeader.biCompression = BI_RGB;
  bmpHeader.biSizeImage = 0;
  bmpHeader.biXPelsPerMeter = 1000;
  bmpHeader.biYPelsPerMeter = 1000;
  bmpHeader.biClrUsed = 0;
  bmpHeader.biClrImportant = 0;
  
  for(int i = 0; i < 256; i++)
    pBmpInfo->bmiColors[i] = quakePalette[i];

  CDIB *pDIB = new CDIB;
  pDIB->Create(pBmpInfo,badtex.data);
  
  if(bFirstImage)
  {
    bFirstImage = FALSE;
    if (texPalette.m_hObject)
      texPalette.DeleteObject();
    texPalette.Create(pDIB);
  }
  
  pDIB->MapColorsToPalette(&texPalette);

  badtex.rep = pDIB;    	
  badtex.glimage = new CGLImage;
  badtex.glimage->Load(*pDIB);
  badtex.alreadyScaled = FALSE;
  
  free(pBmpInfo);


}

void TEX_ImageFromMiptex (miptex_t *qtex)
{
  BYTE		*source,*dest;
	int			width, height, count, i ,j, index;
  unsigned tr,tg,tb;
	qtexture_t	*q;
	
	width = LittleLong(qtex->width);
	height = LittleLong(qtex->height);
	count = width * height;

	source = (BYTE *)qtex + LittleLong(qtex->offsets[0]);
  dest = (BYTE *)SafeMalloc(count);

  tr = tg = tb = 0;
	index = 0;

  for (j = 0; j < height; j++)
	  for (i = 0 ; i < width ; i++, index++)
	  {
		  dest[index] = source[(height - j - 1) * width + i];
		  tr += quakePalette[dest[index]].rgbRed;
		  tg += quakePalette[dest[index]].rgbGreen;
		  tb += quakePalette[dest[index]].rgbBlue;
	  }

  BITMAPINFO *pBmpInfo = (BITMAPINFO *)SafeMalloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD)*256);
  BITMAPINFOHEADER &bmpHeader = pBmpInfo->bmiHeader;
  bmpHeader.biSize = sizeof(bmpHeader);
  bmpHeader.biWidth = width;
  bmpHeader.biHeight = height;
  bmpHeader.biPlanes = 1;
  bmpHeader.biBitCount = 8;
  bmpHeader.biCompression = BI_RGB;
  bmpHeader.biSizeImage = 0;
  bmpHeader.biXPelsPerMeter = 1000;
  bmpHeader.biYPelsPerMeter = 1000;
  bmpHeader.biClrUsed = 0;
  bmpHeader.biClrImportant = 0;
  
  for(i = 0; i < 256; i++)
    pBmpInfo->bmiColors[i] = quakePalette[i];

  CDIB *pDIB = new CDIB;
  pDIB->Create(pBmpInfo,dest);
  
  if(bFirstImage)
  {
    bFirstImage = FALSE;
    if (texPalette.m_hObject)
      texPalette.DeleteObject();
    texPalette.Create(pDIB);
  }
  
  pDIB->MapColorsToPalette(&texPalette);

  q = &qtextures[tex_count];
	tex_count++;
	
	q->width = width;
	q->height = height;
  q->rep = pDIB;    	
  q->data = dest;
  q->flatcolor.chan[0] = tr / count;
	q->flatcolor.chan[1] = tg / count;
	q->flatcolor.chan[2] = tb / count;
	q->flatcolor.chan[3] = 0xff;	
  q->glimage = new CGLImage;
  q->glimage->Load(*pDIB);
  q->alreadyScaled = FALSE;
  
  free(pBmpInfo);
}

//=============================================================================

typedef struct
{
	char		identification[4];		// should be WAD2 or 2DAW
	int			numlumps;
	int			infotableofs;
} wadinfo_t;


typedef struct
{
	int			filepos;
	int			disksize;
	int			size;					// uncompressed
	char		type;
	char		compression;
	char		pad1, pad2;
	char		name[16];				// must be null terminated
} lumpinfo_t;

void TEX_FreeTextures()
{
  // free any textures
	for (int i=0 ; i<tex_count ; i++)
  {
    if (qtextures[i].rep)
    {
      delete qtextures[i].rep;
      qtextures[i].rep = NULL;
    }
    if (qtextures[i].data)
      free(qtextures[i].data);

    if (qtextures[i].glimage)
    {
      delete qtextures[i].glimage;
      qtextures[i].glimage = NULL;
    }
  }
	tex_count = 0;

  if(badtex.rep)
  {
    delete badtex.rep;
    badtex.rep = NULL;
  }

  if(badtex.glimage)
  {
    delete badtex.glimage;
    badtex.glimage = NULL;
  }
}

/*
=================
TEX_InitFromWad
=================
*/
void	TEX_InitFromWad (const char *path)
{
	int			i;
	char		local[1024];
	char		newpath[1024];
	BYTE		*wadfile;
	wadinfo_t	*wadinfo;
	lumpinfo_t	*lumpinfo;
	int			numlumps;

	strcpy(newpath, preferences_i->getProjectPath());
	strcat(newpath,"\\");
	strcat(newpath, path);

  TEX_FreeTextures();

  strcpy(local,newpath);

///////////////////////////////  
  FILE *fp = fopen(local,"rb");
  if (fp == NULL)
  {
    qprintf("Wad file %s does not exists",path);
    return;
  }
  else 
    fclose(fp);
///////////////////////////////

  LoadFile (local, (void **)&wadfile);
	wadinfo = (wadinfo_t *)wadfile;
	
	if (strncmp ((char *)wadfile, "WAD2", 4))
	{
		qprintf("TEX_InitFromWad: %s isn't a wadfile", newpath);
    MessageBeep(MB_ICONEXCLAMATION);
    free (wadfile);
    return;
	}
	
	numlumps = LittleLong (wadinfo->numlumps);
	lumpinfo = (lumpinfo_t *)(wadfile + LittleLong (wadinfo->infotableofs));
	
  int startIndex;
  
  bFirstImage = TRUE;

	if (strcmp (lumpinfo->name, "PALETTE"))
	{
		qprintf("TEX_InitFromWad: %s doesn't have palette as 0",path);
    qprintf("Using default palette");
    
    MessageBeep(MB_ICONEXCLAMATION);
    
    TEX_InitPalette (defaultPalette);
    startIndex = 0;
	}
	else
  {
    TEX_InitPalette (wadfile + LittleLong(lumpinfo->filepos));
    
    lumpinfo++;	
    startIndex = 1;
  }
	
  TEX_InitBadTex();
  
  for (i = startIndex ; i<numlumps ; i++, lumpinfo++)
	{
		if (lumpinfo->type != TYP_MIPTEX)
    {
      qprintf("TEX_InitFromWad: %s is not a miptex!",lumpinfo->name);
      MessageBeep(MB_ICONEXCLAMATION);
      continue;
    }
		CleanupName (lumpinfo->name,qtextures[tex_count].name);
		TEX_ImageFromMiptex ( (miptex_t *)(wadfile + 
			LittleLong(lumpinfo->filepos) ));
	}
	free (wadfile);
}

/*
=================
TEX_NumForName
=================
*/
qtexture_t *TEX_ForName (char *name)
{
	char	newname[16];
	int		i;
	qtexture_t	*q;
	
	CleanupName (name, newname);
	
	for (i=0,q = qtextures ; i< tex_count ; i++, q++)
	{
		if (!strcmp(name, q->name))
			return q;
	}
	
	return &badtex;
}

/////////////////////////////////////////////////////////////////////////////
// CTextures dialog

CTextures::CTextures()
{
	texturepalette_i = this;
	selectedTexture = -1;
  m_XScale = 1;
  m_YScale = 1;
  m_Rotate = 0;
  m_XShift = 0;
  m_YShift = 0;
}

CTextures::~CTextures()
{
  TEX_FreeTextures();
  if(texPalette.m_hObject)
    texPalette.DeleteObject();
}

void CTextures::DoDataExchange(CDataExchange* pDX)
{
	CInspector::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextures)
  DDX_Control(pDX,IDC_INUSE,m_wndInUse);
  DDX_Control(pDX,IDC_TEXLIST,m_wndTexList);
  DDX_Control(pDX,IDC_TEXTURE,m_wndTexture);
  DDX_Control(pDX,IDC_TEXSEARCH,m_wndSearch);
	DDX_Text(pDX,IDC_XSHIFT,m_XShift);
  DDX_Text(pDX,IDC_YSHIFT,m_YShift);
  DDX_Text(pDX,IDC_XSCALE,m_XScale);
  DDX_Text(pDX,IDC_YSCALE,m_YScale);
  DDX_Text(pDX,IDC_ROTATE,m_Rotate);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTextures, CInspector)
	//{{AFX_MSG_MAP(CTextures)
	ON_LBN_SELCHANGE(IDC_TEXLIST, OnSelchangeTexlist)
	ON_EN_UPDATE(IDC_TEXSEARCH, OnUpdateTexsearch)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextures message handlers

BOOL CTextures::Create(CWnd *pParent)
{
  if(!CInspector::Create(pParent,IDD_TEXTURES))
  {
		return FALSE;    // fail to create
  }
  
  SetWindowText("Textures");
  return TRUE;
}

const char *CTextures::getCurrentWad()
{
	return currentwad;
}

void CTextures::initPaletteFromWadfile(const char *wf)
{
	int			i;
	texpal_t	t;
	qtexture_t	*q;
	
	currentwad = wf;
  
  map_i->makeGlobalPerform(BRUSH_FLUSHTEXTURES);	
	
  selectedTexture = -1;
	
	// Init textures WAD
	TEX_InitFromWad(wf);
	
	// Create STORAGE
	m_wndTexList.ResetContent();
	
	for (i = 0,q = qtextures;i < tex_count; i++,q++)
	{
		int index = m_wndTexList.AddString(q->name);
    m_wndTexList.SetItemData(index,i);
	}

	// Calculate size of TextureView
	setSelectedTexture(0);
}

//
//	Set the selected texture
//
void CTextures::setSelectedTexture(int which)
{
// wipe the fields
	clearTexinfo();
	if (which != selectedTexture)
	{
		selectedTexture = which;
		m_wndTexture.SetTexture(qtextures[m_wndTexList.GetItemData(selectedTexture)].rep,&texPalette);
    m_wndTexList.SetCurSel(which);
	}

	texturedefChanged();
}

//
//	Return the selected texture index
//
int CTextures::getSelectedTexture()
{
	return selectedTexture;
}

//
//	Return the original tex_ index of the selected texture
//	so the texture info can be indexed from tex_images, etc.
//

int CTextures::getSelectedTexIndex()
{
	if (selectedTexture == -1)
		return -1;
	return m_wndTexList.GetItemData(selectedTexture);
}

//
//	Return the name of the selected texture
//
char *CTextures::getSelTextureName()
{
	return qtextures[getSelectedTexIndex()].name;
}

//
//	Set selected texture by texture name
//
void CTextures::setTextureByName(char *name)
{
	int		i;
	int		max;
	
	max = m_wndTexList.GetCount();
	CleanupName(name,name);
	for (i = 0;i < max;i++)
	{
		int index = m_wndTexList.GetItemData(i);
		if (strcmp(qtextures[index].name,name) == 0)
		{
			setSelectedTexture(i);
			return;
		}
	}
}

void CTextures::OnSelchangeTexlist() 
{
	setSelectedTexture(m_wndTexList.GetCurSel());
}

void CTextures::OnUpdateTexsearch() 
{
  char texName[256];
  m_wndSearch.GetWindowText(texName,sizeof(texName));
  setTextureByName(texName);
}

//
//	Set texture def from outside TexturePalette
//
void CTextures::setTextureDef(texturedef_t *td)
{
	setTextureByName(td->texture);
  m_XShift = td->shift[0];
  m_YShift = td->shift[1];
  m_XScale = td->scale[0];
  m_YScale = td->scale[1];
  m_Rotate = td->rotate;
  UpdateData(FALSE);
	texturedefChanged();
}

//
//	Return the current texture def to passed *
//
void CTextures::getTextureDef(texturedef_t *td)
{
	if (selectedTexture == -1)
	{
		memset (td, 0, sizeof(*td));
		strcpy (td->texture, "notexture");
		return;
	}
	
	strncpy(td->texture,getSelTextureName(),16);
  UpdateData(TRUE);
  td->shift[0] = m_XShift;
  td->shift[1] = m_YShift;
  td->scale[0] = m_XScale;
  td->scale[1] = m_YScale;
  td->rotate = m_Rotate;
}

//
//	Search for texture in entire palette
//	Return index of texturedef, or -1 if unsuccessful
//
int CTextures::searchForTextureInPalette(const char *texture)
{
	int		i;
	int		max;
	char	name[32];
	
	if (selectedTexture == -1)
		return -1;

	max = m_wndTexList.GetCount();
	strcpy(name,texture);
	
	for (i = 0; i < max; i++)
	{
		int index= m_wndTexList.GetItemData(i);
		if (strcmp(qtextures[index].name,name) == 0)
			return i;
	}
	return -1;
};


void CTextures::texturedefChanged()
{
  if (!map_i)
    return;
  if (map_i->numSelected())
	{
		if ( map_i->getCurrentEntity()->getModifiable() )
		{
			map_i->makeSelectedPerform(BRUSH_TAKECURRENTTEXTURE);
			quakeed_i->updateAll();
		}
		else
			qprintf ("can't modify spawned entities");
	}
#ifndef PORTING
  [quakeed_i makeFirstResponder: quakeed_i];
#endif
}

void CTextures::clearTexinfo()
{
	m_XShift = 0;
  m_YShift = 0;
  m_XScale = 1;
  m_YScale = 1;
  m_Rotate = 0;
  UpdateData(FALSE);
  
  texturedefChanged();
}

void CTextures::OnClear() 
{
	clearTexinfo();
}
