// QuakeView.h : header file
//
#ifndef QUAKEVIEW_H
#define QUAKEVIEW_H

/////////////////////////////////////////////////////////////////////////////
// CQuakeView view

class CQuakeView : public CView
{
protected:
	CDC * m_pDC;
	CPoint m_ViewportOffset;
	void UpdateSizes();
	CSize m_ClientSize;
	CSize m_MapSize;
	void UpdateVisRect();
	CRect m_VisibleRect;
	virtual BOOL FlipY();
	virtual BOOL FlipX();
	CPoint m_Offset;
	double m_nScale;
  CRect m_ClientRect;
  CClientDC * m_pClientDC;
	BOOL m_bDrag;
	BOOL m_bUg;
  

	CQuakeView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CQuakeView)

// Attributes
public:
	virtual void MapToWindow(CPoint&,CDC *myDC = NULL);
	virtual void MapToWindow(CRect&,CDC *myDC = NULL);
  virtual void WindowToMap(CPoint&,CDC *myDC = NULL);
	virtual void WindowToMap(CRect&,CDC *myDC = NULL);
	CRect GetVisibleRect();

// Operations
public:
 	CPoint GetPosition();
  void SetPosition(CPoint&);
	double GetScale();
  void SetScale(double nScale);
  virtual void lockFocus(BOOL bXorMode = FALSE);
  void unlockFocus();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuakeView)
	public:
	virtual void OnInitialUpdate();
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CQuakeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CQuakeView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif
/////////////////////////////////////////////////////////////////////////////
