// QZView.cpp : implementation file
//

#include "stdafx.h"
#include "QuakeEdit.h"
#include "QZView.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ZView
ZView *zview_i;
float	zplane = 0;
float	zplanedir = 0;

IMPLEMENT_DYNCREATE(ZView, CQuakeView)

ZView::ZView()
{
  zview_i = this;
  scale = 1;
	origin[0] = 0.333;
	origin[1] = 0.333;
  m_bDrag = FALSE;
}

ZView::~ZView()
{
}


BEGIN_MESSAGE_MAP(ZView, CQuakeView)
	//{{AFX_MSG_MAP(ZView)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ZView drawing

void ZView::OnDraw(CDC* pDC)
{
  DC_AttachDC(pDC->m_hDC);
  DC_LockAttachedDC(); 
  
  DC_SetFont("MS Sans Serif",10);

  CRect rect = GetVisibleRect();

  drawGrid(&rect);
	
// draw zplane
  drawZplane();
  
// draw all entities
  map_i->makeAllPerform(BRUSH_ZDRAW_SELF);

  cameraview_i->ZDrawSelf();
  clipper_i->ZDrawSelf();
  
  DC_UnLockAttachedDC();
  DC_DetachDC();
}

/////////////////////////////////////////////////////////////////////////////
// ZView diagnostics

#ifdef _DEBUG
void ZView::AssertValid() const
{
	CQuakeView::AssertValid();
}

void ZView::Dump(CDumpContext& dc) const
{
	CQuakeView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// ZView message handlers

void ZView::OnInitialUpdate() 
{
	CQuakeView::OnInitialUpdate();
}

void ZView::getPoint(CPoint *p)
{
  p->x = origin[0];
  p->y = origin[1];
}

void ZView::getPoint(vec3_t p)
{
  p[0] = origin[0];
  p[1] = origin[1];
}

void ZView::setXYOrigin(CPoint *pt)
{
	origin[0] = pt->x;
	origin[1] = pt->y;
}

void ZView::setPoint(CPoint *pt)
{
	origin[0] = pt->x;
	origin[1] = pt->y;
}


/*
============
drawGrid

Draws tile markings every 64 units, and grid markings at the grid scale if
the grid lines are >= 4 pixels apart

Rect is in global world (unscaled) coordinates
============
*/
void ZView::drawGrid(const CRect *rect)
{
	int		y, stopy;
	float	top,bottom;
	int		left, right;
	int		gridsize;
	char	text[10];
	BOOL	showcoords;
	
  if(!preferences_i->GetGrid())
    return;

  showcoords = quakeed_i->showCoordinates();
		
	gridsize = xyview_i->getGridsize();
	
	left = rect->left;
	right = 24;
	
	bottom = rect->bottom - 1;
	top = rect->top + 2;

//
// grid
//
// can't just divide by grid size because of negetive coordinate
// truncating direction
//

  SetColor(COLOR_GRID);	// thin grid color

	if (gridsize>= 4/scale)
	{
		y = floor(bottom/gridsize);
		stopy = floor(top/gridsize);
		
		y *= gridsize;
		stopy *= gridsize;
		if (y<bottom)
			y+= gridsize;
			
		for ( ; y<=stopy ; y+= gridsize)
			if (y&31)
			{
				Line(left, y,right, y);
			}
	}

//
// half tiles
//
	y = floor(bottom/32);
	stopy = floor(top/32);
	
	if ( ! (((int)y + 4096) & 1) )
		y++;
	y *= 32;
	stopy *= 32;
	if (stopy >= top)
		stopy -= 32;
	
	
	for ( ; y<=stopy ; y+= 64)
	{
		Line(left, y, right, y);
	}


//
// tiles
//
	y = floor(bottom/64);
	stopy = floor(top/64);
	
	y *= 64;
	stopy *= 64;
	if (y<bottom)
		y+= 64;
	if (stopy >= top)
		stopy -= 64;
		
	for ( ; y<=stopy ; y+= 64)
	{
		if (showcoords)
		{
			sprintf (text, "%i",y);
			DC_TextOut(left,y + 5,text);
		}
		Line(left+24, y, right, y);
	}

// divider
	SetColor(COLOR_DIVIDER);	// thin grid color
  Line(0, rect->top, 0, rect->bottom);

//
// origin
//
	SetColor(COLOR_ORIGIN);
	Line(right,0,left,0);
}

void ZView::drawZplane()
{
	SetColor(COLOR_ZPLANE);
	Circle(0,zplane,4);
}


/*
===============
XYmouseDown
===============
*/
BOOL ZView::XYmouseDown(CPoint *pt)
{	
	vec3_t		movemod;
	
	if (fabs(pt->x - origin[0]) > 16
	||  fabs(pt->y - origin[1]) > 16)
		return NO;
		
	movemod[0] = 1;
	movemod[1] = 1;
	movemod[2] = 0;
	
	modalMoveLoop(pt,movemod, xyview_i);
	
	return YES;
}

/*
================
modalMoveLoop
================
*/
void ZView::modalMoveLoop(CPoint *basept, vec3_t movemod,CQuakeView *converter)
{
	vec3_t		originbase;	
	MSG msg;
	CPoint		newpt;
	vec3_t		delta;
	
	int			i;
	
	VectorCopy (origin, originbase);	
	
//
// modal event loop using instance drawing
//
  converter->SetCapture();
  quakeed_i->updateZCheckerInstance();

	goto drawentry;

	while (msg.message != WM_LBUTTONUP)
	{
    newpt = CPoint(LOWORD(msg.lParam),HIWORD(msg.lParam));
    converter->WindowToMap(newpt);

    quakeed_i->updateZCheckerInstance();

    delta[0] = newpt.x-basept->x;
		delta[1] = newpt.y-basept->y;
		delta[2] = delta[1];		// height change
		
		for (i=0 ; i<3 ; i++)
			origin[i] = originbase[i]+movemod[i]*delta[i];
		
					
drawentry:
		//
		// instance draw new frame
		//
    Invalidate();
    UpdateWindow();

    quakeed_i->updateZCheckerInstance();

		GetMessage(&msg,converter->m_hWnd,WM_MOUSEFIRST,WM_MOUSELAST);
	}
//
// draw the brush back into the window buffer
//
	xyview_i->Invalidate();
	
	ReleaseCapture();
}
/*
==============
XYDrawSelf
==============
*/
void ZView::XYDrawSelf()
{
	SetColor(COLOR_ZCHECKER);
  Line(origin[0]-16, origin[1]-16,origin[0]+16,origin[1]+16);
	Line(origin[0]-16, origin[1]+16,origin[0]+16,origin[1]-16);
}

static CPoint startpt;
static	CPoint oldreletive;
static 	CPoint reletive;
static SetBrush *selBrush = NULL;

void ZView::OnMouseMove(UINT nFlags, CPoint point) 
{
  if (m_bDrag)
  {
    CPoint delta;
    WindowToMap(point,m_pClientDC);
	
		reletive.y = point.y - startpt.y;
		
		if (m_bUg)
		{	// we want truncate towards 0 behavior here
			reletive.y = m_Gridsize * (int)(reletive.y / m_Gridsize);
		}

		if (reletive.y == oldreletive.y)
			return;

		delta.y = reletive.y - oldreletive.y;
		oldreletive = reletive;			
		m_Callback (delta.y);		
  }
}

void ZView::OnLButtonDown(UINT nFlags, CPoint point) 
{
  BOOL bAltDown = (GetKeyState(VK_MENU) & 0x8000) != 0;
  vec3_t	p1;

  nFlags &= (MK_SHIFT | MK_CONTROL);

  WindowToMap(point);
  
  p1[0] = origin[0];
	p1[1] = origin[1];
	p1[2] = point.y;

  if (nFlags == MK_SHIFT && !bAltDown)
	{		
		map_i->selectRay(p1,p1,NO);
		return;
	}
//
// alt click = set entire brush texture
//
	if (nFlags == 0 && bAltDown)
	{
		map_i->setTextureRay(p1,p1,YES);
		return;
	}

//
// control click = position view
//
	if (nFlags == MK_CONTROL && !bAltDown)
	{
    cameraview_i->setZOrigin(point.y);
		quakeed_i->updateAll();
		cameraview_i->ZmouseDown(&point,nFlags);
		return;
	}

//
// bare click to drag icons or new brush drag
//
	if (nFlags == 0 && !bAltDown)
	{
// check eye
		if ( cameraview_i->ZmouseDown(&point,nFlags))
			return;
		if (map_i->numSelected())
		{
			if ( point.x > 0)
			{
				if (planeDragFrom(&point))
					return;
			}
			selectionDragFrom(&point);
			return;
		}

	}
	qprintf ("bad flags for click");
}

void ZView::OnLButtonUp(UINT nFlags, CPoint point) 
{
  if(m_bDrag)
  {
	  if(m_pClientDC)
    {
      delete m_pClientDC;
      m_pClientDC = NULL;
    }
    if (selBrush)
    {
      selBrush->removeIfInvalid();
    }
    m_bDrag = FALSE;
  }
  
  selBrush = NULL;
  
  if(::GetCapture() == m_hWnd)
    ReleaseCapture();
}


void ZView::dragFrom(CPoint *startevent,BOOL ug,void (*callback)(float))
{
  m_Callback = callback;
  m_bUg = ug;
  m_bDrag = TRUE;
  
  startpt = *startevent;
  m_pClientDC = new CClientDC(this);
  OnPrepareDC(m_pClientDC);
  
  SetCapture();

	m_Gridsize = xyview_i->getGridsize();
	
	oldreletive.x = oldreletive.y = 0;
}

//============================================================================


void ZDragCallback (float dy)
{
	sb_translate[0] = 0;
	sb_translate[1] = 0;
	sb_translate[2] = dy;

  quakeed_i->redrawInstance();

	map_i->makeSelectedPerform(BRUSH_TRANSLATE);
	
	quakeed_i->redrawInstance();
}

void ZView::selectionDragFrom(CPoint *pt)
{
	qprintf ("dragging selection");
	dragFrom(pt,YES,ZDragCallback);
}

//============================================================================

void ZControlCallback (float dy)
{
	int		i;
	
	for (i=0 ; i<numcontrolpoints ; i++)
		controlpoints[i][2] += dy;
	
  quakeed_i->redrawInstance();
	
  map_i->selectedBrush()->calcWindings();	
	
  quakeed_i->redrawInstance();
}

BOOL ZView::planeDragFrom(CPoint *pt)
{
	vec3_t			dragpoint;
	
	if (map_i->numSelected() != 1)
		return NO;

	dragpoint[0] = origin[0];
	dragpoint[1] = origin[1];
	dragpoint[2] = pt->y;
	
	map_i->selectedBrush()->getZdragface(dragpoint);
	if (!numcontrolpoints)
		return NO;
	
	qprintf ("dragging brush plane");
	
	dragFrom(pt,YES,ZControlCallback);
	
	selBrush = map_i->selectedBrush();

#ifndef PORTING	
	[quakeed_i updateCamera];
#endif
  
  return YES;
}

BOOL ZView::FlipY()
{
  return TRUE;
}
