#include "stdafx.h"
#include "qedefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


Entity *carve_in,*carve_out;

/*
==================
textureAxisFromPlane
==================
*/

//=============================================================================


Map  *map_i = NULL;

Map::Map()
{
  map_i = this;
  minz = 0;
  maxz = 80;
  currentEntity = NULL;
  oldselection = new Entity;
  abortEnabled = FALSE;
}

Map::~Map()
{
  if (oldselection)
	  delete oldselection;
  for(int i = 0; i < GetSize(); i++)
    delete GetAt(i);
  
  RemoveAll();
}

void Map::saveSelected()
{
  int   i, c;
  Entity *w;  // world
  SetBrush  *o;
  
  if(!GetSize())
	  return;

  if (oldselection)
    delete oldselection;
  
  oldselection = new Entity;

  
  sb_newowner = oldselection;
  
  for(int j = 0; j < GetSize(); j++)
  {
    w = GetAt(j);
    c = w->GetSize();
    for (i=0 ; i<c ; i++)
    {
      o = w->GetAt(0);
      if (o->getSelected())
        o->moveToEntity();
      else
      {
        w->RemoveAt(0);
        delete o;
      }
    }
  }
  
  c = GetSize();
  for (i=0 ; i<c ; i++)
  {
    w = GetAt(0);
    RemoveAt(0);
  //  o->freeObjects();
	// o->remove(); // ?
    delete w;
  }
}

void Map::addSelected()
{
  int   i, c;
  Entity *w;
  SetBrush *n;
  
  c = oldselection->GetSize();
  w = GetAt(0); // world object

  sb_newowner = w;
  for (i=0 ; i<c ; i++)
  {
    n = oldselection->GetAt(i);
    n->moveToEntity();
    i--;
    c--;
  }
  // oldselection->RemoveAll(); since all brushes removed entity destroyed
  oldselection = new Entity;
}


void Map::newMap()
{
  Entity *ent;
  
  saveSelected();
  ent = new Entity;
  ent->initClass("worldspawn");
  Add(ent);
  currentEntity = NULL;
  setCurrentEntity(ent);
  addSelected();
  GetAt(0)->setKey("wad",(char *)texturepalette_i->getCurrentWad());
}

Entity *Map::getCurrentEntity()
{
  return currentEntity;
}

void Map::setCurrentEntity(Entity *ent)
{
  Entity *old;
  
  old = currentEntity;
  currentEntity = ent;
  if (old != ent)
  {
	  things_i->newCurrentEntity();  // update inspector
  }
}

float Map::currentMinZ()
{
  float grid;
  grid = xyview_i->getGridsize();
  minz = grid * rint(minz/grid);
  return minz;
}

void Map::setCurrentMinZ(float m)
{
  if (m > -2048)
    minz = m;
}

float Map::currentMaxZ()
{
  float grid;
  
  currentMinZ(); // grid align
  grid = xyview_i->getGridsize();  
  maxz = grid * rint(maxz/grid);

  if (maxz <= minz)
    maxz = minz + grid;
  return maxz;
}

void Map::setCurrentMaxZ(float m)
{
  if (m < 2048)
    maxz = m;
}

void Map::removeObject(CObject *o)
{
  for(int i = 0; i < GetSize(); i++)
    if(GetAt(i) == o)
    {
      delete GetAt(i);
      RemoveAt(i);
    }  
  
  if (o == currentEntity)
  { // select the world
    setCurrentEntity(GetAt(0));
  }

}

int Map::numSelected()
{
  int   i, c;
  int   num;
  
  num = 0;
  if (currentEntity)
  {
    c = currentEntity->GetSize();
    for (i=0 ; i<c ; i++)
      if ((currentEntity->GetAt(i))->getSelected())
        num++;
  }
  return num;
}

SetBrush *Map::selectedBrush()
{
  int   i, c;
  int   num;
  
  num = 0;
  c = currentEntity->GetSize();
  for (i=0 ; i<c ; i++)
    if ((currentEntity->GetAt(i))->getSelected())
      return (currentEntity->GetAt(i));
  return NULL;
}


/*
=================
readMapFile
=================
*/
void Map::readMapFile(char *fname)
{
  char  *dat, *cl;
  
  Entity  *ent;
  int   i, c;
  vec3_t  org;
  float angle;
  
  saveSelected();
  
  qprintf ("loading %s", fname);

  LoadFile (fname, (void **)&dat);
  StartTokenParsing (dat);

  do
  {
    Entity *newEnt = new Entity;
    if(!newEnt->initFromTokens())
      break;
    Add(newEnt);
  } while (1);

  free (dat);

  setCurrentEntity(GetAt(0));

  addSelected();
    
// load the apropriate texture wad
  dat = currentEntity->valueForQKey("wad");
  if (dat && dat[0])
  {
    if (dat[0] == '/')  // remove old style fullpaths
      currentEntity->removeKeyPair("wad");
    else
    {
		  if (strcmpi (texturepalette_i->getCurrentWad(), dat) )
      {
        texturepalette_i->initPaletteFromWadfile(dat);
      }
    }
  }

// center the camera and XY view on the playerstart
  c = GetSize();
  for (i=1 ; i<c ; i++)
  {
    ent = GetAt(i);
    cl = ent->valueForQKey("classname");
    if (cl && !strcmpi (cl,"info_player_start"))
    {
      angle = atof(ent->valueForQKey("angle"));
      angle = angle/180*M_PI;
      ent->getVector(org,"origin");
      cameraview_i->setOrigin(org,angle);
      xyview_i->centerOn(org);
      break;
    }
  }
}

/*
=================
writeMapFile
=================
*/
void Map::writeMapFile(char *fname,BOOL reg)
{
  FILE  *f;
  int   i;
  
  qprintf ("writeMapFile: %s", fname);
  
  f = fopen (fname,"w");
  if (!f)
    Error ("couldn't write %s", fname);
  
  for (i=0 ; i<GetSize() ; i++)
    (GetAt(i))->writeToFILE(f,reg);
      
  fclose (f);
  
}

/*
==============================================================================

DRAWING


/*
===================
entityConnect

A command-shift-click on an entity while an entity is selected will
make a target connection from the original entity.
===================
*/
void Map::entityConnect(vec3_t p1, vec3_t p2)
{
  Entity *oldent, *ent;
  
  oldent = getCurrentEntity();
  if (oldent == GetAt(0))
  {
    qprintf ("Must have a non-world entity selected to connect");
    return;
  }

  selectRay(p1,p2,YES);
  ent = getCurrentEntity();
  if (ent == oldent)
  {
    qprintf ("Must click on a different entity to connect");
    return;
  }
  
  if (ent == GetAt(0))
  {
    qprintf ("Must click on a non-world entity to connect");
    return;
  }
  
  oldent->setKey("target",ent->targetname());

  quakeed_i->updateAll();

}


/*
=================
selectRay

If ef is true, any entity brush along the ray will be selected in preference
to intervening world brushes
=================
*/
void Map::selectRay(vec3_t p1,vec3_t p2, BOOL ef)
{
  int   i, j, c, c2;
  Entity *ent, *bestent;
  SetBrush *brush, *bestbrush;
  int   face, bestface;
  float time, besttime;
  texturedef_t  *td;
  
  bestent = NULL;
  bestface = -1;
  bestbrush = NULL;
  besttime = 99999;
  
  c = GetSize();
  for (i=c-1 ; i>=0 ; i--)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j=0 ; j<c2 ; j++)
    {
      brush = ent->GetAt(j);
      brush->hitByRay(p1,p2,&time,&face);
      if (time < 0 || time >besttime)
        continue;
      bestent = ent;
      besttime = time;
      bestbrush = brush;
      bestface = face;
    }
    if (i == 1 && ef && bestbrush)
      break;    // found an entity, so don't check the world
  }
  
  if (besttime == 99999)
  {
    qprintf ("trace missed");
    return;
  }

  if (bestbrush->getRegioned())
  {
    qprintf ("WANRING: clicked on regioned brush");
    return;
  }
  
  if (bestent != currentEntity)
  {
    makeSelectedPerform(BRUSH_DESELECT);
    setCurrentEntity(bestent);
  }
  
  quakeed_i->redrawInstance();

  if ( !bestbrush->getSelected() )
  {
    if ( map_i->numSelected() == 0)
    { // don't grab texture if others are selected
      td = bestbrush->texturedefForFace(bestface);
      texturepalette_i->setTextureDef(td);
    }

    bestbrush->setSelected(YES);
  }
  else 
  {
    bestbrush->setSelected(NO);
  }
  quakeed_i->redrawInstance();
}

/*
=================
grabRay

only checks the selected brushes
Returns the brush hit, or nil if missed.
=================
*/
SetBrush *Map::grabRay(vec3_t p1, vec3_t p2)
{
  int   i, j, c, c2;
  Entity *ent;
  SetBrush *brush, *bestbrush;
  int   face;
  float time, besttime;
  
  bestbrush = NULL;
  besttime = 99999;
  
  c = GetSize();
  for (i=0 ; i<c ; i++)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j=0 ; j<c2 ; j++)
    {
      brush = ent->GetAt(j);
      if (!brush->getSelected())
        continue;
      brush->hitByRay(p1,p2,&time,&face);
      if (time < 0 || time >besttime)
        continue;
      besttime = time;
      bestbrush = brush;
    }
  }
  
  if (besttime == 99999)
    return NULL;
  
  return bestbrush;
}

/*
=================
getTextureRay
=================
*/
SetBrush *Map::getTextureRay(vec3_t p1, vec3_t p2)
{
  int   i, j, c, c2;
  Entity   *ent, *bestent;
  SetBrush    *brush, *bestbrush;
  int   face, bestface;
  float time, besttime;
  texturedef_t  *td;
  vec3_t  mins, maxs;   


  bestbrush = NULL;
  bestent = NULL;
  besttime = 99999;
  bestface = -1;
  c = GetSize();
  for (i=0 ; i<c ; i++)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j=0 ; j<c2 ; j++)
    {
      brush = ent->GetAt(j);
      brush->hitByRay(p1,p2,&time,&face);
      if (time < 0 || time >besttime)
        continue;
      bestent = ent;
      bestface = face;
      besttime = time;
      bestbrush = brush;
    }
  }
  
  if (besttime == 99999)
    return NULL;

  if (!bestent->getModifiable())
  {
    qprintf ("can't modify spawned entities");
    return NULL;
  }
  
  td = bestbrush->texturedefForFace(bestface);
  texturepalette_i->setTextureDef(td);
  qprintf ("grabbed texturedef and sizes");
  
  bestbrush->getMins(mins,maxs);
  
  minz = mins[2];
  maxz = maxs[2];
  
  return bestbrush;
}

/*
=================
setTextureRay
=================
*/
void Map::setTextureRay(vec3_t p1, vec3_t p2, BOOL allsides)
{
  int   i, j, c, c2;
  Entity    *ent, *bestent;
  SetBrush    *brush, *bestbrush;
  int   face, bestface;
  float time, besttime;
  texturedef_t  td;
    
  bestent = NULL;
  bestface = -1;
  bestbrush = NULL;
  besttime = 99999;
  
  c = GetSize();
  for (i=0 ; i<c ; i++)
  {
    ent = GetAt(i);;   
    c2 = ent->GetSize();
    for (j=0 ; j<c2 ; j++)
    {
      brush = ent->GetAt(j);
      brush->hitByRay(p1,p2,&time,&face);
      if (time < 0 || time >besttime)
        continue;
      bestent = ent;
      besttime = time;
      bestbrush = brush;
      bestface = face;
    }
  }
  
  if (besttime == 99999)
  {
    qprintf ("trace missed");
    return;
  }

  if (!bestent->getModifiable())
  {
    qprintf ("can't modify spawned entities");
    return;
  }
  
  if (bestbrush->getRegioned())
  {
    qprintf ("WANRING: clicked on regioned brush");
    return;
  }
  texturepalette_i->getTextureDef(&td);
  if (allsides)
  {
    bestbrush->setTexturedef(&td);
  }
  else 
  {
    bestbrush->setTexturedef(&td,bestface);
  }
}


/*
==============================================================================

OPERATIONS ON SELECTIONS

==============================================================================
*/

void Map::makeSelectedPerform(int sel)
{
  int i,j, c, c2;
  Entity *ent;
  SetBrush *brush;
  int total;
  
  total = 0;
  c = GetSize();
  for (i=c-1 ; i>=0 ; i--)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j = c2-1 ; j >=0 && !checkAbort(); j--)
    {
      brush = ent->GetAt(j);
      if (! brush->getSelected())
        continue;
      if (brush->getRegioned())
        continue;
      total++;
      brush->perform(sel);
    }
  }
  checkAbort();
}

void Map::makeUnselectedPerform(int sel)
{
  int i,j, c, c2;
  Entity *ent;
  SetBrush *brush;
  
  c = GetSize();
  for (i=c-1 ; i>=0 ; i--)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j = c2-1 ; j >=0 && !checkAbort(); j--)
    {
      brush = ent->GetAt(j);
      if (brush->getSelected())
        continue;
      if (brush->getRegioned())
        continue;
      brush->perform(sel);
    }
  }
  checkAbort();
}

void Map::makeAllPerform(int sel)
{
  int i,j, c, c2;
  Entity *ent;
  SetBrush *brush;
  
  c = GetSize();
  for (i=c-1 ; i>=0 ; i--)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j = c2-1 ; j >=0 && !checkAbort() ; j--)
    {
      brush = ent->GetAt(j);
      if (brush->getRegioned())
        continue;
      brush->perform(sel);
    }
  }
  
  checkAbort();
}

void Map::makeGlobalPerform(int sel) // in and out of region
{
  int i,j, c, c2;
  Entity *ent;
  SetBrush *brush;
  
  c = GetSize();
  for (i=c-1 ; i>=0 ; i--)
  {
    ent = GetAt(i);
    c2 = ent->GetSize();
    for (j = c2-1 ; j >=0 && !checkAbort(); j--)
    {
      brush = ent->GetAt(j);
      brush->perform(sel);
    }
  }
  checkAbort();
}


void sel_identity (void)
{
  sel_x[0]=1; sel_x[1]=0; sel_x[2]=0;
  sel_y[0]=0; sel_y[1]=1; sel_y[2]=0;
  sel_z[0]=0; sel_z[1]=0; sel_z[2]=1;
}

void Map::transformSelection()
{
  if ( !currentEntity->getModifiable())
  {
    qprintf ("can't modify spawned entities");
    return;
  }

// find an origin to apply the transformation to
  sb_mins[0] = sb_mins[1] = sb_mins[2] = 99999;
  sb_maxs[0] = sb_maxs[1] = sb_maxs[2] = -99999;
  makeSelectedPerform(BRUSH_ADDTOBBOX);
  sel_org[0] = xyview_i->snapToGrid((sb_mins[0] + sb_maxs[0])/2);
  sel_org[1] = xyview_i->snapToGrid((sb_mins[1] + sb_maxs[1])/2);
  sel_org[2] = xyview_i->snapToGrid((sb_mins[2] + sb_maxs[2])/2);
  
// do it!
  makeSelectedPerform(BRUSH_TRANSFORM);

  quakeed_i->updateAll();
}

void swapvectors (vec3_t a, vec3_t b)
{
  vec3_t  temp;
  
  VectorCopy (a, temp);
  VectorCopy (b, a);
  VectorSubtract (vec3_origin, temp, b);
}

/*
===============================================================================

UI operations

===============================================================================
*/
void Map::rotate_x()
{
  sel_identity ();
  swapvectors(sel_y, sel_z);
  transformSelection();
}

void Map::rotate_y()
{
  sel_identity ();
  swapvectors(sel_x, sel_z);
  transformSelection();
}

void Map::rotate_z()
{
  sel_identity ();
  swapvectors(sel_x, sel_y);
  transformSelection();
}


void Map::flip_x()
{
  sel_identity ();
  sel_x[0] = -1;
  transformSelection();
  map_i->makeSelectedPerform(BRUSH_FLIPNORMALS);
}

void Map::flip_y()
{
  sel_identity ();
  sel_y[1] = -1;
  transformSelection();
  map_i->makeSelectedPerform(BRUSH_FLIPNORMALS);
}


void Map::flip_z()
{
  sel_identity ();
  sel_z[2] = -1;
  transformSelection();
  map_i->makeSelectedPerform(BRUSH_FLIPNORMALS);
}


void Map::cloneSelection()
{
  int   i,j , c, originalElements;
  Entity *o,*newO;
  SetBrush  *b;
  SetBrush  *newBr;
  
  sb_translate[0] = sb_translate[1] = xyview_i->getGridsize();
  sb_translate[2] = 0;

// copy individual brushes in the world entity
  o = GetAt(0);
  c = o->GetSize();
  for (i=0 ; i<c ; i++)
  {
    b = o->GetAt(i);
    if (!b->getSelected())
      continue;
      
  // copy the brush, then translate the original
    newBr = b->copy();
    newBr->setSelected(YES);
    newBr->translate();
    b->setSelected(NO);
    o->Add(newBr);
  }
  
// copy entire entities otherwise
  originalElements = GetSize(); // don't copy the new ones
  for (i=1 ; i<originalElements ; i++)
  {
    o = GetAt(i);
    if (!o->GetAt(0)->getSelected())
      continue;

    newO = o->copy();
    Add(newO);

    c = o->GetSize();
    for (j=0 ; j<c ; j++)
      o->GetAt(j)->setSelected(NO);
    
    c = newO->GetSize();
    for (j=0 ; j<c ; j++)
    {
      b = (newO->GetAt(j));
      b->translate();
      b->setSelected(YES);
    }
  }

  quakeed_i->updateAll();
}


void Map::selectCompleteEntity()
{
  SetBrush *o;
  Entity *e;
  int i, c;
  
  o = selectedBrush();
  if (!o)
  {
    qprintf ("nothing selected");
    return;
  }
  e = o->getParent();
  c = e->GetSize();
  for (i=0 ; i<c ; i++)
    (e->GetAt(i))->setSelected(YES); 
  qprintf ("%i brushes selected", c);

  quakeed_i->updateAll();
}

void Map::makeEntity()
{
  if (currentEntity != GetAt(0))
  {
    qprintf ("ERROR: can't makeEntity inside an entity");
    MessageBeep(MB_ICONEXCLAMATION);
    return;
  }
  
  if (numSelected() == 0)
  {
    qprintf ("ERROR: must have a seed brush to make an entity");
    MessageBeep(MB_ICONEXCLAMATION);
    return;
  }
  
  sb_newowner = new Entity;
  sb_newowner->initClass(things_i->spawnName());

  if ( sb_newowner->getModifiable() )
    makeSelectedPerform(BRUSH_MOVETOENTITY);
  else
  { // throw out seed brush and select entity fixed brush
    makeSelectedPerform(BRUSH_REMOVE);
    (sb_newowner->GetAt(0))->setSelected(YES);
  }
  
  Add(sb_newowner);
  setCurrentEntity(sb_newowner);
  
  quakeed_i->updateAll();
}

void Map::selbox(UINT selector)
{
  SetBrush *b;
  
  if (numSelected() != 1)
  {
    qprintf ("must have a single brush selected");
    return;
  } 

  b = selectedBrush();
  b->getMins(select_min,select_max);
  b->remove();
  
  makeUnselectedPerform(selector);
  
  qprintf ("identified contents");
  quakeed_i->updateAll();
}

void Map::selectCompletelyInside()
{
  selbox(BRUSH_SELECTCOMPLETE);
}

void Map::selectPartiallyInside()
{
  selbox(BRUSH_SELECTPARTIAL);
}

void Map::tallBrush()
{
  SetBrush *b;
  vec3_t  mins, maxs;
  texturedef_t  td;
  
  if (numSelected() != 1)
  {
    qprintf ("must have a single brush selected");
    return;
  } 

  b = selectedBrush();
  td = *b->texturedef();
  b->getMins(mins, maxs);
  b->remove();

  mins[2] = -2048;
  maxs[2] = 2048;
  
  b = new SetBrush;
  b->initOwner(map_i->GetAt(0),mins,maxs,&td);
  (map_i->GetAt(0))->Add(b);
  
  b->setSelected(YES);
  quakeed_i->updateAll();
}

void Map::shortBrush()
{
  SetBrush *b;
  vec3_t  mins, maxs;
  texturedef_t  td;
  
  if (numSelected() != 1)
  {
    qprintf ("must have a single brush selected");
    return;
  } 

  b = selectedBrush();
  td = *b->texturedef();
  b->getMins(mins,maxs);
  b->remove();

  mins[2] = 0;
  maxs[2] = 16;
  
  b = new SetBrush;
  b->initOwner(map_i->GetAt(0),mins,maxs,&td);
  map_i->GetAt(0)->Add(b);
  b->setSelected(YES);
  quakeed_i->updateAll();
}

/*
==================
subtractSelection
==================
*/

void Map::subtractSelection()
{
  int   i, j, c, c2;
  SetBrush   * o, *o2;
  Entity  *sellist, *sourcelist;
  
  qprintf ("performing brush subtraction...");

  sourcelist = new Entity;
  sellist = new Entity;
  carve_in = new Entity;
  carve_out = new Entity;
  
  c = currentEntity->GetSize();
  for (i=0 ; i<c ; i++)
  {
    o = currentEntity->GetAt(i);
    if (o->getSelected())
      sellist->Add(o);
    else
      sourcelist->Add(o);
  }
  
  c = sellist->GetSize();
  for (i=0 ; i<c ; i++)
  {
    o = sellist->GetAt(i);
    o->setCarveVars();
    
    c2 = sourcelist->GetSize();
    for (j=0 ; j<c2 ; j++)
    {
      o2 = sourcelist->GetAt(j);
      o2->carve();
      carve_in->RemoveAll();
    }

    sourcelist->RemoveAll();  // the individual have been moved/freed // TT ?
    sourcelist = carve_out;
    carve_out = new Entity;
  }

// add the selection back to the remnants
  currentEntity->RemoveAll();
  currentEntity->InsertAt(0,sourcelist);
  currentEntity->InsertAt(0,sellist);

  sourcelist->RemoveAll();
  sellist->RemoveAll();
  carve_in->RemoveAll();
  carve_out->RemoveAll();
  
  if (!currentEntity->GetSize())
  {
    Entity *o = currentEntity;
    removeObject(o);
    delete o;
  }
  qprintf ("subtracted selection");
  quakeed_i->updateAll();
}


BOOL Map::checkAbort()
{
  if(!abortEnabled)
    return FALSE;

  MSG msg;
  while(PeekMessage(&msg,NULL,WM_KEYFIRST,WM_KEYLAST,PM_REMOVE))
  {
    if(msg.message == WM_KEYDOWN && msg.wParam == VK_ESCAPE)
      return TRUE;
  }
  return FALSE;
}
